/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.dm.CMDataModel;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMGetUserItemPermissionMediator;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.security.cm8.CM8SecurityUtils;
import com.ibm.ecm.security.cm8.CM8User;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.teamspace.BaseTeamspaceService;
import com.ibm.mm.sdk.common.DKACLData;
import com.ibm.mm.sdk.common.DKAccessControlListICM;
import com.ibm.mm.sdk.common.DKAuthorizationMgmtICM;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKPrivilegeSetICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkPrivilegeSet;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMGetUserItemPermissionAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMGetUserItemPermissionMediator permissionMediator = (CMGetUserItemPermissionMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                boolean isOwner = false;
                String id = request.getParameter("docid");
                String userId = dsICM.getUserName();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docid:" + id);
                DKDDO icmddo = dsICM.createDDOFromPID(id);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.basePropertyAclName(true);
                DKPidICM pid = (DKPidICM)icmddo.getPidObject();
                if (pid.getVersionNumber().equals("0")) {
                    pid.setVersionNumber("1");
                    dkRetrieveOptions.functionVersionLatest(true);
                }
                icmddo.retrieve(dkRetrieveOptions.dkNVPair());
                this.dumpDdo(icmddo);
                DKAccessControlListICM acl = this.retrieveDKACL(icmddo, dsICM);
                this.printACL(acl);
                List<String> privNames = new ArrayList<String>();
                dkCollection aclDataCollection = acl.listACLData();
                dkIterator iterator = aclDataCollection.createIterator();
                List<String> groupNames = null;
                try {
                    CM8SecurityService securityService = new CM8SecurityService(request, dsICM);
                    CM8User usrObj = (CM8User)securityService.retrieveUser(dsICM.getUserName());
                    groupNames = usrObj.getGroups();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "aclDataCollection.cardinality(): " + aclDataCollection.cardinality());
                while (iterator.more()) {
                    DKACLData aclData = (DKACLData)iterator.next();
                    if ((groupNames == null || !groupNames.contains(aclData.getUserGroupName())) && !aclData.getUserGroupName().equalsIgnoreCase(userId)) continue;
                    dkPrivilegeSet privSet = aclData.getPrivilegeSet();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "privSet.getName() " + privSet.getName());
                    String[] privNamesArray = privSet.listPrivilegeNames();
                    privNames = Arrays.asList(privNamesArray);
                    List<String> privsForOwners = Arrays.asList(CMDataModel.TEAMSPACE_OWNER_PRIVSET);
                    if (privNames.containsAll(privsForOwners)) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "is owner");
                        isOwner = true;
                        continue;
                    }
                    if (Logger.getLogLevel() <= 2 || privsForOwners == null || privNames == null) continue;
                    for (String priv : privsForOwners) {
                        if (privNames.contains(priv)) continue;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "missing priv: " + priv + " in order to be owner");
                    }
                }
                if (Logger.getLogLevel() > 3) {
                    for (String privName : privNames) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "has priv: " + privName);
                    }
                }
                dkDatastoreExt dsExt = (dkDatastoreExt)dsICM.getExtension("DATASTORE_EXTENSION");
                DKCommonPrivilege privilege = this.getCommonPrivilege(icmddo, dsExt);
                boolean hasAdminPriv = privilege.hasAdminPrivilege();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "hasAdminPriv: " + hasAdminPriv);
                privNames = CM8SecurityUtils.getMappedPrivileges(privNames, hasAdminPriv, isOwner);
                permissionMediator.setPrivNames(privNames);
                Integer tmpState = (Integer)icmddo.getDataByName("clbState");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "tmpState = " + tmpState);
                String state = BaseTeamspaceService.State.getEnum(tmpState).getStringValue();
                if (tmpState != null) {
                    state = BaseTeamspaceService.State.getEnum(tmpState).getStringValue();
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "state = " + state);
                permissionMediator.setState(state);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                permissionMediator.addError("error.exception.general", e.getMessage());
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
        }
        this.writeJSONMediator(request, response);
        return actionForward;
    }

    public DKAccessControlListICM retrieveDKACL(DKDDO ddo, DKDatastoreICM dsICM) throws Exception {
        DKAccessControlListICM acl;
        String methodName;
        block5: {
            methodName = " retrieveACL";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            acl = null;
            try {
                if (ddo == null) break block5;
                String aclName = null;
                try {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrieve ACL property from ddo");
                    short propertyID = ddo.propertyId("SYSROOTATTRS.ACLCODE");
                    aclName = (String)ddo.getProperty(propertyID);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "aclName: " + aclName);
                }
                catch (Exception e) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "No ACL property found. Setting Item object ACL to null.");
                }
                if (aclName != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving ACL \"" + aclName + "\"...");
                    acl = this.retrieveDKACL(aclName, dsICM);
                }
            }
            catch (Exception e) {
                Logger.logError(this, methodName, (ServletRequest)this.request, "Failed to retrieve ACL for item \"\".", e);
                throw e;
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return acl;
    }

    public DKAccessControlListICM retrieveDKACL(String aclName, DKDatastoreICM dsICM) throws Exception {
        String methodName = "retrieveACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKAccessControlListICM acl = null;
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving ACL \"" + aclName + "\"...");
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)dsICM);
            acl = (DKAccessControlListICM)authorMgmt.retrieveAccessControlList(aclName);
        }
        catch (Exception e) {
            Logger.logError(this, methodName, (ServletRequest)this.request, "Failed to retrieve ACL \"" + aclName + "\".", e);
            throw e;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return acl;
    }

    private void printACL(DKAccessControlListICM acl_1) throws DKException, Exception {
        String methodName = "printACL";
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "  ACL = " + acl_1.getName() + " (" + acl_1.getDescription() + ")");
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Contains " + acl_1.getACLType() + " type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ID " + acl_1.getID());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Has acl rules:  " + acl_1.getACLData().isEmpty());
        dkCollection coll = acl_1.listACLData();
        dkIterator iter = coll.createIterator();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Has user data " + iter.more());
        while (iter.more()) {
            DKACLData aclData = (DKACLData)iter.next();
            DKPrivilegeSetICM _privSet = (DKPrivilegeSetICM)aclData.getPrivilegeSet();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + _privSet + " --> " + _privSet.getName());
            short patronType = aclData.getPatronType();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + patronType + " --> " + patronType);
            String usrGrpName = aclData.getUserGroupName();
            if (patronType == 0) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + usrGrpName + " --> " + _privSet.getName());
                continue;
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + usrGrpName + " --> " + _privSet.getName());
        }
    }

    private DKCommonPrivilege getCommonPrivilege(DKDDO privDDO, dkDatastoreExt dsExt) throws Exception {
        String methodName = "getCommonPrivilege";
        DKCommonPrivilege commonPrivilege = null;
        if (privDDO != null) {
            try {
                commonPrivilege = dsExt.getCommonItemPrivilege((dkDataObject)privDDO);
            }
            catch (RuntimeException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return commonPrivilege;
    }

    private void dumpDdo(DKDDO ddoItem) {
        String methodName = "dumpDdo";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "--------------------------------------------------------");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ddoItem pid:   " + ddoItem.getPidObject().pidString());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Number of Attributes / Data Items: " + ddoItem.dataCount());
            for (short dataid = 1; dataid <= ddoItem.dataCount(); dataid = (short)(dataid + 1)) {
                String name = ddoItem.getDataName(dataid);
                Object value = ddoItem.getData(dataid);
                Short type = (Short)ddoItem.getDataPropertyByName(dataid, "type");
                try {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrieve ACL property from ddo");
                    short propertyID = ddoItem.propertyId("SYSROOTATTRS.ACLCODE");
                    String aclName = (String)ddoItem.getProperty(propertyID);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "aclName: " + aclName);
                }
                catch (Exception e) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "No ACL property found. Setting Item object ACL to null.");
                }
                String typeDescription = "To Be Determined...";
                switch (type.intValue()) {
                    case 0: {
                        typeDescription = "Undefined";
                        break;
                    }
                    case 1: {
                        typeDescription = "String";
                        break;
                    }
                    case 3: {
                        typeDescription = "Short";
                        break;
                    }
                    case 4: {
                        typeDescription = "Long";
                        break;
                    }
                    case 5: {
                        typeDescription = "Float";
                        break;
                    }
                    case 6: {
                        typeDescription = "Decimal";
                        break;
                    }
                    case 7: {
                        typeDescription = "Date";
                        break;
                    }
                    case 8: {
                        typeDescription = "Time";
                        break;
                    }
                    case 9: {
                        typeDescription = "Timestamp";
                        break;
                    }
                    case 10: {
                        typeDescription = "Double";
                        break;
                    }
                    case 11: {
                        typeDescription = "Byte Array";
                        break;
                    }
                    case 48: {
                        typeDescription = "DDO";
                        break;
                    }
                    case 49: {
                        typeDescription = "XDO";
                        break;
                    }
                    case 50: {
                        typeDescription = "Data Object Base";
                        break;
                    }
                    case 1024: {
                        typeDescription = "Collection";
                        break;
                    }
                    case 1072: {
                        typeDescription = "DDO Collection";
                        break;
                    }
                    case 1073: {
                        typeDescription = "XDO Colleciton";
                        break;
                    }
                    case 1071: {
                        typeDescription = "DKLinkCollection";
                        break;
                    }
                    case 2048: {
                        typeDescription = "Array";
                        break;
                    }
                    default: {
                        typeDescription = "Unknown (" + type + ")";
                    }
                }
                if (value != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Data Item '" + name + "' of type '" + typeDescription + "' with value: " + value);
                    continue;
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Data Item '" + name + "' of type '" + typeDescription + "' with value: null");
            }
        }
        catch (DKUsageError e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "--------------------------------------------------------");
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        String id = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + id);
        if (id == null || id.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMGetUserItemPermissionMediator mediator = new CMGetUserItemPermissionMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        String id = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + id);
    }
}

