/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.struts.actions.cm.CMQueryContinuationData;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMGetSearchTemplatesAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dataStore;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMSearchResultsMediator mediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dataStore = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                String repositoryId = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + repositoryId);
                String teamspaceId = request.getParameter("workspaceId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + teamspaceId);
                CMConnection connection = this.getConnection(request);
                if (repositoryId != null) {
                    this.getConfigInfo(request);
                    DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dataStore.datastoreDef();
                    DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity("ICMSearch");
                    mediator.setItemType(itemType);
                    CMBaseAction.QueryOutput queryOutput = null;
                    if (teamspaceId != null && teamspaceId.length() > 0) {
                        CM8TeamspaceService teamspaceService = new CM8TeamspaceService(request, connection, this.wcDateFormats);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieving teamspace");
                        Teamspace teamspace = teamspaceService.retrieveTeamspace(teamspaceId, "searches", "instance");
                        if (teamspace != null) {
                            List<String> teamspaceSearchIds = teamspace.getSearches();
                            if (teamspaceSearchIds != null && teamspaceSearchIds.size() > 0) {
                                StringBuffer sbQuery = new StringBuffer();
                                sbQuery.append("/").append("ICMSearch").append("[@ITEMID IN (");
                                for (int i = 0; i < teamspaceSearchIds.size(); ++i) {
                                    DKPidICM pidObj = new DKPidICM(teamspaceSearchIds.get(i));
                                    if (i > 0) {
                                        sbQuery.append(",");
                                    }
                                    sbQuery.append("\"").append(pidObj.getItemId()).append("\"");
                                }
                                sbQuery.append(")]");
                                sbQuery.append(" SORTBY (@").append("ICM$NAME").append(" ASCENDING)");
                                queryOutput = this.runQuery(request, dataStore, sbQuery.toString(), 0, 200, true, false, false);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "queryOutput.count = " + queryOutput.count);
                            } else {
                                String query = "/ICMSearch SORTBY (@ICM$NAME ASCENDING)";
                                queryOutput = this.runQuery(request, dataStore, query, 0, 1000, true, false, false);
                            }
                        } else {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspace not found!");
                            queryOutput = new CMBaseAction.QueryOutput();
                        }
                    } else {
                        String query = "/ICMSearch SORTBY (@ICM$NAME ASCENDING)";
                        queryOutput = this.runQuery(request, dataStore, query, 0, 1000, true, false, false);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "queryOutput.count = " + queryOutput.count);
                        if (queryOutput.hasMore) {
                            CMQueryContinuationData data = new CMQueryContinuationData(query, "ICMSearch", false, false, null, true, false);
                            String serializedData = data.saveToString();
                            mediator.setContinuation(true);
                            mediator.setContinuationData(serializedData);
                        }
                    }
                    CMSearchResults results = new CMSearchResults(request, connection);
                    results.newResults(queryOutput.items, false, true, false, true);
                    mediator.setConnection(this.getConnection(request));
                    mediator.setSearchResults(results);
                } else {
                    this.logFDC(request, response, null, methodName);
                    mediator.addError("error.parm.null", "repositoryId");
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            mediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

