/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMNotelogMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMGetNotelogsAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMNotelogMediator notelogMediator = (CMNotelogMediator)this.getMediator(request);
        String altOutput = request.getParameter("alt_output");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        String[] notelogs = null;
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                CMConnection connection = this.getConnection(request);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.partsList(true);
                dkRetrieveOptions.partsAttributes(true);
                CMItem item = connection.retrieveItem(pid, request, dkRetrieveOptions);
                CMObject[] logs = item.getNoteLogs();
                String[] logTexts = null;
                if (logs != null && logs.length > 0) {
                    logTexts = new String[logs.length];
                    for (int i = 0; i < logs.length; ++i) {
                        byte[] data = logs[i].getByteArrayData();
                        logTexts[i] = data != null ? new String(data, this.getUtils(request).getEncoding(request)) : "";
                    }
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Retrieved notelogs from item and saved in a string array");
                } else {
                    logTexts = new String[]{};
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Item has no notelogs, returning an empty string array");
                }
                notelogs = logTexts;
                if (notelogs != null && notelogs.length >= 1) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "notelogs from request attribute=" + notelogs.toString());
                    notelogMediator.setNotes(notelogs);
                } else {
                    notelogMediator.addMessage("message.empty.notelog", new Object[0]);
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                notelogMediator.addError("error.exception.general", e.getMessage());
            }
            if (altOutput != null && altOutput.equalsIgnoreCase("JSON")) {
                this.writeJSONMediator(request, response);
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "notelogs=" + notelogs);
                if (notelogs != null && notelogs.length > 0) {
                    StringBuffer notelogBytes = new StringBuffer();
                    for (int i = 0; i < notelogs.length; ++i) {
                        notelogBytes.append(notelogs[i]);
                        notelogBytes.append("\n\n");
                    }
                    response.setContentType("text/plain");
                    response.setContentLength(notelogBytes.toString().getBytes().length);
                    ServletOutputStream os = response.getOutputStream();
                    os.write(notelogBytes.toString().getBytes());
                    os.close();
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMNotelogMediator notelogMediator = new CMNotelogMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)notelogMediator);
        return notelogMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
    }
}

