/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMItemTypesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMGetItemTypesAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMItemTypesMediator entitiesMediator = (CMItemTypesMediator)this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String filterType = request.getParameter("filter_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "filterType = " + filterType);
        String workspaceId = request.getParameter("workspaceId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + workspaceId);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            if (filterType == null || filterType.length() == 0) {
                filterType = "navigation";
            }
            if (serverName == null || serverName.trim().length() < 1) {
                entitiesMediator.addError("error.parm.null", "repositoryId");
            }
            try {
                if (serverName != null) {
                    CMEntity[] entities;
                    CMConnection connection;
                    CM8TeamspaceService teamspaceService = null;
                    List<String> _classes = new ArrayList<String>();
                    boolean teamspaceMode = false;
                    if (workspaceId != null && workspaceId.length() > 0) {
                        connection = this.getConnection(request);
                        teamspaceService = new CM8TeamspaceService(request, connection, this.getDateFormats());
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieving teamspace");
                        Teamspace teamspace = teamspaceService.retrieveTeamspace(workspaceId, "classes", "instance");
                        if (teamspace != null) {
                            _classes = teamspace.getClasses();
                            if (_classes != null && !_classes.isEmpty()) {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "_classes: " + _classes.size());
                                teamspaceMode = true;
                                for (int i = 0; i < _classes.size(); ++i) {
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspace has class name: " + _classes.get(i));
                                }
                            } else {
                                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "No classes found in the teamspace.  Defaulting to repository list");
                            }
                        } else {
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "teamspace not found!");
                        }
                    }
                    connection = this.getConnection(request);
                    if (!filterType.equals("navigation")) {
                        entities = connection.getEntities();
                    } else {
                        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                        dkCollection entityList = dsDefICM.listEntities(2);
                        dkIterator iterator = entityList.createIterator();
                        entities = new CMEntity[entityList.cardinality()];
                        int i = 0;
                        while (iterator.more()) {
                            dkEntityDef entity = (dkEntityDef)iterator.next();
                            entities[i] = new CMEntity(connection, entity);
                            ++i;
                        }
                    }
                    Vector<CMEntity> filteredEntities = CMUtil.getFilteredEntities(dsICM, filterType, entities, request);
                    if (teamspaceMode) {
                        filteredEntities = this.filterByWorkspaceItems(_classes, filteredEntities);
                    }
                    entitiesMediator.setEntities(filteredEntities);
                    int maxEntitiesToDisplay = filteredEntities.size();
                    if (maxEntitiesToDisplay > this.getMaxItemTypes()) {
                        entitiesMediator.addMessage("folders.search.successful.maxItems", new Integer(filteredEntities.size()), new Integer(this.getMaxItemTypes()));
                        maxEntitiesToDisplay = this.getMaxItemTypes();
                    } else {
                        entitiesMediator.addMessage("folders.search.successful", new Integer(filteredEntities.size()));
                    }
                    if (filteredEntities.size() == 0) {
                        entitiesMediator.addMessage("folders.search.nothingfound", new Object[0]);
                    }
                    entitiesMediator.setMaxItemTypes(maxEntitiesToDisplay);
                } else {
                    this.logFDC(request, response, null, methodName);
                    entitiesMediator.addError("error.parm.null", "repositoryId");
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                entitiesMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private Vector<CMEntity> filterByWorkspaceItems(List<String> classes, Vector<CMEntity> filteredEntities) {
        String methodName = "filterByWorkspaceItems";
        Vector<CMEntity> list = new Vector<CMEntity>(filteredEntities.size());
        for (int i = 0; i < filteredEntities.size(); ++i) {
            CMEntity entity = filteredEntities.elementAt(i);
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entity.getName()= " + entity.getName());
            if (classes.contains(entity.getName())) {
                list.add(entity);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "added: " + entity.getName());
                continue;
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "filtered: " + entity.getName());
        }
        return list;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMItemTypesMediator mediator = new CMItemTypesMediator(request, this.getResources(request), request.getLocale());
        MessageResources resources = this.getResources(request);
        return mediator;
    }
}

