/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DocumentInfoMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.Util;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import com.ibm.mm.viewer.CMBDocument;
import com.ibm.mm.viewer.CMBStreamingDocServices;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMGetDocumentAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        DocumentInfoMediator docInfoMediator = (DocumentInfoMediator)this.getMediator(request);
        String altOutput = request.getParameter("alt_output");
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            block46: {
                try {
                    String[] docIDs;
                    RepositoryConfig repositoryConfig;
                    CMConnection connection = this.getConnection(request);
                    String pid = request.getParameter("docid");
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.partsList(true);
                    dkRetrieveOptions.partsAttributes(true);
                    CMItem item = connection.retrieveItem(pid, request, dkRetrieveOptions);
                    if (altOutput != null && altOutput.equals("JSON")) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "output as: JSON");
                        String mimeType = item.getMimeType();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request attribute part mimetype =" + mimeType);
                        docInfoMediator.setMimeType(mimeType);
                        int partCount = item.getContentCount();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request attribute part count =" + partCount);
                        docInfoMediator.setPartCount(partCount);
                        String fileName = "";
                        if (partCount == 1) {
                            CMObject part = item.getContent(0);
                            fileName = part.getOriginalFileName();
                        }
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request attribute part file name =" + fileName);
                        docInfoMediator.setStoredFileName(fileName);
                        long partSize = item.getContent(0).getSize();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request attribute part Size =" + partSize);
                        docInfoMediator.setPartSize(partSize);
                        int annopartCount = item.getAnnotationCount();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request attribute anno part count =" + annopartCount);
                        docInfoMediator.setAnnotationPartCount(annopartCount);
                        int notelogCount = item.getNoteLogCount();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request attribute notelog count =" + notelogCount);
                        docInfoMediator.setNotelogCount(notelogCount);
                        String apiVersion = this.getDataStore(request).getAPIVersion();
                        int indexOfDot = apiVersion.indexOf(".", 0);
                        int version = Integer.parseInt(apiVersion.substring(0, indexOfDot));
                        apiVersion = apiVersion.substring(indexOfDot + 1);
                        indexOfDot = apiVersion.indexOf(".", 0);
                        int release = Integer.parseInt(apiVersion.substring(0, indexOfDot));
                        apiVersion = apiVersion.substring(indexOfDot + 1);
                        indexOfDot = apiVersion.indexOf(".", 0);
                        int fixpack = Integer.parseInt(apiVersion.substring(0, indexOfDot));
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Version = " + version + "\trelease = " + release + "\tfixpack = " + fixpack);
                        if (version * 1000 + release * 100 + fixpack * 10 >= 8420 && (mimeType.equals("image/tiff") || mimeType.equals("image/tif") || mimeType.equals("image/gif") || mimeType.equals("image/jpg") || mimeType.equals("image/jpeg") || mimeType.equals("image/jfif") || mimeType.equals("image/bmp") || mimeType.equals("image/cals") || mimeType.equals("image/x-cals") || mimeType.equals("image/png") || mimeType.equals("application/vnd.ibm.modcap") || mimeType.equals("application/afp") || mimeType.equals("application/line") || mimeType.equals("text/plain") || mimeType.equals("image/pcx") || mimeType.equals("image/x-pcx") || mimeType.equals("image/dcx") || mimeType.equals("image/x-dcx") || mimeType.equals("application/dicom"))) {
                            docInfoMediator.setPDFConvertable(true);
                        }
                        this.writeJSONMediator(request, response);
                        break block46;
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "output as: !JSON");
                    String transform = request.getParameter("transform");
                    if (transform == null && (repositoryConfig = Config.getRepositoryConfig(request)) != null) {
                        if (repositoryConfig.getAfpConversion() != null && repositoryConfig.getAfpConversion().contains(item.getMimeType())) {
                            transform = "PDF";
                        } else if (repositoryConfig.getPdfConversion() != null && repositoryConfig.getPdfConversion().contains(item.getMimeType())) {
                            transform = "PDF";
                        }
                    }
                    String paramVal = request.getParameter("part_number");
                    int partNum = 0;
                    if (paramVal != null) {
                        if (paramVal.equals("all")) {
                            partNum = -1;
                        } else {
                            try {
                                partNum = Integer.parseInt(paramVal);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                    }
                    if ((docIDs = request.getParameterValues("docid")).length == 1) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "doc Id count: 1");
                        if (transform != null && transform.equals("PDF")) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "transform: PDF");
                            CMBStreamingDocServices docServices = new CMBStreamingDocServices();
                            docServices.setPreferredFormats(new String[]{"application/pdf"});
                            CMObject content = item.getContent(0);
                            URL contentUrl = content.getContentURL();
                            InputStream contentStream = contentUrl.openStream();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "load document from: " + contentUrl);
                            CMBDocument document = docServices.loadDocument(contentStream, (int)content.getSize(), 1, content.getMimeType(), content.getMimeType(), null, null);
                            String fileName = content.getOriginalFileName();
                            if (fileName.lastIndexOf(46) > -1) {
                                fileName = fileName.substring(0, fileName.lastIndexOf(46));
                                fileName = fileName + ".pdf";
                            }
                            response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, fileName));
                            response.setContentType(document.getWriteMimeType());
                            ServletOutputStream outputStream = response.getOutputStream();
                            document.write((OutputStream)outputStream);
                            outputStream.close();
                            docServices.dropDocument(document);
                            docServices.terminate();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "document services terminated for type: " + content.getMimeType());
                        } else {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "transform: !PDF");
                            response.setHeader("Part-Count", String.valueOf(item.getContentCount()));
                            response.setHeader("Annotation-Part-Count", String.valueOf(item.getAnnotationCount()));
                            response.setHeader("NoteLog-Part-Count", String.valueOf(item.getNoteLogCount()));
                            int partCount = item.getContentCount();
                            if (partNum >= partCount) {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Requested content part does not exist");
                                throw new Exception("Requested content part does not exist");
                            }
                            if (partNum != -1 || partCount == 1) {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "partNum: " + partNum + ", partCount: " + partCount);
                                CMObject part = item.getContent(Math.max(0, partNum));
                                String mimeType = part.getMimeType();
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "directRetrieve: " + this.isDirectRetrieveEnabled());
                                if (this.isDirectRetrieveEnabled() && request.getHeader("supports-direct-retrieve") != null && !mimeType.equals("text/plain")) {
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "direct-retrieve-url supported");
                                    response.setHeader("direct-retrieve-url", part.getContentURL().toString());
                                } else {
                                    response.setContentType(mimeType);
                                    String fileName = request.getParameter("parm_part_filename");
                                    String fileNameExt = "." + MimeTypeUtil.getExtFromMimeType(mimeType);
                                    if (partCount == 1 || fileName == null || fileName.length() < 1) {
                                        fileName = part.getOriginalFileName();
                                    } else if (fileName != null && fileName.length() > 1 && !fileName.endsWith(fileNameExt)) {
                                        fileName = fileName + fileNameExt;
                                    }
                                    if (fileName == null) {
                                        String itemName = item.getName();
                                        String string = fileName = itemName != null && itemName.length() > 0 ? itemName : "cmDocument";
                                        if (partCount > 1) {
                                            fileName = fileName + "-" + partNum;
                                        }
                                        if (!fileName.endsWith(fileNameExt)) {
                                            fileName = fileName + fileNameExt;
                                        }
                                    }
                                    response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, fileName));
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "content len: " + (int)part.getSize());
                                    response.setContentLength((int)part.getSize());
                                    InputStream partStream = part.getDataStream();
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "inputStream obtained");
                                    if (mimeType.equals("text/plain")) {
                                        String encoding = part.getEncoding();
                                        if (encoding != null) {
                                            response.setCharacterEncoding(encoding);
                                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Character Encoding = " + encoding);
                                        } else if (transform != null && transform.equals("native") && !(partStream instanceof BufferedInputStream)) {
                                            partStream = new BufferedInputStream(partStream);
                                        }
                                    }
                                    if (part.getSize() > 0L) {
                                        ServletOutputStream outputStream = response.getOutputStream();
                                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "copy partStream to outputStream");
                                        CMGetDocumentAction.copyStream(partStream, (OutputStream)outputStream, true);
                                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "copy streams completed");
                                    }
                                }
                            } else {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "retrieve all parts");
                                String partFileName = request.getParameter("parm_part_filename");
                                File multipartZipFile = this.createMultipartZipFile(item, partFileName);
                                response.setHeader("Content-Type", "application/octet-stream");
                                response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, partFileName + ".zip"));
                                response.setContentLength((int)multipartZipFile.length());
                                FileInputStream is = new FileInputStream(multipartZipFile);
                                ServletOutputStream outputStream = response.getOutputStream();
                                CMGetDocumentAction.copyStream(is, (OutputStream)outputStream, true);
                                multipartZipFile.deleteOnExit();
                            }
                        }
                    } else {
                        String tempFileName;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "docIds len: " + docIDs.length);
                        String[] partFileNames = request.getParameterValues("parm_part_filename");
                        File tempFile = File.createTempFile("ContentNavigator", ".zip");
                        String responseFileName = tempFileName = tempFile.getPath();
                        tempFile.delete();
                        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempFileName));
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add documents to main temp zip file: " + tempFileName);
                        for (int i = 0; i < docIDs.length; ++i) {
                            String partFileName = partFileNames[i];
                            item = connection.retrieveItem(docIDs[i], request, dkRetrieveOptions);
                            int partCount = item.getContentCount();
                            if (partCount == 1) {
                                CMObject part = item.getContent(0);
                                this.addEntryToZipFile(zos, part, docIDs.length);
                                if (i != 0) continue;
                                responseFileName = part.getOriginalFileName();
                                continue;
                            }
                            File multipartZipFile = this.createMultipartZipFile(item, partFileName);
                            zos.putNextEntry(new ZipEntry(partFileName + ".zip"));
                            CMGetDocumentAction.copyStream(new FileInputStream(multipartZipFile), zos, false);
                            zos.closeEntry();
                            if (i != 0) continue;
                            responseFileName = partFileName;
                        }
                        int index = responseFileName.lastIndexOf(46);
                        if (index > -1) {
                            responseFileName = responseFileName.substring(0, index);
                        }
                        zos.close();
                        tempFile = new File(tempFileName);
                        response.setHeader("Content-Type", "application/octet-stream");
                        response.setHeader("Content-Disposition", Util.getContentDispositionHeader(request, responseFileName + ".zip"));
                        response.setContentLength((int)tempFile.length());
                        ServletOutputStream outputStream = response.getOutputStream();
                        CMGetDocumentAction.copyStream(new FileInputStream(tempFile), (OutputStream)outputStream, true);
                        tempFile.deleteOnExit();
                    }
                }
                catch (Exception e) {
                    if (e.getClass().getName().endsWith("ClosedConnectionException") || e.getClass().getName().endsWith("ClientAbortException")) {
                        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Client closed connection before reading entire response");
                    }
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    if (e instanceof DKException && ((DKException)((Object)e)).getErrorId() == 7161) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "WARNING!!! The exception message may provide misleading reason: Password expired; actually, the real reason is");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "WARNING!!! the validation information stored on the library server and resource manager are not synchronized.");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "WARNING!!! The system administrator need to resynchronize the encryption key to resolve the problem.");
                    }
                    if (altOutput != null && altOutput.equals("JSON")) {
                        docInfoMediator.addError("error.exception.general", e.getMessage());
                    }
                    try {
                        String message = resources.getMessage(request.getLocale(), "error.exception.general", new Object[]{e.getMessage()});
                        response.sendError(500, message);
                    }
                    catch (Exception ex) {
                        Logger.logError((Object)this, methodName, (ServletRequest)request, "Secondary error sending error response. Error= " + ex);
                    }
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void addEntryToZipFile(ZipOutputStream zos, CMObject part, int maxAttempts) throws Exception {
        String fileName = part.getOriginalFileName();
        int attemptCount = 0;
        boolean noException = false;
        String zipEntryName = fileName;
        while (attemptCount < maxAttempts && !noException) {
            try {
                zos.putNextEntry(new ZipEntry(zipEntryName));
                noException = true;
            }
            catch (ZipException ze) {
                int index = fileName.lastIndexOf(46);
                zipEntryName = index > -1 ? fileName.substring(0, index) + "(" + (attemptCount + 2) + ")" + fileName.substring(index) : fileName + "(" + (attemptCount + 2) + ")";
                ++attemptCount;
            }
        }
        if (noException) {
            CMGetDocumentAction.copyStream(part.getDataStream(), zos, false);
            zos.closeEntry();
        }
    }

    private File createMultipartZipFile(CMItem item, String partFileName) throws Exception {
        String methodName = "createMultipartZipFile";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        File tempZipFile = null;
        tempZipFile = File.createTempFile("ContentNavigator", ".zip");
        String tempZipFileName = tempZipFile.getPath();
        tempZipFile.delete();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "create temp zip file: " + tempZipFileName);
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempZipFileName));
        int partCount = item.getContentCount();
        for (int i = 0; i < partCount; ++i) {
            CMObject part = item.getContent(i);
            String fileName = partFileName + " - " + (i + 1) + "." + MimeTypeUtil.getExtFromMimeType(part.getMimeType());
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "adding to temp zip file: " + fileName);
            zos.putNextEntry(new ZipEntry(fileName));
            CMGetDocumentAction.copyStream(part.getDataStream(), zos, false);
            zos.closeEntry();
        }
        zos.close();
        tempZipFile = new File(tempZipFileName);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return tempZipFile;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        DocumentInfoMediator docInfoMediator = (DocumentInfoMediator)this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        String partNumber = request.getParameter("part_number");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: part_number = " + partNumber);
        String transform = request.getParameter("transform");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            docInfoMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            docInfoMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        docInfoMediator.setDocumentId(pid);
        if (partNumber == null || partNumber.trim().length() < 1 || partNumber.equals("all")) {
            partNumber = "0";
        } else {
            try {
                docInfoMediator.setPartNumber(Integer.parseInt(partNumber));
            }
            catch (NumberFormatException ne) {
                docInfoMediator.addError("error.parm.null", "part_number");
                this.setRequestHasErrors(request, true);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        DocumentInfoMediator docInfoMediator = new DocumentInfoMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)docInfoMediator);
        return docInfoMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        String partNumber = request.getParameter("part_number");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: part_number = " + partNumber);
        String transform = request.getParameter("transform");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        String altOutput = request.getParameter("alt_output");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
    }

    private static void copyStream(InputStream inStream, OutputStream outStream, boolean closeOutputStream) throws IOException {
        if (inStream != null) {
            byte[] buf = new byte[4096];
            int len = inStream.read(buf);
            while (len != -1) {
                outStream.write(buf, 0, len);
                len = inStream.read(buf);
            }
            inStream.close();
            outStream.flush();
        }
        if (closeOutputStream) {
            outStream.close();
        }
    }
}

