/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMAttributesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkEntityDef;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMGetDependentAttributeInfoAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    private WCDateFormat wcDateFormats = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionErrors errors = new ActionErrors();
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        CMAttributesMediator attributesMediator = (CMAttributesMediator)this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String itemTypeName = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemTypeName = " + itemTypeName);
        DKDatastoreICM dsICM = this.getDataStore(request);
        JSONObject jsonAttributeValues = JSONObject.parse(this.readJSON(request));
        for (String key : jsonAttributeValues.keySet()) {
            Object value;
            Object jsonValue = jsonAttributeValues.get(key);
            if (jsonValue instanceof JSONArray) {
                JSONArray jsonValueArray = (JSONArray)jsonValue;
                value = jsonValueArray.toArray(new String[jsonValueArray.size()]);
            } else {
                value = jsonValue;
            }
            attributesMediator.addCurrentValue(key, value);
        }
        DKDatastoreICM dKDatastoreICM = dsICM;
        synchronized (dKDatastoreICM) {
            try {
                this.getConfigInfo(request);
                CMConnection connection = this.getConnection(request);
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(itemTypeName);
                if (itemType != null) {
                    CMEntity entity = new CMEntity(connection, (dkEntityDef)itemType);
                    attributesMediator.addCMEntity(entity);
                    DKSequentialCollection attrColl = (DKSequentialCollection)itemType.listAllAttributes();
                    attributesMediator.setAttrColl((dkCollection)attrColl);
                    dkCollection referenceAttributes = itemType.listAttrGroups(99);
                    attributesMediator.setReferenceAttributes(referenceAttributes);
                    DKSequentialCollection compTypes = (DKSequentialCollection)itemType.listSubEntities();
                    attributesMediator.setChildComponents((dkCollection)compTypes);
                    DKSequentialCollection foreignKeys = (DKSequentialCollection)itemType.listForeignKeys();
                    attributesMediator.setForeignKeys((dkCollection)foreignKeys);
                } else {
                    attributesMediator.addError("cannot.be.opened");
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                attributesMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMAttributesMediator searchCriteriaMediator = new CMAttributesMediator(request, this.getResources(request), request.getLocale());
        return searchCriteriaMediator;
    }

    public void getConfigInfo(HttpServletRequest request) throws Exception {
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
        }
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    public CMItem retrieveItem(HttpServletRequest request, DKDatastoreICM dsICM, String pid) throws Exception {
        String methodName = "retrieveItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMItem item = null;
        CMConnection connection = this.getConnection(request);
        DKDDO ddoItem = dsICM.createDDO(pid);
        item = new CMItem(request, connection, ddoItem, "");
        item.setItemState(1);
        item.setDateFormats(WCDateFormat.getDefaultDateFormats(request));
        item.getAttrName();
        item.getAttrValues();
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item with pid " + item.getPidString() + " retrieve");
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return item;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String itemTypeName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "itemTypeName = " + itemTypeName);
    }
}

