/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMAnnotationsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMGetAnnotationsAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMAnnotationsMediator annotationsMediator = (CMAnnotationsMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            block20: {
                int annotationPosition = 1400;
                String annotationPositionString = request.getParameter("annotation_position");
                if (annotationPositionString != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "annotation_position = " + annotationPositionString);
                    try {
                        annotationPosition = Integer.parseInt(annotationPositionString);
                        String apiVersion = dsICM.getAPIVersion();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "CM API Version: " + apiVersion);
                        if (apiVersion.startsWith("8.3") && apiVersion.compareTo("8.3.0.950") < 0) {
                            annotationPosition &= 0xFFFFFF;
                        } else if (apiVersion.startsWith("8.4.0")) {
                            annotationPosition &= 0xFFFFFF;
                        } else if (apiVersion.startsWith("8.4.1") && apiVersion.compareTo("8.4.1.100") < 0) {
                            annotationPosition &= 0xFFFFFF;
                        }
                    }
                    catch (NumberFormatException e) {
                        this.logFDC(request, response, null, methodName);
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                        if (annotationsMediator != null) {
                            annotationsMediator.addError("error.exception.general", e.getMessage());
                        }
                        response.setStatus(400);
                    }
                }
                String pid = request.getParameter("docid");
                try {
                    CMConnection connection = this.getConnection(request);
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                    dkRetrieveOptions.partsList(true);
                    dkRetrieveOptions.partsAttributes(true);
                    CMItem item = connection.retrieveItem(pid, request, dkRetrieveOptions);
                    int partNum = 0;
                    int annotationCount = item.getAnnotationCount();
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Number of annotations =" + annotationCount + ";  requested part number=" + partNum);
                    String altOutput = request.getParameter("alt_output");
                    if (altOutput == null || altOutput.equalsIgnoreCase("JSON")) {
                        response.setContentType("text/json");
                        ServletOutputStream os = response.getOutputStream();
                        if (annotationCount > partNum) {
                            CMObject annotation = item.getAnnotation(partNum);
                            annotationsMediator.setAnnotation(annotation);
                        }
                        annotationsMediator.setAnnotationPosition(annotationPosition);
                        CMEntity entity = connection.getEntity(item.getEntityName());
                        short versionPolicy = entity.getPartTypeVersionPolicy("ICMANNOTATION");
                        annotationsMediator.setVersioningPolicy(versionPolicy);
                        os.write(annotationsMediator.toJSONString().getBytes("UTF8"));
                        os.close();
                    } else if (altOutput.equalsIgnoreCase("STREAM")) {
                        if (annotationCount > partNum) {
                            CMObject annotation = item.getAnnotation(partNum);
                            byte[] arrayData = annotation.getByteArrayData();
                            int size = arrayData.length;
                            response.setContentLength(size);
                            response.setContentType(annotation.getMimeType());
                            ServletOutputStream os = response.getOutputStream();
                            os.write(arrayData);
                            os.close();
                        } else {
                            response.setContentLength(0);
                        }
                    }
                }
                catch (Exception e) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    if (annotationsMediator == null) break block20;
                    annotationsMediator.addError("error.exception.general", e.getMessage());
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        String transform = request.getParameter("transform");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMAnnotationsMediator baseMediator = new CMAnnotationsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        String transform = request.getParameter("transform");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: transform = " + transform);
    }
}

