/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMFindUsersGroupsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKUserDefICM;
import com.ibm.mm.sdk.common.DKUserMgmtICM;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMFindUsersGroupsAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        request.setCharacterEncoding("UTF-8");
        MessageResources resources = this.getResources(request);
        ActionForward actionForward = null;
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        CMFindUsersGroupsMediator findUsersGroupsMediator = (CMFindUsersGroupsMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                String searchString = request.getParameter("searchString");
                String max = request.getParameter("maxResult");
                dkCollection dkCol = null;
                ArrayList users = new ArrayList();
                DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)dsICM);
                boolean isFindUsers = mapping.getPath().endsWith("/findUsers");
                dkCol = isFindUsers ? userMgmt.listFilteredUserDefs(searchString, DKUserMgmtICM.DK_ICM_USER_RETRIEVAL_OPTION.DK_ICM_USER_RETRIEVAL_OPTION_ALL_ATTRIBUTES_ONLY) : userMgmt.listFilteredUserGroupDefs(searchString, DKUserMgmtICM.DK_ICM_USER_GROUP_RETRIEVAL_OPTION.DK_ICM_USER_GROUP_RETRIEVAL_OPTION_ATTRIBUTES_ONLY);
                findUsersGroupsMediator.setUserGroupCollection(dkCol);
                findUsersGroupsMediator.setPageSize(Integer.parseInt(max));
                String adminDomain = this.getAdminDomain(request, dsICM);
                findUsersGroupsMediator.setAdminDomainName(adminDomain);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Users or groups were retrieved");
                findUsersGroupsMediator.addMessage(isFindUsers ? "users.retrieve.successful" : "groups.retrieve.successful", new Object[0]);
            }
            catch (Throwable e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, e);
                findUsersGroupsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private String getAdminDomain(HttpServletRequest request, DKDatastoreICM dsICM) {
        String methodName = "getAdminDomain";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String domainName = null;
        try {
            if (dsICM.adminDomainEnabled()) {
                DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)dsICM);
                String userId = dsICM.getUserName().toUpperCase();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userId: " + userId);
                DKUserDefICM userDef = (DKUserDefICM)userMgmt.retrieveUserDef(userId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userDef: " + userDef);
                if (userDef != null) {
                    domainName = userDef.getDomainName();
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "domainName: " + domainName);
            }
        }
        catch (DKException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return domainName;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        String searchString = request.getParameter("searchString");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: searchString = " + searchString);
        if (searchString == null || searchString.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "searchString");
            this.setRequestHasErrors(request, true);
        }
        String max = request.getParameter("maxResult");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: maxResult = " + max);
        if (max == null || max.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "maxResult");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMFindUsersGroupsMediator findUsersGroupsMediator = new CMFindUsersGroupsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)findUsersGroupsMediator);
        return findUsersGroupsMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

