/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.Constants;
import com.ibm.ecm.beans.cm.CMAttributeDef;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.security.cm8.CM8SecurityUtils;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkAttrDef;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkXDO;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMEditAttributesAction
extends CMBaseAction
implements Constants {
    private int pageSize = 0;
    private int maxResults = 0;
    private boolean updateStorageCollection = true;
    private boolean keepInAutoFolder = false;
    private WCDateFormat wcDateFormats = null;
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    private JSONObject aclJSON = null;

    public boolean isUpdateStorageCollection() {
        return this.updateStorageCollection;
    }

    public void setUpdateStorageCollection(boolean updateStorageCollection) {
        this.updateStorageCollection = updateStorageCollection;
    }

    public boolean isKeepInAutoFolder() {
        return this.keepInAutoFolder;
    }

    public void setKeepInAutoFolder(boolean keepInAutoFolder) {
        this.keepInAutoFolder = keepInAutoFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        this.aclJSON = new JSONObject();
        this.aclJSON.put("acl", new JSONArray());
        this.aclJSON.put("modifyPermissions", "false");
        DKDatastoreICM dsICM = this.getDataStore(request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Entering synchronized block");
        DKDatastoreICM dKDatastoreICM = dsICM;
        synchronized (dKDatastoreICM) {
            block26: {
                boolean checkInItem = false;
                String checkInItemString = request.getParameter("parm_checked_out_by_action");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "checkInItemString = " + checkInItemString);
                if (checkInItemString != null && checkInItemString.equalsIgnoreCase("true")) {
                    checkInItem = true;
                }
                CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
                HashMap<String, String> updatedDocIds = new HashMap<String, String>();
                String itemTypeName = null;
                String newItemTypeName = null;
                String newItemTypeDescription = null;
                String newItemTypeId = null;
                try {
                    this.getConfigInfo(request);
                    String serverName = request.getParameter("repositoryId");
                    itemTypeName = request.getParameter("template_name");
                    String pid = request.getParameter("docid");
                    JSONArray jsonArray = (JSONArray)this.getJSONRequest(request);
                    JSONObject jsonObj = (JSONObject)jsonArray.get(0);
                    JSONArray criteriasJsonArray = (JSONArray)jsonObj.get("criterias");
                    JSONArray childCompValuesJsonArray = (JSONArray)jsonObj.get("childComponentValues");
                    JSONArray permissionsJSON = null;
                    if (jsonObj.get("acl") != null) {
                        permissionsJSON = (JSONArray)jsonObj.get("acl");
                    }
                    this.aclJSON.put("acl", permissionsJSON);
                    String clientSiteVersionControlSetting = request.getParameter("parm_version_control");
                    newItemTypeName = request.getParameter("new_template_name");
                    boolean reIndex = false;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: newItemTypeName = " + newItemTypeName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: versionControl = " + clientSiteVersionControlSetting);
                    DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                    DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(itemTypeName);
                    if (newItemTypeName != null && !newItemTypeName.equalsIgnoreCase(itemTypeName)) {
                        reIndex = true;
                        dsDefICM = (DKDatastoreDefICM)dsICM.datastoreDef();
                        itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(newItemTypeName);
                    }
                    newItemTypeDescription = itemType.getDescription();
                    newItemTypeId = Integer.toString(itemType.getId());
                    searchResultsMediator.setItemType(itemType);
                    dkCollection referenceAttributes = itemType.listAttrGroups(99);
                    searchResultsMediator.setReferenceAttributes(referenceAttributes);
                    DKSequentialCollection compTypes = (DKSequentialCollection)itemType.listSubEntities();
                    searchResultsMediator.setChildComponents((dkCollection)compTypes);
                    CMItem item = this.retrieveItem(request, dsICM, pid);
                    item.setDateFormats(this.getDateFormats());
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "reIndex=" + reIndex);
                    CMItem updatedItem = this.updateItem(criteriasJsonArray, childCompValuesJsonArray, clientSiteVersionControlSetting, dsICM, item, request, searchResultsMediator, updatedDocIds, checkInItem, newItemTypeName, reIndex, itemType, permissionsJSON);
                    CMConnection connection = this.getConnection(request);
                    CMSearchResults wcSearchResults = new CMSearchResults(request, connection);
                    wcSearchResults.setPageSize(this.getPageSize());
                    searchResultsMediator.setDateFormats(this.getDateFormats());
                    searchResultsMediator.setUpdatedDocIds(updatedDocIds);
                    Vector<CMItem> resultsVector = new Vector<CMItem>();
                    resultsVector.add(updatedItem);
                    wcSearchResults.newResults(resultsVector, true, false, false);
                    searchResultsMediator.setSearchResults(wcSearchResults);
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.childListOneLevel(true);
                    dkRetrieveOptions.childAttributes(true);
                    dkRetrieveOptions.basePropertyAclName(true);
                    dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                    try {
                        CMItem cmItem = connection.retrieveItem(updatedItem.getPidString(), request, dkRetrieveOptions);
                        Hashtable<String, String[]> attrNameValuePairs = new Hashtable<String, String[]>();
                        dkIterator iter = compTypes.createIterator();
                        while (iter.more()) {
                            DKComponentTypeDefICM compType = (DKComponentTypeDefICM)iter.next();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "     - " + compType.getName() + ":  " + compType.getDescription());
                            CMItem[] childComponentInstances = cmItem.getAttrItems(compType.getName());
                            if (childComponentInstances == null || childComponentInstances.length <= 0) continue;
                            String[] attrNames = childComponentInstances[0].getAttrNames();
                            for (int z = 0; z < attrNames.length; ++z) {
                                String attrName = attrNames[z];
                                short attrType = childComponentInstances[0].getAttrType(attrName);
                                String childAttrName = compType.getName() + "@$" + attrName;
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "     - add " + childAttrName);
                                String[] childAttrValues = new String[childComponentInstances.length];
                                for (int j = 0; j < childComponentInstances.length; ++j) {
                                    if (attrType == 48) {
                                        try {
                                            int ri;
                                            CMItem[] items = childComponentInstances[j].getAttrItems(attrName);
                                            if (items.length <= 0 || (ri = 0) >= items.length) continue;
                                            CMItem refItem = items[ri];
                                            childAttrValues[j] = refItem.getPidString();
                                        }
                                        catch (Throwable t) {
                                            childAttrValues[j] = "";
                                        }
                                        continue;
                                    }
                                    childAttrValues[j] = childComponentInstances[j].getAttrValues()[z].trim();
                                }
                                if (childAttrValues == null) continue;
                                attrNameValuePairs.put(childAttrName, childAttrValues);
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "     - added " + childAttrName);
                            }
                        }
                        searchResultsMediator.setAttrNameValuePairs(attrNameValuePairs);
                    }
                    catch (DKException de) {
                        this.logFDC(request, response, null, methodName);
                        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)de);
                        int errorId = de.getErrorId();
                        if (errorId == 491) {
                            searchResultsMediator.addError("error.exception.updateditemnotfound", item.getName());
                            break block26;
                        }
                        throw de;
                    }
                }
                catch (DKException de) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)de);
                    int errorId = de.getErrorId();
                    int errorCode = de.errorCode();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "errorId: " + errorId + ", errorCode: " + errorCode);
                    if (errorId == 5247) {
                        searchResultsMediator.addError("error.cardinality", de.getMessage());
                    } else if (errorId == 5218) {
                        searchResultsMediator.addError("error.null.clobOrBlob", newItemTypeDescription, newItemTypeName, newItemTypeId, de.getMessage());
                    } else if (errorId == 3601 && de.errorCode() == 7388) {
                        searchResultsMediator.addError("editProperies.unique.error", new Object[0]);
                    } else if (errorId == 3616 && errorCode == 7015) {
                        searchResultsMediator.addError("editProperties.linked.error", de.getMessage());
                    } else {
                        searchResultsMediator.addError("editProperies.error", de.getMessage());
                    }
                }
                catch (Exception e) {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    searchResultsMediator.addError("editProperies.error", e.getMessage());
                }
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Leaving synchronized block");
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    public CMItem retrieveItem(HttpServletRequest request, DKDatastoreICM dsICM, String pid) throws Exception {
        String methodName = "setupItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMItem item = null;
        CMConnection connection = this.getConnection(request);
        DKDDO ddoItem = dsICM.createDDOFromPID(pid);
        item = new CMItem(request, connection, ddoItem, "");
        item.setItemState(1);
        item.setDateFormats(this.getDateFormats());
        item.getAttrName();
        item.getAttrValues();
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item with pid " + item.getPidString() + " setup");
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return item;
    }

    private CMItem updateItem(JSONArray criteriasJsonArray, JSONArray childCompValuesJsonArray, String clientSiteVersionControlSetting, DKDatastoreICM dsICM, CMItem item, HttpServletRequest request, CMSearchResultsMediator searchResultsMediator, HashMap<String, String> updatedDocIds, boolean checkInItem, String newItemTypeName, boolean reIndex, DKComponentTypeDefICM itemType, JSONArray permissionsJSON) throws Exception {
        String methodName = "updateItem";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMConnection connection = this.getConnection(request);
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.basePropertyCheckedOutDetails(true);
        dkRetrieveOptions.childListOneLevel(true);
        dkRetrieveOptions.childAttributes(true);
        dkRetrieveOptions.basePropertyAclName(true);
        CMItem updatedItem = connection.retrieveItem(item.getPidString(), request, dkRetrieveOptions);
        DKDDO ddoItem = updatedItem.getDDO();
        boolean createNewVersion = true;
        short itemVersionControlSetting = item.getVersionControl();
        if (itemVersionControlSetting == CMItem.ITEM_TYPE_VERSION_CONTROL_ALWAYS) {
            createNewVersion = true;
        } else if (itemVersionControlSetting == CMItem.ITEM_TYPE_VERSION_CONTROL_NEVER) {
            createNewVersion = false;
        } else if (clientSiteVersionControlSetting == null || clientSiteVersionControlSetting.equalsIgnoreCase("parm_create_new_version")) {
            createNewVersion = true;
        } else if (clientSiteVersionControlSetting != null && clientSiteVersionControlSetting.equalsIgnoreCase("parm_replace_existing_version")) {
            createNewVersion = false;
        } else {
            Logger.logError((Object)this, methodName, (ServletRequest)request, "ERROR - No versioning information provided.");
            Logger.logError((Object)this, methodName, (ServletRequest)request, "The versioning information should be set by the application, but was not received by the WCEditAttributes action. NO UPDATES on item performed.");
            searchResultsMediator.addError("editProperies.error");
            return item;
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "create new version? " + createNewVersion);
        if (item.getEntityName().equals("ICMTeamspace") || item.getEntityName().equals("ICMTeamspaceTemplate")) {
            try {
                dsICM.checkOut((dkDataObject)ddoItem);
                checkInItem = true;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean isCheckedOut = false;
        DKDatastoreExtICM dsExt = this.getDataStoreExt(request);
        if (dsICM != null && dsICM.isConnected() && dsExt.isSupported("checkOut")) {
            if (!dsExt.isCheckedOut((dkDataObject)ddoItem)) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The Item needs to be checked out before it can be updated.");
                isCheckedOut = false;
                searchResultsMediator.addError("editProperties.error.notCheckedOut");
            } else {
                String currentUser = dsExt.getDatastore().userName();
                String checkedOutBy = dsExt.checkedOutUserid((dkDataObject)ddoItem);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "checked out by =" + checkedOutBy);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "user name currently logged on=" + currentUser);
                if (currentUser.equalsIgnoreCase(checkedOutBy)) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item is checked out by current user");
                    isCheckedOut = true;
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The properties cannot be saved because the item is checked out by another user.");
                    isCheckedOut = false;
                    searchResultsMediator.addError("editProperties.error.checkedOut");
                }
            }
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Problems during check out check. Either there is no connection to cm (DKDatastoreICM) or check out is not supported.");
            isCheckedOut = false;
            searchResultsMediator.addError("editProperties.error.server");
        }
        if (isCheckedOut) {
            if (reIndex) {
                updatedItem.removeAllAttrs();
                updatedItem.setEntityName(newItemTypeName);
                updatedItem._attrsRetrieved = true;
            }
            JSONObject criteria = null;
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemType=" + itemType.getName());
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "update Item with values from Edit Properties dialog");
            for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
                String criteriaValue;
                criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
                String criteriaName = criteria.get("name").toString();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, " criteriaName=" + criteriaName);
                if (criteria.get("value") != null) {
                    criteriaValue = (String)criteria.get("value");
                } else {
                    JSONArray valuesJsonArray = (JSONArray)criteria.get("values");
                    criteriaValue = (String)valuesJsonArray.get(0);
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criteriaValue=" + criteriaValue);
                dkAttrDef attrDef = itemType.getAttr(criteriaName);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "update Item: attrName=" + criteriaName + " attrValue=" + criteriaValue + " attrValueLength=" + criteriaValue.length());
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "itemType.getAttr=" + attrDef);
                if (attrDef == null) {
                    DKComponentTypeAttrGroupDefICM attrGroup;
                    String groupName = null;
                    int indexOf = criteriaName.indexOf(46);
                    if (indexOf > -1) {
                        groupName = criteriaName.substring(0, indexOf);
                    }
                    if (groupName != null && !groupName.equals("") && (attrGroup = (DKComponentTypeAttrGroupDefICM)itemType.getAttrGroup(groupName)) != null) {
                        Vector attrs = attrGroup.getAttrs();
                        for (int y = 0; y < attrs.size(); ++y) {
                            dkAttrDef at = (dkAttrDef)attrs.get(y);
                            if (!at.getName().equals(criteriaName)) continue;
                            attrDef = at;
                            break;
                        }
                    }
                }
                short attrType = attrDef.getType();
                SimpleDateFormat dfClient = null;
                SimpleDateFormat dfRepo = null;
                switch (attrType) {
                    case 7: {
                        dfClient = (SimpleDateFormat)this.getDateFormats().getDateFormat();
                        dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(request).getDateFormat();
                        break;
                    }
                    case 8: {
                        dfClient = (SimpleDateFormat)this.getDateFormats().getTimeFormat();
                        dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(request).getTimeFormat();
                        break;
                    }
                    case 9: {
                        dfClient = (SimpleDateFormat)this.getDateFormats().getTimestampFormat();
                        dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(request).getTimestampFormat();
                        break;
                    }
                    default: {
                        dfClient = null;
                    }
                }
                if (dfClient != null && criteriaValue != null && criteriaValue.trim().length() > 0) {
                    Date tempDate = attrType == 7 || attrType == 8 ? DateUtil.parseISODate(criteriaValue, false) : DateUtil.parseISODate(criteriaValue, true);
                    criteriaValue = dfRepo.format(tempDate);
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "updatedItem.setAttrValue for " + criteriaName + "     :  with value :  " + criteriaValue);
                if (!reIndex && updatedItem.isAttr(criteriaName)) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "updatedItem.isAttr  is true");
                    updatedItem.setAttrValue(criteriaName, criteriaValue);
                } else {
                    updatedItem.addAttr(criteriaName, criteriaValue, attrType);
                }
                item.setAttrValue(criteriaName, criteriaValue);
            }
            CMEntity entity = connection.getEntity(updatedItem.getEntityName());
            CMEntity[] subEntities = entity.getSubEntities();
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "childCompValuesJsonArray: " + childCompValuesJsonArray);
            if (childCompValuesJsonArray != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "There are  - " + childCompValuesJsonArray.size() + " child components");
                for (int iChildCompCounter = 0; iChildCompCounter < childCompValuesJsonArray.size(); ++iChildCompCounter) {
                    JSONObject childComponent = (JSONObject)childCompValuesJsonArray.get(iChildCompCounter);
                    String childCompName = childComponent.get("name").toString();
                    JSONArray childCompCriteriasJsonArray = (JSONArray)childComponent.get("values");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "There are  - " + childCompCriteriasJsonArray.size() + " instances for - " + childCompName);
                    CMEntity selectedSubEntity = this.getSubEntity(subEntities, childCompName);
                    CMAttributeDef[] attributes = selectedSubEntity.getAttributes();
                    ArrayList<CMItem> childComponentInstances = null;
                    if (attributes != null && attributes.length > 0) {
                        childComponentInstances = new ArrayList<CMItem>();
                        CMItem childItem = null;
                        JSONObject childJSON = null;
                        for (int iRowCounter = 0; iRowCounter < childCompCriteriasJsonArray.size(); ++iRowCounter) {
                            boolean allValuesAreNull = true;
                            childJSON = (JSONObject)childCompCriteriasJsonArray.get(iRowCounter);
                            childItem = new CMItem(request, connection);
                            childItem.setServerName(item.getServerName());
                            childItem.setServerType(item.getServerType());
                            childItem.setEntityName(childCompName);
                            JSONArray valuesJsonArray = (JSONArray)childJSON.get("values");
                            for (int a = 0; a < valuesJsonArray.size(); ++a) {
                                criteria = (JSONObject)valuesJsonArray.get(a);
                                String criteriaName = criteria.get("name").toString();
                                criteriaName = criteriaName.substring(childCompName.length() + 1);
                                String dataType = criteria.get("dataType").toString();
                                JSONArray critValJsonArray = (JSONArray)criteria.get("values");
                                String criteriaValue = (String)critValJsonArray.get(0);
                                criteriaValue = criteriaValue.trim();
                                if (dataType.equals("xs:reference")) {
                                    if (criteriaValue == null || criteriaValue.length() <= 0) continue;
                                    allValuesAreNull = false;
                                    CMItem refItem = connection.retrieveItem(criteriaValue, request, dkRetrieveOptions);
                                    CMItem[] refitems = new CMItem[]{refItem};
                                    childItem.addAttr(criteriaName, refitems, this.getSubAttribute(attributes, criteriaName).getType());
                                    continue;
                                }
                                SimpleDateFormat dfClient = null;
                                SimpleDateFormat dfRepo = null;
                                if (dataType.equals("xs:date")) {
                                    dfClient = (SimpleDateFormat)this.getDateFormats().getDateFormat();
                                    dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(request).getDateFormat();
                                } else if (dataType.equals("xs:time")) {
                                    dfClient = (SimpleDateFormat)this.getDateFormats().getTimeFormat();
                                    dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(request).getTimeFormat();
                                } else if (dataType.equals("xs:timestamp")) {
                                    dfClient = (SimpleDateFormat)this.getDateFormats().getTimestampFormat();
                                    dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(request).getTimestampFormat();
                                }
                                if (dfClient != null && criteriaValue != null && criteriaValue.trim().length() > 0) {
                                    Date tempDate = dataType.equals("xs:date") || dataType.equals("xs:time") ? DateUtil.parseISODate(criteriaValue, false) : DateUtil.parseISODate(criteriaValue, true);
                                    criteriaValue = dfRepo.format(tempDate);
                                }
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "update Item: attrName=" + criteriaName + " attrValue=" + criteriaValue + " attrValueLength=" + criteriaValue.length());
                                if (criteriaValue == null || criteriaValue.length() <= 0) continue;
                                allValuesAreNull = false;
                                CMAttributeDef subAttribute = this.getSubAttribute(attributes, criteriaName);
                                childItem.addAttr(criteriaName, criteriaValue, subAttribute.getType());
                            }
                            if (allValuesAreNull) continue;
                            childComponentInstances.add(childItem);
                        }
                    }
                    if (childComponentInstances.size() > 0) {
                        CMItem[] collection = new CMItem[childComponentInstances.size()];
                        for (int sibling = 0; sibling < collection.length; ++sibling) {
                            collection[sibling] = (CMItem)childComponentInstances.get(sibling);
                        }
                        if (collection.length <= 0) continue;
                        if (reIndex) {
                            short id = ddoItem.dataId("CHILD", childCompName);
                            updatedItem.addAttr(childCompName, collection, id);
                            continue;
                        }
                        updatedItem.setAttrItems(childCompName, collection);
                        continue;
                    }
                    if (reIndex) continue;
                    CMItem[] subitems = updatedItem.getAttrItems(childCompName);
                    for (int k = 0; k < subitems.length; ++k) {
                        updatedItem.removeAttrItem(childCompName, subitems[k]);
                    }
                }
            }
            boolean isItemTypeLevelACL = entity.isItemTypeLevelACL();
            if (permissionsJSON != null && !isItemTypeLevelACL && CMBaseUtil.checkAuthorization(CMEditAttributesAction.getCommonPrivilege(request, updatedItem.getDDO(), dsICM), 83)) {
                CM8SecurityService securityService = new CM8SecurityService(request, connection.getDatastore());
                AccessControlList secObjACL = CM8SecurityUtils.getPermissionsFromJSON(request, permissionsJSON, connection.getDatastore(), SecurityConstants.AppPrivilegeSets.OWNER);
                if (secObjACL != null) {
                    Object obj;
                    short val;
                    secObjACL.setName(ddoItem.getPidObject().getPrimaryId());
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Applying security to template... ACL name: " + secObjACL.getName());
                    if (secObjACL != null) {
                        secObjACL = securityService.setACL(secObjACL, ddoItem, false, false);
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Default ACL from Item type or User def will be used");
                    }
                    boolean isFolder = false;
                    short propID = ddoItem.propertyId("item-type");
                    if (propID > 0 && (val = ((Short)(obj = ddoItem.getProperty(propID))).shortValue()) == 2) {
                        isFolder = true;
                    }
                    this.aclJSON = CM8SecurityUtils.createJSONFromACL(request, dsICM, secObjACL, isFolder, isItemTypeLevelACL, CMBaseUtil.checkAuthorization(CMEditAttributesAction.getCommonPrivilege(request, ddoItem, dsICM), 83));
                    searchResultsMediator.setACLJson(this.aclJSON);
                }
            }
            DKLobICM resItem = null;
            if (createNewVersion && updatedItem.getDDO() instanceof DKLobICM) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "updating properties + request to create a new version of a Resource Item - therefore need to retrieve resource content");
                resItem = (DKLobICM)updatedItem.getDDO();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "resource ITEM MIME TYPE *before update*:" + resItem.getMimeType());
                resItem.retrieve(512);
                resItem.setContentChanged(true);
            }
            String origPID = updatedItem.getPidString();
            if (reIndex) {
                if (this.isKeepInAutoFolder()) {
                    connection.reindexItem(updatedItem, newItemTypeName, true, false, request);
                } else {
                    connection.reindexItem(updatedItem, newItemTypeName, false, false, request);
                }
            } else {
                connection.updateItem(updatedItem, createNewVersion, request);
            }
            String newPID = updatedItem.getPidString();
            if (createNewVersion && updatedItem.getDDO() instanceof DKLobICM) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "resource ITEM MIME TYPE *after update*:" + resItem.getMimeType());
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Free up resource content now.");
                ((dkXDO)updatedItem.getDDO()).setNull();
            }
            if (!origPID.equals(newPID)) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "new version created - setting information about updated DOC Ids (PID)");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "newDOCid  (PID): " + newPID);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "origDOCid (PID): " + origPID);
                updatedDocIds.put(newPID, origPID);
                item = this.retrieveItem(request, dsICM, newPID);
            }
            if (checkInItem) {
                dsExt.checkIn((dkDataObject)ddoItem);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Item checked in.");
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Item was not checked out by EditProperties (it was already checked out), therefore leave it checked out.");
            }
        }
        item.setItemState(1);
        item._attrsRetrieved = false;
        item.getAttrValues();
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return item;
    }

    private CMAttributeDef getSubAttribute(CMAttributeDef[] attributes, String criteriaName) {
        CMAttributeDef selectedSubAttribute = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equalsIgnoreCase(criteriaName)) continue;
            selectedSubAttribute = attributes[i];
            break;
        }
        return selectedSubAttribute;
    }

    private CMEntity getSubEntity(CMEntity[] subEntities, String childCompName) {
        CMEntity selectedSubEntity = null;
        for (int i = 0; i < subEntities.length; ++i) {
            if (!subEntities[i].getName().equalsIgnoreCase(childCompName)) continue;
            selectedSubEntity = subEntities[i];
            break;
        }
        return selectedSubEntity;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template_name");
        String pid = request.getParameter("docid");
        return serverName != null && itemTypeName != null && pid != null;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator mediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        mediator.setConnection(this.getConnection(request));
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    @Override
    public void getConfigInfo(HttpServletRequest request) throws Exception {
        String methodName = "getConfigInfo";
        int pageSizeInt = 50;
        int maxResultsInt = 50;
        boolean keepInAutoFolderBol = false;
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.keepInAutoFolder = repositoryConfig.getKeepInAutoFolder();
            this.updateStorageCollection = repositoryConfig.getUpdateStorageCollection();
            this.pageSize = repositoryConfig.getPageSize();
            this.maxResults = repositoryConfig.getMaxResults();
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "pageSize = " + pageSizeInt);
        this.setPageSize(pageSizeInt);
        this.setMaxResults(maxResultsInt);
        this.setKeepInAutoFolder(keepInAutoFolderBol);
        this.setKeepInAutoFolder(keepInAutoFolderBol);
    }

    @Override
    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    @Override
    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    @Override
    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        String itemTypeName = request.getParameter("template_name");
        String pid = request.getParameter("docid");
        String clientSiteVersionControlSetting = request.getParameter("parm_version_control");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + itemTypeName);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: versionControl = " + clientSiteVersionControlSetting);
    }

    @Override
    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String strJsonFormData = this.readJSON(request);
        JSONArray jsonArray = JSONArray.parse(strJsonFormData);
        request.setAttribute("json_post", (Object)jsonArray);
    }
}

