/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.Constants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMDeleteRoleAction
extends CMBaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String serverName = request.getParameter("repositoryId");
        String roleId = request.getParameter("id");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "roleId = " + roleId);
        DKDatastoreICM dsICM = this.getDataStore(request);
        BaseMediator mediator = this.getMediator(request);
        try {
            DKDatastoreICM dKDatastoreICM = dsICM;
            synchronized (dKDatastoreICM) {
                CM8SecurityService service = new CM8SecurityService(request, dsICM);
                service.deleteRoleObject(roleId);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Role was deleted");
            mediator.addMessage("role.delete.successful", new Object[0]);
        }
        catch (SecurityException e) {
            if (e.getErrorID() == 7215) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, "User does not have enough privileges");
                mediator.addError("deleteRole.error.failed", e.getCause().getMessage());
            } else {
                Logger.logError((Object)this, methodName, (ServletRequest)request, e.getMessage());
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        catch (Throwable e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, e);
            mediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

