/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMCheckInAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonItem = new JSONObject();
        jsonArray.add(jsonItem);
        String criterias = request.getParameter("criterias");
        JSONArray criteriasJsonArray = JSONArray.parse(criterias);
        jsonItem.put("criterias", criteriasJsonArray);
        String childComps = request.getParameter("childComponentValues");
        JSONArray childCompsJsonArray = JSONArray.parse(childComps);
        jsonItem.put("childComponentValues", childCompsJsonArray);
        request.setAttribute("json_post", (Object)jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM ds;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
        searchResultsMediator.setResponseAsHtml(((FileUploadActionForm)form).getUploadFile() != null);
        DKDatastoreICM dKDatastoreICM = ds = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            String serverName = null;
            String newEntityName = null;
            String contentType = null;
            String pid = null;
            String itemTypeDescription = null;
            String itemTypeName = null;
            String itemTypeId = null;
            try {
                DKDatastoreExtICM dsExt;
                this.getConfigInfo(request);
                serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + (serverName != null ? serverName : ""));
                newEntityName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: newEntityName = " + (newEntityName != null ? newEntityName : ""));
                contentType = request.getParameter("parm_content_source_type");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "contentType = " + (contentType != null ? contentType : ""));
                pid = request.getParameter("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + (pid != null ? pid : ""));
                boolean createNewVersion = this.getBooleanRequestParameter(request, "parm_create_new_version", true);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: createNewVersion = " + createNewVersion);
                if (contentType.equalsIgnoreCase("Document")) {
                    String partType = request.getParameter("parm_part_type");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: partType = " + (partType != null ? partType : ""));
                    String partMimeType = request.getParameter("mimetype");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: partMimeType = " + (partMimeType != null ? partMimeType : ""));
                    String partLength = request.getParameter("parm_part_length");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: partLength = " + (partLength != null ? partLength : ""));
                    String partFileName = request.getParameter("parm_part_filename");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: partFileName = " + (partFileName != null ? partFileName : ""));
                }
                JSONArray jsonRequest = (JSONArray)this.getJSONRequest(request);
                JSONObject jsonItem = (JSONObject)jsonRequest.get(0);
                JSONArray criteriasJsonArray = (JSONArray)jsonItem.get("criterias");
                JSONArray childCompValuesJsonArray = (JSONArray)jsonItem.get("childComponentValues");
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)ds.datastoreDef();
                DKComponentTypeDefICM newCompTypeDef = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(newEntityName);
                DKItemTypeDefICM newItemTypeDef = newCompTypeDef instanceof DKItemTypeDefICM ? (DKItemTypeDefICM)newCompTypeDef : (DKItemTypeDefICM)dsDefICM.retrieveEntity(newCompTypeDef.getItemTypeName());
                switch (newItemTypeDef.getVersionControl()) {
                    case 0: {
                        createNewVersion = false;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Item type forces: createNewVersion = " + createNewVersion);
                        break;
                    }
                    case 1: {
                        createNewVersion = true;
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Item type forces: createNewVersion = " + createNewVersion);
                        break;
                    }
                }
                searchResultsMediator.setConnection(this.getConnection(request));
                searchResultsMediator.setItemType(newCompTypeDef);
                searchResultsMediator.setReferenceAttributes(newCompTypeDef.listAttrGroups(99));
                searchResultsMediator.setChildComponents((dkCollection)((DKSequentialCollection)newCompTypeDef.listSubEntities()));
                searchResultsMediator.setDateFormats(this.getDateFormats());
                itemTypeDescription = newCompTypeDef.getDescription();
                itemTypeName = newCompTypeDef.getName();
                itemTypeId = Integer.toString(newCompTypeDef.getItemTypeId());
                short entityClassification = newItemTypeDef.getClassification();
                boolean validItemType = this.validateItemType(request, itemTypeDescription, entityClassification, contentType, searchResultsMediator, itemTypeName, itemTypeId);
                if (!validItemType) {
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                boolean validAttributes = this.validateItemTypeAttributes(request, dsDefICM, (DKComponentTypeDefICM)newItemTypeDef, criteriasJsonArray);
                if (!validAttributes) {
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "CLOB, BLOB or DBCLOB attributes are not supported");
                    searchResultsMediator.addError("import.attribute.notsupported.explanation");
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                DKDDO ddo = ds.createDDOFromPID(pid);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)ds);
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                dkRetrieveOptions.basePropertyAclName(true);
                dkRetrieveOptions.childListOneLevel(true);
                dkRetrieveOptions.childAttributes(true);
                dkRetrieveOptions.partsList(true);
                dkRetrieveOptions.partsAttributes(true);
                dkRetrieveOptions.functionVersionLatest(true);
                ddo.retrieve(dkRetrieveOptions.dkNVPair());
                String oldEntityName = ddo.getObjectType();
                DKComponentTypeDefICM oldCompTypeDef = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(oldEntityName);
                DKItemTypeDefICM oldItemTypeDef = oldCompTypeDef instanceof DKItemTypeDefICM ? (DKItemTypeDefICM)oldCompTypeDef : (DKItemTypeDefICM)dsDefICM.retrieveEntity(oldCompTypeDef.getItemTypeName());
                if (oldItemTypeDef.getItemTypeName() != newItemTypeDef.getItemTypeName()) {
                    short dataid = ddo.propertyId("semantic-type");
                    int semanticType = 1;
                    if (dataid != 0) {
                        semanticType = (Integer)ddo.getProperty(dataid);
                    }
                    DKDDO updateDdo = ds.createDDO(newEntityName, semanticType);
                    this.setItemAttributesFromCriterias(request, newItemTypeDef, criteriasJsonArray, childCompValuesJsonArray, ds, updateDdo, null);
                    ds.moveObject((dkDataObject)ddo, (dkDataObject)updateDdo, 0);
                    ddo = updateDdo;
                    ddo.retrieve(dkRetrieveOptions.dkNVPair());
                } else {
                    this.setItemAttributesFromCriterias(request, newItemTypeDef, criteriasJsonArray, childCompValuesJsonArray, ds, ddo, null);
                }
                if (contentType.equalsIgnoreCase("Document")) {
                    this.setContent(request, ddo, ds, newItemTypeDef, form, false, createNewVersion);
                }
                if ((dsExt = this.getDataStoreExt(request)).isSupported("checkIn")) {
                    if (dsExt.isCheckedOut((dkDataObject)ddo)) {
                        int updateOptions = 8192;
                        if (createNewVersion) {
                            updateOptions |= 2;
                        }
                        ds.updateObject((dkDataObject)ddo, updateOptions);
                        ddo.retrieve(dkRetrieveOptions.dkNVPair());
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item is unlocked " + ddo.getPidObject().toString());
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item not checked out");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "user name currently logged on=" + dsExt.getDatastore().userName());
                    }
                }
                CMConnection connection = this.getConnection(request);
                CMItem item = new CMItem(request, connection, ddo, null, true, false, true);
                CMSearchResults wcSearchResults = new CMSearchResults(request, connection);
                Vector<CMItem> resultsVector = new Vector<CMItem>(1);
                resultsVector.add(item);
                wcSearchResults.newResults(resultsVector, true, false, true);
                searchResultsMediator.setSearchResults(wcSearchResults);
                searchResultsMediator.addMessage("document.checkin.successful", new Object[0]);
            }
            catch (DKException de) {
                this.logFDC(request, response, null, methodName);
                this.handleCMItemError(request, methodName, de, itemTypeDescription, contentType, searchResultsMediator, itemTypeName, itemTypeId);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        Boolean maxFileSizeExceeded;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.createMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + (repositoryId != null ? repositoryId : ""));
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + (pid != null ? pid : ""));
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            searchResultsMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            searchResultsMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        if ((maxFileSizeExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxFileSizeExceeded.booleanValue()) {
            searchResultsMediator.addError("import.filesize.exceed.maxlength");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String repositoryId = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + (repositoryId != null ? repositoryId : ""));
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + (pid != null ? pid : ""));
        String itemTypeName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: itemTypeName = " + (itemTypeName != null ? itemTypeName : ""));
        String contentSourceType = request.getParameter("parm_content_source_type");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "contentType = " + (contentSourceType != null ? contentSourceType : ""));
        String createNewVersion = request.getParameter("parm_create_new_version");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: createNewVersion = " + createNewVersion);
        if (contentSourceType.equalsIgnoreCase("Document")) {
            String partType = request.getParameter("parm_part_type");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: part type = " + (partType != null ? partType : ""));
            String partMimeType = request.getParameter("mimetype");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partMimeType = " + (partMimeType != null ? partMimeType : ""));
            String partLength = request.getParameter("parm_part_length");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partLength = " + (partLength != null ? partLength : ""));
            String partFileName = request.getParameter("parm_part_filename");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: partFileName = " + (partFileName != null ? partFileName : ""));
        }
    }
}

