/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.Constants;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.mediator.cm.CMLogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.mm.sdk.common.DKDatabaseLogonFailure;
import com.ibm.mm.sdk.common.DKDatastoreAccessError;
import com.ibm.mm.sdk.common.DKInvalidPasswordException;
import com.ibm.mm.sdk.common.DKLogonFailure;
import com.ibm.mm.sdk.common.DKServerNotAvailable;
import com.ibm.mm.sdk.common.DKUsageError;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMChangePasswordAction
extends CMBaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    public static final String PRIV_ADD_ITEM = "privAddItem";
    public static final String PRIV_ADD_CONTENT = "privAddContent";

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        ActionForward actionForward = null;
        CMConnection connection = null;
        CMLogonMediator logonMediator = (CMLogonMediator)this.getMediator(request);
        HttpSession session = null;
        session = request.getSession(true);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String newPassword = request.getParameter("new_password");
        String displayName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + displayName);
        String desktopName = request.getParameter("desktop");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig == null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repository not found");
            logonMediator.addError("error.server.notfound");
        } else if (userid != null && userid.length() > 32) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invalud userid -- too long");
            logonMediator.addError("error.bad.userid.password");
        } else if (password != null && password.length() > 32) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invalud old password -- too long");
            logonMediator.addError("error.bad.userid.password");
        } else if (newPassword != null && newPassword.length() > 32) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Invalid new password -- too long");
            logonMediator.addError("newPassword.invalid");
        } else {
            try {
                String strLangCodes;
                String connectString = null;
                String langCode = CMUtil.getLanguageCode(request.getLocale());
                if (repositoryConfig != null && (strLangCodes = repositoryConfig.getLanguageCodes()) != null) {
                    String[] langCodes;
                    for (String code : langCodes = strLangCodes.split(",")) {
                        if (!code.equals(langCode)) continue;
                        connectString = "LANG=" + langCode;
                        break;
                    }
                }
                connection = CMConnection.changePassword(repositoryConfig.getServerName(), userid, password, newPassword, connectString);
                this.storeNewConnection(request, connection);
                session = Util.replaceSession(request);
                if (session != null && userid != null) {
                    session.setAttribute("session_userid", (Object)userid);
                }
                logonMediator.setConnection(connection);
                logonMediator.addMessage("changepassword.successful", userid);
            }
            catch (DKInvalidPasswordException e) {
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Change password failed  due to invalud old password");
                logonMediator.addError("error.bad.userid.password");
            }
            catch (DKDatabaseLogonFailure e) {
                Logger.logError(this, methodName, (ServletRequest)request, "Change password failed due to database login failure", e);
                logonMediator.addError("error.server.unavailable");
            }
            catch (DKLogonFailure e) {
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Change password failed due to bad userid or password");
                logonMediator.addError("error.bad.userid.password");
            }
            catch (DKServerNotAvailable e) {
                Logger.logError(this, methodName, (ServletRequest)request, "Change password failed due to server unavailable", e);
                logonMediator.addError("error.server.unavailable");
            }
            catch (DKDatastoreAccessError e) {
                if (e.getErrorId() == 7173) {
                    String serverName = null;
                    if (repositoryConfig != null) {
                        serverName = repositoryConfig.getServerName();
                    }
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Change password failed as user id is locked on server." + serverName);
                    logonMediator.addError("error.userid.locked", serverName);
                } else {
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    logonMediator.addError("error.fatal", e.getLocalizedMessage(), new Integer(e.getErrorId()));
                }
            }
            catch (DKUsageError e) {
                if (e.getErrorId() == 7175) {
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Change password failed as this userid is also a system userid");
                    logonMediator.addError("error.exception.general", e.getLocalizedMessage());
                } else {
                    this.logFDC(request, response, null, methodName);
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    logonMediator.addError("error.exception.general", e.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                logonMediator.addError("error.exception.general", e.getLocalizedMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        LogonMediator logonMediator = (LogonMediator)this.getMediator(request);
        MessageResources resources = this.getResources(request);
        String userid = request.getParameter("userid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String newPassword = request.getParameter("new_password");
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        if (userid == null || userid.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "userid was not found");
            logonMediator.addError("error.parm.null", "userid");
            this.setRequestHasErrors(request, true);
        }
        if (password == null || password.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "password was not found");
            logonMediator.addError("error.parm.null", "password");
            this.setRequestHasErrors(request, true);
        }
        if (serverName == null || serverName.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "server name was not found");
            logonMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (newPassword == null || newPassword.trim().length() < 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "new password was not found");
            logonMediator.addError("error.parm.null", "new_password");
            this.setRequestHasErrors(request, true);
        }
        if (this.getRequestHasErrors(request)) {
            Logger.logExit((Object)this, methodName, (ServletRequest)request);
            return false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return true;
    }

    private void storeNewConnection(HttpServletRequest request, CMConnection connection) {
        String methodName = "storeNewConnection";
        String serverName = request.getParameter("repositoryId");
        String userid = request.getParameter("userid");
        if (connection != null && connection.isConnected()) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The connection object is connected");
            CMChangePasswordAction.setConnection(request, connection, serverName);
            request.getSession(false).setAttribute(serverName, (Object)connection);
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "There was not a valid connection created by the action bean");
        }
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMLogonMediator logonMediator = new CMLogonMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)logonMediator);
        return logonMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String userid = request.getParameter("userid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "userid = " + userid);
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "desktopName = " + desktopName);
    }
}

