/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.util.DateUtil;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.WCDateFormat;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.ecm.util.cm.CMUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKAttrDefICM;
import com.ibm.mm.sdk.common.DKAttrGroupDefICM;
import com.ibm.mm.sdk.common.DKChildCollection;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreAccessError;
import com.ibm.mm.sdk.common.DKDatastoreAdminICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKDate;
import com.ibm.mm.sdk.common.DKDocRoutingServiceICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKItemTypeRelationDefICM;
import com.ibm.mm.sdk.common.DKLobICM;
import com.ibm.mm.sdk.common.DKMimeTypeDefICM;
import com.ibm.mm.sdk.common.DKMimeTypeMgmtICM;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKParts;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKSequentialIterator;
import com.ibm.mm.sdk.common.DKTime;
import com.ibm.mm.sdk.common.DKTimestamp;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkAttrDef;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkResultSetCursor;
import com.ibm.mm.sdk.server.DKDatastoreExtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CMBaseAction
extends BaseAction {
    public static final String CM_SERVER_LIST = "cm_servers";
    public static final String CM_DOCROUTINGQUERYSERVICE_LIST = "cm_docroutingqueryservice_list";
    private String languageCodes;
    protected int maxItemTypes = Integer.MAX_VALUE;
    protected int maxWorklists = Integer.MAX_VALUE;
    protected int pageSize;
    protected int maxResults = Integer.MAX_VALUE;
    protected boolean directRetrieveEnabled = true;
    protected String rootFolderId;
    protected HttpServletRequest request;
    public static final String PRIV_ADD_ITEM = "privAddItem";
    public static final String PRIV_ADD_CONTENT = "privAddContent";
    public static final String PRIV_ADD_SEARCH = "privAddSearch";
    public static final String PRIV_SEARCH_TEMPLATE = "setSearchTemplateSupported";
    public static final String PRIV_ADD_TEAMSPACE = "privAddTeamspace";
    public static final String PRIV_ADD_TEAMSPACE_TEMPLATE = "privAddTeamspaceTemplate";
    public static final String PRIV_FOLDERING = "privFoldering";
    protected WCDateFormat wcDateFormats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        this.request = request;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        try {
            this.preUserExit(request);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "action mapping: " + mapping.getPath());
            this.initConfigInfo(request);
            CMConnection connection = null;
            if (!(mapping.getPath().endsWith("/logon") || mapping.getPath().endsWith("/changePassword") || mapping.getPath().endsWith("/logoff") || mapping.getPath().endsWith("/getProfile"))) {
                connection = this.getConnection(request);
                if (connection == null || !connection.isConnected()) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The session does not have a valid connection to the server.");
                    String altOutput = request.getParameter("alt_output");
                    if (mapping.getPath().endsWith("/getDocument") && (altOutput == null || !altOutput.equals("JSON"))) {
                        MessageResources resources = this.getResources(request);
                        String message = resources.getMessage(request.getLocale(), "error.no.connection");
                        message = message + "  \n" + resources.getMessage(request.getLocale(), "error.no.connection.explanation");
                        response.sendError(408, message);
                    } else {
                        BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                        mediator.addError("error.session.expired");
                        request.setAttribute("mediator", (Object)mediator);
                        this.writeJSONMediator(request, response);
                    }
                    return actionForward;
                }
                if (connection != null) {
                    DKDatastoreICM dsICM;
                    String userId = connection.getUserid();
                    if (userId != null) {
                        request.getSession(false).setAttribute("session_userid", (Object)userId);
                    }
                    String languages = (String)request.getAttribute("languages");
                    String lang = CMUtil.getLanguageCode(request.getLocale());
                    if (languages == null || languages.length() == 0) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "No languages specified, defaulting to ENU");
                        lang = "ENU";
                    } else {
                        StringTokenizer tokenizer = new StringTokenizer(languages, " ");
                        boolean found = false;
                        while (tokenizer.hasMoreTokens()) {
                            String currentToken = tokenizer.nextToken();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "webi defined language = " + currentToken);
                            if (!currentToken.equalsIgnoreCase(lang)) continue;
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "defined language = " + currentToken);
                            lang = currentToken;
                            found = true;
                            break;
                        }
                        if (!found) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "No support for language : " + request.getLocale());
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Defaulting to ENU");
                            lang = "ENU";
                        }
                    }
                    DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
                    synchronized (dKDatastoreICM) {
                        connection.setLanguageCode(lang);
                    }
                }
            }
            actionForward = this.executeAction(mapping, form, request, response);
            this.postUserExit(request);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            throw e;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected abstract ActionForward executeAction(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected void preUserExit(HttpServletRequest request) {
    }

    protected void postUserExit(HttpServletRequest request) {
    }

    private CMConnection getConnection(HttpServletRequest request, String repositoryId) {
        String methodName = "getConnection";
        HttpSession session = request.getSession(false);
        CMConnection connection = null;
        if (session != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
            Hashtable<String, CMConnection> connectionList = (Hashtable<String, CMConnection>)session.getAttribute(CM_SERVER_LIST);
            if (connectionList != null) {
                connection = (CMConnection)connectionList.get(repositoryId);
            } else {
                connectionList = new Hashtable<String, CMConnection>();
                request.getSession(true).setAttribute(CM_SERVER_LIST, connectionList);
            }
            if (connection == null || !connection.isConnected()) {
                connection = this.establishCM8Connection(request, repositoryId);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId: " + repositoryId + "   connection=" + connection + "  connectionList=" + connectionList.size());
                if (connection != null) {
                    connectionList.put(repositoryId, connection);
                }
            }
            if (connection == null || !connection.isConnected()) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The connection object is not connected.");
                this.removeConnection(request);
                connection = null;
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "connection: " + connection);
        return connection;
    }

    private CMConnection establishCM8Connection(HttpServletRequest request, String repositoryId) {
        String useSSO;
        String methodName = "establishCM8Connection";
        RepositoryConfig repositoryConfig = Config.getRepositoryConfigUsingIdOrServerName(request, repositoryId);
        if (repositoryConfig != null && (useSSO = repositoryConfig.getUseSSO()) != null && useSSO.equalsIgnoreCase("TRUE")) {
            try {
                CMConnection connection = CMConnection.trustedLogin(repositoryConfig.getServerName(), request);
                return connection;
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        return null;
    }

    public String initConfigInfo(HttpServletRequest request) throws Exception {
        String methodName = "initConfigInfo";
        String languageCodes = null;
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            languageCodes = repositoryConfig.getLanguageCodes();
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "languageCodes = " + languageCodes);
        request.setAttribute("languages", (Object)languageCodes);
        this.setLanguageCodes(languageCodes);
        this.getConfigInfo(request);
        return languageCodes;
    }

    public void getConfigInfo(HttpServletRequest request) throws Exception {
        String methodName = "getConfigInfo";
        RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
        if (repositoryConfig != null) {
            this.pageSize = repositoryConfig.getPageSize();
            this.maxItemTypes = repositoryConfig.getMaxItemTypes();
            this.maxWorklists = repositoryConfig.getMaxWorklists();
            this.directRetrieveEnabled = repositoryConfig.isDirectRetrieveEnabled();
            this.rootFolderId = repositoryConfig.getRootFolderId();
            this.setDateFormats(WCDateFormat.getDateFormats(request, repositoryConfig));
        }
        this.setMaxItemTypes(this.maxItemTypes);
        this.setMaxWorklists(this.maxWorklists);
        StringBuffer sb = new StringBuffer();
        sb.append("pageSize:").append(this.pageSize).append(", maxItemTypes:").append(this.maxItemTypes).append(", maxWorklists:").append(this.maxWorklists);
        sb.append(", directRetrieveEnabled:").append(this.directRetrieveEnabled);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "config: " + sb.toString());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "rootFolderId: " + this.rootFolderId);
    }

    public void setDateFormats(WCDateFormat wcDateFormats) {
        this.wcDateFormats = wcDateFormats;
    }

    public WCDateFormat getDateFormats() {
        return this.wcDateFormats;
    }

    protected DKDatastoreICM getDataStore(HttpServletRequest request) {
        return this.getDataStore(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DKDatastoreICM getDataStore(HttpServletRequest request, RepositoryConfig repoConfig) {
        CMConnection connection = null;
        connection = repoConfig != null ? this.getConnection(request, repoConfig.getObjectId()) : this.getConnection(request);
        if (connection != null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    return connection.getDatastore();
                }
            }
            return connection.getDatastore();
        }
        return null;
    }

    protected DKDatastoreExtICM getDataStoreExt(HttpServletRequest request) throws Exception {
        DKDatastoreICM ds = this.getDataStore(request);
        if (ds != null) {
            return (DKDatastoreExtICM)ds.getExtension("DATASTORE_EXTENSION");
        }
        return null;
    }

    protected DKDocRoutingServiceICM getDKDocRoutingServiceICM(HttpServletRequest request) throws Exception {
        String methodName = "getDKDocRoutingServiceICM";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String repositoryId = request.getParameter("repositoryId");
        DKDocRoutingServiceICM dkDocRoutingServiceICM = this.getDKDocRoutingServiceICM(request, repositoryId);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return dkDocRoutingServiceICM;
    }

    private DKDocRoutingServiceICM getDKDocRoutingServiceICM(HttpServletRequest request, String repositoryId) {
        String methodName = "getDKDocRoutingServiceICM";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        HttpSession session = request.getSession(true);
        DKDocRoutingServiceICM dkDocRoutingServiceICM = null;
        if (session != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
            Hashtable docRoutingQueryServiceObjList = (Hashtable)request.getSession(true).getAttribute(CM_DOCROUTINGQUERYSERVICE_LIST);
            if (docRoutingQueryServiceObjList != null) {
                dkDocRoutingServiceICM = (DKDocRoutingServiceICM)docRoutingQueryServiceObjList.get(repositoryId);
            }
            if (dkDocRoutingServiceICM == null) {
                docRoutingQueryServiceObjList = (Hashtable)request.getSession(true).getAttribute(CM_DOCROUTINGQUERYSERVICE_LIST);
                if (docRoutingQueryServiceObjList == null) {
                    docRoutingQueryServiceObjList = new Hashtable();
                }
                CMConnection connection = this.getConnection(request, repositoryId);
                try {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "  docRoutingQueryServiceObjList  size=" + docRoutingQueryServiceObjList.size() + " connection " + connection + "  datastore" + connection.getDatastore());
                    docRoutingQueryServiceObjList.put(repositoryId, new DKDocRoutingServiceICM((dkDatastore)connection.getDatastore()));
                    dkDocRoutingServiceICM = (DKDocRoutingServiceICM)docRoutingQueryServiceObjList.get(repositoryId);
                }
                catch (Exception e) {
                    Logger.logWarning(CMBaseAction.class, methodName, (ServletRequest)request, "DKDocRoutingServiceICM error: " + e.getMessage());
                }
                session.setAttribute(CM_DOCROUTINGQUERYSERVICE_LIST, docRoutingQueryServiceObjList);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request, " Returning dkDocRoutingServiceICM=" + dkDocRoutingServiceICM);
        return dkDocRoutingServiceICM;
    }

    protected CMConnection getConnection(HttpServletRequest request) {
        String methodName = "getConnection";
        String repositoryId = request.getParameter("repositoryId");
        CMConnection connection = this.getConnection(request, repositoryId);
        return connection;
    }

    protected void removeConnection(HttpServletRequest request) {
        Hashtable docRoutingQueryServiceObjList;
        String repositoryId = request.getParameter("repositoryId");
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute(CM_SERVER_LIST);
        if (connectionList != null && connectionList.size() > 0) {
            connectionList.remove(repositoryId);
        }
        if ((docRoutingQueryServiceObjList = (Hashtable)request.getSession(true).getAttribute(CM_DOCROUTINGQUERYSERVICE_LIST)) != null && docRoutingQueryServiceObjList.size() > 0) {
            docRoutingQueryServiceObjList.remove(repositoryId);
        }
    }

    public static void setConnection(HttpServletRequest request, CMConnection connection, String repositoryId) {
        String methodName = "setConnection";
        Logger.logEntry(CMBaseAction.class, methodName, (ServletRequest)request);
        HttpSession session = request.getSession(true);
        Hashtable<String, CMConnection> connectionList = (Hashtable<String, CMConnection>)session.getAttribute(CM_SERVER_LIST);
        if (connectionList == null) {
            connectionList = new Hashtable<String, CMConnection>();
        }
        Logger.logDebug(CMBaseAction.class, methodName, (ServletRequest)request, "repositoryId: " + repositoryId);
        connectionList.put(repositoryId, connection);
        session.setAttribute(CM_SERVER_LIST, connectionList);
        Hashtable<String, DKDocRoutingServiceICM> docRoutingQueryServiceObjList = (Hashtable<String, DKDocRoutingServiceICM>)request.getSession(true).getAttribute(CM_DOCROUTINGQUERYSERVICE_LIST);
        if (docRoutingQueryServiceObjList == null) {
            docRoutingQueryServiceObjList = new Hashtable<String, DKDocRoutingServiceICM>();
        }
        try {
            DKDocRoutingServiceICM rs = new DKDocRoutingServiceICM((dkDatastore)connection.getDatastore());
            docRoutingQueryServiceObjList.put(repositoryId, rs);
        }
        catch (DKException e) {
            if (e.getMessage() != null) {
                Logger.logWarning(CMBaseAction.class, methodName, (ServletRequest)request, e.getMessage());
            }
        }
        catch (Exception e) {
            Logger.logError(CMBaseAction.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logDebug(CMBaseAction.class, methodName, (ServletRequest)request, "  docRoutingQueryServiceObjList  size=" + docRoutingQueryServiceObjList.size() + " connection " + connection + "  datastore" + connection.getDatastore());
        session.setAttribute(CM_DOCROUTINGQUERYSERVICE_LIST, docRoutingQueryServiceObjList);
        Logger.logExit(CMBaseAction.class, methodName, (ServletRequest)request);
    }

    public String getLanguageCodes() {
        return this.languageCodes;
    }

    public void setLanguageCodes(String languageCodes) {
        this.languageCodes = languageCodes;
    }

    public int getMaxItemTypes() {
        return this.maxItemTypes;
    }

    public void setMaxItemTypes(int maxItemTypes) {
        this.maxItemTypes = maxItemTypes;
    }

    public int getMaxWorklists() {
        return this.maxWorklists;
    }

    public void setMaxWorklists(int maxWorklists) {
        this.maxWorklists = maxWorklists;
    }

    public boolean isDirectRetrieveEnabled() {
        return this.directRetrieveEnabled;
    }

    public void setDirectRetrieveEnabled(boolean enabled) {
        this.directRetrieveEnabled = enabled;
    }

    public String getRootFolderId() {
        return this.rootFolderId;
    }

    public void setRootFolderId(String rootFolderId) {
        this.rootFolderId = rootFolderId;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest arg0) {
        return null;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest req, HttpServletResponse resp) {
        return false;
    }

    protected DKMimeTypeDefICM getCMMimeTypeDef(HttpServletRequest request) throws Exception {
        DKMimeTypeDefICM mimeTypeDef = null;
        DKDatastoreICM ds = this.getDataStore(request);
        DKDatastoreDefICM dsDef = (DKDatastoreDefICM)ds.datastoreDef();
        DKDatastoreAdminICM dsAdmin = (DKDatastoreAdminICM)dsDef.datastoreAdmin();
        DKMimeTypeMgmtICM mimeTypeMgmt = dsAdmin.mimeTypeMgmt();
        String mimeType = request.getParameter("mimetype");
        if (mimeType != null && mimeType.length() > 0) {
            mimeTypeDef = mimeTypeMgmt.retrieveMimeType(mimeType.toLowerCase());
        }
        if (mimeTypeDef == null) {
            String filename = (String)this.getAttribute(request, "parm_part_filename");
            if (filename != null && filename.length() > 0) {
                String extension = null;
                File file = new File(filename);
                int index = (filename = file.getName()).lastIndexOf(".");
                if (index != -1) {
                    extension = filename.substring(index + 1, filename.length()).toLowerCase();
                }
                if (extension != null && extension.length() >= 0) {
                    dkCollection mimeTypeDefs = mimeTypeMgmt.listMimeTypes();
                    dkIterator iterator = mimeTypeDefs.createIterator();
                    block0: while (iterator.more() && mimeTypeDef == null) {
                        String[] mimeExtensions;
                        DKMimeTypeDefICM cmMimeTypeDef = (DKMimeTypeDefICM)iterator.next();
                        String mimeSuffixes = cmMimeTypeDef.getSuffixes();
                        if (mimeSuffixes == null || mimeSuffixes.length() <= 0) continue;
                        for (String mimeExtension : mimeExtensions = mimeSuffixes.split(" ")) {
                            if (!extension.equalsIgnoreCase(mimeExtension)) continue;
                            mimeTypeDef = cmMimeTypeDef;
                            continue block0;
                        }
                    }
                    if (mimeTypeDef == null) {
                        String[] extMimeTypes;
                        for (String extMimeType : extMimeTypes = MimeTypeUtil.getMimeTypes(extension)) {
                            if (extMimeType == null || extMimeType.length() <= 0) continue;
                            mimeTypeDef = mimeTypeMgmt.retrieveMimeType(extMimeType);
                            break;
                        }
                    }
                }
            }
            if (mimeTypeDef == null) {
                mimeTypeDef = mimeTypeMgmt.retrieveMimeType("application/octet-stream");
            }
        }
        return mimeTypeDef;
    }

    protected boolean validateItemType(HttpServletRequest request, String itemTypeDescription, short entityClassification, String contentType, CMSearchResultsMediator searchResultsMediator, String itemTypeName, String itemTypeId) {
        String methodName = "validateItemType";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        boolean isValid = true;
        if (entityClassification == 1) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item type classification is resource item");
        } else if (entityClassification == 2) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item type classification is doc model");
        } else if (entityClassification == 0) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item type classification is item (metadata only)");
            if (contentType.equalsIgnoreCase("Document")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item type classification item (metadata only) does not support storing content");
                searchResultsMediator.addError("import.itemtype.classification.content.notsupported", itemTypeDescription, itemTypeName, itemTypeId);
                isValid = false;
            } else if (contentType.equalsIgnoreCase("Folder")) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "adding a folder");
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "adding an item without content (metadata only)");
            }
        } else {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "item type classification not supported");
            searchResultsMediator.addError("import.itemtype.classification.notsupported", itemTypeDescription, itemTypeName, itemTypeId);
            isValid = false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return isValid;
    }

    protected boolean validateItemTypeAttributes(HttpServletRequest request, DKDatastoreDefICM dsDefICM, DKComponentTypeDefICM entityDef, JSONArray criteriasJsonArray) throws Exception {
        String methodName = "validateItemTypeAttributes";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        JSONObject criteria = null;
        boolean returnValue = true;
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
            for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
                criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
                String criteriaName = criteria.get("name").toString();
                short attrType = 0;
                dkAttrDef attrDef = entityDef.getAttr(criteriaName);
                if (attrDef != null) {
                    attrType = attrDef.getType();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attribute type = " + attrType);
                    short attrTypeInt = attrType;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attribute type Int= " + attrTypeInt);
                    if (attrType != 19 && attrType != 18 && attrType != 25) continue;
                    returnValue = false;
                    continue;
                }
                int index = criteriaName.indexOf(46);
                if (index == -1) continue;
                String attrGroupName = criteriaName.substring(0, index);
                String attrName = criteriaName.substring(index + 1);
                DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)dsDefICM.retrieveAttrGroup(attrGroupName);
                DKSequentialCollection attrs = (DKSequentialCollection)attrGroupDef.listAttrs();
                dkIterator iter = attrs.createIterator();
                while (iter.more()) {
                    DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                    if (!attrName.equals(attr.getName())) continue;
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "     - " + attr.getName() + ":  " + attr.getDescription());
                    attrType = attr.getType();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attribute type = " + attrType);
                    switch (attrType) {
                        case 18: 
                        case 19: 
                        case 25: {
                            returnValue = false;
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            returnValue = false;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return returnValue;
    }

    private Object getAttributeValue(short attrType, String criteriaValue) {
        Object dataObj = null;
        if (criteriaValue != null && criteriaValue.length() > 0) {
            switch (attrType) {
                case 0: {
                    dataObj = criteriaValue;
                    break;
                }
                case 1: {
                    dataObj = criteriaValue;
                    break;
                }
                case 3: {
                    dataObj = Short.valueOf(criteriaValue);
                    break;
                }
                case 4: {
                    dataObj = Integer.valueOf(criteriaValue);
                    break;
                }
                case 13: {
                    dataObj = Integer.valueOf(criteriaValue);
                    break;
                }
                case 5: {
                    dataObj = Float.valueOf(criteriaValue);
                    break;
                }
                case 6: {
                    dataObj = new BigDecimal(criteriaValue);
                    break;
                }
                case 7: {
                    dataObj = DKDate.valueOf((String)criteriaValue);
                    break;
                }
                case 8: {
                    dataObj = DKTime.valueOf((String)criteriaValue);
                    break;
                }
                case 9: {
                    if (criteriaValue.indexOf(58) != -1) {
                        dataObj = new DKTimestamp(Timestamp.valueOf(criteriaValue));
                        break;
                    }
                    dataObj = DKTimestamp.valueOf((String)criteriaValue);
                    break;
                }
                case 10: {
                    dataObj = Double.valueOf(criteriaValue);
                    break;
                }
                case 11: {
                    dataObj = criteriaValue.getBytes();
                    break;
                }
                case 1024: {
                    break;
                }
                default: {
                    dataObj = criteriaValue;
                }
            }
        }
        return dataObj;
    }

    private Object setCriteriaValue(String criteriaValue, short attrType) throws Exception {
        SimpleDateFormat dfClient = null;
        SimpleDateFormat dfRepo = null;
        switch (attrType) {
            case 7: {
                dfClient = (SimpleDateFormat)this.getDateFormats().getDateFormat();
                dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(this.request).getDateFormat();
                break;
            }
            case 8: {
                dfClient = (SimpleDateFormat)this.getDateFormats().getTimeFormat();
                dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(this.request).getTimeFormat();
                break;
            }
            case 9: {
                dfClient = (SimpleDateFormat)this.getDateFormats().getTimestampFormat();
                dfRepo = (SimpleDateFormat)WCDateFormat.getDefaultDateFormats(this.request).getTimestampFormat();
                break;
            }
            case 18: 
            case 19: 
            case 25: {
                break;
            }
            default: {
                dfClient = null;
            }
        }
        if (dfClient != null && criteriaValue != null && criteriaValue.trim().length() > 0) {
            Date tempDate = attrType == 7 || attrType == 8 ? DateUtil.parseISODate(criteriaValue, false) : DateUtil.parseISODate(criteriaValue, true);
            criteriaValue = dfRepo.format(tempDate);
        }
        Object dataObj = this.getAttributeValue(attrType, criteriaValue);
        return dataObj;
    }

    private DKComponentTypeDefICM getSubEntity(dkCollection subEntities, String childCompName) throws DKUsageError {
        DKComponentTypeDefICM selectedSubEntity = null;
        dkIterator entityIterator = subEntities.createIterator();
        while (entityIterator.more() && !(selectedSubEntity = (DKComponentTypeDefICM)entityIterator.next()).getName().equalsIgnoreCase(childCompName)) {
        }
        return selectedSubEntity;
    }

    protected void setItemAttributesFromCriterias(HttpServletRequest request, DKItemTypeDefICM itemTypeDef, JSONArray criteriasJsonArray, JSONArray childCompValuesJsonArray, DKDatastoreICM ds, DKDDO ddo, String aclName) throws Exception {
        String methodName = "getItemTypeAttributes";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        JSONObject criteria = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "criteriasJsonArray.length()" + criteriasJsonArray.size());
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "adding the attribute values for the newly created item");
        if (aclName != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "about to set aclName (" + aclName + ") on ddo: ");
            short propertyID = ddo.propertyId("SYSROOTATTRS.ACLCODE");
            ddo.setProperty(propertyID, (Object)aclName);
        }
        for (int iCriteriaCounter = 0; iCriteriaCounter < criteriasJsonArray.size(); ++iCriteriaCounter) {
            JSONArray valuesJsonArray;
            criteria = (JSONObject)criteriasJsonArray.get(iCriteriaCounter);
            String criteriaName = criteria.get("name").toString();
            String criteriaValue = criteria.get("value") != null ? criteria.get("value").toString() : ((valuesJsonArray = (JSONArray)criteria.get("values")) != null ? (String)valuesJsonArray.get(0) : "");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "update Item: attrName=" + criteriaName + " attrValue=" + criteriaValue);
            short attrType = 0;
            Object dataObj = null;
            dkAttrDef attrDef = itemTypeDef.getAttr(criteriaName);
            if (attrDef != null) {
                attrType = attrDef.getType();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attribute type = " + attrType);
                dataObj = this.setCriteriaValue(criteriaValue, attrType);
                short dataId = ddo.dataId(criteriaName);
                if (dataObj == null) continue;
                ddo.setData(dataId, dataObj);
                continue;
            }
            int index = criteriaName.indexOf(46);
            if (index == -1) continue;
            String attrGroupName = criteriaName.substring(0, index);
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "     - " + attrGroupName);
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)ds.datastoreDef();
            DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)dsDefICM.retrieveAttrGroup(attrGroupName);
            DKSequentialCollection attrs = (DKSequentialCollection)attrGroupDef.listAttrs();
            dkIterator iter = attrs.createIterator();
            while (iter.more()) {
                DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "     - " + attr.getName() + ":  " + attr.getDescription());
                if (!attr.getName().equals(criteriaName)) continue;
                attrType = attr.getType();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attribute type = " + attrType);
                dataObj = this.setCriteriaValue(criteriaValue, attrType);
                short dataId = ddo.dataId(attr.getName());
                if (dataObj == null) continue;
                ddo.setData(dataId, dataObj);
            }
        }
        DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)ds.datastoreDef();
        dkCollection subEntities = itemTypeDef.listSubEntities(111);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "There are  - " + childCompValuesJsonArray.size() + " child components");
        for (int iChildCompCounter = 0; iChildCompCounter < childCompValuesJsonArray.size(); ++iChildCompCounter) {
            JSONObject childComponent = (JSONObject)childCompValuesJsonArray.get(iChildCompCounter);
            String childCompName = childComponent.get("name").toString();
            JSONArray childCompCriteriasJsonArray = (JSONArray)childComponent.get("values");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "There are  - " + childCompCriteriasJsonArray.size() + " instances for - " + childCompName);
            DKComponentTypeDefICM selectedSubEntity = this.getSubEntity(subEntities, childCompName);
            DKDDO childItem = null;
            JSONObject childJSON = null;
            boolean allValuesAreNull = true;
            DKChildCollection children = new DKChildCollection();
            for (int iRowCounter = 0; iRowCounter < childCompCriteriasJsonArray.size(); ++iRowCounter) {
                childJSON = (JSONObject)childCompCriteriasJsonArray.get(iRowCounter);
                childItem = ds.createChildDDO(itemTypeDef.getItemTypeName(), childCompName);
                JSONArray valuesJsonArray = (JSONArray)childJSON.get("values");
                for (int a = 0; a < valuesJsonArray.size(); ++a) {
                    criteria = (JSONObject)valuesJsonArray.get(a);
                    String criteriaName = criteria.get("name").toString();
                    criteriaName = criteriaName.substring(childCompName.length() + 1);
                    JSONArray critValJsonArray = (JSONArray)criteria.get("values");
                    String criteriaValue = (String)critValJsonArray.get(0);
                    criteriaValue = criteriaValue.trim();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "ADD Item: attrName=" + criteriaName + " attrValue=" + criteriaValue + " attrValueLength=" + criteriaValue.length());
                    if (criteriaValue == null || criteriaValue.length() <= 0) continue;
                    allValuesAreNull = false;
                    dkAttrDef attrDef = selectedSubEntity.getAttr(criteriaName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attrDef =" + attrDef);
                    short attrType = 0;
                    Object dataObj = null;
                    if (attrDef != null) {
                        attrType = attrDef.getType();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "child attribute type = " + attrType);
                        dataObj = this.setCriteriaValue(criteriaValue.trim(), attrType);
                        if (dataObj == null) continue;
                        childItem.setData(childItem.dataId("ATTR", criteriaName), dataObj);
                        continue;
                    }
                    int index = criteriaName.indexOf(46);
                    if (index == -1) continue;
                    String attrGroupName = criteriaName.substring(0, index);
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "     - " + attrGroupName);
                    DKAttrGroupDefICM attrGroupDef = (DKAttrGroupDefICM)dsDefICM.retrieveAttrGroup(attrGroupName);
                    DKSequentialCollection attrs = (DKSequentialCollection)attrGroupDef.listAttrs();
                    dkIterator iter = attrs.createIterator();
                    while (iter.more()) {
                        DKAttrDefICM attr = (DKAttrDefICM)iter.next();
                        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "     - " + attr.getName() + ":  " + attr.getDescription());
                        if (!attr.getName().equals(criteriaName)) continue;
                        attrType = attr.getType();
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "attribute type = " + attrType);
                        dataObj = this.setCriteriaValue(criteriaValue, attrType);
                        if (dataObj == null) continue;
                        childItem.setData(childItem.dataId("ATTR", criteriaName), dataObj);
                    }
                }
                if (allValuesAreNull) continue;
                children.addElement((Object)childItem);
            }
            ddo.setData(ddo.dataId("CHILD", childCompName), (Object)children);
        }
    }

    private FormFile getFormFile(ActionForm form) {
        FormFile formFile;
        block1: {
            formFile = ((FileUploadActionForm)form).getUploadFile();
            if (formFile != null) break block1;
            Hashtable fileElements = form.getMultipartRequestHandler().getFileElements();
            Iterator it = fileElements.values().iterator();
            while (it.hasNext() && (formFile = (FormFile)it.next()) == null) {
            }
        }
        return formFile;
    }

    private void setDataStream(DKLobICM _xdoObj, InputStream data, long length, boolean bNewPart) throws Exception {
        if (_xdoObj != null) {
            DKNVPair[] dknv = new DKNVPair[]{new DKNVPair("STREAM", (Object)data), new DKNVPair("LENGTH", (Object)new Long(length))};
            if (bNewPart) {
                _xdoObj.setAddLocation(dknv);
            } else {
                _xdoObj.setUpdateLocation(dknv);
            }
        }
    }

    protected void setContent(HttpServletRequest request, DKDDO ddo, DKDatastoreICM ds, DKItemTypeDefICM itemTypeDef, ActionForm form, boolean newDocument, boolean createNewVersion) throws Exception {
        String methodName = "setContent";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String partMimeType = request.getParameter("mimetype");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "request mime type = " + (partMimeType != null ? partMimeType : ""));
        DKMimeTypeDefICM mimeTypeDef = this.getCMMimeTypeDef(request);
        partMimeType = mimeTypeDef.getMimeType();
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "resolved mime type = " + partMimeType);
        String partFileName = null;
        String partFilePath = request.getParameter("parm_part_filename");
        if (partFilePath != null) {
            partFileName = Util.getFileNameFromPath(request, partFilePath);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "file name = " + (partFileName != null ? partFileName : ""));
        boolean newPart = false;
        if (itemTypeDef.getClassification() == 2) {
            int contentLen;
            InputStream is;
            FormFile ff;
            DKParts partColl = null;
            short data_id = ddo.dataId("ATTR", "DKParts");
            if (data_id == 0) {
                data_id = ddo.addData("ATTR", "DKParts");
                ddo.addDataProperty(data_id, "type", (Object)new Short(1073));
                partColl = new DKParts();
                ddo.setData(data_id, (Object)partColl);
            } else {
                partColl = (DKParts)ddo.getData(data_id);
                if (partColl == null) {
                    partColl = new DKParts();
                    ddo.setData(data_id, (Object)partColl);
                }
            }
            String partType = "ICMBASE";
            String requestedPartType = request.getParameter("parm_part_type");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "requested part type = " + requestedPartType);
            DKItemTypeRelationDefICM partTypeDef = CMUtil.getContentPart(itemTypeDef, mimeTypeDef.getMimeTypeFlag(), requestedPartType);
            if (partTypeDef != null) {
                partType = partTypeDef.getTargetItemTypeName();
            }
            DKLobICM contentXdo = null;
            if (partColl.cardinality() > 0) {
                DKLobICM expectedPart = null;
                DKLobICM firstPart = null;
                DKLobICM icmbasePart = null;
                DKLobICM icmbasetextPart = null;
                DKLobICM icmbasecsPart = null;
                DKLobICM icmbasetextcsPart = null;
                DKSequentialIterator seqIterator = (DKSequentialIterator)partColl.createIterator();
                while (seqIterator.more()) {
                    DKLobICM partXdo = (DKLobICM)seqIterator.next();
                    String objectType = partXdo.getObjectType();
                    if (firstPart == null) {
                        firstPart = partXdo;
                    }
                    if (objectType.equalsIgnoreCase(partType)) {
                        expectedPart = partXdo;
                    }
                    if (objectType.equalsIgnoreCase("ICMBASE")) {
                        icmbasePart = partXdo;
                        continue;
                    }
                    if (objectType.equalsIgnoreCase("ICMBASETEXT")) {
                        icmbasetextPart = partXdo;
                        continue;
                    }
                    if (objectType.equalsIgnoreCase("ICMBASECS")) {
                        icmbasecsPart = partXdo;
                        continue;
                    }
                    if (!objectType.equalsIgnoreCase("ICMBASETEXTCS")) continue;
                    icmbasetextcsPart = partXdo;
                }
                if (expectedPart != null) {
                    contentXdo = expectedPart;
                } else if (icmbasePart != null) {
                    contentXdo = icmbasePart;
                } else if (icmbasetextPart != null) {
                    contentXdo = icmbasetextPart;
                } else if (icmbasecsPart != null) {
                    contentXdo = icmbasecsPart;
                } else if (icmbasetextcsPart != null) {
                    contentXdo = icmbasetextcsPart;
                } else if (firstPart != null) {
                    contentXdo = firstPart;
                }
            }
            if (contentXdo == null) {
                int semanticType = partType.equalsIgnoreCase("ICMBASE") ? 128 : (partType.equalsIgnoreCase("ICMBASETEXT") ? 256 : (partType.equalsIgnoreCase("ICMBASECS") ? 128 : (partType.equalsIgnoreCase("ICMBASETEXTCS") ? 256 : (partType.equalsIgnoreCase("ICMBASESTREAM") ? 512 : 128))));
                contentXdo = (DKLobICM)ds.createDDO(partType, semanticType);
                contentXdo.setPartNumber(partColl.cardinality() + 1);
                partColl.addElement((Object)contentXdo);
                newPart = true;
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "actual part type = " + contentXdo.getObjectType());
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "number of parts = " + partColl.cardinality());
            if (partMimeType != null) {
                contentXdo.setMimeType(partMimeType);
            }
            if (partFileName != null) {
                contentXdo.setOrgFileName(partFileName);
            }
            if (!newPart && createNewVersion) {
                contentXdo.setNewVersion(true);
            }
            if ((ff = this.getFormFile(form)) != null) {
                is = ff.getInputStream();
                contentLen = ff.getFileSize();
            } else {
                is = request.getInputStream();
                contentLen = request.getContentLength();
            }
            this.setDataStream(contentXdo, is, contentLen, newPart);
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parts cardinality is = " + partColl.cardinality());
        } else if (itemTypeDef.getClassification() == 1 && ddo instanceof DKLobICM) {
            int contentLen;
            InputStream is;
            FormFile ff = this.getFormFile(form);
            if (ff != null) {
                is = ff.getInputStream();
                contentLen = ff.getFileSize();
            } else {
                is = request.getInputStream();
                contentLen = request.getContentLength();
            }
            this.setDataStream((DKLobICM)ddo, is, contentLen, newDocument);
            if (partMimeType != null) {
                ((DKLobICM)ddo).setMimeType(partMimeType);
            }
            if (partFileName != null) {
                ((DKLobICM)ddo).setOrgFileName(partFileName);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected void handleCMItemError(HttpServletRequest request, String methodName, DKException de, String itemTypeDescription, String contentType, CMSearchResultsMediator searchResultsMediator, String itemTypeName, String itemTypeId) {
        Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)de);
        String errorMsg = "error.exception.general";
        Object[] errObjects = new Object[3];
        Logger.logError((Object)this, methodName, (ServletRequest)request, "The specific errorId = " + de.getErrorId());
        switch (de.getErrorId()) {
            case 5160: 
            case 5161: 
            case 5162: 
            case 5163: 
            case 5164: 
            case 5165: 
            case 5410: {
                errorMsg = "error.rmserver.exception.explanation";
                errObjects[0] = de.getMessage();
                break;
            }
            case 5247: {
                errorMsg = "error.cardinality";
                errObjects[0] = de.getMessage();
                break;
            }
            case 3601: {
                if (de.errorCode() == 7097) {
                    errorMsg = "additem.error.document.nocontentpart";
                    errObjects[0] = itemTypeDescription;
                    errObjects[1] = itemTypeName;
                    errObjects[2] = itemTypeId;
                    break;
                }
                if (de.errorCode() == 7089) {
                    if (contentType != null && contentType.equalsIgnoreCase("Folder")) {
                        errorMsg = "additem.error.folder.longattribute";
                        errObjects[0] = itemTypeDescription;
                        errObjects[1] = itemTypeName;
                        errObjects[2] = itemTypeId;
                        break;
                    }
                    errorMsg = "additem.error.document.longattribute";
                    errObjects[0] = itemTypeDescription;
                    errObjects[1] = itemTypeName;
                    errObjects[2] = itemTypeId;
                    break;
                }
                if (de.errorCode() == 7382) {
                    errorMsg = "changeClass.error.nonHierarchicalParentFolder";
                    errObjects[0] = itemTypeDescription;
                    errObjects[1] = itemTypeName;
                    errObjects[2] = itemTypeId;
                    break;
                }
                if (de.errorCode() == 7383) {
                    errorMsg = contentType != null && contentType.equalsIgnoreCase("Folder") ? "additem.error.folder.parentFolder" : "additem.error.document.parentFolder";
                    errObjects[0] = itemTypeDescription;
                    errObjects[1] = itemTypeName;
                    errObjects[2] = itemTypeId;
                    break;
                }
                if (de.errorCode() == 7388) {
                    errorMsg = contentType != null && contentType.equalsIgnoreCase("Folder") ? "additem.error.folder.uniqueName" : "additem.error.document.uniqueName";
                    errObjects[0] = itemTypeDescription;
                    break;
                }
                if (contentType != null && contentType.equalsIgnoreCase("Folder")) {
                    errorMsg = "additem.error.folder.uniqueattribute";
                    errObjects[0] = itemTypeDescription;
                    errObjects[1] = itemTypeName;
                    errObjects[2] = itemTypeId;
                    break;
                }
                errorMsg = "additem.error.document.uniqueattribute";
                errObjects[0] = itemTypeDescription;
                errObjects[1] = itemTypeName;
                errObjects[2] = itemTypeId;
                break;
            }
            case 3616: {
                errorMsg = "additem.error.foreignkeymissing.explanation";
                errObjects[0] = itemTypeDescription;
                errObjects[1] = itemTypeName;
                errObjects[2] = itemTypeId;
                break;
            }
            case 5218: {
                errorMsg = "additem.error.requiredattributemissing";
                errObjects[0] = itemTypeDescription;
                errObjects[1] = itemTypeName;
                errObjects[2] = itemTypeId;
                break;
            }
            case 3624: {
                errorMsg = "additem.error.folder.lockbyother";
                errObjects[0] = itemTypeDescription;
                errObjects[1] = itemTypeName;
                errObjects[2] = itemTypeId;
                break;
            }
            default: {
                errorMsg = "error.exception.general";
                errObjects[0] = de.getMessage();
            }
        }
        searchResultsMediator.addError(errorMsg, errObjects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CMItem> convertToListOfCMItems(HttpServletRequest request, DKDatastoreICM dataStore, List<DKDDO> ddoList, boolean retrieveChildren) throws Exception {
        String methodName = "convertToListOfCMItems";
        int listSize = ddoList.size();
        ArrayList<CMItem> items = new ArrayList<CMItem>(listSize);
        if (listSize != 0) {
            try {
                DKSequentialCollection collection = new DKSequentialCollection();
                for (DKDDO ddo : ddoList) {
                    collection.addElement((Object)ddo);
                }
                DKDatastoreICM i$ = dataStore;
                synchronized (i$) {
                    DKRetrieveOptionsICM options = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dataStore);
                    options.baseAttributes(true);
                    options.basePropertyAclName(true);
                    options.resourceContent(false);
                    options.basePropertyCheckedOutDetails(true);
                    options.partsList(true);
                    options.partsAttributes(true);
                    options.behaviorPartsAttributesCoreOnly(true);
                    if (retrieveChildren) {
                        options.childListOneLevel(true);
                    }
                    DKNVPair[] pairs = options.dkNVPair();
                    dataStore.retrieveObjects((dkCollection)collection, pairs);
                }
                CMConnection connection = this.getConnection(request);
                for (DKDDO ddo : ddoList) {
                    CMItem item = new CMItem(request, connection, ddo, null, true, false, true);
                    item.getItemType();
                    items.add(item);
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        return items;
    }

    protected QueryOutput runQuery(HttpServletRequest request, DKDatastoreICM dataStore, String queryString, int itemsToSkip, int itemsToRetrieve, boolean retrieveLatestVersion, boolean useMaxResults, boolean retrieveChildren) throws Exception {
        String methodName = "runQuery";
        CMQueryService query = new CMQueryService(request, dataStore);
        DKRetrieveOptionsICM retrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dataStore);
        retrieveOptions.functionVersionLatest(retrieveLatestVersion);
        DKNVPair[] options = useMaxResults ? new DKNVPair[]{new DKNVPair("MAX_RESULTS", (Object)String.valueOf(this.maxResults)), new DKNVPair("RETRIEVE_OPTION", (Object)retrieveOptions), new DKNVPair("End", null)} : new DKNVPair[]{new DKNVPair("RETRIEVE_OPTION", (Object)retrieveOptions), new DKNVPair("End", null)};
        dkResultSetCursor cursor = query.execute(queryString, options);
        return this.loadCursor(request, dataStore, itemsToSkip, itemsToRetrieve, cursor, retrieveChildren);
    }

    protected QueryOutput loadCursor(HttpServletRequest request, DKDatastoreICM dataStore, int itemsToSkip, int itemsToRetrieve, dkResultSetCursor cursor, boolean retrieveChildren) throws DKException, Exception {
        DKDDO ddo;
        String methodName = "loadCursor";
        QueryOutput out = new QueryOutput();
        int skipped = 0;
        ArrayList<DKDDO> searchResults = new ArrayList<DKDDO>(itemsToRetrieve);
        while ((ddo = cursor.fetchNext()) != null) {
            if (skipped < itemsToSkip) {
                ++skipped;
                continue;
            }
            if (out.count >= itemsToRetrieve) {
                out.hasMore = true;
                break;
            }
            searchResults.add(ddo);
            ++out.count;
            if (skipped + out.count < this.maxResults) continue;
            out.hasMore = false;
            out.maxResultsReached = true;
            break;
        }
        cursor.close();
        cursor.destroy();
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Skipped " + skipped + " rows, returned " + out.count + " items");
        out.items = this.convertToListOfCMItems(request, dataStore, searchResults, retrieveChildren);
        out.position = out.count + skipped;
        return out;
    }

    protected Collection<DKComponentTypeDefICM> getUniqueItemTypes(HttpServletRequest request, List<CMItem> results, DKDatastoreDefICM dsDefICM) throws DKException, Exception {
        HashSet<DKComponentTypeDefICM> entities = new HashSet<DKComponentTypeDefICM>();
        for (CMItem cmItem : results) {
            String fromListItemTypeName = cmItem.getEntityName();
            Logger.logDebug((Object)this, "getUniqueItemTypes", (ServletRequest)request, "resultList entity: " + fromListItemTypeName);
            DKComponentTypeDefICM key = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(fromListItemTypeName);
            entities.add(key);
        }
        return entities;
    }

    public static Hashtable<String, String> getPrivilagesTable(HttpServletRequest request, CMConnection connection, RepositoryConfig repoConfig) {
        if (connection == null || !connection.isConnected()) {
            return null;
        }
        DKDatastoreICM dataStore = connection.getDatastore();
        Hashtable<String, String> results = new Hashtable<String, String>();
        try {
            results = CMBaseAction.getPriv(request, dataStore, repoConfig);
        }
        catch (Exception e) {
            results.put(PRIV_ADD_ITEM, "false");
            results.put(PRIV_ADD_CONTENT, "false");
            results.put(PRIV_SEARCH_TEMPLATE, "false");
            results.put(PRIV_ADD_SEARCH, "false");
            results.put(PRIV_ADD_TEAMSPACE, "false");
            results.put(PRIV_ADD_TEAMSPACE_TEMPLATE, "false");
            results.put(PRIV_FOLDERING, "false");
        }
        return results;
    }

    protected Hashtable<String, String> getPriv(HttpServletRequest request, HttpServletResponse response, RepositoryConfig repoConfig) throws Exception {
        String methodName = "getPriv";
        DKDatastoreICM dataStore = this.getDataStore(request, repoConfig);
        Hashtable<String, String> results = new Hashtable();
        try {
            results = CMBaseAction.getPriv(request, dataStore, repoConfig);
        }
        catch (RuntimeException e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, e.getMessage());
            results.put(PRIV_ADD_ITEM, "false");
            results.put(PRIV_ADD_CONTENT, "false");
            results.put(PRIV_SEARCH_TEMPLATE, "false");
            results.put(PRIV_ADD_SEARCH, "false");
            results.put(PRIV_ADD_TEAMSPACE, "false");
            results.put(PRIV_ADD_TEAMSPACE_TEMPLATE, "false");
            results.put(PRIV_FOLDERING, "false");
        }
        return results;
    }

    protected static DKCommonPrivilege getCommonPrivilege(HttpServletRequest request, DKDDO privDDO, DKDatastoreICM dsICM) throws Exception {
        String methodName = "getCommonPrivilege";
        DKCommonPrivilege commonPrivilege = null;
        dkDatastoreExt dsExt = (dkDatastoreExt)dsICM.getExtension("DATASTORE_EXTENSION");
        if (privDDO != null) {
            try {
                commonPrivilege = dsExt.getCommonItemPrivilege((dkDataObject)privDDO);
            }
            catch (RuntimeException e) {
                Logger.logError(CMBaseAction.class, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        return commonPrivilege;
    }

    public static boolean APIIs843OrHigher(DKDatastoreICM ds) {
        String apiVersion = ds.getAPIVersion();
        return apiVersion.compareTo("8.4.3.000") >= 0;
    }

    public static boolean serverIsBelow843(DKDatastoreICM ds) {
        String lsVersion = ds.getLSVersion();
        return lsVersion.compareTo("8.4.03.000") < 0;
    }

    private static Hashtable<String, String> getPriv(HttpServletRequest request, DKDatastoreICM dataStore, RepositoryConfig repoConfig) throws DKException, Exception, DKUsageError, DKDatastoreAccessError {
        boolean privFoldering;
        boolean privAddTeamspaceTemplate;
        boolean privAddTeamspace;
        boolean privAddContent;
        boolean privAddItem;
        Hashtable<String, String> results;
        block23: {
            DKDDO itemTypePrivDDO;
            String methodName = "getPriv";
            results = new Hashtable<String, String>();
            dkDatastoreExt dsExt = (dkDatastoreExt)dataStore.getExtension("DATASTORE_EXTENSION");
            DKCommonPrivilege _priv = dsExt.getCommonPrivilege();
            boolean teamspaceEnabled = false;
            if (repoConfig != null) {
                teamspaceEnabled = repoConfig.isTeamspacesEnabled();
            }
            privAddItem = CMBaseUtil.checkAuthorization(_priv, 28);
            boolean privAddLink = CMBaseUtil.checkAuthorization(_priv, 80);
            privAddContent = CMBaseUtil.checkAuthorization(_priv, 4);
            privAddTeamspace = false;
            privAddTeamspaceTemplate = false;
            privAddContent = privAddItem;
            DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dataStore.datastoreDef();
            DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity("ICMSearch");
            if (itemType != null) {
                boolean addOnInstalled = itemType.getAttr("clbShowInTree") != null;
                results.put(PRIV_SEARCH_TEMPLATE, addOnInstalled ? "true" : "false");
                boolean privAddItemSearch = false;
                if (addOnInstalled) {
                    itemTypePrivDDO = CMBaseUtil.getDDO4ICMItemTypePrivilege(itemType);
                    DKCommonPrivilege privilege = CMBaseAction.getCommonPrivilege(request, itemTypePrivDDO, dataStore);
                    privAddItemSearch = CMBaseUtil.checkAuthorization(privilege, 28) && CMBaseUtil.checkAuthorization(privilege, 83);
                }
                results.put(PRIV_ADD_SEARCH, addOnInstalled && privAddItem && privAddItemSearch ? "true" : "false");
            } else {
                results.put(PRIV_ADD_SEARCH, "false");
                results.put(PRIV_SEARCH_TEMPLATE, "false");
            }
            if (privAddItem && privAddLink && teamspaceEnabled) {
                try {
                    DKComponentTypeDefICM teamspaceItemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity("ICMTeamspace");
                    if (teamspaceItemType == null) {
                        Logger.logInfo(CMBaseAction.class, methodName, (ServletRequest)request, "teamspaceItemType: " + teamspaceItemType);
                    } else {
                        DKCommonPrivilege privilege = null;
                        itemTypePrivDDO = CMBaseUtil.getDDO4ICMItemTypePrivilege(teamspaceItemType);
                        privilege = CMBaseAction.getCommonPrivilege(request, itemTypePrivDDO, dataStore);
                        boolean privAddItemTeamspace = CMBaseUtil.checkAuthorization(privilege, 28);
                        boolean privAddLinkTeamspace = CMBaseUtil.checkAuthorization(privilege, 80);
                        if (privAddItemTeamspace && privAddLinkTeamspace) {
                            privAddTeamspace = true;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logError(CMBaseAction.class, methodName, (ServletRequest)request, (Throwable)e);
                }
                try {
                    DKComponentTypeDefICM teamspaceTemplateItemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity("ICMTeamspaceTemplate");
                    if (teamspaceTemplateItemType == null) {
                        Logger.logInfo(CMBaseAction.class, methodName, (ServletRequest)request, "teamspaceTemplateItemType: " + teamspaceTemplateItemType);
                    } else {
                        DKCommonPrivilege privilege = null;
                        itemTypePrivDDO = CMBaseUtil.getDDO4ICMItemTypePrivilege(teamspaceTemplateItemType);
                        privilege = CMBaseAction.getCommonPrivilege(request, itemTypePrivDDO, dataStore);
                        boolean privAddItemTeamspaceTemplate = CMBaseUtil.checkAuthorization(privilege, 28);
                        boolean privAddLinkTeamspaceTemplate = CMBaseUtil.checkAuthorization(privilege, 80);
                        if (privAddItemTeamspaceTemplate && privAddLinkTeamspaceTemplate) {
                            privAddTeamspaceTemplate = true;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logError(CMBaseAction.class, methodName, (ServletRequest)request, (Throwable)e);
                }
            }
            Logger.logInfo(CMBaseAction.class, methodName, (ServletRequest)request, "library server version: " + dataStore.getLSVersion());
            privFoldering = false;
            try {
                String rootFolderId = null;
                if (repoConfig != null) {
                    rootFolderId = repoConfig.getRootFolderId();
                }
                if (rootFolderId != null && rootFolderId.length() > 0) {
                    privFoldering = true;
                    break block23;
                }
                try {
                    DKDDO ddoItem;
                    Boolean doesNotSupportRootFoldering = CMBaseAction.serverIsBelow843(dataStore);
                    if (!doesNotSupportRootFoldering.booleanValue() && (ddoItem = dataStore.getRootFolder()) != null) {
                        privFoldering = true;
                    }
                }
                catch (DKException de) {
                    if (de.getErrorId() != 7255) {
                        Logger.logError(CMBaseAction.class, methodName, (ServletRequest)request, (Throwable)de);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(CMBaseAction.class, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        results.put(PRIV_ADD_TEAMSPACE_TEMPLATE, privAddTeamspaceTemplate + "");
        results.put(PRIV_ADD_TEAMSPACE, privAddTeamspace + "");
        results.put(PRIV_ADD_ITEM, privAddItem + "");
        results.put(PRIV_ADD_CONTENT, privAddContent + "");
        results.put(PRIV_FOLDERING, privFoldering + "");
        return results;
    }

    protected static class QueryOutput {
        public int position;
        public boolean maxResultsReached;
        public boolean hasMore;
        public int count;
        public List<CMItem> items;

        protected QueryOutput() {
        }
    }
}

