/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.dm.CMDataModel;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMTeamspaceListMediator;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.cm8.CM8AccessControlListData;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.security.cm8.CM8SecurityUtils;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.teamspace.Teamspace;
import com.ibm.ecm.teamspace.TeamspaceException;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMAddTeamspaceAction
extends CMBaseAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMTeamspaceListMediator teamspaceAddMediator = (CMTeamspaceListMediator)this.getMediator(request);
        DKDatastoreICM dsICM = this.getDataStore(request);
        String teamspaceType = null;
        String teamspaceJson = null;
        String modifyTeamspace = null;
        DKDatastoreICM dKDatastoreICM = dsICM;
        synchronized (dKDatastoreICM) {
            try {
                CMConnection connection = this.getConnection(request);
                CM8TeamspaceService teamspaceService = new CM8TeamspaceService(request, connection, this.getDateFormats());
                CM8SecurityService securityService = new CM8SecurityService(request, connection.getDatastore());
                String teamspaceId = request.getParameter("workspaceId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceId = " + teamspaceId);
                String serverName = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
                teamspaceType = request.getParameter("workspaceType");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceType = " + teamspaceType);
                modifyTeamspace = request.getParameter("modifyWorkspace");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "modifyteamspace = " + modifyTeamspace);
                String modifyUsers = request.getParameter("modifyUsers");
                if (modifyUsers == null) {
                    modifyUsers = "false";
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "modifyUsers = " + modifyUsers);
                teamspaceJson = this.readJSON(request);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceJson = " + teamspaceJson);
                JSONObject jsonObject = (JSONObject)JSON.parse(teamspaceJson);
                String teamspaceState = (String)jsonObject.get("state");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspaceState = " + teamspaceState);
                if (teamspaceState != null && teamspaceState.length() == 0) {
                    teamspaceState = "published";
                }
                String teamspaceTemplateId = (String)jsonObject.get("id");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "templateId = " + teamspaceTemplateId);
                String name = (String)jsonObject.get("name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "name = " + name);
                String description = (String)jsonObject.get("description");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description = " + description);
                String templateName = (String)jsonObject.get("templateName");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "templateName = " + templateName);
                ArrayList<String> minReadPrivs = new ArrayList<String>();
                minReadPrivs.add("ItemSQLSelect");
                minReadPrivs.add("ItemQuery");
                JSONArray rolesArray = (JSONArray)jsonObject.get("roles");
                HashMap<String, Role> rolesMap = new HashMap<String, Role>();
                for (int i = 0; i < rolesArray.size(); ++i) {
                    JSONObject roleObj = (JSONObject)rolesArray.get(i);
                    String roleId = (String)roleObj.get("id");
                    String messageId = (String)roleObj.get("messageId");
                    String roleName = (String)roleObj.get("name");
                    String roleDesc = (String)roleObj.get("description");
                    boolean owner = (Boolean)roleObj.get("owner");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "roleName: " + roleName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "role messageId: " + messageId);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "owner: " + owner);
                    JSONArray privsArray = (JSONArray)roleObj.get("privileges");
                    List<String> origPrivList = this.convertJsonArrayToList(privsArray);
                    Role role = null;
                    if (!owner) {
                        String privSetHashName = CM8SecurityUtils.generatePrivSetNameHash(origPrivList);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "privSetHashName: " + privSetHashName);
                        ArrayList<String> privileges = new ArrayList<String>();
                        for (int j = 0; j < privsArray.size(); ++j) {
                            String priv = (String)privsArray.get(j);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "check priv: " + priv);
                            List<String> privNames = SecurityConstants.cm8PrivilegeMap.get(priv);
                            if (privNames != null) {
                                Iterator<String> privIterator = privNames.iterator();
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Privilege map has item: " + privIterator.hasNext());
                                while (privIterator.hasNext()) {
                                    String privName = privIterator.next();
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "for " + priv + " add privName= " + privName);
                                    if (privileges.contains(privName)) continue;
                                    privileges.add(privName);
                                }
                                continue;
                            }
                            Logger.logWarning((Object)this, methodName, (ServletRequest)request, "privsNames is null");
                        }
                        for (String priv : minReadPrivs) {
                            if (!privileges.contains(priv)) {
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add needed min priv to privileges: " + priv);
                                privileges.add(priv);
                                continue;
                            }
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "privileges already contain: " + priv);
                        }
                        role = new Role(roleId, roleName, roleDesc, privileges, privSetHashName);
                        role.setUnMappedPrivileges(origPrivList);
                        role.setRoleType(SecurityConstants.RoleType.TEAMSPACE);
                        role.setMessageId(messageId);
                        securityService.createPrivilegeSet(role.getPrivSetName(), role.getName(), role.getPrivileges());
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Is not owner: " + roleName);
                        role.setOwner(false);
                    } else {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Role is owner: " + roleName);
                        role = new Role(SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue(), SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue(), roleDesc, new ArrayList<String>(Arrays.asList(CMDataModel.TEAMSPACE_OWNER_PRIVSET)), SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue());
                        role.setUnMappedPrivileges(origPrivList);
                        role.setRoleType(SecurityConstants.RoleType.TEAMSPACE);
                        role.setMessageId(messageId);
                        role.setOwner(true);
                    }
                    rolesMap.put(roleId, role);
                }
                ArrayList<Role> roles = new ArrayList<Role>();
                roles.addAll(rolesMap.values());
                ArrayList<AccessControlListData> aclData = new ArrayList<AccessControlListData>();
                AccessControlList secObjACL = new AccessControlList("", aclData);
                JSONArray members = (JSONArray)jsonObject.get("members");
                for (int i = 0; i < members.size(); ++i) {
                    JSONObject member = (JSONObject)members.get(i);
                    String principalId = (String)member.get("id");
                    String principalName = (String)member.get("name");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "principalName= " + principalName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "principalId= " + principalId);
                    SecurityConstants.PrincipalType principalType = SecurityConstants.PrincipalType.valueOf(((String)member.get("type")).toUpperCase());
                    JSONArray memberRolesArray = (JSONArray)member.get("roles");
                    for (int j = 0; j < memberRolesArray.size(); ++j) {
                        String roleId = (String)memberRolesArray.get(j);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "memberRolesArray  roleId= " + roleId);
                        Role role = (Role)rolesMap.get(roleId);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, principalName + " is assigned Role " + role.getName());
                        if (secObjACL.contains(principalName)) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "ACL already contains a rule for user: " + principalName);
                            CM8AccessControlListData existingACLData = (CM8AccessControlListData)secObjACL.get(principalName);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "existingACLData: " + existingACLData.getName());
                            Role existingRole = existingACLData.getPrivSet();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "existingRoleName: " + existingRole.getName());
                            List<String> existingPrivs = existingRole.getPrivileges();
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Existing priv size: " + existingPrivs.size());
                            List<String> privs = role.getPrivileges();
                            List<String> existingUnMappedPrivs = existingRole.getUnMappedPrivileges();
                            List<String> unMappedPrivs = role.getUnMappedPrivileges();
                            for (String priv : unMappedPrivs) {
                                if (!existingUnMappedPrivs.contains(priv)) {
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Adding unmapped priv: " + priv + " from " + role.getName() + " role");
                                    existingUnMappedPrivs.add(priv);
                                    continue;
                                }
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Not Adding unMapped priv: " + priv + " from " + role.getName() + " role... It's a duplicate");
                            }
                            for (String priv : privs) {
                                if (!existingPrivs.contains(priv)) {
                                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Adding priv: " + priv + " from " + role.getName() + " role");
                                    existingPrivs.add(priv);
                                    continue;
                                }
                                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Not Adding priv: " + priv + " from " + role.getName() + " role... It's a duplicate");
                            }
                            String unMappedPrivSetHashName = CM8SecurityUtils.generatePrivSetNameHash(existingUnMappedPrivs);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "unMappedPrivSetHashName: " + unMappedPrivSetHashName);
                            existingRole.setPrivSetName(unMappedPrivSetHashName);
                            existingRole.setPrivileges(existingPrivs);
                            existingACLData.setPrivSet(existingRole);
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "merged priv size: " + existingACLData.getPrivSet().getPrivileges().size());
                            secObjACL.remove(principalName);
                            this.addACLData(request, securityService, secObjACL, aclData, existingRole, principalId, principalName, principalType, roles);
                            continue;
                        }
                        this.addACLData(request, securityService, secObjACL, aclData, role, principalId, principalName, principalType, roles);
                    }
                }
                String className = "ICMTeamspaceTemplate";
                if (teamspaceType.equals("instance")) {
                    className = "ICMTeamspace";
                }
                Teamspace teamspace = new Teamspace(request, name, description, teamspaceType, className, teamspaceJson, null);
                teamspace.setId(teamspaceId);
                teamspace.setState(teamspaceState);
                teamspace.setTemplateId(teamspaceTemplateId);
                boolean retrieveFullTeamspaceObject = false;
                if (modifyTeamspace != null && modifyTeamspace.equalsIgnoreCase("true")) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "editing teamspace template");
                    teamspaceService.editTeamspace(teamspace, roles, secObjACL, modifyUsers.equalsIgnoreCase("true"));
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "creating teamspace template");
                    if (teamspaceType.equals("template")) {
                        JSONArray jsonPermissions = (JSONArray)jsonObject.get("permissions");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "jsonPermissions:  " + jsonPermissions);
                        secObjACL = CM8SecurityUtils.getPermissionsFromJSON(request, jsonPermissions, dsICM, SecurityConstants.AppPrivilegeSets.TEAMSPACE);
                        jsonObject.remove("permissions");
                        String json = jsonObject.toString();
                        teamspace.setJson(json);
                    } else {
                        retrieveFullTeamspaceObject = true;
                    }
                    teamspaceId = teamspaceService.createTeamspace(teamspace, roles, secObjACL);
                }
                if (retrieveFullTeamspaceObject) {
                    teamspace = teamspaceService.retrieveTeamspace(teamspaceId, "allData", teamspaceType);
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Set teamspace");
                ArrayList<Teamspace> teamspaces = new ArrayList<Teamspace>();
                teamspaces.add(teamspace);
                teamspaceAddMediator.setTeamspaces(teamspaces);
            }
            catch (SecurityException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, "modifyTeamspace: " + modifyTeamspace);
                if (modifyTeamspace == null || modifyTeamspace.equalsIgnoreCase("false")) {
                    if (teamspaceType.equals("template")) {
                        teamspaceAddMediator.addError("addWorkspaceTemplate.error.failed", e.getCause().getMessage());
                    } else {
                        teamspaceAddMediator.addError("addWorkspaceInstance.error.failed", e.getCause().getMessage());
                    }
                } else {
                    teamspaceAddMediator.addError("addWorkspace.error.failed", e.getCause().getMessage());
                }
            }
            catch (TeamspaceException we) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)we);
                if (we.getErrorID() == 1088) {
                    teamspaceAddMediator.addError("addWorkspace.error.failed", we.getCause().getMessage());
                } else if (we.getErrorID() == 1097) {
                    teamspaceAddMediator.addError("addSearchToWorkspace.error.failed");
                } else {
                    teamspaceAddMediator.addError("error.exception.general", we.getMessage());
                }
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                teamspaceAddMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void addACLData(HttpServletRequest request, CM8SecurityService securityService, AccessControlList secObjACL, List<AccessControlListData> aclData, Role role, String principalId, String principalName, SecurityConstants.PrincipalType principalType, List<Role> roles) throws Exception {
        String methodName = "addACLData";
        if (principalId.equals("CURRENT_USER")) {
            if (!secObjACL.contains(principalName)) {
                if (role.getPrivileges().contains("addRemoveRoleParticipants")) {
                    Logger.logError((Object)this, methodName, (ServletRequest)request, "add ACL data for current user");
                    aclData.add(new CM8AccessControlListData(request, principalName, roles, principalType, role));
                    if (!role.isOwner()) {
                        securityService.createPrivilegeSet(role.getPrivSetName(), role.getName(), role.getPrivileges());
                    }
                } else {
                    Logger.logError((Object)this, methodName, (ServletRequest)request, "Missing addRemoveRoleParticipants");
                }
            }
        } else if (!secObjACL.contains(principalId) && !secObjACL.contains(principalName)) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, "ACL does not contain principal id: " + principalId + " or name: " + principalName);
            aclData.add(new CM8AccessControlListData(request, principalId, roles, principalType, role));
            if (!role.isOwner()) {
                securityService.createPrivilegeSet(role.getPrivSetName(), role.getName(), role.getPrivileges());
            }
        }
    }

    private List<String> convertJsonArrayToList(JSONArray privsArray) {
        ArrayList<String> list = new ArrayList<String>();
        for (int j = 0; j < privsArray.size(); ++j) {
            String priv = (String)privsArray.get(j);
            list.add(priv);
        }
        return list;
    }

    private DKDDO retrieveTeamspaceDDO(DKDatastoreICM dsICM, String teamspaceId) {
        String methodName = "retrieveTeamspaceDD";
        DKDDO icmddo = null;
        try {
            icmddo = dsICM.createDDOFromPID(teamspaceId);
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)dsICM);
            dkRetrieveOptions.linksOutbound(true);
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.childAttributes(true);
            dkRetrieveOptions.childListOneLevel(true);
            dkRetrieveOptions.linksTypeFilter("DKFolder");
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            DKPidICM pid = (DKPidICM)icmddo.getPidObject();
            if (pid.getVersionNumber().equals("0")) {
                pid.setVersionNumber("1");
                dkRetrieveOptions.functionVersionLatest(true);
            }
            icmddo.retrieve(dkRetrieveOptions.dkNVPair());
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
        return icmddo;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: wc_repositoryId = " + serverName);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        CMTeamspaceListMediator teamspaceAddMediator = new CMTeamspaceListMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)teamspaceAddMediator);
        return teamspaceAddMediator;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

