/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.security.cm8.CM8SecurityUtils;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.teamspace.cm8.CM8AddItemUtil;
import com.ibm.ecm.teamspace.cm8.CM8TeamspaceService;
import com.ibm.ecm.util.cm.CMSearchTemplate;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKChildCollection;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMAddSearchTemplateAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dataStore;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMSearchResultsMediator mediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dataStore = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                String repositoryId = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + repositoryId);
                String workspaceId = request.getParameter("workspaceId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + workspaceId);
                this.getConfigInfo(request);
                String str = this.readJSON(request);
                JSONObject json = (JSONObject)JSON.parse(str);
                CMSearchTemplate searchTemplate = new CMSearchTemplate();
                searchTemplate.fromJSON(json);
                String name = (String)json.get("name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "name = " + name);
                String description = (String)json.get("description");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description = " + description);
                String parentFolderId = (String)json.get("parentFolderId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parentFolderId = " + parentFolderId);
                mediator.setConnection(this.getConnection(request));
                mediator.setDateFormats(this.getDateFormats());
                if (dataStore != null && dataStore.isConnected()) {
                    DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)dataStore.datastoreDef();
                    DKComponentTypeDefICM itemType = (DKComponentTypeDefICM)dsDefICM.retrieveEntity("ICMSearch");
                    mediator.setItemType(itemType);
                    mediator.setReferenceAttributes(itemType.listAttrGroups(99));
                    DKDDO ddo = dataStore.createDDO("ICMSearch", 4);
                    ddo.setData(ddo.dataId("ICM$NAME"), (Object)name);
                    ddo.setData(ddo.dataId("clbDescription"), (Object)description);
                    ddo.setData(ddo.dataId("clbSearchType"), (Object)0);
                    ddo.setData(ddo.dataId("clbAutoRun"), (Object)(searchTemplate.isAutoRun() ? 1 : 0));
                    ddo.setData(ddo.dataId("clbShowInTree"), (Object)(searchTemplate.isShowInTree() ? 1 : 0));
                    DKDDO child = dataStore.createChildDDO("ICMSearch", "ICMSearchData");
                    child.setData(child.dataId("ATTR", "clbSearchJSON"), (Object)searchTemplate.toPersistableJSON().toString());
                    DKChildCollection children = new DKChildCollection();
                    children.addElement((Object)child);
                    ddo.setData(ddo.dataId("CHILD", "ICMSearchData"), (Object)children);
                    dataStore.addObject((dkDataObject)ddo, 0);
                    AccessControlList secObjACL = CM8SecurityUtils.getPermissionsFromJSON(request, (JSONArray)json.get("permissions"), dataStore, SecurityConstants.AppPrivilegeSets.OWNER);
                    if (secObjACL != null) {
                        secObjACL.setName(ddo.getPidObject().getPrimaryId());
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Applying security to template... ACL name: " + secObjACL.getName());
                        if (secObjACL != null && secObjACL.getAclData().size() > 0) {
                            CM8SecurityService securityService = new CM8SecurityService(request, dataStore);
                            securityService.setACL(secObjACL, ddo, false, false);
                        } else {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Default ACL from Item type or User def will be used");
                        }
                    }
                    dataStore.checkOut((dkDataObject)ddo);
                    ddo.update();
                    if ((parentFolderId == null || parentFolderId.length() == 0) && workspaceId != null) {
                        parentFolderId = workspaceId;
                    }
                    if (parentFolderId != null) {
                        DKDDO parentFolder = dataStore.createDDOFromPID(parentFolderId);
                        CM8AddItemUtil util = new CM8AddItemUtil(this.request, dataStore, this.getDateFormats());
                        util.addItemToFolder(parentFolder, ddo, this.request);
                    }
                    CMConnection connection = this.getConnection(request);
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                    dkRetrieveOptions.basePropertyAclName(true);
                    CMItem item = connection.retrieveItem(ddo.getPidObject().pidString(), request, dkRetrieveOptions);
                    CMSearchResults searchResults = new CMSearchResults(request, connection);
                    Vector<CMItem> items = new Vector<CMItem>();
                    items.add(item);
                    searchResults.newResults(items, true, false, false);
                    mediator.setSearchResults(searchResults);
                    mediator.addMessage("addDocument.success", new Object[0]);
                    if (workspaceId != null && workspaceId.length() > 0) {
                        CM8TeamspaceService workspaceService = new CM8TeamspaceService(request, connection, this.wcDateFormats);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "adding a search to the teamspace");
                        workspaceService.addSearchTemplate(workspaceId, ddo.getPidObject().pidString(), name, description);
                    }
                }
            }
            catch (DKException de) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)de);
                String msgKey = "error.exception.general";
                Object[] msgInserts = new Object[1];
                int errorId = de.getErrorId();
                Logger.logError((Object)this, methodName, (ServletRequest)request, "errorId = " + errorId);
                switch (errorId) {
                    case 5160: 
                    case 5161: 
                    case 5162: 
                    case 5163: 
                    case 5164: 
                    case 5165: 
                    case 5410: {
                        msgKey = "error.rmserver.exception.explanation";
                        msgInserts[0] = de.getMessage();
                        break;
                    }
                    case 5218: {
                        msgKey = "additem.error.requiredattributemissing";
                        msgInserts[0] = "ICMSearch";
                        break;
                    }
                    case 3624: {
                        msgKey = "additem.error.folder.lockbyother";
                        msgInserts[0] = "ICMSearch";
                        break;
                    }
                    default: {
                        msgKey = "error.exception.general";
                        msgInserts[0] = de.getMessage();
                    }
                }
                mediator.addError(msgKey, msgInserts);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                mediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            mediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

