/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.Constants;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.RoleListMediator;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.security.cm8.CM8SecurityUtils;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMAddRoleAction
extends CMBaseAction
implements Constants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM privIterator;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String serverName = request.getParameter("repositoryId");
        String roleName = request.getParameter("name");
        String description = request.getParameter("description");
        String[] privileges = request.getParameterValues("privs");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "privs: " + request.getParameterValues("privs"));
        ArrayList<String> privList = new ArrayList<String>();
        ArrayList<String> origPrivList = new ArrayList();
        origPrivList = Arrays.asList(privileges);
        CMConnection connection = this.getConnection(request);
        String privSetHashName = CM8SecurityUtils.generatePrivSetNameHash(origPrivList);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "privSetHashName: " + privSetHashName);
        if (privileges != null) {
            for (int i = 0; i < privileges.length; ++i) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "priv= " + privileges[i]);
                List<String> privNames = SecurityConstants.cm8PrivilegeMap.get(privileges[i]);
                if (privNames == null) continue;
                privIterator = privNames.iterator();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Privilege map has item: " + privIterator.hasNext());
                while (privIterator.hasNext()) {
                    String privName = privIterator.next();
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "privName= " + privName);
                    privList.add(privName);
                }
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "roleName = " + roleName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "description = " + description);
        DKDatastoreICM dsICM = this.getDataStore(request);
        RoleListMediator rolesListMediator = (RoleListMediator)this.getMediator(request);
        try {
            privIterator = dsICM;
            synchronized (privIterator) {
                Random r = new Random();
                String roleId = "ROLE_" + r.nextLong();
                Role role = new Role(roleId, roleName, description, privList, privSetHashName);
                CM8SecurityService service = new CM8SecurityService(request, dsICM);
                String id = service.createRoleTemplate(role);
                DKDDO ddo = this.retrieveDDO(request, id, connection);
                dkDatastoreExt dsExt = (dkDatastoreExt)dsICM.getExtension("DATASTORE_EXTENSION");
                DKCommonPrivilege privilege = this.getCommonPrivilege(ddo, dsExt);
                boolean privDelete = CMBaseUtil.checkAuthorization(privilege, 27);
                ArrayList<String> userPrivileges = new ArrayList<String>();
                if (privDelete) {
                    userPrivileges.add("privDelete");
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add delete priv");
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "does not have delete priv");
                }
                role.setCurrentUserPrivileges(userPrivileges);
                role.setId(id);
                rolesListMediator.setRoles(Arrays.asList(role));
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Role was added");
            rolesListMediator.addMessage("role.add.successful", new Object[0]);
        }
        catch (SecurityException e) {
            if (e.getErrorID() == 7215) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, "User does not have enough privileges");
                rolesListMediator.addError("addRole.error.failed", e.getCause().getMessage());
            } else {
                Logger.logError((Object)this, methodName, (ServletRequest)request, e.getMessage());
                rolesListMediator.addError("error.exception.general", e.getMessage());
            }
        }
        catch (Throwable e) {
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, e);
            rolesListMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private DKCommonPrivilege getCommonPrivilege(DKDDO privDDO, dkDatastoreExt dsExt) throws Exception {
        String methodName = "getCommonPrivilege";
        DKCommonPrivilege commonPrivilege = null;
        if (privDDO != null) {
            try {
                commonPrivilege = dsExt.getCommonItemPrivilege((dkDataObject)privDDO);
            }
            catch (RuntimeException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return commonPrivilege;
    }

    private DKDDO retrieveDDO(HttpServletRequest request, String id, CMConnection connection) throws Exception {
        DKDDO icmddo = null;
        icmddo = connection.getDatastore().createDDOFromPID(id);
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
        DKPidICM pid = (DKPidICM)icmddo.getPidObject();
        if (pid.getVersionNumber().equals("0")) {
            pid.setVersionNumber("1");
            dkRetrieveOptions.functionVersionLatest(true);
        }
        icmddo.retrieve();
        return icmddo;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        RoleListMediator rolesListMediator = new RoleListMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)rolesListMediator);
        return rolesListMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
    }
}

