/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMObject;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMNotelogMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class CMAddNotelogAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DKDatastoreICM dsICM;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        DKDatastoreICM dKDatastoreICM = dsICM = this.getDataStore(request);
        synchronized (dKDatastoreICM) {
            try {
                this.addNotelog(request, response);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                baseMediator.addError("error.exception.general", e.getMessage());
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void addNotelog(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "addNotelog";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        CMConnection connection = this.getConnection(request);
        StringBuffer newLog = new StringBuffer();
        String separator = "******************************\n";
        int newLine = 10;
        newLog.append("******************************\n");
        newLog.append(new Date().toString());
        newLog.append('\n');
        newLog.append(connection.getUserid());
        newLog.append('\n');
        newLog.append("******************************\n");
        newLog.append(request.getParameter("text"));
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        String decodedPid = pid;
        String utf8 = this.getUtils(request).getEncoding(request);
        try {
            decodedPid = URLDecoder.decode(pid, utf8);
        }
        catch (UnsupportedEncodingException ue) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, ue.getLocalizedMessage());
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: decodedPID = " + decodedPid);
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.partsList(true);
        dkRetrieveOptions.partsAttributes(true);
        CMItem item = connection.retrieveItem(pid, request, dkRetrieveOptions);
        item.lock();
        try {
            String logText = newLog.toString();
            byte[] data = logText.getBytes(this.getUtils(request).getEncoding(request));
            CMObject newNoteLog = new CMObject(data, "text/plain");
            item.addNoteLog(newNoteLog);
        }
        catch (Exception e) {
            try {
                item.unlock();
            }
            catch (Exception t) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, "Add item notelog failed");
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            }
            throw e;
        }
        item.unlock();
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: new notelog added = " + newLog);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String serverName = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        String newNotelog = request.getParameter("text");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: newNotelog = " + newNotelog);
        if (serverName == null || serverName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        if (newNotelog == null || newNotelog.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "text");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMNotelogMediator notelogMediator = new CMNotelogMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)notelogMediator);
        return notelogMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: serverName = " + serverName);
        String pid = request.getParameter("docid");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: documentID = " + pid);
        String newNotelog = request.getParameter("text");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: newNotelog = " + newNotelog);
    }
}

