/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.cm;

import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.beans.cm.CMEntity;
import com.ibm.ecm.beans.cm.CMItem;
import com.ibm.ecm.beans.cm.CMSearchResults;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.cm.CMSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.struts.actions.cm.CMBaseAction;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKComponentTypeDefICM;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKFolder;
import com.ibm.mm.sdk.common.DKItemTypeDefICM;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CMAddItemAction
extends CMBaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";
    protected static final int INTERNAL_BUFFER_SIZE = 4096;

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        String contentType = request.getParameter("parm_content_source_type");
        if (contentType != null && contentType.equalsIgnoreCase("Folder")) {
            String strJsonFormData = this.readJSON(request);
            JSONArray jsonArray = JSONArray.parse(strJsonFormData);
            request.setAttribute("json_post", (Object)jsonArray);
        } else {
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonItem = new JSONObject();
            jsonArray.add(jsonItem);
            String criterias = request.getParameter("criterias");
            JSONArray criteriasJsonArray = JSONArray.parse(criterias);
            jsonItem.put("criterias", criteriasJsonArray);
            String childComps = request.getParameter("childComponentValues");
            JSONArray childCompsJsonArray = JSONArray.parse(childComps);
            jsonItem.put("childComponentValues", childCompsJsonArray);
            request.setAttribute("json_post", (Object)jsonArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        CMSearchResultsMediator searchResultsMediator = (CMSearchResultsMediator)this.getMediator(request);
        DKDatastoreICM ds = this.getDataStore(request);
        CMConnection connection = this.getConnection(request);
        DKDatastoreICM dKDatastoreICM = ds;
        synchronized (dKDatastoreICM) {
            String entityName = null;
            String contentType = null;
            String itemTypeDescription = null;
            String itemTypeName = null;
            String itemTypeId = null;
            try {
                this.getConfigInfo(request);
                String repositoryId = request.getParameter("repositoryId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName = " + repositoryId);
                entityName = request.getParameter("template_name");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
                contentType = request.getParameter("parm_content_source_type");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "contentType = " + contentType);
                String workspaceId = request.getParameter("workspaceId");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "workspaceId = " + workspaceId);
                JSONArray jsonRequest = (JSONArray)this.getJSONRequest(request);
                JSONObject jsonItem = (JSONObject)jsonRequest.get(0);
                JSONArray criteriasJsonArray = (JSONArray)jsonItem.get("criterias");
                JSONArray childCompValuesJsonArray = (JSONArray)jsonItem.get("childComponentValues");
                searchResultsMediator.setResponseAsHtml(((FileUploadActionForm)form).getUploadFile() != null);
                DKDatastoreDefICM dsDefICM = (DKDatastoreDefICM)ds.datastoreDef();
                DKComponentTypeDefICM compTypeDef = (DKComponentTypeDefICM)dsDefICM.retrieveEntity(entityName);
                DKItemTypeDefICM itemTypeDef = compTypeDef instanceof DKItemTypeDefICM ? (DKItemTypeDefICM)compTypeDef : (DKItemTypeDefICM)dsDefICM.retrieveEntity(compTypeDef.getItemTypeName());
                searchResultsMediator.setConnection(this.getConnection(request));
                searchResultsMediator.setItemType(compTypeDef);
                searchResultsMediator.setReferenceAttributes(compTypeDef.listAttrGroups(99));
                searchResultsMediator.setChildComponents((dkCollection)((DKSequentialCollection)compTypeDef.listSubEntities()));
                searchResultsMediator.setDateFormats(this.getDateFormats());
                itemTypeDescription = compTypeDef.getDescription();
                itemTypeName = compTypeDef.getName();
                itemTypeId = Integer.toString(compTypeDef.getItemTypeId());
                short entityClassification = itemTypeDef.getClassification();
                boolean hierarchicalItemType = itemTypeDef.isHierarchical();
                boolean validItemType = this.validateItemType(request, itemTypeDescription, entityClassification, contentType, searchResultsMediator, itemTypeName, itemTypeId);
                if (!validItemType) {
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                boolean validAttributes = this.validateItemTypeAttributes(request, dsDefICM, (DKComponentTypeDefICM)itemTypeDef, criteriasJsonArray);
                if (!validAttributes) {
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "CLOB, BLOB or DBCLOB attributes are not supported");
                    searchResultsMediator.addError("import.attribute.notsupported.explanation");
                    this.writeJSONMediator(request, response);
                    Logger.logExit((Object)this, methodName, (ServletRequest)request);
                    return actionForward;
                }
                DKDDO ddo = null;
                String parentFolderPid = request.getParameter("docid");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "parent folder was selected and the pid = " + parentFolderPid);
                DKDDO parentFolderDDO = null;
                if (parentFolderPid != null && !parentFolderPid.equals("")) {
                    parentFolderDDO = ds.createDDOFromPID(parentFolderPid);
                }
                ddo = contentType.equalsIgnoreCase("Folder") ? ds.createDDO(entityName, 2) : ds.createDDO(entityName, 1);
                String aclName = null;
                CMEntity entity = connection.getEntity(CMBaseUtil._getEntityName(ddo.getPidObject().getObjectType()));
                boolean isItemTypeLevelSec = entity.isItemTypeLevelACL();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "isItemTypeLevelSec: " + isItemTypeLevelSec);
                if (!isItemTypeLevelSec && workspaceId != null && workspaceId.length() > 0) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "adding teamspace acl to item");
                    DKDDO teamspaceDDO = ds.createDDOFromPID(workspaceId);
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)ds);
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.basePropertyAclName(true);
                    DKPidICM pid = (DKPidICM)teamspaceDDO.getPidObject();
                    if (pid.getVersionNumber().equals("0")) {
                        pid.setVersionNumber("1");
                        dkRetrieveOptions.functionVersionLatest(true);
                    }
                    teamspaceDDO.retrieve(dkRetrieveOptions.dkNVPair());
                    short propertyID = teamspaceDDO.propertyId("SYSROOTATTRS.ACLCODE");
                    aclName = (String)teamspaceDDO.getProperty(propertyID);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "teamspace aclName: " + aclName);
                }
                this.setItemAttributesFromCriterias(request, itemTypeDef, criteriasJsonArray, childCompValuesJsonArray, ds, ddo, aclName);
                if (contentType.equalsIgnoreCase("Document")) {
                    this.setContent(request, ddo, ds, itemTypeDef, form, true, false);
                }
                if (hierarchicalItemType) {
                    if (parentFolderDDO == null) {
                        parentFolderDDO = ds.getRootFolder();
                    }
                    ddo.addProperty("PARENT_FOLDER", (Object)parentFolderDDO);
                    ds.addObject((dkDataObject)ddo, 0);
                } else {
                    ds.addObject((dkDataObject)ddo, 0);
                    if (parentFolderDDO != null) {
                        this.addItemToFolder(ds, parentFolderDDO, ddo, request);
                    }
                }
                ddo = this.retrieveDDO(request, ddo.getPidObject().pidString(), connection);
                CMItem item = new CMItem(request, connection, ddo, null, true, false, true);
                CMSearchResults wcSearchResults = new CMSearchResults(request, connection);
                Vector<CMItem> resultsVector = new Vector<CMItem>();
                resultsVector.add(item);
                wcSearchResults.newResults(resultsVector, true, false, true);
                searchResultsMediator.setSearchResults(wcSearchResults);
                String messageKey = contentType.equalsIgnoreCase("Folder") ? "addFolder.success" : "addDocument.success";
                if (parentFolderDDO != null) {
                    messageKey = "addToFolder.success.singleitem.singlefolder";
                }
                searchResultsMediator.addMessage(messageKey, new Object[0]);
            }
            catch (DKException de) {
                this.logFDC(request, response, null, methodName);
                this.handleCMItemError(request, methodName, de, itemTypeDescription, contentType, searchResultsMediator, itemTypeName, itemTypeId);
            }
            catch (Exception e) {
                this.logFDC(request, response, null, methodName);
                Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                searchResultsMediator.addError("error.exception.general", e.getMessage());
            }
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private DKDDO retrieveDDO(HttpServletRequest request, String id, CMConnection connection) throws Exception {
        DKDDO icmddo = null;
        icmddo = connection.getDatastore().createDDOFromPID(id);
        DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)connection.getDatastore());
        dkRetrieveOptions.baseAttributes(true);
        dkRetrieveOptions.basePropertyAclName(true);
        dkRetrieveOptions.childListOneLevel(true);
        dkRetrieveOptions.childAttributes(true);
        dkRetrieveOptions.partsList(true);
        dkRetrieveOptions.partsAttributes(true);
        dkRetrieveOptions.functionVersionLatest(true);
        icmddo.retrieve(dkRetrieveOptions.dkNVPair());
        return icmddo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addItemToFolder(DKDatastoreICM ds, DKDDO parentFolderDDO, DKDDO ddoObj, HttpServletRequest request) throws DKException, DKUsageError, Exception {
        String methodName;
        block11: {
            methodName = "addItemToFolder";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            if (parentFolderDDO == null) {
                return;
            }
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)ds);
            dkRetrieveOptions.linksOutbound(true);
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.basePropertyAclName(true);
            dkRetrieveOptions.childAttributes(true);
            dkRetrieveOptions.childListOneLevel(true);
            dkRetrieveOptions.linksTypeFilter("DKFolder");
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            DKPidICM pid = (DKPidICM)parentFolderDDO.getPidObject();
            if (pid.getVersionNumber().equals("0")) {
                pid.setVersionNumber("1");
                dkRetrieveOptions.functionVersionLatest(true);
            }
            parentFolderDDO.retrieve(dkRetrieveOptions.dkNVPair());
            short data_id = 0;
            data_id = parentFolderDDO.dataId("ATTR", "DKFolder");
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "data id = " + data_id);
            if (data_id != 0) {
                boolean wasCheckedOut;
                DKFolder f = null;
                f = (DKFolder)parentFolderDDO.getData(data_id);
                if (f == null) {
                    f = new DKFolder();
                    f.addElement((Object)ddoObj);
                    parentFolderDDO.setData(data_id, (Object)f);
                } else {
                    f.addElement((Object)ddoObj);
                }
                String userid = null;
                try {
                    userid = (String)parentFolderDDO.getPropertyByName("Checked_Out_UserID");
                }
                catch (DKUsageError ex) {
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ex);
                }
                boolean bl = wasCheckedOut = userid != null;
                if (!wasCheckedOut) {
                    ds.checkOut((dkDataObject)parentFolderDDO);
                }
                try {
                    parentFolderDDO.update();
                    Object var13_13 = null;
                    if (wasCheckedOut) break block11;
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    if (!wasCheckedOut) {
                        ds.checkIn((dkDataObject)parentFolderDDO);
                    }
                    throw throwable;
                }
                ds.checkIn((dkDataObject)parentFolderDDO);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        Boolean maxFileSizeExceeded;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if ((maxFileSizeExceeded = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded")) != null && maxFileSizeExceeded.booleanValue()) {
            baseMediator.addError("import.filesize.exceed.maxlength");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        CMSearchResultsMediator baseMediator = new CMSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String serverName = request.getParameter("repositoryId");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "serverName = " + serverName);
        String entityName = request.getParameter("template_name");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "entityName = " + entityName);
        String contentType = request.getParameter("parm_content_source_type");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "contentType = " + contentType);
    }
}

