/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.admin.p8;

import com.filenet.api.core.Domain;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.struts.actions.p8.P8BaseAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.ecm.util.p8.P8NexusAddOn;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class P8AddOnAction
extends P8BaseAction {
    public static final String CIWEB_TEAMSPACES_ADDON_NAME = "CIWEBTeamspacesAddOn";
    public static final String CIWEB_SEARCH_ADDON_NAME = "CEWEBSearchAddOn";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName;
        block7: {
            methodName = "executeAction";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            request.setCharacterEncoding("UTF-8");
            String addOnStringName = request.getParameter("values");
            String[] values = addOnStringName.split(",");
            BaseMediator mediator = this.getMediator(request);
            P8Connection connection = this.getConnection(request);
            try {
                try {
                    ObjectStore objectStore = connection.getObjectStore();
                    Domain p8Domain = objectStore.get_Domain();
                    for (String id : values) {
                        if (id.equalsIgnoreCase(CIWEB_SEARCH_ADDON_NAME)) {
                            this.searchAddOn(objectStore, p8Domain, P8NexusAddOn.NEXUS_STORED_SEARCH_ADDON_ID, request);
                            continue;
                        }
                        this.teamspacesAddOn(objectStore, p8Domain, P8NexusAddOn.NEXUS_TEAMSPACE_ADDON_ID, request);
                    }
                    Object var17_17 = null;
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
                    mediator.addError("desktop.configError");
                    this.setRequestHasErrors(request, true);
                    Object var17_18 = null;
                    this.writeJSONMediator(request, response);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                this.writeJSONMediator(request, response);
                throw throwable;
            }
            this.writeJSONMediator(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private void searchAddOn(ObjectStore objectStore, Domain p8Domain, Id addonId, HttpServletRequest request) throws Exception {
        String methodName = "searchAddOn";
        String objectStoreName = objectStore.get_Name();
        boolean prerequisiteMet = false;
        if (P8NexusAddOn.addOnExistsInDomain(p8Domain, P8NexusAddOn.CE520_BASE_STORED_SEARCH_ADDON_ID)) {
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Domain " + p8Domain.get_Name() + " has 5.2.0 stored search extensions");
            prerequisiteMet = P8NexusAddOn.addOnExistsInObjectStore(objectStore, P8NexusAddOn.CE520_BASE_STORED_SEARCH_ADDON_ID);
        } else if (P8NexusAddOn.checkPreRequisiteAddons(p8Domain, objectStore, addonId)) {
            prerequisiteMet = true;
            if (this.createSearchAddOn(p8Domain, addonId, request)) {
                this.installSearchAddOn(objectStore, p8Domain, addonId, request);
            }
        }
        if (!prerequisiteMet) {
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "The prerequisite add-ons are not installed on either the " + p8Domain.get_Name() + " domain or the " + objectStoreName + " object store");
            BaseMediator mediator = this.getMediator(request);
            mediator.addError("admin.exception.prerequisiteaddonmissing", objectStoreName, p8Domain.get_Name());
            this.setRequestHasErrors(request, true);
        }
    }

    private boolean createSearchAddOn(Domain p8Domain, Id addonId, HttpServletRequest request) throws Exception {
        String methodName = "createSearchAddOn";
        String domainName = p8Domain.get_Name();
        try {
            P8NexusAddOn.createAddOn(p8Domain, addonId);
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "AddOn: " + addonId + " has been created in: " + domainName);
            return true;
        }
        catch (EngineRuntimeException ex) {
            BaseMediator mediator = this.getMediator(request);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ex);
            mediator.addError("admin.exception.searchaddonfailedtocreate", domainName);
            this.setRequestHasErrors(request, true);
            return false;
        }
    }

    private void installSearchAddOn(ObjectStore objectStore, Domain p8Domain, Id addonId, HttpServletRequest request) throws Exception {
        String methodName = "installSearchAddOn";
        String objectStoreName = objectStore.get_Name();
        try {
            P8NexusAddOn.installAddOn(p8Domain, objectStore.get_Id().toString(), addonId);
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "AddOn: " + addonId + " has been installed in: " + objectStoreName);
        }
        catch (EngineRuntimeException ex) {
            if (ex.getExceptionCode() == ExceptionCode.E_NOT_UNIQUE) {
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "AddOn: " + addonId + " was already installed in the: " + objectStoreName);
            }
            BaseMediator mediator = this.getMediator(request);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ex);
            mediator.addError("admin.exception.searchaddonfailedtoinstall", objectStoreName);
            this.setRequestHasErrors(request, true);
        }
    }

    private void teamspacesAddOn(ObjectStore objectStore, Domain p8Domain, Id addonId, HttpServletRequest request) throws Exception {
        String methodName = "teamspacesAddOn";
        String objectStoreName = objectStore.get_Name();
        if (P8NexusAddOn.checkPreRequisiteAddons(p8Domain, objectStore, addonId)) {
            if (this.createTeamspacesAddOn(p8Domain, addonId, request)) {
                this.installTeamspacesAddOn(objectStore, p8Domain, addonId, request);
            }
        } else {
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "The prerequisite add-ons are not installed on either the " + p8Domain.get_Name() + " domain or the " + objectStoreName + " object store");
            BaseMediator mediator = this.getMediator(request);
            mediator.addError("admin.exception.prerequisiteaddonmissing", objectStoreName, p8Domain.get_Name());
            this.setRequestHasErrors(request, true);
        }
    }

    private boolean createTeamspacesAddOn(Domain p8Domain, Id addonId, HttpServletRequest request) throws Exception {
        String methodName = "createTeamspacesAddOn";
        String domainName = p8Domain.get_Name();
        try {
            P8NexusAddOn.createAddOn(p8Domain, addonId);
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "AddOn: " + addonId + " has been created in: " + domainName);
            return true;
        }
        catch (EngineRuntimeException ex) {
            BaseMediator mediator = this.getMediator(request);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ex);
            mediator.addError("admin.exception.teamspacesaddonfailedtocreate", domainName);
            this.setRequestHasErrors(request, true);
            return false;
        }
    }

    private void installTeamspacesAddOn(ObjectStore objectStore, Domain p8Domain, Id addonId, HttpServletRequest request) throws Exception {
        String methodName = "installTeamspacesAddOn";
        String objectStoreName = objectStore.get_Name();
        try {
            P8NexusAddOn.installAddOn(p8Domain, objectStore.get_Id().toString(), addonId);
            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "AddOn: " + addonId + " has been installed in: " + objectStoreName);
        }
        catch (EngineRuntimeException ex) {
            if (ex.getExceptionCode() == ExceptionCode.E_NOT_UNIQUE) {
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "AddOn: " + addonId + " was already installed in the: " + objectStoreName);
            }
            BaseMediator mediator = this.getMediator(request);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ex);
            mediator.addError("admin.exception.teamspacesaddonfailedtoinstall", objectStoreName);
            this.setRequestHasErrors(request, true);
        }
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
        return mediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = this.getMediator(request);
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        String repositoryId = request.getParameter("repositoryId");
        String addOnStringName = request.getParameter("values");
        String objectStore = request.getParameter("objectstore");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: app name = " + appName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: desktop name = " + desktopName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: AddonIds = " + addOnStringName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repository name = " + repositoryId);
        if (repositoryId == null || repositoryId.length() == 0 || addOnStringName == null || addOnStringName.length() == 0 || objectStore == null || objectStore.length() == 0) {
            mediator.addError("error.parm.null", "repositoryId", "values", "objectStore");
            this.setRequestHasErrors(request, true);
        }
        HttpSession session = request != null ? request.getSession() : null;
        try {
            ApplicationConfig appCfg = Config.getApplicationConfig(appName);
            Hashtable connectionList = (Hashtable)session.getAttribute(ContainerLogonAction.CONTAINERS);
            if (connectionList != null && desktopName != null) {
                Hashtable connections = (Hashtable)connectionList.get(desktopName);
                boolean validUser = false;
                if (connections != null) {
                    Enumeration userIds = connections.keys();
                    while (userIds.hasMoreElements()) {
                        String userId = (String)userIds.nextElement();
                        if (!appCfg.checkAdminAccessForUser(userId)) continue;
                        validUser = true;
                        break;
                    }
                    if (!validUser) {
                        mediator.addError("error.bad.userid.password");
                        this.setRequestHasErrors(request, true);
                    }
                }
            }
        }
        catch (Exception e) {
            mediator.addError("desktop.configError", e);
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

