/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.admin;

import com.ibm.ecm.Constants;
import com.ibm.ecm.ParamConstants;
import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.PluginsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.util.PluginUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class LoadPluginAction
extends BaseAction
implements Constants,
ParamConstants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        ActionForward actionForward = null;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        PluginsMediator pluginsMediator = (PluginsMediator)this.getMediator(request);
        String pluginFileName = request.getParameter("fileName");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "plugin filename = " + pluginFileName);
        try {
            Plugin plugin = PluginUtil.loadNewPlugin(request, pluginFileName);
            if (plugin == null) {
                pluginsMediator.addMessage("plugin.load.error", new Object[0]);
            } else {
                pluginsMediator.setPlugin(plugin);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            pluginsMediator.addMessage("plugin.load.error", new Object[0]);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        PluginsMediator baseMediator = new PluginsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)baseMediator);
        return baseMediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: app name = " + appName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: desktop name = " + desktopName);
        HttpSession httpSession = session = request != null ? request.getSession() : null;
        if (session != null) {
            try {
                ApplicationConfig appCfg = Config.getApplicationConfig(appName);
                Hashtable connectionList = (Hashtable)session.getAttribute(ContainerLogonAction.CONTAINERS);
                if (connectionList != null && desktopName != null) {
                    Hashtable connections = (Hashtable)connectionList.get(desktopName);
                    boolean validUser = false;
                    if (connections != null) {
                        Enumeration userIds = connections.keys();
                        while (userIds.hasMoreElements()) {
                            String userId = (String)userIds.nextElement();
                            if (!appCfg.checkAdminAccessForUser(userId)) continue;
                            validUser = true;
                            break;
                        }
                        if (!validUser) {
                            baseMediator.addError("error.bad.userid.password");
                            this.setRequestHasErrors(request, true);
                        }
                    }
                }
            }
            catch (Exception e) {
                baseMediator.addError("desktop.configError", e);
                this.setRequestHasErrors(request, true);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

