/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions.admin;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.IconConfig;
import com.ibm.ecm.configuration.IconStatusConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.InterfaceTextLocaleConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.ViewerConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.ConfigurationMediator;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ConfigurationAction
extends BaseAction {
    private static Map<String, ConfigMethod> configMethodMap = new LinkedHashMap<String, ConfigMethod>();

    protected BaseMediator createMediator(HttpServletRequest request) {
        String methodName = "createMediator";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationMediator configurationMediator = new ConfigurationMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)configurationMediator);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return configurationMediator;
    }

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        request.setCharacterEncoding("UTF-8");
        HttpSession session = request.getSession(false);
        AdminLogger.enableTimestamps = session != null ? session.getServletContext().getServerInfo().toUpperCase().indexOf("WEBSPHERE") == -1 : false;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        String action = request.getParameter("action");
        try {
            if (action.equals("add")) {
                this.addConfiguration(request, response);
            } else if (action.equals("get")) {
                this.getConfiguration(request, response);
            } else if (action.equals("list")) {
                this.getConfigurationList(request, response);
            } else if (action.equals("connectionDesktop")) {
                this.getConfigurationConnectionDesktop(request, response);
            } else if (action.equals("update")) {
                this.updateConfiguration(request, response);
            } else if (action.equals("updateList")) {
                this.updateListConfiguration(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("updateInterfaceText")) {
                this.updateInterfaceTextConfiguration(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("updateInterfaceTextOnly")) {
                this.updateInterfaceTextConfigurationOnly(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("delete")) {
                this.deleteConfiguration(request, response);
            } else if (action.equals("deleteList")) {
                this.deleteConfigurationList(request, response);
                configMediator.addMessage("deleteconfiguration.successful", new Object[0]);
            } else if (action.equals("multiple")) {
                this.multipleActions(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("export")) {
                String path = this.exportConfigurations(request, response);
                configMediator.addMessage("configuration.export.success", path);
            } else if (action.equals("updateUILabels")) {
                this.updateUILabels(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("updateIconMapping")) {
                this.updateIconMapping(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("updateFileTypesMapping")) {
                this.updateFileTypesMapping(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("updatePropertiesMapping")) {
                this.updatePropertiesMapping(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("updateMobileFeatures")) {
                this.updateMobileFeatures(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else {
                Logger.logError((Object)this, "executeBaseAction", (ServletRequest)request, "Invalid action type: " + action);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            String operator = request.getParameter("operator");
            configMediator.addError("desktop.configError");
            this.setRequestHasErrors(request, true);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private ConfigurationObject getConfiguration(HttpServletRequest request) throws Exception {
        String methodName = "getConfiguration2";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String configName = request.getParameter("configuration");
        String id = request.getParameter("id");
        ConfigurationMediator mediator = (ConfigurationMediator)this.getMediator(request);
        return ConfigurationAction.getConfiguration(appName, configName, id, request, mediator);
    }

    private static ConfigurationObject getConfiguration(String appName, String configName, String id, HttpServletRequest request, BaseMediator mediator) throws Exception {
        String methodName = "getConfiguration3";
        Logger.logEntry(ConfigurationObject.class, methodName, (ServletRequest)request);
        ConfigurationObject config = null;
        try {
            ConfigMethod configMethod = configMethodMap.get(configName);
            if (configMethod != null) {
                config = configMethod.getConfig(request, appName, id);
            } else {
                Logger.logError(ConfigurationObject.class, methodName, (ServletRequest)request, "Invalid configuration type: " + configName);
            }
        }
        catch (Exception e) {
            ConfigurationMediator configMediator = (ConfigurationMediator)mediator;
            configMediator.addError("desktop.configError");
            Logger.logError(ConfigurationObject.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(ConfigurationObject.class, methodName, (ServletRequest)request);
        return config;
    }

    private ConfigurationObject getParentConfiguration(String appName, String configName, String id, HttpServletRequest request) throws Exception {
        String methodName = "getParentConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        InterfaceTextConfig config = null;
        try {
            if (configName.equals("InterfaceTextLocaleConfig")) {
                config = Config.getInterfaceTextConfig(appName, id);
            }
        }
        catch (Exception e) {
            ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
            configMediator.addError("desktop.configError");
            Logger.logError((Object)this, "getConfiguration", (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return config;
    }

    private void getConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "getConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        String operator = request.getParameter("operator");
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(config);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void getConfigurationList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "getConfigurationList";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        String listType = request.getParameter("type");
        String sorted = request.getParameter("sorted");
        String appName = request.getParameter("application");
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        Collection configCollection = config.getList(listType, appName, request);
        if (sorted != null && sorted.equalsIgnoreCase("true") && configCollection != null) {
            ArrayList list = new ArrayList();
            list.addAll(configCollection);
            Collections.sort(list, new Comparator<ConfigurationObject>(){

                @Override
                public int compare(ConfigurationObject item1, ConfigurationObject item2) {
                    if (item1 != null && item2 != null && item1.getName() != null && item2.getName() != null) {
                        return item1.getName().compareTo(item2.getName());
                    }
                    return 0;
                }
            });
            configMediator.setConfigurationList(list);
        } else {
            configMediator.setConfigurationCollection(configCollection);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void getConfigurationConnectionDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "getConfigurationConnectionDesktop";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String isoRegion = request.getParameter("isoRegion");
        String listType = request.getParameter("type");
        String sorted = request.getParameter("sorted");
        String appName = request.getParameter("application");
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        ConfigurationObject config = this.getConfiguration(request);
        Collection collectionDesktops = config.getList(listType, appName, request);
        ArrayList listDesktops = new ArrayList();
        listDesktops.addAll(collectionDesktops);
        if (sorted != null && sorted.equalsIgnoreCase("true") && collectionDesktops != null) {
            Collections.sort(listDesktops, new Comparator<DesktopConfig>(){

                @Override
                public int compare(DesktopConfig item1, DesktopConfig item2) {
                    if (item1 != null && item2 != null && item1.getName() != null && item2.getName() != null) {
                        return item1.getName().compareTo(item2.getName());
                    }
                    return 0;
                }
            });
        }
        DesktopConfig defaultDesktop = null;
        DesktopConfig desktopConfig2 = null;
        for (DesktopConfig desktopConfig2 : listDesktops) {
            String currentIsoRegion;
            int index;
            String connectionPoint;
            RepositoryConfig defaultRepoConfig;
            String defaultRepositoryId;
            String isDefault = desktopConfig2.getDefault();
            if (isDefault != null && isDefault.equals("Yes")) {
                defaultDesktop = desktopConfig2;
            }
            if (desktopConfig2.getSupportWorkflowNotification() && (defaultRepositoryId = desktopConfig2.getDefaultRepositoryId()) != null && (defaultRepoConfig = desktopConfig2.getRepository(defaultRepositoryId)) != null && defaultRepoConfig.getType().equals("p8") && (connectionPoint = defaultRepoConfig.getConnectionPoint()) != null && connectionPoint.length() > 0 && (index = connectionPoint.lastIndexOf(58, connectionPoint.length())) != -1 && (currentIsoRegion = connectionPoint.substring(index + 1)) != null && currentIsoRegion.equals(isoRegion)) {
                Logger.logDebug(ConfigurationAction.class, methodName, (ServletRequest)request, "Repository id: " + defaultRepositoryId);
                Logger.logDebug(ConfigurationAction.class, methodName, (ServletRequest)request, "Connection point: " + connectionPoint);
                break;
            }
            desktopConfig2 = null;
        }
        if (desktopConfig2 == null && defaultDesktop != null) {
            desktopConfig2 = defaultDesktop;
            Logger.logDebug(ConfigurationAction.class, methodName, (ServletRequest)request, "Returning default repository: " + desktopConfig2.getDefaultRepositoryId());
        }
        configMediator.setConfigurationObject(desktopConfig2);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void addConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "addConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String id = request.getParameter("id");
        String appName = request.getParameter("application");
        String updateListId = request.getParameter("update_list_id");
        String updateListConfigName = request.getParameter("update_list_configuration");
        String updateListType = request.getParameter("update_list_type");
        ConfigurationObject config = this.getConfiguration(request);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONObject jsonObject = JSONObject.parse(jsonData);
        if (config instanceof DesktopConfig) {
            ((DesktopConfig)config).setPluginValues(request, jsonObject);
        }
        config.setValues(jsonObject);
        configMediator.setConfigurationObject(config);
        config.save();
        Config.removeConfigurationFromCache(config);
        if (updateListId != null && updateListConfigName != null && updateListType != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add - updateId=" + updateListId + " updateConfigName=" + updateListConfigName + " updateType=" + updateListType);
            ConfigurationObject updateConfig = ConfigurationAction.getConfiguration(appName, updateListConfigName, updateListId, request, this.getMediator(request));
            updateConfig.addValueToList(updateListType, id);
            updateConfig.save();
            Config.removeConfigurationFromCache(updateConfig);
        }
        String oType = config.getObjectType();
        configMediator.addMessage("addconfiguration.successful", new Object[0]);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updateConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONObject jsonObject = JSONObject.parse(jsonData);
        if (config instanceof DesktopConfig) {
            ((DesktopConfig)config).setPluginValues(request, jsonObject);
        }
        config.setValues(jsonObject);
        configMediator.setConfigurationObject(config);
        config.save();
        Config.removeConfigurationFromCache(config);
        configMediator.addMessage("changeconfiguration.successful", new Object[0]);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateInterfaceTextConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updateInterfaceTextConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String desktopId = request.getParameter("desktop");
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONArray jsonArray = JSONArray.parse(jsonData);
        ConfigurationObject config = null;
        String[] ids = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            String id;
            JSONObject itData = (JSONObject)jsonArray.get(i);
            ids[i] = id = (String)itData.get("id");
            JSONObject value = (JSONObject)itData.get("_attributes");
            String configName = (String)itData.get("name");
            config = ConfigurationAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
            config.setValues(value);
            config.save();
            Config.removeConfigurationFromCache(config);
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        if (desktopId == null || desktopId.length() == 0) {
            configMediator.setConfigurationObject(config);
        } else {
            DesktopConfig desktopConfig = (DesktopConfig)ConfigurationAction.getConfiguration(appName, "DesktopConfig", desktopId, request, this.getMediator(request));
            String[] oldIds = desktopConfig.getApplicationSpaceLabels();
            desktopConfig.setApplicationSpaceLabels(ids);
            desktopConfig.save();
            Config.removeConfigurationFromCache(desktopConfig);
            this.deleteUnselectedObjects(request, appName, "InterfaceTextConfig", oldIds, ids, this.getMediator(request));
            configMediator.setConfigurationObject(desktopConfig);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateInterfaceTextConfigurationOnly(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updateInterfaceTextConfigurationOnly";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONArray jsonArray = JSONArray.parse(jsonData);
        ConfigurationObject config = null;
        String[] ids = new String[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            String id;
            JSONObject itData = (JSONObject)jsonArray.get(i);
            ids[i] = id = (String)itData.get("id");
            JSONObject value = (JSONObject)itData.get("_attributes");
            String configName = (String)itData.get("name");
            config = ConfigurationAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
            config.setValues(value);
            config.save();
            Config.removeConfigurationFromCache(config);
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(config);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void deleteUnselectedObjects(HttpServletRequest request, String appName, String configName, String[] oldIds, String[] newIds, BaseMediator mediator) throws Exception {
        if (oldIds != null && oldIds.length > 0) {
            for (String oldId : oldIds) {
                boolean found = false;
                for (String id : newIds) {
                    if (!id.equals(oldId)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                try {
                    ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, oldId, request, mediator);
                    config.delete();
                    Config.removeConfigurationFromCache(config);
                }
                catch (MissingValueException mve) {
                    Logger.logError((Object)this, "Configuration object not found", (ServletRequest)request, (Throwable)mve);
                }
                catch (Exception e) {
                    throw e;
                }
            }
        }
    }

    private void updateListConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updateListConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String configName = request.getParameter("configuration");
        String op = request.getParameter("operator");
        JSONArray jsonArray = JSONArray.parse(request.getParameter("data"));
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject configData = (JSONObject)jsonArray.get(i);
            String id = (String)configData.get("id");
            ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
            ConfigurationObject parentConfig = this.getParentConfiguration(appName, configName, id, request);
            config.delete();
            config.setValues(configData, true);
            config.save();
            Config.removeConfigurationFromCache(config);
            if (parentConfig == null) continue;
            Config.removeConfigurationFromCache(parentConfig);
        }
        String listConfigName = request.getParameter("list_configuration");
        String listId = request.getParameter("listId");
        ConfigurationObject config = ConfigurationAction.getConfiguration(appName, listConfigName, listId, request, this.getMediator(request));
        String listType = request.getParameter("listType");
        Collection configCollection = config.getList(listType, appName, request);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationCollection(configCollection);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void deleteConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "deleteConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(config);
        config.delete();
        Config.removeConfigurationFromCache(config);
        configMediator.addMessage("deleteconfiguration.successful", new Object[0]);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void multipleActions(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String configName;
        String methodName = "multipleActions";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String strJsonFormData = this.readJSON(request);
        if (strJsonFormData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONArray jsonArray = JSONArray.parse(strJsonFormData);
        for (int i = 0; i < jsonArray.size(); ++i) {
            String id;
            int j;
            JSONObject configAction = (JSONObject)jsonArray.get(i);
            String action = (String)configAction.get("action");
            configName = (String)configAction.get("configuration");
            if (action.equals("deleteList")) {
                JSONArray idsArray = (JSONArray)configAction.get("ids");
                for (j = 0; j < idsArray.size(); ++j) {
                    String id2 = (String)idsArray.get(j);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "multiple - deleteList - id=" + id2);
                    ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, id2, request, this.getMediator(request));
                    config.delete();
                    Config.removeConfigurationFromCache(config);
                }
                continue;
            }
            if (action.equals("add")) {
                id = (String)configAction.get("id");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "multiple - add - id=" + id);
                ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
                config.setValues((JSONObject)configAction.get("data"));
                config.save();
                Config.removeConfigurationFromCache(config);
                String updateListId = (String)configAction.get("update_list_id");
                String updateListConfigName = (String)configAction.get("update_list_configuration");
                String updateListType = (String)configAction.get("update_list_type");
                if (updateListId == null || updateListConfigName == null || updateListType == null) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "multiple - add - updateId=" + updateListId + " updateConfigName=" + updateListConfigName + " updateType=" + updateListType);
                ConfigurationObject updateConfig = ConfigurationAction.getConfiguration(appName, updateListConfigName, updateListId, request, this.getMediator(request));
                updateConfig.addValueToList(updateListType, id);
                updateConfig.save();
                Config.removeConfigurationFromCache(updateConfig);
                continue;
            }
            if (action.equals("update")) {
                id = (String)configAction.get("id");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "multiple - update - id=" + id);
                ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
                config.setValues((JSONObject)configAction.get("data"));
                config.save();
                Config.removeConfigurationFromCache(config);
                continue;
            }
            if (!action.equals("addList")) continue;
            JSONArray updateDataArray = (JSONArray)configAction.get("data");
            for (j = 0; j < updateDataArray.size(); ++j) {
                JSONObject configData = (JSONObject)updateDataArray.get(j);
                String id3 = (String)configData.get("id");
                if (id3 == null) {
                    id3 = "" + i;
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "multiple - addList - id=" + id3);
                ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, id3, request, this.getMediator(request));
                config.setValues(configData, true);
                config.save();
                Config.removeConfigurationFromCache(config);
            }
        }
        String listConfigName = request.getParameter("list_configuration");
        String listId = request.getParameter("listId");
        if (listConfigName != null && listId != null) {
            ConfigurationObject config = ConfigurationAction.getConfiguration(appName, listConfigName, listId, request, this.getMediator(request));
            String listType = request.getParameter("listType");
            Collection configCollection = config.getList(listType, appName, request);
            ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
            configMediator.setConfigurationCollection(configCollection);
        } else {
            String id = request.getParameter("id");
            configName = request.getParameter("configuration");
            ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
            ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
            configMediator.setConfigurationObject(config);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void deleteConfigurationList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "deleteConfigurationList";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String configName = request.getParameter("configuration");
        JSONArray ids = JSONArray.parse(request.getParameter("ids"));
        ArrayList<String> listToDelete = new ArrayList<String>();
        ConfigurationObject aconfig = null;
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            ConfigurationObject config = ConfigurationAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
            if (config instanceof RepositoryConfig || config instanceof ViewerConfig || config instanceof MenuConfig) {
                ArrayList<String> desktopNamesUsingTheConfig = new ArrayList<String>();
                Collection<DesktopConfig> desktopCollection = Config.getApplicationConfig(appName).getDesktopList(request);
                if (desktopCollection != null) {
                    block1: for (DesktopConfig desktopConfig : desktopCollection) {
                        String type;
                        String desktopsMenuIdForType;
                        if (config instanceof RepositoryConfig) {
                            String[] reposIds = desktopConfig.getRepositoriesId();
                            if (reposIds == null) continue;
                            for (int j = 0; j < reposIds.length; ++j) {
                                if (!reposIds[j].equals(id)) continue;
                                desktopNamesUsingTheConfig.add(desktopConfig.getName());
                                continue block1;
                            }
                            continue;
                        }
                        if (config instanceof ViewerConfig) {
                            String viewer = desktopConfig.getViewer();
                            if (!viewer.equals(id)) continue;
                            desktopNamesUsingTheConfig.add(desktopConfig.getName());
                            continue;
                        }
                        if (!(config instanceof MenuConfig) || (desktopsMenuIdForType = desktopConfig.getProperty(type = ((MenuConfig)config).getType())) == null || !desktopsMenuIdForType.equals(((MenuConfig)config).getId())) continue;
                        desktopNamesUsingTheConfig.add(desktopConfig.getName());
                    }
                }
                if (desktopNamesUsingTheConfig.size() > 0) {
                    String s = (String)desktopNamesUsingTheConfig.get(0);
                    for (int k = 1; k < desktopNamesUsingTheConfig.size(); ++k) {
                        s = s + ", " + (String)desktopNamesUsingTheConfig.get(k);
                    }
                    this.getMediator(request).addError("error.cannot.delete", config.getName(), s);
                    return;
                }
            }
            aconfig = config;
            listToDelete.add(id);
            config.delete();
            Config.removeConfigurationFromCache(config);
        }
        String deleteListPrefixID = request.getParameter("delete_list_prefix_id");
        if (deleteListPrefixID != null) {
            JSONArray deleteListPrefixIds = JSONArray.parse(deleteListPrefixID);
            String deleteListConfigName = request.getParameter("delete_list_configuration");
            String deleteListType = request.getParameter("delete_list_type");
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "delete list prefix - deleteListPrefixId=" + deleteListPrefixIds + " deleteConfigName=" + deleteListConfigName + " deleteType=" + deleteListType);
            if (deleteListPrefixIds != null && deleteListConfigName != null && deleteListType != null) {
                ApplicationConfig appConfig = Config.getApplicationConfig(appName);
                Configuration propertiesConfig = appConfig.getConfigurationObject();
                block4: for (int i = 0; i < deleteListPrefixIds.size(); ++i) {
                    String prefix = (String)deleteListPrefixIds.get(i);
                    int counter = 0;
                    while (true) {
                        String id = prefix + counter;
                        String key = deleteListType + "." + appConfig.getObjectId() + "." + id;
                        if (!propertiesConfig.containsKey(key)) continue block4;
                        ConfigurationObject config = ConfigurationAction.getConfiguration(appName, deleteListConfigName, id, request, this.getMediator(request));
                        config.delete();
                        Config.removeConfigurationFromCache(config);
                        ++counter;
                    }
                }
            }
        }
        String updateListId = request.getParameter("update_list_id");
        String updateListConfigName = request.getParameter("update_list_configuration");
        String updateListType = request.getParameter("update_list_type");
        String type = request.getParameter("update_app_configuration_type");
        if (type != null) {
            ApplicationConfig appConfig = Config.getApplicationConfig(appName);
            appConfig.removeValuesFromList(type, listToDelete);
            appConfig.save();
            Config.removeConfigurationFromCache(appConfig);
        } else if (updateListId != null && updateListConfigName != null && updateListType != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add - updateId=" + updateListId + " updateConfigName=" + updateListConfigName + " updateType=" + updateListType);
            ConfigurationObject updateConfig = ConfigurationAction.getConfiguration(appName, updateListConfigName, updateListId, request, this.getMediator(request));
            updateConfig.removeValuesFromList(updateListType, listToDelete);
            updateConfig.save();
            Config.removeConfigurationFromCache(updateConfig);
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(aconfig);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateFileTypesMapping(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updateFileTypesMapping";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONObject jsonDataObject = JSONObject.parse(jsonData);
        JSONArray fileTypesMappingDataArray = (JSONArray)jsonDataObject.get("fileTypesMappingData");
        String[] ids = new String[fileTypesMappingDataArray.size()];
        ConfigurationObject config = null;
        ApplicationConfig appConfig = Config.getApplicationConfig(appName);
        for (int i = 0; i < fileTypesMappingDataArray.size(); ++i) {
            JSONObject jsonMappingData = (JSONObject)fileTypesMappingDataArray.get(i);
            String id = (String)jsonMappingData.get("id");
            config = ConfigurationAction.getConfiguration(appName, "FileTypeConfig", id, request, this.getMediator(request));
            ids[i] = id;
            config.setValues((JSONObject)jsonMappingData.get("_attributes"));
            config.save();
            Config.removeConfigurationFromCache(config);
            config = ConfigurationAction.getConfiguration(appName, "InterfaceTextConfig", id, request, this.getMediator(request));
            config.setValues((JSONObject)jsonMappingData.get("_attributes"));
            config.save();
            Config.removeConfigurationFromCache(config);
        }
        SettingsConfig settingsConfig = (SettingsConfig)ConfigurationAction.getConfiguration(appName, "SettingsConfig", "default", request, this.getMediator(request));
        String[] oldIds = settingsConfig.getFileTypes();
        settingsConfig.setFileTypes(ids);
        settingsConfig.save();
        Config.removeConfigurationFromCache(settingsConfig);
        this.deleteUnselectedObjects(request, appName, "FileTypeConfig", oldIds, ids, this.getMediator(request));
        this.deleteUnselectedObjects(request, appName, "InterfaceTextConfig", oldIds, ids, this.getMediator(request));
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(settingsConfig);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updatePropertiesMapping(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updatePropertiesMapping";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String repositoryName = request.getParameter("id");
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONObject jsonDataObject = JSONObject.parse(jsonData);
        JSONArray propertiesMappingDataArray = (JSONArray)jsonDataObject.get("propertiesMappingData");
        String[] ids = new String[propertiesMappingDataArray.size()];
        ConfigurationObject config = null;
        ApplicationConfig appConfig = Config.getApplicationConfig(appName);
        for (int i = 0; i < propertiesMappingDataArray.size(); ++i) {
            JSONObject jsonMappingData = (JSONObject)propertiesMappingDataArray.get(i);
            String id = (String)jsonMappingData.get("id");
            config = ConfigurationAction.getConfiguration(appName, "PropertyMappingConfig", id, request, this.getMediator(request));
            ids[i] = id;
            config.setValues((JSONObject)jsonMappingData.get("_attributes"));
            config.save();
            Config.removeConfigurationFromCache(config);
        }
        RepositoryConfig repositoryConfig = (RepositoryConfig)ConfigurationAction.getConfiguration(appName, "RepositoryConfig", repositoryName, request, this.getMediator(request));
        String[] oldIds = repositoryConfig.getPropertiesMapping();
        repositoryConfig.setPropertiesMapping(ids);
        repositoryConfig.save();
        Config.removeConfigurationFromCache(repositoryConfig);
        this.deleteUnselectedObjects(request, appName, "PropertyMappingConfig", oldIds, ids, this.getMediator(request));
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(repositoryConfig);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateMobileFeatures(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updateMobileFeature";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String desktopId = request.getParameter("id");
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONObject jsonDataObject = JSONObject.parse(jsonData);
        JSONArray featuresArray = (JSONArray)jsonDataObject.get("mobileFeaturesData");
        JSONArray interfaceTextsArray = (JSONArray)jsonDataObject.get("mobileFeaturesInterfaceTextData");
        String[] ids = new String[featuresArray.size()];
        ConfigurationObject config = null;
        ApplicationConfig appConfig = Config.getApplicationConfig(appName);
        for (int i = 0; i < featuresArray.size(); ++i) {
            JSONObject jsonFeatureData = (JSONObject)featuresArray.get(i);
            String id = (String)jsonFeatureData.get("id");
            config = ConfigurationAction.getConfiguration(appName, "MobileFeatureConfig", id, request, this.getMediator(request));
            ids[i] = id;
            config.setValues((JSONObject)jsonFeatureData.get("_attributes"));
            config.save();
            Config.removeConfigurationFromCache(config);
        }
        DesktopConfig desktopConfig = (DesktopConfig)ConfigurationAction.getConfiguration(appName, "DesktopConfig", desktopId, request, this.getMediator(request));
        String[] oldIds = desktopConfig.getMobileFeaturesId();
        desktopConfig.setMobileFeaturesId(ids);
        this.deleteUnselectedObjects(request, appName, "MobileFeatureConfig", oldIds, ids, this.getMediator(request));
        config = null;
        ids = new String[interfaceTextsArray.size()];
        boolean j = false;
        for (int i = 0; i < interfaceTextsArray.size(); ++i) {
            String id;
            JSONObject itData = (JSONObject)interfaceTextsArray.get(i);
            ids[i] = id = (String)itData.get("id");
            JSONObject value = (JSONObject)itData.get("_attributes");
            config = ConfigurationAction.getConfiguration(appName, "InterfaceTextConfig", id, request, this.getMediator(request));
            config.setValues(value);
            config.save();
            Config.removeConfigurationFromCache(config);
        }
        this.deleteUnselectedObjects(request, appName, "InterfaceTextConfig", oldIds, ids, this.getMediator(request));
        desktopConfig.save();
        Config.removeConfigurationFromCache(desktopConfig);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(desktopConfig);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateIconMapping(HttpServletRequest request, HttpServletResponse response) throws IOException, ConfigurationException, MissingValueException {
        ConfigurationObject config;
        String fileName;
        String className;
        int i;
        String appName = request.getParameter("application");
        appName = appName == null || appName.length() == 0 ? "navigator" : appName;
        String jsonData = this.readJSON(request);
        JSONObject jsonDataObject = JSONObject.parse(jsonData);
        JSONArray iconMappingDataArray = (JSONArray)jsonDataObject.get("iconMimeMappingData");
        JSONArray iconStatusDataArray = (JSONArray)jsonDataObject.get("iconStatusData");
        String idPrefix = "default";
        ApplicationConfig appConfig = Config.getApplicationConfig(appName);
        Configuration propertiesConfig = appConfig.getConfigurationObject();
        int counter = 0;
        while (true) {
            String iconId = idPrefix + counter;
            String key = "icon." + appName + "." + iconId;
            if (!propertiesConfig.containsKey(key)) break;
            IconConfig config2 = Config.getIconConfig(appName, iconId);
            config2.delete();
            Config.removeConfigurationFromCache(config2);
            ++counter;
        }
        for (i = 0; i < iconMappingDataArray.size(); ++i) {
            JSONObject jsonMappingData = (JSONObject)iconMappingDataArray.get(i);
            className = (String)jsonMappingData.get("className");
            fileName = (String)jsonMappingData.get("fileName");
            String contentTypes = (String)jsonMappingData.get("contentTypes");
            config = Config.getIconConfig(appName, idPrefix + i);
            ((IconConfig)config).setClassName(className);
            ((IconConfig)config).setFileName(fileName);
            ((IconConfig)config).setContentTypes(contentTypes);
            config.save();
            Config.removeConfigurationFromCache(config);
        }
        for (i = 0; i < iconStatusDataArray.size(); ++i) {
            JSONObject jsonIconStatusData = (JSONObject)iconStatusDataArray.get(i);
            className = (String)jsonIconStatusData.get("className");
            fileName = (String)jsonIconStatusData.get("fileName");
            String id = (String)jsonIconStatusData.get("id");
            config = Config.getIconStatusConfig(appName, id);
            ((IconStatusConfig)config).setClassName(className);
            ((IconStatusConfig)config).setFileName(fileName);
            config.save();
            Config.removeConfigurationFromCache(config);
        }
    }

    private void updateUILabels(HttpServletRequest request, HttpServletResponse response) throws IOException, ConfigurationException, MissingValueException {
        InterfaceTextLocaleConfig config;
        String methodName = "updateUILabels";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        appName = appName == null || appName.length() == 0 ? "navigator" : appName;
        String jsonData = this.readJSON(request);
        JSONArray jsonArray = JSONArray.parse(jsonData);
        ApplicationConfig appConfig = Config.getApplicationConfig(appName);
        Configuration propertiesConfig = appConfig.getConfigurationObject();
        String prefix = "interfaceTextLocale." + appName + ".";
        Iterator keys = propertiesConfig.getKeys();
        while (keys.hasNext()) {
            int lastIndex;
            String key = (String)keys.next();
            if (!key.startsWith(prefix) || (lastIndex = key.lastIndexOf(".")) <= -1) continue;
            String lastId = key.substring(lastIndex + 1);
            config = Config.getInterfaceTextLocaleConfig(appName, lastId);
            config.delete();
            Config.removeConfigurationFromCache(config);
        }
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String id = (String)jsonObject.get("id");
            config = new InterfaceTextLocaleConfig(propertiesConfig, appName, id);
            for (String key : jsonObject.keySet()) {
                if (key.equals("id")) continue;
                String value = (String)jsonObject.get(key);
                config.setProperty(key, value);
            }
            config.save();
            Config.removeConfigurationFromCache(config);
        }
    }

    private String exportConfigurations(HttpServletRequest request, HttpServletResponse response) throws FileNotFoundException {
        String methodName = "exportConfigurations";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String filePath = System.getProperty("user.home") + System.getProperty("file.separator") + request.getParameter("application") + "." + "configuration.properties";
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "configuration export filepath = " + filePath);
        PrintWriter printer = new PrintWriter(filePath);
        AbstractConfiguration config = Config.getConfiguration();
        Iterator keyIterator = config.getKeys();
        String key = null;
        Properties properties = null;
        String name = null;
        String value = null;
        while (keyIterator.hasNext()) {
            key = (String)keyIterator.next();
            properties = config.getProperties(key);
            printer.print(key);
            printer.print(" = ");
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                name = (String)propertyNames.nextElement();
                value = properties.getProperty(name);
                printer.print(name);
                printer.print("=");
                printer.print(value);
                printer.print(";");
            }
            printer.println();
        }
        printer.flush();
        printer.close();
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return filePath;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session;
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        String repositoryName = request.getParameter("repositoryId");
        String action = request.getParameter("action");
        String configName = request.getParameter("configuration");
        String id = request.getParameter("id");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: app name = " + appName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: desktop name = " + desktopName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repository name = " + repositoryName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: action = " + action);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: configuration name = " + configName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: id = " + id);
        if (action == null || action.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "action");
            this.setRequestHasErrors(request, true);
        } else if (configName == null || configName.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "configuration");
            this.setRequestHasErrors(request, true);
        } else if (id == null || id.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "id");
            this.setRequestHasErrors(request, true);
        }
        HttpSession httpSession = session = request != null ? request.getSession() : null;
        if (!(session == null || action.equalsIgnoreCase("get") || action.equalsIgnoreCase("list") || action.equalsIgnoreCase("connectionDesktop"))) {
            try {
                ApplicationConfig appCfg = Config.getApplicationConfig(appName);
                Hashtable connectionList = (Hashtable)session.getAttribute(ContainerLogonAction.CONTAINERS);
                if (connectionList != null && desktopName != null) {
                    Hashtable connections = (Hashtable)connectionList.get(desktopName);
                    boolean validUser = false;
                    if (connections != null) {
                        Enumeration userIds = connections.keys();
                        while (userIds.hasMoreElements()) {
                            String userId = (String)userIds.nextElement();
                            if (!appCfg.checkAdminAccessForUser(userId)) continue;
                            validUser = true;
                            break;
                        }
                        if (!validUser) {
                            baseMediator.addError("error.bad.userid.password");
                            this.setRequestHasErrors(request, true);
                        }
                    }
                }
            }
            catch (Exception e) {
                baseMediator.addError("desktop.configError", e);
                this.setRequestHasErrors(request, true);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    static {
        configMethodMap.put("ApplicationConfig", new ConfigMethod("ApplicationConfig"));
        configMethodMap.put("SettingsConfig", new ConfigMethod("SettingsConfig"));
        configMethodMap.put("PluginConfig", new ConfigMethod("PluginConfig"));
        configMethodMap.put("DesktopConfig", new ConfigMethod("DesktopConfig"));
        configMethodMap.put("ServerConfig", new ConfigMethod("ServerConfig"));
        configMethodMap.put("RepositoryConfig", new ConfigMethod("RepositoryConfig"));
        configMethodMap.put("ViewerConfig", new ConfigMethod("ViewerConfig"));
        configMethodMap.put("ViewerDefConfig", new ConfigMethod("ViewerDefConfig"));
        configMethodMap.put("ViewerMappingConfig", new ConfigMethod("ViewerMappingConfig"));
        configMethodMap.put("IconConfig", new ConfigMethod("IconConfig"));
        configMethodMap.put("IconStatusConfig", new ConfigMethod("IconStatusConfig"));
        configMethodMap.put("MenuConfig", new ConfigMethod("MenuConfig"));
        configMethodMap.put("MenuTypeConfig", new ConfigMethod("MenuTypeConfig"));
        configMethodMap.put("AdminConfig", new ConfigMethod("AdminConfig"));
        configMethodMap.put("InterfaceTextConfig", new ConfigMethod("InterfaceTextConfig"));
        configMethodMap.put("InterfaceTextLocaleConfig", new ConfigMethod("InterfaceTextLocaleConfig"));
        configMethodMap.put("FileTypeConfig", new ConfigMethod("FileTypeConfig"));
        configMethodMap.put("PropertyMappingConfig", new ConfigMethod("PropertyMappingConfig"));
        configMethodMap.put("MobileFeatureConfig", new ConfigMethod("MobileFeatureConfig"));
    }

    static class ConfigMethod {
        String className;
        Class<?> configClass;
        Method method;

        public ConfigMethod(String className) {
            this.className = className;
        }

        public synchronized ConfigurationObject getConfig(HttpServletRequest request, String idPrefix, String id) throws Exception {
            try {
                if (this.method == null) {
                    this.configClass = Class.forName("com.ibm.ecm.configuration.Config");
                    this.method = this.className.equals("ApplicationConfig") ? this.configClass.getMethod("get" + this.className, String.class) : (this.className.equals("MenuConfig") ? this.configClass.getMethod("get" + this.className, String.class, String.class, Class.forName("[Z")) : this.configClass.getMethod("get" + this.className, String.class, String.class));
                }
                if (this.className.equals("ApplicationConfig")) {
                    return (ConfigurationObject)this.method.invoke(null, id);
                }
                if (this.className.equals("MenuConfig")) {
                    return (ConfigurationObject)this.method.invoke(null, idPrefix, id, null);
                }
                return (ConfigurationObject)this.method.invoke(null, idPrefix, id);
            }
            catch (Exception e) {
                this.method = null;
                Logger.logError(Config.class, "getConfig method failed", (ServletRequest)request, (Throwable)e);
                ConfigurationException ce = new ConfigurationException((Throwable)e);
                throw ce;
            }
        }
    }
}

