/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.ConfigurationObject;
import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.configuration.InterfaceTextConfig;
import com.ibm.ecm.configuration.RecentSearchConfig;
import com.ibm.ecm.configuration.UserConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.ConfigurationMediator;
import com.ibm.ecm.serviceability.AdminLogger;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class UserAction
extends BaseAction {
    private static Map<String, ConfigMethod> configMethodMap = new LinkedHashMap<String, ConfigMethod>();

    protected BaseMediator createMediator(HttpServletRequest request) {
        String methodName = "createMediator";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationMediator configurationMediator = new ConfigurationMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)configurationMediator);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return configurationMediator;
    }

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        request.setCharacterEncoding("UTF-8");
        HttpSession session = request.getSession(false);
        AdminLogger.enableTimestamps = session != null ? session.getServletContext().getServerInfo().toUpperCase().indexOf("WEBSPHERE") == -1 : false;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        String action = request.getParameter("action");
        try {
            if (action.equals("add")) {
                this.addConfiguration(request, response);
            } else if (action.equals("get")) {
                this.getConfiguration(request, response);
            } else if (action.equals("list")) {
                this.getConfigurationList(request, response);
            } else if (action.equals("update")) {
                this.updateConfiguration(request, response);
            } else if (action.equals("updateList")) {
                this.updateListConfiguration(request, response);
                configMediator.addMessage("changeconfiguration.successful", new Object[0]);
            } else if (action.equals("delete")) {
                this.deleteConfiguration(request, response);
            } else if (action.equals("deleteList")) {
                this.deleteConfigurationList(request, response);
                configMediator.addMessage("deleteconfiguration.successful", new Object[0]);
            } else {
                Logger.logError((Object)this, "executeBaseAction", (ServletRequest)request, "Invalid action type: " + action);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            String operator = request.getParameter("operator");
            if (operator != null && operator.equalsIgnoreCase("unique") && action.equals("get")) {
                configMediator.addError("error.exception.favoriteAlreadyExist");
            } else {
                configMediator.addError("desktop.configError");
            }
            this.setRequestHasErrors(request, true);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private ConfigurationObject getConfiguration(HttpServletRequest request) throws Exception {
        String methodName = "getConfiguration2";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String configName = request.getParameter("configuration");
        String id = request.getParameter("id");
        ConfigurationMediator mediator = (ConfigurationMediator)this.getMediator(request);
        return UserAction.getConfiguration(appName, configName, id, request, mediator);
    }

    private static ConfigurationObject getConfiguration(String appName, String configName, String id, HttpServletRequest request, BaseMediator mediator) throws Exception {
        String methodName = "getConfiguration3";
        Logger.logEntry(ConfigurationObject.class, methodName, (ServletRequest)request);
        ConfigurationObject config = null;
        try {
            ConfigMethod configMethod = configMethodMap.get(configName);
            if (configMethod != null) {
                config = configMethod.getConfig(request, appName, id);
            } else {
                Logger.logError(ConfigurationObject.class, methodName, (ServletRequest)request, "Invalid configuration type: " + configName);
            }
        }
        catch (Exception e) {
            ConfigurationMediator configMediator = (ConfigurationMediator)mediator;
            configMediator.addError("desktop.configError");
            Logger.logError(ConfigurationObject.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit(ConfigurationObject.class, methodName, (ServletRequest)request);
        return config;
    }

    private ConfigurationObject getParentConfiguration(String appName, String configName, String id, HttpServletRequest request) throws Exception {
        String methodName = "getParentConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        InterfaceTextConfig config = null;
        try {
            if (configName.equals("InterfaceTextLocaleConfig")) {
                config = Config.getInterfaceTextConfig(appName, id);
            }
        }
        catch (Exception e) {
            ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
            configMediator.addError("desktop.configError");
            Logger.logError((Object)this, "getConfiguration", (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return config;
    }

    private void getConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "getConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        String operator = request.getParameter("operator");
        if (operator != null && operator.equalsIgnoreCase("unique") && !config.isEmpty()) {
            throw new Exception(this.getResources(request).getMessage(request.getLocale(), "error.exception.favoriteAlreadyExist"));
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(config);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void getConfigurationList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "getConfigurationList";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        String listType = request.getParameter("type");
        String sorted = request.getParameter("sorted");
        String appName = request.getParameter("application");
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        Collection configCollection = config.getList(listType, appName, request);
        if (sorted != null && sorted.equalsIgnoreCase("true") && configCollection != null) {
            ArrayList list = new ArrayList();
            list.addAll(configCollection);
            Collections.sort(list, new Comparator<ConfigurationObject>(){

                @Override
                public int compare(ConfigurationObject item1, ConfigurationObject item2) {
                    if (item1 != null && item2 != null && item1.getName() != null && item2.getName() != null) {
                        return item1.getName().compareTo(item2.getName());
                    }
                    return 0;
                }
            });
            configMediator.setConfigurationList(list);
        } else {
            configMediator.setConfigurationCollection(configCollection);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void addConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String oType;
        ConfigurationObject tempConfig;
        UserConfig userConfig;
        String methodName = "addConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String id = request.getParameter("id");
        String appName = request.getParameter("application");
        String updateListId = request.getParameter("update_list_id");
        String updateListConfigName = request.getParameter("update_list_configuration");
        String updateListType = request.getParameter("update_list_type");
        ConfigurationObject config = this.getConfiguration(request);
        if (config.getObjectType().equalsIgnoreCase("favorite") && (userConfig = (UserConfig)(tempConfig = UserAction.getConfiguration(appName, updateListConfigName, updateListId, request, this.getMediator(request)))).isFavorteMax()) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.exception.exceedMaxFavoritesAllowed", 100);
            this.setRequestHasErrors(request, true);
            return;
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONObject jsonObject = JSONObject.parse(jsonData);
        config.setValues(jsonObject);
        configMediator.setConfigurationObject(config);
        config.save();
        Config.removeConfigurationFromCache(config);
        if (updateListId != null && updateListConfigName != null && updateListType != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add - updateId=" + updateListId + " updateConfigName=" + updateListConfigName + " updateType=" + updateListType);
            UserConfig updateConfig = (UserConfig)UserAction.getConfiguration(appName, updateListConfigName, updateListId, request, this.getMediator(request));
            if (config.getObjectType().equalsIgnoreCase("recentSearch")) {
                updateConfig.addRecentSearch((RecentSearchConfig)config);
                configMediator.setConfigurationCollection(updateConfig.getList(updateListType, appName, request));
            } else {
                updateConfig.addValueToList(updateListType, id);
            }
            updateConfig.save();
            Config.removeConfigurationFromCache(updateConfig);
        }
        if (config.getObjectType().equals("favorite")) {
            String repositoryLabel = BaseUtil.getCustomLabelValue(request, "app_repository");
            if (repositoryLabel == null || repositoryLabel.length() == 0) {
                repositoryLabel = this.getResources().getMessage(request.getLocale(), "repository");
            }
            ((FavoriteConfig)config).setRepositoryLabel(repositoryLabel);
        }
        if ("favorite".equals(oType = config.getObjectType())) {
            configMediator.addMessage("addToFavorites.success", ((FavoriteConfig)config).getAlias());
        } else {
            configMediator.addMessage("addconfiguration.successful", new Object[0]);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean isFavoriteUpdate;
        String methodName = "updateConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        String oType = config.getObjectType();
        String oldName = "";
        if ("favorite".equals(oType)) {
            oldName = ((FavoriteConfig)config).getAlias();
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        String jsonData = this.readJSON(request);
        if (jsonData == null) {
            BaseMediator baseMediator = this.getMediator(request);
            baseMediator.addError("error.parm.null", "json_post");
            this.setRequestHasErrors(request, true);
            return;
        }
        JSONObject jsonObject = JSONObject.parse(jsonData);
        config.setValues(jsonObject);
        configMediator.setConfigurationObject(config);
        config.save();
        Config.removeConfigurationFromCache(config);
        boolean bl = isFavoriteUpdate = config instanceof UserConfig && jsonObject.containsKey("favorites");
        if ("favorite".equals(oType)) {
            configMediator.addMessage("renameFavorite.success", oldName, ((FavoriteConfig)config).getAlias());
        } else if (!isFavoriteUpdate) {
            configMediator.addMessage("changeconfiguration.successful", new Object[0]);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void updateListConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "updateListConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String configName = request.getParameter("configuration");
        String op = request.getParameter("operator");
        JSONArray jsonArray = JSONArray.parse(request.getParameter("data"));
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject configData = (JSONObject)jsonArray.get(i);
            String id = (String)configData.get("id");
            ConfigurationObject config = UserAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
            ConfigurationObject parentConfig = this.getParentConfiguration(appName, configName, id, request);
            config.delete();
            config.setValues(configData, true);
            config.save();
            Config.removeConfigurationFromCache(config);
            if (parentConfig == null) continue;
            Config.removeConfigurationFromCache(parentConfig);
        }
        String listConfigName = request.getParameter("list_configuration");
        String listId = request.getParameter("listId");
        ConfigurationObject config = UserAction.getConfiguration(appName, listConfigName, listId, request, this.getMediator(request));
        String listType = request.getParameter("listType");
        Collection configCollection = config.getList(listType, appName, request);
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationCollection(configCollection);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void deleteConfiguration(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "deleteConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ConfigurationObject config = this.getConfiguration(request);
        String oType = config.getObjectType();
        String name = "";
        if ("favorite".equals(oType)) {
            name = ((FavoriteConfig)config).getAlias();
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(config);
        config.delete();
        Config.removeConfigurationFromCache(config);
        if ("favorite".equals(oType)) {
            configMediator.addMessage("deleteFavorite.success", name);
        } else {
            configMediator.addMessage("deleteconfiguration.successful", new Object[0]);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    private void deleteConfigurationList(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "deleteConfigurationList";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String configName = request.getParameter("configuration");
        JSONArray ids = JSONArray.parse(request.getParameter("ids"));
        ArrayList<String> listToDelete = new ArrayList<String>();
        ConfigurationObject aconfig = null;
        for (int i = 0; i < ids.size(); ++i) {
            ConfigurationObject config;
            String id = (String)ids.get(i);
            aconfig = config = UserAction.getConfiguration(appName, configName, id, request, this.getMediator(request));
            listToDelete.add(id);
            config.delete();
            Config.removeConfigurationFromCache(config);
        }
        ConfigurationMediator configMediator = (ConfigurationMediator)this.getMediator(request);
        configMediator.setConfigurationObject(aconfig);
        String updateListId = request.getParameter("update_list_id");
        String updateListConfigName = request.getParameter("update_list_configuration");
        String updateListType = request.getParameter("update_list_type");
        String type = request.getParameter("update_app_configuration_type");
        if (type != null) {
            ApplicationConfig appConfig = Config.getApplicationConfig(appName);
            appConfig.removeValuesFromList(type, listToDelete);
            appConfig.save();
            Config.removeConfigurationFromCache(appConfig);
        } else if (updateListId != null && updateListConfigName != null && updateListType != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "add - updateId=" + updateListId + " updateConfigName=" + updateListConfigName + " updateType=" + updateListType);
            ConfigurationObject updateConfig = UserAction.getConfiguration(appName, updateListConfigName, updateListId, request, this.getMediator(request));
            updateConfig.removeValuesFromList(updateListType, listToDelete);
            updateConfig.save();
            Config.removeConfigurationFromCache(updateConfig);
            configMediator.setConfigurationCollection(updateConfig.getList(updateListType, appName, request));
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator baseMediator = this.getMediator(request);
        String appName = request.getParameter("application");
        String repositoryName = request.getParameter("repositoryId");
        String action = request.getParameter("action");
        String configName = request.getParameter("configuration");
        String id = request.getParameter("id");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: app name = " + appName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repository name = " + repositoryName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: action = " + action);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: configuration name = " + configName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: id = " + id);
        if (action == null || action.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "action");
            this.setRequestHasErrors(request, true);
        } else if (configName == null || configName.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "configuration");
            this.setRequestHasErrors(request, true);
        } else if (id == null || id.trim().length() == 0) {
            baseMediator.addError("error.parm.null", "id");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    static {
        configMethodMap.put("ApplicationConfig", new ConfigMethod("ApplicationConfig"));
        configMethodMap.put("DesktopConfig", new ConfigMethod("DesktopConfig"));
        configMethodMap.put("RepositoryConfig", new ConfigMethod("RepositoryConfig"));
        configMethodMap.put("UserConfig", new ConfigMethod("UserConfig"));
        configMethodMap.put("FavoriteConfig", new ConfigMethod("FavoriteConfig"));
        configMethodMap.put("RecentSearchConfig", new ConfigMethod("RecentSearchConfig"));
    }

    static class ConfigMethod {
        String className;
        Class configClass;
        Method method;

        public ConfigMethod(String className) {
            this.className = className;
        }

        public synchronized ConfigurationObject getConfig(HttpServletRequest request, String idPrefix, String id) throws Exception {
            try {
                if (this.method == null) {
                    this.configClass = Class.forName("com.ibm.ecm.configuration.Config");
                    this.method = this.className.equals("ApplicationConfig") ? this.configClass.getMethod("get" + this.className, String.class) : this.configClass.getMethod("get" + this.className, String.class, String.class);
                }
                if (this.className.equals("ApplicationConfig")) {
                    return (ConfigurationObject)this.method.invoke(null, id);
                }
                if (this.className.equals("UserConfig")) {
                    return (ConfigurationObject)this.method.invoke(null, idPrefix, id.toLowerCase(request.getLocale()));
                }
                return (ConfigurationObject)this.method.invoke(null, idPrefix, id);
            }
            catch (Exception e) {
                this.method = null;
                Logger.logError(Config.class, "getConfig method failed", (ServletRequest)request, (Throwable)e);
                ConfigurationException ce = new ConfigurationException((Throwable)e);
                throw ce;
            }
        }
    }
}

