/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.filenet.api.util.UserContext;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.struts.actions.p8.P8LogonAction;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Enumeration;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TAMSSOLogon {
    private static String webSealIdentityHeaderIVUser = "iv-user";

    public static boolean doLogin(HttpServletRequest request, HttpServletResponse response, LogonMediator logonMediator, DesktopConfig desktopConfig) {
        String methodName = "doLogin";
        String user = request.getHeader(webSealIdentityHeaderIVUser);
        boolean success = false;
        if (user != null) {
            UserContext uc = new UserContext();
            UserContext.set((UserContext)uc);
            Subject subject = null;
            try {
                Method getAmbientSubject = UserContext.class.getDeclaredMethod("getAmbientSubject", new Class[0]);
                subject = (Subject)getAmbientSubject.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                subject = Subject.getSubject(AccessController.getContext());
            }
            Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "  Current user= " + user + " Current SUBJECT =" + subject);
            if (subject != null) {
                Logger.logInfo(TAMSSOLogon.class, methodName, (ServletRequest)request, "TAM/WebSEAL authenticated user " + user + " and a valid subject found. So Propogating the TAM authentication.");
                HttpSession session = request.getSession(true);
                if (session != null) {
                    session.setAttribute("session_userid", (Object)user);
                }
                success = true;
                try {
                    String defaultRepositoryId = desktopConfig.getDefaultRepositoryId();
                    try {
                        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "before ContainerLogonActiion doContainerLogin");
                        new ContainerLogonAction().doContainerLogin(request, user, logonMediator, subject, null);
                    }
                    catch (Throwable t) {
                        Logger.logError(TAMSSOLogon.class, methodName, (ServletRequest)request, t.getMessage());
                    }
                    RepositoryConfig defaultRepository = null;
                    if (defaultRepositoryId != null) {
                        defaultRepository = desktopConfig.getRepository(defaultRepositoryId);
                    }
                    if (defaultRepository != null && defaultRepository.getType().equals("p8")) {
                        P8LogonAction.createP8Connection(request, response, logonMediator, user, ContainerLogonAction.NEXUS_STANZA, defaultRepository, subject);
                    } else {
                        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "TAM/WebSEAL authenticated user=" + user + ". Default Repository might not be P8 :  " + defaultRepositoryId + " for desktop: " + desktopConfig.getName());
                    }
                }
                catch (Exception e) {
                    Logger.logError(TAMSSOLogon.class, methodName, (ServletRequest)request, e.getMessage());
                }
                Logger.logInfo(TAMSSOLogon.class, methodName, (ServletRequest)request, " TAM authentication,  Session never expires.");
                session.setMaxInactiveInterval(-1);
            } else {
                Logger.logInfo(TAMSSOLogon.class, methodName, (ServletRequest)request, "TAM/WebSEAL authenticated user " + user + ". But Valid subject is not found. Please check the configuration of application");
            }
        }
        logonMediator.setTamKerberosTokenPresent(success);
        return success;
    }

    public static void dumpRequest(HttpServletRequest request) {
        String methodName = "dumpRequest";
        Enumeration headerNames = request.getHeaderNames();
        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "headers====");
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, headerName + "-->");
            Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, request.getHeader(headerName));
        }
        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "headers====\n");
        Enumeration attrNames = request.getAttributeNames();
        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "Attributes====");
        while (attrNames.hasMoreElements()) {
            String headerName = (String)attrNames.nextElement();
            Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, headerName + "-->");
            Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, (String)request.getAttribute(headerName));
        }
        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "Attributes====\n");
        Enumeration paramNames = request.getParameterNames();
        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "Parameters====");
        while (paramNames.hasMoreElements()) {
            String headerName = (String)paramNames.nextElement();
            Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, headerName + "-->");
            Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, request.getParameter(headerName));
        }
        Logger.logDebug(TAMSSOLogon.class, methodName, (ServletRequest)request, "Parameters====\n");
    }
}

