/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.util.UserContext;
import com.ibm.ecm.Constants;
import com.ibm.ecm.beans.cm.CMConnection;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.ODSSOLogonAction;
import com.ibm.ecm.struts.actions.cm.CMLogonAction;
import com.ibm.ecm.struts.actions.p8.P8LogonAction;
import com.ibm.ecm.util.p8.P8Connection;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;

public abstract class SSOLogonAction
extends Action
implements Constants {
    public static void doSSOLogonForOD(HttpServletRequest request, HttpServletResponse response, LogonMediator logonMediator) throws Exception {
        String methodName = "doSSOLogonForOD";
        String loginRepoId = request.getParameter("repositoryId");
        ArrayList<RepositoryConfig> odSSORepositoryList = new ArrayList<RepositoryConfig>();
        DesktopConfig desktopConfig = Config.getDesktopConfig(request);
        Map<String, RepositoryConfig> map = desktopConfig.getRepositoryMap();
        for (Map.Entry<String, RepositoryConfig> pairs : map.entrySet()) {
            String useSSO;
            RepositoryConfig ssoRepoConfig;
            String repoId = pairs.getKey();
            if (loginRepoId == null || loginRepoId.equals(repoId) || (ssoRepoConfig = pairs.getValue()) == null || !ssoRepoConfig.getType().equals("od") || (useSSO = ssoRepoConfig.getUseSSO()) == null || !useSSO.equalsIgnoreCase("TRUE")) continue;
            String ssoPasswd = ssoRepoConfig.getSSOPassword();
            if (useSSO == null || !useSSO.equalsIgnoreCase("TRUE") || ssoPasswd == null) continue;
            odSSORepositoryList.add(ssoRepoConfig);
            Logger.logInfo(SSOLogonAction.class, methodName, (ServletRequest)request, "==> The OD server is configured for SSO '" + ssoRepoConfig.getServerName() + " RepositoryId=" + ssoRepoConfig.getObjectId());
        }
        if (odSSORepositoryList == null || odSSORepositoryList.isEmpty()) {
            return;
        }
        ODSSOLogonAction.doSSOLogonForOD(request, response, logonMediator);
    }

    public static void doSSOLogonForCM8(HttpServletRequest request, LogonMediator logonMediator) throws Exception {
        String userid = request.getParameter("userid");
        SSOLogonAction.doSSOLogonForCM8(request, logonMediator, userid);
    }

    public static void doSSOLogonForCM8(HttpServletRequest request, LogonMediator logonMediator, String userid) throws Exception {
        String methodName = "doSSOLogonForCM8";
        Logger.logEntry(SSOLogonAction.class, methodName, (ServletRequest)request);
        String desktopName = request.getParameter("desktop");
        Logger.logInfo(SSOLogonAction.class, methodName, (ServletRequest)request, "userid = " + userid);
        String password = request.getParameter("password");
        String loginRepoId = request.getParameter("repositoryId");
        Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "loginRepoId = " + loginRepoId);
        try {
            ArrayList<RepositoryConfig> cm8SSORepositoryList = new ArrayList<RepositoryConfig>();
            DesktopConfig desktopConfig = Config.getDesktopConfig(request);
            Map<String, RepositoryConfig> map = desktopConfig.getRepositoryMap();
            for (Map.Entry<String, RepositoryConfig> pairs : map.entrySet()) {
                String useSSO;
                String repoId = pairs.getKey();
                RepositoryConfig ssoRepoConfig = pairs.getValue();
                if (ssoRepoConfig == null) continue;
                if (repoId != null && repoId.equals(loginRepoId)) {
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "The CM8 server  for logging in '" + ssoRepoConfig.getServerName() + " repoId " + repoId);
                    continue;
                }
                if (!ssoRepoConfig.getType().equals("cm") || (useSSO = ssoRepoConfig.getUseSSO()) == null || !useSSO.equalsIgnoreCase("TRUE")) continue;
                cm8SSORepositoryList.add(ssoRepoConfig);
                Logger.logInfo(SSOLogonAction.class, methodName, (ServletRequest)request, "==> The CM8 server is configured for SSO '" + ssoRepoConfig.getServerName() + " RepositoryId=" + ssoRepoConfig.getObjectId() + "  userId=" + userid);
            }
            if (cm8SSORepositoryList == null || cm8SSORepositoryList.isEmpty()) {
                return;
            }
            for (int i = 0; i < cm8SSORepositoryList.size(); ++i) {
                RepositoryConfig ssoRepo = (RepositoryConfig)cm8SSORepositoryList.get(i);
                DKDatastoreICM datastore = new DKDatastoreICM();
                CMConnection connection = new CMConnection(datastore, userid, datastore.languageCode());
                CMLogonAction.storeNewConnection(request, connection, ssoRepo.getObjectId());
            }
        }
        catch (Exception e) {
            Logger.logError(SSOLogonAction.class, methodName, (ServletRequest)request, (Throwable)e);
        }
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("cm_servers");
        logonMediator.setCM8ConnectionList(connectionList);
    }

    public static void doSSOLogonForP8(HttpServletRequest request, LogonMediator logonMediator) throws Exception {
        String methodName = "doSSOLogonForP8";
        String desktopName = request.getParameter("desktop");
        String userid = request.getParameter("userid");
        String password = request.getParameter("password");
        String protocol = request.getParameter("protocol");
        String loginRepoId = request.getParameter("repositoryId");
        Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "loginRepoId = " + loginRepoId);
        try {
            ArrayList<RepositoryConfig> p8SSORepositoryList = new ArrayList<RepositoryConfig>();
            DesktopConfig desktopConfig = Config.getDesktopConfig(request);
            Map<String, RepositoryConfig> map = desktopConfig.getRepositoryMap();
            for (Map.Entry<String, RepositoryConfig> pairs : map.entrySet()) {
                String useSSO;
                String repoId = pairs.getKey();
                RepositoryConfig ssoRepoConfig = pairs.getValue();
                if (ssoRepoConfig == null) continue;
                if (repoId != null && repoId.equals(loginRepoId)) {
                    Logger.logDebug(CMLogonAction.class, methodName, (ServletRequest)request, "The P8 server  for logging in '" + ssoRepoConfig.getServerName() + " repoId " + repoId);
                    continue;
                }
                if (!ssoRepoConfig.getType().equals("p8") || (useSSO = ssoRepoConfig.getUseSSO()) == null || !useSSO.equalsIgnoreCase("TRUE") || !P8LogonAction.getConnectionType(ssoRepoConfig.getServerName()).equals(P8LogonAction.EJB_CONNECTION_TYPE)) continue;
                p8SSORepositoryList.add(ssoRepoConfig);
                Logger.logInfo(SSOLogonAction.class, methodName, (ServletRequest)request, "==> The P8 server configured is for SSO '" + ssoRepoConfig.getServerName() + " RepositoryId=" + ssoRepoConfig.getObjectId());
            }
            if (p8SSORepositoryList == null || p8SSORepositoryList.isEmpty()) {
                return;
            }
            UserContext uc = null;
            Subject subject = null;
            for (int i = 0; i < p8SSORepositoryList.size(); ++i) {
                RepositoryConfig ssoRepo = (RepositoryConfig)p8SSORepositoryList.get(i);
                Connection ssoCEConnection = Factory.Connection.getConnection((String)ssoRepo.getServerName());
                String osName = ssoRepo.getObjectStore();
                protocol = ssoRepo.getProtocol();
                if (protocol == null || protocol.trim().equals("")) {
                    protocol = "ClientContainer";
                }
                String domName = null;
                if (i == 0) {
                    uc = UserContext.get();
                    subject = UserContext.createSubject((Connection)ssoCEConnection, (String)userid, (String)password, (String)protocol);
                    uc.pushSubject(subject);
                }
                P8Connection ssoConnection = new P8Connection(userid, null, null, uc, ssoCEConnection, subject, domName, osName, null, null);
                Logger.logDebug(SSOLogonAction.class, methodName, (ServletRequest)request, "ssoConnection" + ssoConnection + "ssoRepo.getObjectId()=" + ssoRepo.getObjectId());
                P8LogonAction.storeNewConnection(request, ssoConnection, ssoRepo.getObjectId());
            }
            Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("p8_servers");
            logonMediator.setP8ConnectionList(connectionList);
        }
        catch (Exception e) {
            Logger.logError(SSOLogonAction.class, methodName, (ServletRequest)request, (Throwable)e);
        }
    }
}

