/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.util.PluginUtil;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class PluginAction
extends BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    protected BaseMediator createMediator(HttpServletRequest request) {
        return null;
    }

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String pluginId = request.getParameter("plugin");
        Plugin plugin = PluginUtil.getPlugin(request, pluginId);
        if (plugin == null) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, "Invalid plugin id: " + pluginId + ".  This is likely a logic error in the plugin itself.");
        } else {
            String actionId = request.getParameter("action");
            if ("getResource".equals(actionId)) {
                String resourceId = request.getParameter("resource");
                if (resourceId != null) {
                    String packageName = plugin.getClass().getPackage().getName();
                    if (packageName != null) {
                        while (packageName.indexOf(46) >= 0) {
                            int i = packageName.indexOf(46);
                            packageName = packageName.substring(0, i) + "/" + packageName.substring(i + 1);
                        }
                        resourceId = packageName + "/WebContent/" + resourceId;
                    }
                    resourceId = "/" + resourceId;
                    URL resourceURL = plugin.getClass().getResource(resourceId);
                    URLConnection resourceConnection = resourceURL.openConnection();
                    resourceConnection.setUseCaches(false);
                    InputStream resourceStream = resourceConnection.getInputStream();
                    if (resourceStream == null) {
                        Logger.logError((Object)this, methodName, (ServletRequest)request, "Missing resource " + resourceId + ".  This is likely a logic error in the plugin.");
                    } else {
                        if (resourceId.toLowerCase().endsWith("html")) {
                            response.setContentType("text/html");
                        } else if (resourceId.toLowerCase().endsWith(".xml")) {
                            response.setContentType("text/xml");
                        } else if (resourceId.toLowerCase().endsWith(".css")) {
                            response.setContentType("text/css");
                        } else if (resourceId.toLowerCase().endsWith(".js")) {
                            response.setContentType("text/javascript");
                        } else if (resourceId.toLowerCase().endsWith(".json")) {
                            response.setContentType("text/json");
                        } else if (resourceId.toLowerCase().endsWith(".gif")) {
                            response.setContentType("image/gif");
                        } else if (resourceId.toLowerCase().endsWith(".jpg") || resourceId.toLowerCase().endsWith(".jpeg")) {
                            response.setContentType("image/jpeg");
                        } else if (resourceId.toLowerCase().endsWith(".png")) {
                            response.setContentType("image/png");
                        }
                        ServletOutputStream responseStream = response.getOutputStream();
                        byte[] buf = new byte[4096];
                        int len = resourceStream.read(buf);
                        while (len > 0) {
                            responseStream.write(buf, 0, len);
                            len = resourceStream.read(buf);
                        }
                        resourceStream.close();
                    }
                }
            } else {
                if (form instanceof FileUploadActionForm) {
                    request.setAttribute(FileUploadActionForm.class.getName(), (Object)form);
                }
                PluginUtil.invokeService(plugin, actionId, request, response);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    public boolean isSecureServiceEnabled(HttpServletRequest request) {
        String methodName = "isSecureService";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        boolean isSecureService = super.isSecureServiceEnabled(request);
        if (isSecureService) {
            String pluginId = request.getParameter("plugin");
            try {
                String actionId;
                Plugin plugin = PluginUtil.getPlugin(request, pluginId);
                if (plugin != null && (actionId = request.getParameter("action")) != null) {
                    isSecureService = PluginUtil.isSecureService(plugin, actionId, request);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Secure service enabled on plugin: pluginId = " + pluginId + ", " + Boolean.toString(isSecureService));
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, "Invalid plugin id: " + pluginId + ".  This is likely a logic error in the plugin itself.");
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return isSecureService;
    }
}

