/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.od.ODBaseAction;
import com.ibm.ecm.struts.actions.od.ODLogonAction;
import com.ibm.ecm.util.Util;
import com.ibm.ecm.util.od.ODServerConnection;
import com.ibm.edms.od.ODConfig;
import com.ibm.edms.od.ODException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ODSSOLogonAction {
    public static String getODWEKVersion() {
        String returnVersion = "7.1.2.9";
        try {
            Field[] fields = Class.forName("com.ibm.edms.od.ODVersion").getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!"version".equals(fields[i].getName())) continue;
                returnVersion = (String)fields[i].get(fields[i].getName());
            }
        }
        catch (IllegalAccessException e) {
            returnVersion = "7.1.2.9";
        }
        catch (SecurityException e) {
            returnVersion = "7.1.2.9";
        }
        catch (ClassNotFoundException e) {
            returnVersion = "7.1.2.9";
        }
        return returnVersion;
    }

    public static void doSSOLogonForOD(HttpServletRequest request, HttpServletResponse response, LogonMediator logonMediator) throws Exception {
        block10: {
            String methodName = "doSSOLogonForOD";
            Logger.logEntry(ODSSOLogonAction.class, methodName, (ServletRequest)request);
            HttpSession session = null;
            String userid = Util.xSSEncode(request.getParameter("userid"));
            String loginRepoId = request.getParameter("repositoryId");
            session = request.getSession(true);
            if (session != null && userid != null) {
                session.setAttribute("session_userid", (Object)userid);
            }
            ArrayList<RepositoryConfig> odSSORepositoryList = new ArrayList<RepositoryConfig>();
            DesktopConfig desktopConfig = Config.getDesktopConfig(request);
            Map<String, RepositoryConfig> map = desktopConfig.getRepositoryMap();
            for (Map.Entry<String, RepositoryConfig> pairs : map.entrySet()) {
                RepositoryConfig ssoRepoConfig;
                String repoId = pairs.getKey();
                if (loginRepoId == null || loginRepoId.equals(repoId) || (ssoRepoConfig = pairs.getValue()) == null || !ssoRepoConfig.getType().equals("od")) continue;
                String useSSO = ssoRepoConfig.getUseSSO();
                String ssoPasswd = ssoRepoConfig.getSSOPassword();
                if (useSSO == null || !useSSO.equalsIgnoreCase("TRUE") || ssoPasswd == null) continue;
                odSSORepositoryList.add(ssoRepoConfig);
                Logger.logInfo(ODSSOLogonAction.class, methodName, (ServletRequest)request, "==> The OD server is configured for SSO '" + ssoRepoConfig.getServerName() + " RepositoryId=" + ssoRepoConfig.getObjectId());
            }
            if (odSSORepositoryList == null || odSSORepositoryList.isEmpty()) {
                return;
            }
            ODConfig odConfig = null;
            ODServerConnection server = null;
            try {
                for (int i = 0; i < odSSORepositoryList.size(); ++i) {
                    RepositoryConfig ssoRepo = (RepositoryConfig)odSSORepositoryList.get(i);
                    int iServerPort = 0;
                    String repositoryId = ssoRepo.getObjectId();
                    iServerPort = Integer.parseInt(ssoRepo.getPortNumber());
                    Logger.logInfo(ODSSOLogonAction.class, methodName, (ServletRequest)request, "==> The port for (SSO) server '" + ssoRepo.getServerName() + "' is " + iServerPort + "  for " + repositoryId);
                    odConfig = ssoRepo.getODConfig(request);
                    server = new ODServerConnection(odConfig);
                    ODBaseAction.setConfig(request, repositoryId, odConfig);
                    String encodedDisplayName = URLEncoder.encode(repositoryId, "UTF-8");
                    server.initialize(response.encodeURL(request.getContextPath() + "/appletCallback/" + encodedDisplayName));
                    server.setUserId(userid);
                    server.setPassword(ssoRepo.getSSOPassword());
                    server.setServerName(ssoRepo.getServerName());
                    server.setPort(iServerPort);
                    server.setConnectType('T');
                    server.setConnected(false);
                    ODLogonAction.storeNewConnection(request, server, repositoryId);
                    Logger.logDebug(ODSSOLogonAction.class, methodName, (ServletRequest)request, "ODWEK version = " + ODSSOLogonAction.getODWEKVersion());
                    if (session == null || userid == null) continue;
                    session.setAttribute("session_userid", (Object)userid);
                }
            }
            catch (ODException ode) {
                if (server != null && server.isInitialized()) {
                    server.terminate();
                }
                Logger.logError(ODSSOLogonAction.class, methodName, (ServletRequest)request, (Throwable)ode);
            }
            catch (Exception e) {
                Logger.logError(ODSSOLogonAction.class, methodName, (ServletRequest)request, (Throwable)e);
                if (server != null && server.isInitialized()) {
                    server.terminate();
                }
            }
            catch (Throwable t) {
                Logger.logError(ODSSOLogonAction.class, methodName, (ServletRequest)request, t);
                if (server == null || !server.isInitialized()) break block10;
                server.terminate();
            }
        }
        Hashtable connectionList = (Hashtable)request.getSession(true).getAttribute("od_servers");
        logonMediator.setODConnectionList(connectionList);
    }
}

