/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.Constants;
import com.ibm.ecm.ParamConstants;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DocumentInfoMediator;
import com.ibm.ecm.mediator.SelectedItemsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.util.MimeTypeUtil;
import com.ibm.ecm.util.Results;
import com.ibm.ecm.util.SelectedItem;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public class ListSelectedItemsAction
extends BaseAction
implements Constants,
ParamConstants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ActionForward actionForward = null;
        MessageResources resources = this.getResources(request);
        SelectedItemsMediator itemsMediator = (SelectedItemsMediator)this.getMediator(request);
        try {
            this.listItems(request, response);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            itemsMediator.addError("error.exception.general", e.getMessage());
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void listItems(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "listItems";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        SelectedItemsMediator itemsMediator = (SelectedItemsMediator)this.getMediator(request);
        try {
            String[] docIds = request.getParameterValues("docid");
            String repositoryId = request.getParameter("repositoryId");
            String templateName = request.getParameter("template_name");
            String serverServiceURL = null;
            RepositoryConfig repositoryConfig = Config.getRepositoryConfig(request);
            if (repositoryConfig != null) {
                serverServiceURL = Config.getServerConfig(request).getServiceURL();
            }
            String[] fileNames = request.getParameterValues("fileName");
            String[] mimeTypes = request.getParameterValues("mimetype");
            for (int i = 0; i < mimeTypes.length; ++i) {
                mimeTypes[i] = MimeTypeUtil.getMimeTypeForOD(mimeTypes[i]);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "mimetype = " + mimeTypes[i]);
            }
            String utf8 = this.getUtils(request).getEncoding(request);
            for (int i = 0; i < docIds.length; ++i) {
                String mimeTypeDescription;
                String iconFileName;
                if (mimeTypes[i].equalsIgnoreCase("item")) {
                    SelectedItem item = new SelectedItem();
                    item.setMimetype(mimeTypes[i]);
                    item.setDocId(docIds[i]);
                    item.setFilename(fileNames[i]);
                    item.setAllPartsSize(0L);
                    item.setBasePartSize(0L);
                    itemsMediator.getItems().put(docIds[i], item);
                    continue;
                }
                String data = URLEncoder.encode("repositoryId", utf8) + "=" + URLEncoder.encode(repositoryId, utf8);
                data = data + "&" + URLEncoder.encode("template_name", utf8) + "=" + URLEncoder.encode(templateName, utf8);
                data = data + "&" + URLEncoder.encode("docid", utf8) + "=" + URLEncoder.encode(docIds[i], utf8);
                data = data + "&" + URLEncoder.encode("alt_output", utf8) + "=" + URLEncoder.encode("JSON", utf8);
                StringBuffer linkURL = new StringBuffer().append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort());
                String getDocumentURL = response.encodeURL(linkURL.append(serverServiceURL).append("/getDocument.do").toString()) + "?" + "transform" + "=native";
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "getDocumentURL=" + getDocumentURL);
                Results resultObject = this.getUtils(request).invokeAction(request, getDocumentURL, data);
                String resultsStr = new String(resultObject.getResults(), "UTF-8");
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JSON results returned from " + getDocumentURL + "=" + resultsStr);
                DocumentInfoMediator mediator = (DocumentInfoMediator)DocumentInfoMediator.getFromJSONString(request, resultsStr.toString(), this.getResources(request), request.getLocale());
                if (mediator.hasErrors) {
                    request.setAttribute("mediator", (Object)mediator);
                    return;
                }
                long partSize = mediator.getPartSize();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "part Size =" + partSize);
                int partCount = mediator.getPartCount();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "part count =" + partCount);
                int annoCount = mediator.getAnnotationPartCount();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "anno  count =" + annoCount);
                int notelogCount = mediator.getNotelogCount();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "notelog count =" + notelogCount);
                String firstPartMimeType = mediator.getMimeType();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "part mimeType =" + firstPartMimeType);
                boolean pdfConvertable = mediator.isPDFConvertable();
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "pdf convertable =" + pdfConvertable);
                SelectedItem item = new SelectedItem();
                item.setDocId(docIds[i]);
                item.setBasePartSize(partSize);
                long totalPartSize = partSize;
                String queryString = "";
                if (partCount > 1) {
                    for (int j = 1; j < partCount; ++j) {
                        queryString = data + "&" + URLEncoder.encode("part_number", utf8) + "=" + URLEncoder.encode(new Integer(j).toString(), utf8);
                        Results partObject = this.getUtils(request).invokeAction(request, getDocumentURL, queryString);
                        String retStr = new String(partObject.getResults(), "UTF-8");
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "JSON results returned from " + getDocumentURL + "=" + retStr);
                        mediator = (DocumentInfoMediator)DocumentInfoMediator.getFromJSONString(request, retStr, this.getResources(request), request.getLocale());
                        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "total part Size =" + (totalPartSize += mediator.getPartSize()));
                    }
                }
                item.setAnnoPartCount(annoCount);
                item.setNotelogCount(notelogCount);
                item.setPDFConvertable(pdfConvertable);
                item.setAllPartsSize(totalPartSize);
                try {
                    if (fileNames == null || fileNames[i] == null || fileNames[i].trim().length() < 1) {
                        item.setFilename(resources.getMessage(request.getLocale(), "email.file.name.default"));
                    } else {
                        String newFileName = StringEscapeUtils.unescapeJavaScript((String)StringEscapeUtils.unescapeXml((String)fileNames[i]));
                        item.setFilename(newFileName);
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "filename = " + fileNames[i] + " mime type=" + mimeTypes[i]);
                }
                catch (Exception e) {
                    item.setFilename(resources.getMessage(request.getLocale(), "email.file.name.default"));
                }
                String storedFileName = mediator.getStoredFileName();
                if (storedFileName != null && !storedFileName.equals("")) {
                    item.setFilename(storedFileName);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "stored file name set on the mediator=" + storedFileName);
                }
                item.setPartCount(partCount);
                if (mimeTypes == null || mimeTypes[i] == null || mimeTypes[i].trim().length() < 1) {
                    iconFileName = MimeTypeUtil.getIconNameFromMimeType("application/binary");
                    mimeTypeDescription = MimeTypeUtil.getDescriptionFromMimeType("application/binary");
                    item.setFileExtension(MimeTypeUtil.getExtFromMimeType("application/binary"));
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "content type (defaulted) = 'application/binary'");
                } else {
                    iconFileName = MimeTypeUtil.getIconNameFromMimeType(firstPartMimeType);
                    mimeTypeDescription = MimeTypeUtil.getDescriptionFromMimeType(firstPartMimeType);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "mime type description =" + mimeTypeDescription);
                    item.setFileExtension(MimeTypeUtil.getExtFromMimeType(firstPartMimeType));
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "content type =" + firstPartMimeType);
                }
                item.setIconFileName(resources.getMessage(request.getLocale(), iconFileName));
                item.setMimetype(firstPartMimeType);
                String description = resources.getMessage(request.getLocale(), mimeTypeDescription);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "mime type description from messages =" + description);
                if (description != null && !description.equals("")) {
                    item.setMimeTypeDescription(description);
                } else if (mimeTypeDescription.equalsIgnoreCase("file.type.audio")) {
                    item.setMimeTypeDescription("audio");
                } else if (mimeTypeDescription.equalsIgnoreCase("file.type.video")) {
                    item.setMimeTypeDescription("video");
                } else if (mimeTypeDescription.equalsIgnoreCase("file.type.g3fax")) {
                    item.setMimeTypeDescription("g3fax");
                }
                itemsMediator.getItems().put(docIds[i], item);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            itemsMediator.addError("error.exception.general", e.getMessage());
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String repositoryId = request.getParameter("repositoryId");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: repositoryId = " + repositoryId);
        String templateName = request.getParameter("template_name");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: templateName = " + templateName);
        String pid = request.getParameter("docid");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: docid = " + pid);
        if (repositoryId == null || repositoryId.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "repositoryId");
            this.setRequestHasErrors(request, true);
        }
        if (templateName == null || templateName.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "template_name");
            this.setRequestHasErrors(request, true);
        }
        if (pid == null || pid.trim().length() < 1) {
            baseMediator.addError("error.parm.null", "docid");
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        SelectedItemsMediator selMediator = new SelectedItemsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)selMediator);
        return selMediator;
    }
}

