/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.FavoriteConfig;
import com.ibm.ecm.configuration.UserConfig;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.ListFavoritesMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFavoritesAction
extends BaseAction {
    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        String methodName = "createMediator";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ListFavoritesMediator favoritesMediator = new ListFavoritesMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)favoritesMediator);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return favoritesMediator;
    }

    @Override
    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        try {
            Map<String, UserConfig> userConfigs = this.getConfiguration(request);
            Collection<FavoriteConfig> favoriteList = new ArrayList<FavoriteConfig>();
            for (UserConfig userConfig : userConfigs.values()) {
                favoriteList.addAll(userConfig.getFavoriteList());
            }
            if (favoriteList != null && favoriteList.size() > 1) {
                favoriteList = this.sortFavorites(favoriteList);
            }
            ListFavoritesMediator listFavoritesMediator = (ListFavoritesMediator)this.getMediator(request);
            listFavoritesMediator.setConfigurationObject(favoriteList);
        }
        catch (Exception e) {
            ListFavoritesMediator listFavoritesMediator = (ListFavoritesMediator)this.getMediator(request);
            listFavoritesMediator.addError("desktop.configError");
            Logger.logError((Object)this, "executeBaseAction", (ServletRequest)request, (Throwable)e);
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private Collection<FavoriteConfig> sortFavorites(Collection<FavoriteConfig> favoriteList) {
        ArrayList<FavoriteConfig> resultList = new ArrayList<FavoriteConfig>();
        resultList.addAll(this.findFavoritesByType(favoriteList, "teamspace"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "folder"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "search"));
        resultList.addAll(this.findFavoritesByType(favoriteList, "document"));
        return resultList;
    }

    private Collection<FavoriteConfig> findFavoritesByType(Collection<FavoriteConfig> favoriteList, String type) {
        ArrayList<FavoriteConfig> resultList = new ArrayList<FavoriteConfig>();
        for (FavoriteConfig favorite : favoriteList) {
            if (favorite.getType() == null || !favorite.getType().equals(type)) continue;
            resultList.add(favorite);
        }
        Collections.sort(resultList);
        return resultList;
    }

    private Map<String, UserConfig> getConfiguration(HttpServletRequest request) throws Exception {
        String methodName = "getConfiguration";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String appName = request.getParameter("application");
        String userIds = request.getParameter("userid");
        LinkedHashMap<String, UserConfig> userConfigs = new LinkedHashMap<String, UserConfig>();
        if (userIds != null) {
            String[] ids = userIds.split(",");
            try {
                for (String id : ids) {
                    if (userConfigs.get(id = id.toLowerCase(request.getLocale())) != null) continue;
                    userConfigs.put(id, Config.getUserConfig(appName, id));
                }
            }
            catch (Exception e) {
                ListFavoritesMediator listFavoritesMediator = (ListFavoritesMediator)this.getMediator(request);
                listFavoritesMediator.addError("desktop.configError");
                Logger.logError((Object)this, "getConfiguration", (ServletRequest)request, (Throwable)e);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return userConfigs;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MessageResources resources = this.getResources(request);
        BaseMediator baseMediator = this.getMediator(request);
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        String userName = request.getParameter("userid");
        String action = request.getParameter("action");
        String id = request.getParameter("id");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: app name = " + appName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: desktop name = " + desktopName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: user id = " + userName);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: action = " + action);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: id = " + id);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return !this.getRequestHasErrors(request);
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }

    private static Collator getCollator(Locale locale) {
        Collator localCollator = null;
        localCollator = locale == null ? Collator.getInstance() : Collator.getInstance(locale);
        return localCollator;
    }
}

