/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.RepositoryConfig;
import com.ibm.ecm.mediator.LogonMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.TAMSSOLogon;
import com.ibm.ecm.struts.actions.cm.CMLogonAction;
import com.ibm.ecm.struts.actions.container.ContainerLogonAction;
import com.ibm.ecm.struts.actions.p8.P8LogonAction;
import com.ibm.ecm.util.Util;
import com.ibm.websphere.security.WSSecurityHelper;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.webservices.engine.encoding.Base64;
import com.ibm.wsspi.security.auth.callback.WSCallbackHandlerFactory;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LTPASSOLogon {
    public static String LTPA2_TOKEN = "LTPAToken2";
    public static String LTPA_STANZA = "Navigator";

    public static String getLTPAToken2Cookie(HttpServletRequest request) {
        String methodName = "getLTPAToken2Cookie";
        Cookie[] cookies = request.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(LTPA2_TOKEN)) continue;
            Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, "Cookie Name " + cookies[i].getName() + "  Value=" + cookies[i].getValue());
            return cookies[i].getValue();
        }
        return null;
    }

    public static boolean doesLtpaTokenExists(HttpServletRequest request) {
        boolean ssoAuthenticated = false;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().startsWith("LtpaToken")) continue;
                ssoAuthenticated = true;
                break;
            }
        }
        return ssoAuthenticated;
    }

    private static boolean sessionIsNewAndNoConnections(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        boolean isNew = session != null && session.isNew();
        Logger.logDebug(LTPASSOLogon.class, "sessionIsNewOrNoConnections", (ServletRequest)request, "======  Session.isNew=" + isNew);
        if (!isNew) {
            Util.dumpSession(request);
            Logger.logDebug(LTPASSOLogon.class, "sessionIsNewOrNoConnections", (ServletRequest)request, "======  Session.hasConnections=" + Util.hasConnections(session));
            isNew = !Util.hasConnections(session);
        }
        return isNew;
    }

    public static String getLtpaToken(HttpServletRequest request) {
        int i;
        String methodName = "getLtpaToken";
        Logger.logEntry(LTPASSOLogon.class, methodName, (ServletRequest)request);
        Cookie[] cookies = request.getCookies();
        String ltpaCookieValue = null;
        if (cookies == null || cookies.length == 0) {
            return ltpaCookieValue;
        }
        for (i = 0; i < cookies.length; ++i) {
            Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, "cookies Name = " + cookies[i].getName() + "   Value = " + cookies[i].getValue());
            if (!cookies[i].getName().equals("LtpaToken2")) continue;
            ltpaCookieValue = cookies[i].getValue();
            break;
        }
        if (ltpaCookieValue == null) {
            for (i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("LtpaToken")) continue;
                ltpaCookieValue = cookies[i].getValue();
                break;
            }
        }
        Logger.logExit(LTPASSOLogon.class, methodName, (ServletRequest)request);
        Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " LTPA Token Cookie Value=" + ltpaCookieValue);
        return ltpaCookieValue;
    }

    private static void dumpLTPA(Subject security_subject, HttpServletRequest request) {
        String methodName = "dumpLTPA";
        if (security_subject != null) {
            try {
                Set<WSCredential> publicSecurity_credentials = security_subject.getPublicCredentials(WSCredential.class);
                Set<WSCredential> privateSecurity_credentials = security_subject.getPrivateCredentials(WSCredential.class);
                WSCredential security_credential = publicSecurity_credentials.iterator().next();
                String user = security_credential.getSecurityName();
                String securityRealmName = security_credential.getRealmSecurityName();
                Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " securityRealmName= " + securityRealmName);
                Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " user = " + user);
                Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, "public security_credential = " + security_credential);
                WSCredential privateSecurity_credential = null;
                if (privateSecurity_credentials != null && (privateSecurity_credential = publicSecurity_credentials.iterator().next()) != null) {
                    Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " privateSecurity_credential = " + privateSecurity_credential);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logger.logError(LTPASSOLogon.class, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
    }

    public static String getLTPASecurityToken() {
        byte[] token = null;
        try {
            Subject security_subject = WSSubject.getRunAsSubject();
            if (security_subject != null) {
                Set<WSCredential> security_credentials = security_subject.getPublicCredentials(WSCredential.class);
                WSCredential security_credential = security_credentials.iterator().next();
                String user = security_credential.getSecurityName();
                if (user.equalsIgnoreCase("UNAUTHENTICATED")) {
                    return null;
                }
                token = security_credential.getCredentialToken();
                if (token == null) {
                    return null;
                }
                String ltpaToken = Base64.encode((byte[])token);
                return ltpaToken;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void addLTPACookie(HttpServletRequest request, HttpServletResponse response) {
        String ltp2Token = LTPASSOLogon.getLTPASecurityToken();
        if (LTPASSOLogon.getLTPAToken2Cookie(request) == null && ltp2Token != null) {
            Cookie ltpaCookie = new Cookie(LTPA2_TOKEN, ltp2Token);
            ltpaCookie.setPath("/");
            response.addCookie(ltpaCookie);
        }
    }

    public static void removeLTPACookie(HttpServletRequest request, HttpServletResponse response) {
        WSSecurityHelper.revokeSSOCookies((HttpServletRequest)request, (HttpServletResponse)response);
    }

    public static Subject doJAASLogin(String userid, String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "doJAASLogin";
        CallbackHandler callbackHandler = WSCallbackHandlerFactory.getInstance().getCallbackHandler(userid, null, password, request, response, null);
        LoginContext lc = new LoginContext(LTPA_STANZA, callbackHandler);
        lc.login();
        Subject subject = lc.getSubject();
        WSSubject.setRunAsSubject((Subject)subject);
        Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " LTPA token creation subject=" + subject);
        return subject;
    }

    public static void dumpHeaders(HttpServletRequest request) {
        String methodName = "dumpHeaders";
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            if (headerName == null || headerName.length() <= 0) continue;
            String header = request.getHeader(headerName);
            Logger.logInfo(LTPASSOLogon.class, methodName, (ServletRequest)request, " headerName: " + headerName + "  = " + header);
        }
    }

    public static boolean isKerberosSSO(Subject subject, HttpServletRequest request) {
        String methodName = "isKerberosSSO";
        Iterator<Object> it = subject.getPrivateCredentials().iterator();
        boolean isKerberosSSO = false;
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj.getClass().getName().equalsIgnoreCase("com.ibm.ws.wssecurity.platform.websphere.token.KRB5TokenImpl")) {
                isKerberosSSO = true;
            }
            Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " obj.getClass().getName() = " + obj.getClass().getName());
        }
        return isKerberosSSO;
    }

    public static Subject acceptLTPACookie(HttpServletRequest request, HttpServletResponse response, LogonMediator logonMediator, DesktopConfig desktopConfig) throws Exception {
        String methodName = "acceptLTPACookie";
        HttpSession session = request.getSession(false);
        LTPASSOLogon.dumpHeaders(request);
        String ltpaTokenStr = LTPASSOLogon.getLtpaToken(request);
        if (session != null && !LTPASSOLogon.sessionIsNewAndNoConnections(request)) {
            Logger.logInfo(LTPASSOLogon.class, methodName, (ServletRequest)request, " session=" + session.getId() + " Exists. isNew=" + session.isNew() + ". So not considering the LTPAToken " + ltpaTokenStr);
            return null;
        }
        if (!LTPASSOLogon.doesLtpaTokenExists(request)) {
            Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " LTPA token does not exist in the request");
        } else {
            Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " LTPA token exist in the request " + ltpaTokenStr);
            try {
                byte[] ltpaToken = Base64.decode((String)ltpaTokenStr);
                CallbackHandler h = WSCallbackHandlerFactory.getInstance().getCallbackHandler(ltpaToken);
                LoginContext lc = new LoginContext("WSLogin", h);
                lc.login();
                Subject subject = lc.getSubject();
                Set<Principal> principalSet = subject.getPrincipals();
                Principal[] principals = principalSet.toArray(new Principal[0]);
                String user = principals[0].getName();
                Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, " Current SUBJECT =" + subject);
                LTPASSOLogon.dumpLTPA(subject, request);
                if (subject != null) {
                    WSSubject.setRunAsSubject((Subject)subject);
                    Logger.logInfo(LTPASSOLogon.class, methodName, (ServletRequest)request, "LTPA authenticated user " + user + " and a valid subject found. So Propogating the LTPA token for authentication.");
                    session = request.getSession(true);
                    if (session != null) {
                        session.setAttribute("session_userid", (Object)user);
                    }
                    String defaultRepositoryId = desktopConfig.getDefaultRepositoryId();
                    RepositoryConfig defaultRepository = null;
                    String desktopName = request.getParameter("desktop");
                    if (desktopName == null || desktopName.length() == 0) {
                        desktopName = Config.getDefaultDesktopName(request);
                    }
                    if (defaultRepositoryId != null) {
                        defaultRepository = desktopConfig.getRepository(defaultRepositoryId);
                    }
                    if (defaultRepository != null && defaultRepository.getType().equals("p8")) {
                        P8LogonAction.createP8Connection(request, response, logonMediator, user, LTPA_STANZA, defaultRepository, subject);
                        if (LTPASSOLogon.isKerberosSSO(subject, request)) {
                            new ContainerLogonAction().doContainerLogin(request, user, logonMediator, subject, null);
                        }
                    } else if (defaultRepository != null && defaultRepository.getType().equals("cm") && defaultRepository.getUseSSO().equalsIgnoreCase("true")) {
                        new CMLogonAction().createCMConnection(request, response, logonMediator);
                    } else if (defaultRepositoryId == null || desktopName.equalsIgnoreCase("admin")) {
                        try {
                            Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, "Before ContainerLogonActiion doContainerLogin  defaultRepositoryId  :  " + defaultRepositoryId + "   desktopName" + desktopName);
                            new ContainerLogonAction().doContainerLogin(request, user, logonMediator, subject, null);
                        }
                        catch (Throwable t) {
                            Logger.logError(TAMSSOLogon.class, methodName, (ServletRequest)request, t.getMessage());
                        }
                    } else {
                        Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, "LTPA authenticated user=" + user + ". Default Repository  :  " + defaultRepositoryId + "  desktopName=" + desktopName);
                    }
                    return subject;
                }
            }
            catch (Exception e) {
                Logger.logDebug(LTPASSOLogon.class, methodName, (ServletRequest)request, e.getMessage());
            }
        }
        return null;
    }
}

