/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.Constants;
import com.ibm.ecm.ParamConstants;
import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.LocaleConfig;
import com.ibm.ecm.configuration.ServerConfig;
import com.ibm.ecm.configuration.exception.MissingValueException;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.ServerMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.util.MessageUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetServersAction
extends BaseAction
implements Constants,
ParamConstants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    @Override
    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        String appName = request.getParameter("application");
        appName = appName == null || appName.length() == 0 ? "navigator" : appName;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ApplicationConfig appConfig = Config.getApplicationConfig(appName);
        ServerMediator serverMediator = (ServerMediator)this.getMediator(request);
        serverMediator.setLocaleConfigs(this.getLocaleConfigs(request, appConfig));
        serverMediator.setServerConfigs(this.getServerConfigs(request, appConfig));
        this.writeJSONMediator(request, response);
        return null;
    }

    private List<ServerConfig> getServerConfigs(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        ArrayList<ServerConfig> list = new ArrayList<ServerConfig>();
        Collection<ServerConfig> collection = appConfig.getServersList();
        for (ServerConfig config : collection) {
            list.add(config);
        }
        return list;
    }

    private List<LocaleConfig> getLocaleConfigs(HttpServletRequest request, ApplicationConfig appConfig) throws ConfigurationException, MissingValueException {
        ArrayList<LocaleConfig> list = new ArrayList<LocaleConfig>();
        String[] locales = appConfig.getLocales();
        for (int i = 0; i < locales.length; ++i) {
            String localeId = locales[i];
            String messageKey = "locale." + localeId + ".label";
            String label = MessageUtil.getMessage(request, messageKey);
            LocaleConfig config = Config.getLocaleConfig(appConfig.getObjectId(), localeId);
            config.setLabel(label);
            Config.removeConfigurationFromCache(config);
            list.add(config);
        }
        Collections.sort(list, new Comparator<LocaleConfig>(){

            @Override
            public int compare(LocaleConfig item1, LocaleConfig item2) {
                return item1.getLabel().compareToIgnoreCase(item2.getLabel());
            }
        });
        return list;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        ServerMediator mediator = new ServerMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

