/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.Constants;
import com.ibm.ecm.ParamConstants;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.MenuTypeConfig;
import com.ibm.ecm.extension.PluginMenuType;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.MenuTypeMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.util.MessageUtil;
import com.ibm.ecm.util.PluginUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetMenuTypesAction
extends BaseAction
implements Constants,
ParamConstants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    @Override
    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        String appName = request.getParameter("application");
        appName = appName == null || appName.length() == 0 ? "navigator" : appName;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        MenuTypeMediator menuTypeMediator = (MenuTypeMediator)this.getMediator(request);
        menuTypeMediator.setMenuTypeConfigs(this.getMenuTypeConfigs(request, appName));
        this.writeJSONMediator(request, response);
        return null;
    }

    private String[] getAllMenuTypeIds() {
        String[] menuTypeIds = new String[]{"TeamspaceToolbar", "FolderContextMenu", "VersionsContextMenu", "VersionsCMContextMenu", "ItemContextMenu", "SystemItemContextMenu", "MixItemsContextMenu", "BannerToolsContextMenu", "GlobalToolbar", "BannerUserSessionContextMenu", "FavoritesToolbar", "ContentListToolbar", "SelectObjectToolbar", "SelectObjectFolderContextMenu", "SelectObjectItemContextMenu", "AttachmentFolderContextMenu", "AttachmentItemContextMenu", "AddDocumentAttachmentContextMenu", "AddFolderAttachmentContextMenu", "AttachmentToolbar", "SearchTemplateContextMenu", "SearchSearchTemplateContextMenu", "InbasketToolbarP8", "InbasketToolbar", "TeamspaceTemplateContextMenu", "TeamspaceContextMenu", "TemplatesListToolbar", "TeamspacesListToolbar", "BrowseToolbar", "FavoritesContextMenu", "UserQueueContextMenu", "ProcessQueueContextMenu", "TrackerQueueContextMenu", "WorkItemFolderContextMenu", "WorkItemDocumentContextMenu", "SearchContextMenu", "TeamspaceFolderContextMenu", "ObjectStoreFolderContextMenu", "FavoriteItemContextMenu", "FavoriteFolderContextMenu", "FavoriteTeamspaceContextMenu", "FavoriteSearchTemplateContextMenu"};
        return menuTypeIds;
    }

    private List<MenuTypeConfig> getMenuTypeConfigs(HttpServletRequest request, String applicationName) throws Exception {
        MenuTypeConfig config;
        ArrayList<MenuTypeConfig> list = new ArrayList<MenuTypeConfig>();
        String[] menuTypeIds = this.getAllMenuTypeIds();
        for (int i = 0; i < menuTypeIds.length; ++i) {
            String menuTypeId = menuTypeIds[i];
            MenuTypeConfig config2 = Config.getMenuTypeConfig(applicationName, menuTypeId, new boolean[0]);
            String label = MessageUtil.getMessage(request, "menuType." + menuTypeId + ".label");
            config2.setLabel(label);
            String tooltip = MessageUtil.getMessage(request, "menuType." + menuTypeId + ".tooltip");
            config2.setTooltip(tooltip);
            String category = MessageUtil.getMessage(request, "menuType." + menuTypeId + ".category");
            config2.setCategory(category);
            list.add(config2);
        }
        String customToolbarCategory = MessageUtil.getMessage(request, "menuType.customToolbar.category");
        String customContextMenuCategory = MessageUtil.getMessage(request, "menuType.customContextMenu.category");
        boolean hasCustomToolbar = false;
        boolean hasCustomContextMenu = false;
        Map<String, PluginMenuType> pluginMenuTypeMap = PluginUtil.getPluginMenuTypes(request);
        for (String key : pluginMenuTypeMap.keySet()) {
            PluginMenuType pluginMenuType = pluginMenuTypeMap.get(key);
            MenuTypeConfig config3 = Config.getMenuTypeConfig(applicationName, pluginMenuType.getId(), new boolean[0]);
            config3.setLabel(pluginMenuType.getName(request.getLocale()) != null && !pluginMenuType.getName(request.getLocale()).equals("") ? pluginMenuType.getName(request.getLocale()) : pluginMenuType.getId());
            config3.setTooltip(pluginMenuType.getTooltip(request.getLocale()) != null ? pluginMenuType.getTooltip(request.getLocale()) : "");
            if (pluginMenuType.isToolbar()) {
                hasCustomToolbar = true;
            } else {
                hasCustomContextMenu = true;
            }
            config3.setCategory(pluginMenuType.isToolbar() ? customToolbarCategory : customContextMenuCategory);
            list.add(config3);
        }
        if (!hasCustomToolbar) {
            config = Config.getMenuTypeConfig(applicationName, "noCustomToolbars", new boolean[0]);
            config.setLabel("");
            config.setCategory(customToolbarCategory);
            list.add(config);
        }
        if (!hasCustomContextMenu) {
            config = Config.getMenuTypeConfig(applicationName, "noCustomContextMenus", new boolean[0]);
            config.setLabel("");
            config.setCategory(customContextMenuCategory);
            list.add(config);
        }
        Collections.sort(list, new Comparator<MenuTypeConfig>(){

            @Override
            public int compare(MenuTypeConfig item1, MenuTypeConfig item2) {
                int cat = item1.getCategory().compareToIgnoreCase(item2.getCategory());
                if (cat == 0) {
                    return item1.getLabel().compareToIgnoreCase(item2.getLabel());
                }
                return cat;
            }
        });
        return list;
    }

    @Override
    protected BaseMediator createMediator(HttpServletRequest request) {
        MenuTypeMediator mediator = new MenuTypeMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    @Override
    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    @Override
    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

