/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.Constants;
import com.ibm.ecm.ParamConstants;
import com.ibm.ecm.configuration.ApplicationConfig;
import com.ibm.ecm.configuration.Config;
import com.ibm.ecm.configuration.DesktopConfig;
import com.ibm.ecm.configuration.MenuConfig;
import com.ibm.ecm.configuration.SettingsConfig;
import com.ibm.ecm.configuration.ViewerConfig;
import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.extension.PluginAction;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.DesktopMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import com.ibm.ecm.struts.actions.LTPASSOLogon;
import com.ibm.ecm.struts.actions.TAMSSOLogon;
import com.ibm.ecm.util.ActionUtil;
import com.ibm.ecm.util.IconMappingUtil;
import com.ibm.ecm.util.J2EEServerUtil;
import com.ibm.ecm.util.LabelUtil;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.ecm.util.ViewerUtil;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class GetDesktopAction
extends BaseAction
implements Constants,
ParamConstants {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        DesktopMediator desktopMediator = (DesktopMediator)this.getMediator(request);
        String appName = request.getParameter("application");
        String desktopName = request.getParameter("desktop");
        String containerLoginId = request.getParameter("containerLoginId");
        try {
            DesktopConfig desktopConfig;
            appName = appName == null || appName.length() == 0 ? "navigator" : appName;
            ApplicationConfig appConfig = Config.getApplicationConfig(appName);
            if (desktopName == null || desktopName.length() == 0) {
                desktopName = Config.getDefaultDesktopName(request);
            }
            if ((desktopConfig = Config.getDesktopConfig(appName, desktopName)) == null || desktopConfig.isEmpty()) {
                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Invalid desktop requested: " + desktopName);
                desktopMediator.addError("error.desktop.invalid");
            } else {
                boolean tamKerberosLoggedIn = TAMSSOLogon.doLogin(request, response, desktopMediator, desktopConfig);
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "tamLoggedIn: " + tamKerberosLoggedIn);
                if (!tamKerberosLoggedIn && J2EEServerUtil.getJ2EEAppServerType(this.getServlet().getServletContext()) == "websphere") {
                    Subject subject = LTPASSOLogon.acceptLTPACookie(request, response, desktopMediator, desktopConfig);
                    if (subject != null) {
                        tamKerberosLoggedIn = LTPASSOLogon.isKerberosSSO(subject, request);
                        desktopMediator.setTamKerberosTokenPresent(tamKerberosLoggedIn);
                        if (tamKerberosLoggedIn) {
                            HttpSession session = request.getSession(true);
                            session.setMaxInactiveInterval(-1);
                        }
                    }
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Did not do LTPASSO");
                }
                desktopMediator.setDesktopName(desktopName);
                desktopMediator.setDesktop(desktopConfig);
                SettingsConfig settingsConfig = Config.getSettingsConfig(appName);
                desktopMediator.setSettingsConfig(settingsConfig);
                desktopMediator.setRepositories(desktopConfig.getRepositoryList());
                Plugin[] plugins = PluginUtil.getPlugins(request);
                desktopMediator.setSession(request.getSession(false));
                desktopMediator.setPlugins(plugins);
                if (PluginUtil.didPluginInitializationFail()) {
                    Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Plugin initialization failed.  See earlier entries in the log for errors");
                    desktopMediator.addWarning("desktop.configError", new Object[0]);
                }
                desktopMediator.setViewerDefConfigs(ViewerUtil.getDefaultViewerDefinitions(request, appName));
                String viewerID = desktopConfig.getViewer();
                viewerID = viewerID == null || viewerID.length() == 0 ? "default" : viewerID;
                ViewerConfig viewerConfig = Config.getViewerConfig(appName, viewerID);
                desktopMediator.setViewerConfig(viewerConfig);
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "BannerApplicationMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "BannerUserSessionContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "BannerToolsContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "FavoritesToolbar");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "FavoriteFolderContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "FavoriteItemContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "ContentListToolbar");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "ObjectStoreFolderContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "FolderContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "ItemContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "SearchTemplateContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "SearchSearchTemplateContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "InbasketToolbar");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "WorkItemDocumentContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "WorkItemFolderContextMenu");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "TeamspacesListToolbar");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "TemplatesListToolbar");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "TeamspaceToolbar");
                this.addMenuToMediator(request, desktopMediator, appConfig, desktopName, "TeamspaceFolderContextMenu");
                desktopMediator.setIconConfigs(IconMappingUtil.getIconConfigs(request, appConfig));
                desktopMediator.setIconStatusConfigs(IconMappingUtil.getIconStatusConfigs(request, appConfig));
                desktopMediator.setApplicationUILabels(LabelUtil.getApplicationUILabels(request, appConfig));
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            desktopMediator.addError("desktop.configError");
        }
        this.writeJSONMediator(request, response);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    private void addMenuToMediator(HttpServletRequest request, DesktopMediator desktopMediator, ApplicationConfig appConfig, String desktopName, String menuType) throws Exception {
        String menuId = ActionUtil.getDesktopMenuId(request, desktopName, menuType);
        List<MenuConfig> menu = ActionUtil.getActionsForMenuId(request, appConfig, menuId);
        Map<String, PluginAction> pluginActions = PluginUtil.getPluginActions(request);
        ActionUtil.getActionAttributes(request, menu, pluginActions);
        desktopMediator.addMenu(menuType, menu);
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        DesktopMediator mediator = new DesktopMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)mediator);
        return mediator;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object params, String methodName) {
    }
}

