/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.mediator.ExportSearchResultsMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.BaseAction;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ExportSearchResultsAction
extends BaseAction {
    private static final String COPYRIGHT = "Licensed Materials - Property of IBM IBM DB2 Content Manager OnDemand for Multiplatforms V8.3 (program number 5724-J33) IBM DB2 Content Manager OnDemand for z/OS and OS/390 V7 (program number 5655-H39) IBM DB2 Content Manager OnDemand for iSeries V5 (program number 5722-RD1) (c) Copyright IBM Corp. 2004, 2006.  All Rights Reserved. US Government Users Restricted Rights Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corporation";

    public ActionForward executeBaseAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodName = "executeBaseAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ExportSearchResultsMediator mediator = (ExportSearchResultsMediator)this.getMediator(request);
        String altOutput = request.getParameter("alt_output");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        if (altOutput != null && altOutput.equalsIgnoreCase("JSON")) {
            mediator.addMessage("properties.download.successful", new Object[0]);
            request.setAttribute("mediator", (Object)mediator);
            this.writeJSONMediator(request, response);
            return null;
        }
        String exportColumns = request.getParameter("exportColumns");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: exportColumns = " + exportColumns);
        String[] exportRows = request.getParameterValues("exportRows");
        StringBuffer sbExportRows = new StringBuffer("[");
        for (int i = 0; i < exportRows.length; ++i) {
            sbExportRows.append(exportRows[i]);
            if (i == exportRows.length - 1) continue;
            sbExportRows.append("\n");
        }
        sbExportRows.append("]");
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Request Parameter: exportRows = " + sbExportRows.toString());
        try {
            ServletOutputStream os = response.getOutputStream();
            mediator.addMessage("properties.download.successful", new Object[0]);
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=properties.csv");
            os.write(mediator.toCSVString(exportColumns, exportRows).getBytes("UTF8"));
            os.flush();
            os.close();
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, "Unexpected Exception:" + e);
            this.logFDC(request, response, null, methodName);
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
            mediator.addError("error.exception.general", e.getMessage());
            this.setRequestHasErrors(request, true);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return null;
    }

    protected boolean validateRequest(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "validateRequest";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        boolean isValid = true;
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        if (!altOutput.equals("JSON") && !altOutput.equals("CSV")) {
            isValid = false;
        }
        String exportColumns = request.getParameter("exportColumns");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: exportColumns = " + exportColumns);
        String[] exportRows = request.getParameterValues("exportRows");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: exportRows = " + exportRows);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return isValid;
    }

    protected BaseMediator createMediator(HttpServletRequest request) {
        String methodName = "createMediator";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ExportSearchResultsMediator exportSearchResultsMediator = new ExportSearchResultsMediator(request, this.getResources(request), request.getLocale());
        request.setAttribute("mediator", (Object)exportSearchResultsMediator);
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return exportSearchResultsMediator;
    }

    protected void logFDC(HttpServletRequest request, HttpServletResponse response, Object param, String methodName) {
        String altOutput = request.getParameter("alt_output");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: altOutput = " + altOutput);
        String exportColumns = request.getParameter("exportColumns");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: exportColumns = " + exportColumns);
        String[] exportRows = request.getParameterValues("exportRows");
        Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Request Parameter: exportRows = " + exportRows);
    }
}

