/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.struts.actions;

import com.ibm.ecm.Constants;
import com.ibm.ecm.mediator.BaseMediator;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.struts.actions.FileUploadActionForm;
import com.ibm.ecm.util.BaseUtil;
import com.ibm.ecm.util.PluginUtil;
import com.ibm.ecm.util.SecurityTokenManager;
import com.ibm.ecm.util.Util;
import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

public abstract class BaseAction
extends Action
implements Constants {
    protected BaseUtil utils = new BaseUtil();
    private static final String ENABLE_SECURE_SERVICE = "enableSecureService";
    protected static final String SECURE_JSON_PREFIX = "{}&&";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward;
        String methodName;
        block20: {
            methodName = "execute";
            Logger.logEntry((Object)this, methodName, (ServletRequest)request);
            actionForward = null;
            MessageResources resources = this.getResources(request);
            boolean secureServiceEnabled = this.isSecureServiceEnabled(request);
            request.setAttribute(ENABLE_SECURE_SERVICE, (Object)secureServiceEnabled);
            try {
                JSONObject jsonResponse;
                String path = mapping.getPath();
                if (!path.endsWith("/Ping") && !path.endsWith("/logoff")) {
                    HttpSession session;
                    if (path.endsWith("/logon")) {
                        session = request.getSession(false);
                        if (session != null && secureServiceEnabled && new SecurityTokenManager().generateToken(request, false) == null) {
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Invalidating the Session : " + session.getId() + "      SecurityToken" + new SecurityTokenManager().generateToken(request, false));
                            session.invalidate();
                        }
                    } else if (!path.endsWith("/getDesktop")) {
                        session = request.getSession(false);
                        if (session != null && !session.isNew() && path.endsWith("/changePassword")) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The request has a validate session with an id of : " + session.getId() + " path=" + path + "  So we are not considering the connections");
                        } else if (!this.sessionIsNewOrNoConnections(request, session)) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "The request has a validate session with an id of : " + session.getId());
                        } else if (session != null && request.getParameter("userAgent") != null && request.getParameter("userAgent").indexOf("Safari") > -1) {
                            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "New session for email applet when launched from Safari to retrieve document: " + session.getId());
                        } else {
                            String altOutput;
                            if (session != null) {
                                Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Invalidating the session since if invoked again it will no longer appear as new " + session.getId() + " isNew" + session.isNew());
                                session.invalidate();
                            }
                            if ((path.endsWith("/getDocument") || path.endsWith("/getXMLMetaData") || path.endsWith("/getAnnotations") || path.endsWith("/getNotes")) && ((altOutput = request.getParameter("alt_output")) == null || !altOutput.equalsIgnoreCase("JSON"))) {
                                response.sendError(408, resources.getMessage(request.getLocale(), "error.no.connection") + "  " + resources.getMessage(request.getLocale(), "error.no.connection.explanation") + "                                                                                                                                    " + "                                                                                                                                    " + "                                                                                                                                    " + "                                                                                                                                    ");
                                return actionForward;
                            }
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "The request does not have a valid session!");
                            BaseMediator mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
                            mediator.addError("error.session.expired");
                            mediator.setResponseAsHtml(form != null && ((FileUploadActionForm)form).getUploadFile() != null);
                            request.setAttribute("mediator", (Object)mediator);
                            this.writeJSONMediator(request, response);
                            return actionForward;
                        }
                        if (secureServiceEnabled && !this.validateSecurityToken(request)) {
                            Logger.logInfo((Object)this, methodName, (ServletRequest)request, "Invalid security token for: " + path);
                            BaseMediator mediator = new BaseMediator(request, resources, request.getLocale());
                            mediator.addError("error.parameter.missing");
                            mediator.setResponseAsHtml(form != null && ((FileUploadActionForm)form).getUploadFile() != null);
                            request.setAttribute("mediator", (Object)mediator);
                            this.writeJSONMediator(request, response);
                            return actionForward;
                        }
                    }
                }
                if (!this.validateRequest(request, response)) {
                    BaseMediator mediator = this.getMediator(request);
                    if (mediator != null) {
                        this.writeJSONMediator(request, response);
                    }
                    return actionForward;
                }
                JSONArtifact jsonRequest = this.getJSONRequest(request);
                if (PluginUtil.requestFilterExists(request) && (jsonResponse = PluginUtil.invokeRequestFilters(request, jsonRequest)) != null) {
                    response.setContentType("text/plain");
                    response.setCharacterEncoding("UTF-8");
                    PrintWriter writer = response.getWriter();
                    if (secureServiceEnabled) {
                        ((Writer)writer).write(SECURE_JSON_PREFIX);
                    }
                    this.writeJSON(jsonResponse.toString(), writer, response, form != null && ((FileUploadActionForm)form).getUploadFile() != null);
                    return actionForward;
                }
                actionForward = this.executeBaseAction(mapping, form, request, response);
            }
            catch (Throwable t) {
                Logger.logError((Object)this, methodName, (ServletRequest)request, t);
                BaseMediator mediator = this.getMediator(request);
                if (mediator == null) break block20;
                mediator.addError("error.exception.general", t.getLocalizedMessage());
                mediator.setResponseAsHtml(form != null && ((FileUploadActionForm)form).getUploadFile() != null);
                this.writeJSONMediator(request, response);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return actionForward;
    }

    private void writeJSON(String jsonString, Writer writer, HttpServletResponse response, boolean responseAsHtml) throws IOException {
        if (responseAsHtml) {
            jsonString = "<html><body><textarea>" + jsonString + "</textarea></body></html>";
            response.setContentType("text/html");
        }
        writer.write(jsonString);
    }

    private boolean sessionIsNewOrNoConnections(HttpServletRequest request, HttpSession session) {
        boolean isNew = session != null && session.isNew();
        Logger.logDebug((Object)this, "sessionIsNewOrNoConnections", (ServletRequest)request, "======  Session.isNew=" + isNew);
        if (!isNew) {
            Logger.logDebug((Object)this, "sessionIsNewOrNoConnections", (ServletRequest)request, "======  Session.hasConnections=" + Util.hasConnections(session));
            isNew = !Util.hasConnections(session);
        }
        return isNew;
    }

    protected BaseMediator getMediator(HttpServletRequest request) {
        String methodName = "getMediator";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = (BaseMediator)this.getAttribute(request, "mediator");
        if (mediator == null) {
            mediator = this.createMediator(request);
            if (mediator == null) {
                mediator = new BaseMediator(request, this.getResources(request), request.getLocale());
            }
            request.setAttribute("mediator", (Object)mediator);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return mediator;
    }

    protected abstract BaseMediator createMediator(HttpServletRequest var1);

    protected abstract boolean validateRequest(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract void logFDC(HttpServletRequest var1, HttpServletResponse var2, Object var3, String var4);

    protected abstract ActionForward executeBaseAction(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected byte[] getKey(HttpServletRequest request, String password) {
        String methodName = "getKey";
        byte[] encodedBytes = null;
        try {
            Key key = (Key)this.servlet.getServletContext().getAttribute("wckeyconfig");
            Cipher cipher = Cipher.getInstance("DESede");
            if (key != null) {
                cipher.init(1, key);
                encodedBytes = cipher.doFinal(password.getBytes("UTF-8"), 0, password.getBytes("UTF-8").length);
            }
        }
        catch (InvalidKeyException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (IllegalStateException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (BadPaddingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        encodedBytes = Base64.encodeBase64(encodedBytes);
        return encodedBytes;
    }

    protected String getKeyAsString(HttpServletRequest request, String password) {
        String methodName = "getKeyAsString";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String encryPassword = null;
        byte[] encrypted = this.getKey(request, password);
        try {
            encryPassword = new String(encrypted, 0, encrypted.length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return encryPassword;
    }

    protected String tegKey(HttpServletRequest request, String encodedPassword) {
        String methodName = "tegKey";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        byte[] decodedBytes = null;
        byte[] decryptedBytes = null;
        String password = null;
        try {
            decodedBytes = Base64.decodeBase64((String)encodedPassword);
            Key key = (Key)this.servlet.getServletContext().getAttribute("wckeyconfig");
            Cipher cipher = Cipher.getInstance("DESede");
            if (key != null) {
                cipher.init(2, key);
                decryptedBytes = cipher.doFinal(decodedBytes, 0, decodedBytes.length);
                password = new String(decryptedBytes, "UTF-8");
            }
        }
        catch (InvalidKeyException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (NoSuchPaddingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (IllegalStateException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (BadPaddingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return password;
    }

    public Object getAttribute(HttpServletRequest request, String name) {
        BaseUtil util = this.getUtils(request);
        if (util.getControllerServletContext() == null) {
            util.setControllerServletContext(this.getServlet().getServletContext());
        }
        return util.getAttribute((ServletRequest)request, name);
    }

    public Object getAttributeWithoutParameter(HttpServletRequest request, String name) {
        BaseUtil util = this.getUtils(request);
        if (util.getControllerServletContext() == null) {
            util.setControllerServletContext(this.getServlet().getServletContext());
        }
        return util.getAttributeWithoutParameter((ServletRequest)request, name);
    }

    public boolean getBooleanRequestParameter(HttpServletRequest request, String name, boolean defaultValue) {
        boolean value = defaultValue;
        String valueString = request.getParameter(name);
        if (valueString != null && valueString.length() > 0) {
            value = valueString.equals("1") ? true : Boolean.valueOf(valueString);
        }
        return value;
    }

    protected void setAttribute(HttpServletRequest request, Object value, String name) {
        this.getUtils(request).setAttribute((ServletRequest)request, value, name);
    }

    public BaseUtil getUtils(HttpServletRequest request) {
        return this.utils;
    }

    public void setUtils(BaseUtil util) {
        this.utils = util;
    }

    public JSONArtifact getJSONRequest(HttpServletRequest request) throws IOException {
        JSONArtifact jsonRequest = (JSONArtifact)request.getAttribute("json_post");
        if (jsonRequest == null) {
            this.readJSONRequest(request);
            jsonRequest = (JSONArtifact)request.getAttribute("json_post");
        }
        return jsonRequest;
    }

    public void readJSONRequest(HttpServletRequest request) throws IOException {
        request.setAttribute("json_post", null);
    }

    protected String readJSON(HttpServletRequest request) throws IOException {
        String json = request.getParameter("json_post");
        if (json == null) {
            json = request.getReader().readLine();
        }
        return json;
    }

    public boolean getRequestHasErrors(HttpServletRequest request) {
        Boolean hasErrors = (Boolean)request.getAttribute("wc.hasErrors");
        if (hasErrors == null) {
            return false;
        }
        if (hasErrors instanceof Boolean && hasErrors.booleanValue()) {
            return true;
        }
        if (hasErrors instanceof Boolean && !hasErrors.booleanValue()) {
            return false;
        }
        return false;
    }

    public void setRequestHasErrors(HttpServletRequest request, boolean errors) {
        if (!this.getRequestHasErrors(request) && errors) {
            request.setAttribute("wc.hasErrors", (Object)new Boolean(true));
        }
    }

    protected void writeJSONMediator(HttpServletRequest request, HttpServletResponse response) {
        String methodName = "writeJSONMediator";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        BaseMediator mediator = (BaseMediator)request.getAttribute("mediator");
        if (mediator != null) {
            mediator.writeJSONResponse(request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    public boolean isSecureServiceEnabled(HttpServletRequest request) {
        String methodName = "isSecureServiceEnabled";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        boolean isSecureServiceEnabled = Boolean.parseBoolean(this.servlet.getServletConfig().getInitParameter(ENABLE_SECURE_SERVICE));
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        return isSecureServiceEnabled;
    }

    protected boolean validateSecurityToken(HttpServletRequest request) {
        String methodName = "validateSecurityToken";
        String token = request.getHeader("security_token");
        if (token == null) {
            token = request.getParameter("security_token");
        }
        boolean valid = new SecurityTokenManager().validateToken(request, token);
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, "token: " + token + " valid: " + valid);
        return valid;
    }
}

