/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.servlets.od;

import com.ibm.ecm.ODConstants;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.edms.od.ODException;
import com.ibm.edms.od.ODServer;
import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ODAppletCallbackServlet
extends HttpServlet
implements Servlet,
ODConstants {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String methodName = "doGet";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        Object servers = null;
        HttpSession session = request.getSession(false);
        byte[] appletResponse = null;
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        ODServer server = null;
        String pathInfo = request.getPathInfo();
        String serverName = null;
        if (pathInfo != null) {
            serverName = pathInfo.substring(pathInfo.lastIndexOf("/") + 1);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)request, new StringBuffer("serverName = ").append(serverName).toString());
        try {
            if (serverName != null && (server = this.getConnection(request, serverName)) != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Query String=> " + request.getQueryString());
                if ("9.0.0.0".compareTo("8.4.0.0") < 0) {
                    String queryString = request.getQueryString();
                    StringTokenizer tokenizer = new StringTokenizer(queryString, "&=", true);
                    String reencodedQueryString = "";
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("&") || token.equals("=")) {
                            reencodedQueryString = reencodedQueryString + token;
                            continue;
                        }
                        String decodedToken = URLDecoder.decode(token, "UTF-8");
                        String reencodedToken = URLEncoder.encode(decodedToken);
                        reencodedQueryString = reencodedQueryString + reencodedToken;
                    }
                    appletResponse = server.viewerPassthru(reencodedQueryString);
                } else {
                    appletResponse = server.viewerPassthru(request.getQueryString());
                }
            }
        }
        catch (ODException ode) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)ode);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, (Throwable)e);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
        if (appletResponse != null) {
            response.setContentType("text/html");
            ServletOutputStream os = response.getOutputStream();
            os.write(appletResponse);
            os.close();
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String methodName = "doPost";
        Logger.logEntry((Object)this, "doPost", (ServletRequest)request);
        this.doGet(request, response);
        Logger.logExit((Object)this, "doPost", (ServletRequest)request);
    }

    private ODServer getConnection(HttpServletRequest request, String serverName) {
        String methodName = "getConnection";
        HttpSession session = request.getSession(false);
        ODServer connection = null;
        if (session != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)request, "serverName: " + serverName);
            Hashtable connectionList = (Hashtable)session.getAttribute("od_servers");
            if (connectionList != null) {
                connection = (ODServer)connectionList.get(serverName);
            }
            return connection;
        }
        return null;
    }
}

