/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.servlets.filters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GZipFilter
implements Filter {
    private ServletContext servletContext;
    private Map<String, byte[]> gzipFileCache = new Hashtable<String, byte[]>();
    private long startupTime;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.startupTime = System.currentTimeMillis();
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        HttpServletRequest httpreq = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (httpreq.getMethod().equals("GET") && !response.isCommitted()) {
            String requestURI = httpreq.getRequestURI();
            if (requestURI.endsWith("AdminPane.js")) {
                requestURI = requestURI + ".jgz";
            } else if (requestURI.endsWith("TeamspaceBuilderPane.js")) {
                requestURI = requestURI + ".jgz";
            }
            if (requestURI.endsWith("jgz")) {
                String pathInfo = requestURI.substring(httpreq.getContextPath().length());
                String nonGzipPathInfo = pathInfo.substring(0, pathInfo.length() - 4);
                if (pathInfo.endsWith("js.jgz")) {
                    response.setHeader("Content-Encoding", "gzip");
                    response.setContentType("application/x-javascript; charset=UTF-8");
                } else if (pathInfo.endsWith("css.jgz")) {
                    response.setHeader("Content-Encoding", "gzip");
                    response.setContentType("text/css; charset=UTF-8");
                }
                byte[] content = null;
                if (this.gzipFileCache.containsKey(pathInfo)) {
                    content = this.gzipFileCache.get(pathInfo);
                } else {
                    Map<String, byte[]> map = this.gzipFileCache;
                    synchronized (map) {
                        if (this.gzipFileCache.containsKey(pathInfo)) {
                            content = this.gzipFileCache.get(pathInfo);
                        } else {
                            ByteArrayOutputStream bytes;
                            InputStream fileInputStream = this.servletContext.getResourceAsStream(pathInfo);
                            if (fileInputStream == null) {
                                fileInputStream = this.servletContext.getResourceAsStream(nonGzipPathInfo);
                                response.setHeader("Content-Encoding", "");
                                bytes = new ByteArrayOutputStream(0x100000);
                                int length = 0;
                                byte[] buf = new byte[65536];
                                while (length >= 0) {
                                    length = fileInputStream.read(buf);
                                    if (length <= 0) continue;
                                    bytes.write(buf, 0, length);
                                }
                                fileInputStream.close();
                                content = bytes.toByteArray();
                            } else {
                                bytes = new ByteArrayOutputStream(0x100000);
                                int length = 0;
                                byte[] buf = new byte[65536];
                                while (length >= 0) {
                                    length = fileInputStream.read(buf);
                                    if (length <= 0) continue;
                                    bytes.write(buf, 0, length);
                                }
                                fileInputStream.close();
                                content = bytes.toByteArray();
                                this.gzipFileCache.put(pathInfo, content);
                            }
                        }
                    }
                }
                response.setDateHeader("Last-Modified", this.startupTime);
                long modifiedSinceTime = httpreq.getDateHeader("If-Modified-Since");
                if (modifiedSinceTime + 1000L > this.startupTime) {
                    response.setStatus(304);
                } else {
                    ServletOutputStream servletOutputStream = res.getOutputStream();
                    servletOutputStream.write(content);
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
                return;
            }
        }
        fc.doFilter(req, res);
    }
}

