/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.servlets;

import com.ibm.ecm.extension.Plugin;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.PluginUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.util.MessageResources;

public class PluginServlet
extends HttpServlet {
    protected MessageResources resources;

    public void init(ServletConfig config) throws ServletException {
        this.resources = MessageResources.getMessageResources((String)"com.ibm.ecm.nls.ServicesMessages");
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.process(req, resp);
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Plugin plugin;
        String resourceId;
        String actionId;
        String pluginId;
        String methodName = "executeAction";
        Logger.logEntry((Object)this, methodName, (ServletRequest)request);
        String extra = request.getPathInfo();
        if (extra != null) {
            String[] parms = extra.split("/");
            pluginId = parms[1];
            actionId = parms[2];
            resourceId = parms[3];
            for (int i = 4; i < parms.length; ++i) {
                resourceId = resourceId + "/" + parms[i];
            }
        } else {
            pluginId = request.getParameter("plugin");
            actionId = request.getParameter("action");
            resourceId = request.getParameter("resource");
        }
        try {
            plugin = PluginUtil.getPlugin(request, pluginId);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (plugin == null) {
            Logger.logError((Object)this, methodName, (ServletRequest)request, "Invalid plugin id: " + pluginId + ".  This is likely a logic error in the plugin itself.");
        } else if ("getResource".equals(actionId)) {
            if (resourceId != null) {
                String packageName = plugin.getClass().getPackage().getName();
                if (packageName != null) {
                    while (packageName.indexOf(46) >= 0) {
                        int i = packageName.indexOf(46);
                        packageName = packageName.substring(0, i) + "/" + packageName.substring(i + 1);
                    }
                    resourceId = packageName + "/WebContent/" + resourceId;
                }
                resourceId = "/" + resourceId;
                URL resourceURL = plugin.getClass().getResource(resourceId);
                if (resourceURL == null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)request, "Missing resource" + resourceId + ".  This might be a logic error in the plugin.");
                    response.sendError(404);
                } else {
                    if (resourceId.toLowerCase().endsWith("html")) {
                        response.setContentType("text/html");
                    } else if (resourceId.toLowerCase().endsWith(".xml")) {
                        response.setContentType("text/xml");
                    } else if (resourceId.toLowerCase().endsWith(".css")) {
                        response.setContentType("text/css");
                    } else if (resourceId.toLowerCase().endsWith(".js")) {
                        response.setContentType("text/javascript");
                    } else if (resourceId.toLowerCase().endsWith(".json")) {
                        response.setContentType("text/json");
                    } else if (resourceId.toLowerCase().endsWith(".gif")) {
                        response.setContentType("image/gif");
                    } else if (resourceId.toLowerCase().endsWith(".jpg") || resourceId.toLowerCase().endsWith(".jpeg")) {
                        response.setContentType("image/jpeg");
                    } else if (resourceId.toLowerCase().endsWith(".png")) {
                        response.setContentType("image/png");
                    }
                    URLConnection resourceConnection = resourceURL.openConnection();
                    resourceConnection.setUseCaches(false);
                    InputStream resourceStream = resourceConnection.getInputStream();
                    if (resourceStream == null) {
                        Logger.logError((Object)this, methodName, (ServletRequest)request, "Invalid resource " + resourceId + ".  This is likely a logic error in the plugin.");
                    } else {
                        ServletOutputStream responseStream = response.getOutputStream();
                        byte[] buf = new byte[4096];
                        int len = resourceStream.read(buf);
                        while (len > 0) {
                            responseStream.write(buf, 0, len);
                            len = resourceStream.read(buf);
                        }
                        resourceStream.close();
                    }
                }
            }
        } else {
            PluginUtil.invokeService(plugin, actionId, request, response);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)request);
    }
}

