/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.servicability;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class ViewerLogger {
    private static final String appId = "CIWEB";
    private static final int LOG_ERROR = 1;
    private static final int LOG_WARNING = 2;
    private static final int LOG_INFO = 3;
    private static final int LOG_DEBUG = 4;
    private static final int LOG_ENTRY = 5;
    private static final int LOG_EXIT = 6;
    private static int level = 3;
    private static String[] _loggingIncludes = null;
    private static String[] _loggingExcludes = null;

    public static void setLogLevel(int level) {
        ViewerLogger.level = level;
    }

    public static int getLogLevel() {
        return level;
    }

    public static void setLogIncludes(String includes) {
        String methodName = "setLogIncludes";
        if (includes != null && includes.length() > 0) {
            String[] result = includes.split(",");
            _loggingIncludes = new String[result.length];
            int y = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result == null || result[i] == null || result[i].length() <= 0) continue;
                ViewerLogger._loggingIncludes[y++] = result[i];
                ViewerLogger.logDebug(ViewerLogger.class, methodName, "logging includes[" + i + "]: " + result[i]);
            }
        }
    }

    public static String[] getLoggingIncludes() {
        if (_loggingIncludes == null || _loggingIncludes.length == 0) {
            return null;
        }
        return _loggingIncludes;
    }

    public static void setLogExcludes(String excludes) {
        String methodName = "setLogExcludes";
        if (excludes != null && excludes.length() > 0) {
            String[] result = excludes.split(",");
            _loggingExcludes = new String[result.length];
            int y = 0;
            for (int i = 0; i < result.length; ++i) {
                if (result == null || result[i] == null || result[i].length() <= 0) continue;
                ViewerLogger._loggingExcludes[y++] = result[i];
                ViewerLogger.logDebug(ViewerLogger.class, methodName, "logging excludes[" + i + "]: " + result[i]);
            }
        }
    }

    public static String[] getLoggingExcludes() {
        if (_loggingExcludes == null || _loggingExcludes.length == 0) {
            return null;
        }
        return _loggingExcludes;
    }

    public static void logEntry(Object object, String methodName) {
        ViewerLogger._log(5, object, methodName, "", null);
    }

    public static void logEntry(Object object, String methodName, String message) {
        ViewerLogger._log(5, object, methodName, message, null);
    }

    public static void logExit(Object object, String methodName) {
        ViewerLogger._log(6, object, methodName, "", null);
    }

    public static void logExit(Object object, String methodName, String message) {
        ViewerLogger._log(6, object, methodName, message, null);
    }

    public static void logError(Object object, String methodName, String text, Throwable exception) {
        ViewerLogger._log(1, object, methodName, text, exception);
    }

    public static void logError(Object loggingObject, String loggingMethod, String text) {
        ViewerLogger._log(1, loggingObject, loggingMethod, text, null);
    }

    public static void logError(Object object, String methodName, Throwable exception) {
        ViewerLogger._log(1, object, methodName, null, exception);
    }

    public static void logWarning(Object loggingObject, String loggingMethod, String text) {
        ViewerLogger._log(2, loggingObject, loggingMethod, text, null);
    }

    public static void logInfo(Object loggingObject, String loggingMethod, String text) {
        ViewerLogger._log(3, loggingObject, loggingMethod, text, null);
    }

    public static boolean isDebugLogged() {
        return level >= 4;
    }

    public static void logDebug(Object loggingObject, String loggingMethod, String message) {
        ViewerLogger._log(4, loggingObject, loggingMethod, message, null);
    }

    private static void _log(int type, Object loggingObject, String loggingMethod, String text, Throwable exception) {
        if (type > level && level != 4) {
            return;
        }
        StringBuffer st = new StringBuffer();
        st.append(ViewerLogger.getFormattedDateTime()).append(appId).append(" ");
        if (type == 1) {
            st.append("Error: ");
        } else if (type == 2) {
            st.append("Warn : ");
        } else if (type == 3) {
            st.append("Info : ");
        } else if (type == 4) {
            st.append("Debug: ");
        } else if (type == 5) {
            st.append("Entry: ");
        } else if (type == 6) {
            st.append("Exit : ");
        }
        if (loggingObject != null) {
            String loggingObjectName = null;
            loggingObjectName = loggingObject instanceof Class ? ((Class)loggingObject).getName() : loggingObject.getClass().getName();
            st.append(loggingObjectName);
        }
        if (loggingMethod != null && loggingMethod.length() > 0) {
            st.append(".").append(loggingMethod);
        }
        st.append(" ");
        if (text != null) {
            st.append(text).append(" ");
        }
        String exceptionText = null;
        if (exception != null) {
            exceptionText = ViewerLogger.getStackTraceAsString(exception);
        }
        if (exceptionText != null) {
            if (text != null) {
                st.append("\n");
            }
            st.append(exceptionText);
        }
        text = st.toString();
        System.out.println(text);
    }

    public static String getStackTraceAsString(Throwable exception) {
        if (exception == null) {
            return null;
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(bytes, true);
        exception.printStackTrace(writer);
        return bytes.toString();
    }

    private static String getFormattedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("[MM/dd/yy HH:mm:ss:SSS z] ");
        format.setTimeZone(TimeZone.getDefault());
        return format.format(new Date());
    }
}

