/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security.p8;

import com.filenet.api.collection.AccessPermissionDescriptionList;
import com.filenet.api.collection.AccessPermissionList;
import com.filenet.api.collection.GroupSet;
import com.filenet.api.collection.IndependentObjectSet;
import com.filenet.api.collection.UserSet;
import com.filenet.api.constants.AccessType;
import com.filenet.api.constants.AutoUniqueName;
import com.filenet.api.constants.DefineSecurityParentage;
import com.filenet.api.constants.PrincipalSearchAttribute;
import com.filenet.api.constants.PrincipalSearchSortType;
import com.filenet.api.constants.PrincipalSearchType;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.SecurityPrincipalType;
import com.filenet.api.constants.SpecialPrincipal;
import com.filenet.api.core.Connection;
import com.filenet.api.core.CustomObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.ReferentialContainmentRelationship;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.FilterElement;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchSQL;
import com.filenet.api.query.SearchScope;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.AccessPermissionDescription;
import com.filenet.api.security.Group;
import com.filenet.api.security.Realm;
import com.filenet.api.security.SecurityPrincipal;
import com.filenet.api.util.Id;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.Subject;
import com.ibm.ecm.security.User;
import com.ibm.ecm.security.UserGroup;
import com.ibm.ecm.security.p8.P8AccessControlListData;
import com.ibm.ecm.serviceability.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8SecurityService
implements SecurityConstants {
    public static final String OWNER_ROLE_ID = "{335B6E5F-8E0D-4426-B548-B485DCF67CAA}";
    private Connection connection;
    private ObjectStore objectStore;
    private HttpServletRequest request;
    public String ROLE_CLASS = "Role";
    public String ROLE_PRIVS_PROPERTY = "Privileges";
    public String ROLE_NAME_PROPERTY = "RoleName";
    public String ROLE_TYPE_PROPERTY = "RoleType";
    public String DESCRIPTION_PROPERTY = "Description";
    public String SECURITY_ADAPTER_CLASS = "SecurityAdapter";
    public String SECURITY_ADAPTER_NAME_PROPERTY = "SecurityAdapterName";
    public String SECURITY_ADAPTER_OVP = "SecurityAdapter";
    public String ROLE_OVP_PERFIX = "Role";

    public P8SecurityService(HttpServletRequest request, Connection connection, ObjectStore objectStore) {
        this.connection = connection;
        this.objectStore = objectStore;
        this.request = request;
        this.ROLE_CLASS = "ClbRole";
        this.ROLE_PRIVS_PROPERTY = "ClbPrivileges";
        this.SECURITY_ADAPTER_CLASS = "ClbSecurityAdapter";
        this.SECURITY_ADAPTER_NAME_PROPERTY = "ClbSecurityAdapterName";
        this.SECURITY_ADAPTER_OVP = "ClbSecurityAdapter";
        this.ROLE_OVP_PERFIX = "ClbRole";
    }

    public List<UserGroup> findGroups(String searchString, Realm realm, PrincipalSearchSortType sortType) throws SecurityException {
        String methodName = "findGroups";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<UserGroup> groups = null;
        try {
            GroupSet groupSet = realm.findGroups(searchString, PrincipalSearchType.CONTAINS, PrincipalSearchAttribute.DISPLAY_NAME, sortType, Integer.valueOf(1), null);
            if (groupSet != null) {
                groups = new ArrayList<UserGroup>();
                Iterator groupIterator = groupSet.iterator();
                while (groupIterator.hasNext()) {
                    groups.add(this.createUserGroupObject((Group)groupIterator.next(), false, null));
                }
            }
        }
        catch (EngineRuntimeException e) {
            Logger.logError((Object)this, methodName, "Failed to search for groups with the string \"" + searchString + "\"", (Throwable)e);
            throw new SecurityException("Failed to search for groups with the string \"" + searchString + "\"", e, 1013);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return groups;
    }

    public List<User> findUsers(String searchString, Realm realm, PrincipalSearchSortType sortType) throws SecurityException {
        String methodName = "findUsers";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<User> users = null;
        try {
            UserSet userSet = realm.findUsers(searchString, PrincipalSearchType.CONTAINS, PrincipalSearchAttribute.DISPLAY_NAME, sortType, Integer.valueOf(1), null);
            if (userSet != null) {
                users = new ArrayList<User>();
                for (com.filenet.api.security.User user : userSet) {
                    users.add(new User(user.get_Id(), user.get_Name(), user.get_ShortName(), user.get_DisplayName(), user.get_Email(), null));
                }
            }
        }
        catch (EngineRuntimeException e) {
            Logger.logError((Object)this, methodName, "Failed to search for user with the string \"" + searchString + "\"", (Throwable)e);
            throw new SecurityException("Failed to search for users with the string \"" + searchString + "\"", e, 1011);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return users;
    }

    public User retrieveUser(String userId, boolean retrieveRoles, SecurityConstants.RoleType roleTypeFilter) throws SecurityException {
        String methodName = "retrieveUser";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        User user = null;
        try {
            Properties props;
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving user definition from P8.");
            SecurityPrincipal principal = Factory.SecurityPrincipal.fetchInstance((Connection)this.connection, (String)userId, null);
            if (principal != null && (props = principal.getProperties()) != null) {
                String id = props.getStringValue("Id");
                String shortName = props.getStringValue("ShortName");
                String userName = props.getStringValue("Name");
                String displayName = props.getStringValue("DisplayName");
                String emailAddress = props.getStringValue("Email");
                List<Role> roles = null;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieved user record. User=" + id + " | " + userName + " | " + shortName + " | " + displayName);
                if (retrieveRoles) {
                    roles = this.retrieveRolesByUser(userName, roleTypeFilter, false);
                }
                user = new User(id, userName, shortName, displayName, emailAddress, roles);
            }
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.E_OBJECT_NOT_FOUND) {
                Logger.logError((Object)this, methodName, "User \"" + user + "\" does not exist!", (Throwable)e);
                throw new SecurityException("User \"" + userId + "\" does not exist!", e, 1010);
            }
            Logger.logError((Object)this, methodName, "Failed to retrieve user \"" + userId + "\"!", (Throwable)e);
            throw new SecurityException(e, 1011);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return user;
    }

    public UserGroup retrieveUserGroup(String groupName, Realm realm, boolean retrieveRoles, SecurityConstants.RoleType roleTypeFilter) throws SecurityException {
        String methodName = "retrieveUserGroup";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        UserGroup userGroup = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving group \"" + groupName + "\".");
        try {
            Group group = Factory.Group.fetchInstance((Connection)this.connection, (String)groupName, null);
            userGroup = this.createUserGroupObject(group, retrieveRoles, roleTypeFilter);
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.E_OBJECT_NOT_FOUND) {
                Logger.logError((Object)this, methodName, "Group \"" + groupName + "\" does not exist!", (Throwable)e);
                throw new SecurityException("Group \"" + groupName + "\" does not exist!", e, 1012);
            }
            Logger.logError((Object)this, methodName, "Failed to retrieve group \"" + groupName + "\"!", (Throwable)e);
            throw new SecurityException(e, 1013);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return userGroup;
    }

    private UserGroup createUserGroupObject(Group group, boolean retrieveRoles, SecurityConstants.RoleType roleTypeFilter) throws SecurityException {
        String methodName = "createUserGroupObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<Subject> users = new ArrayList<Subject>();
        UserGroup userGroup = new UserGroup(group.get_Id(), group.get_Name(), group.get_ShortName(), group.get_DisplayName(), users, null);
        UserSet userSet = group.get_Users();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Walking list of users in group \"" + group.get_DisplayName() + "\".");
        for (com.filenet.api.security.User user : userSet) {
            String id = user.get_Id();
            String userName = user.get_Name();
            String shortName = user.get_ShortName();
            String displayName = user.get_DisplayName();
            String emailAddress = user.get_Email();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding user to group. User=" + id + " | " + userName + " | " + shortName + " | " + displayName);
            if (retrieveRoles) {
                users.add(new User(id, userName, shortName, displayName, emailAddress, this.retrieveRolesByUser(userName, roleTypeFilter, false)));
                continue;
            }
            users.add(new User(id, userName, shortName, displayName, emailAddress, null));
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return userGroup;
    }

    public Role createRoleTemplate(String name, String description, List<String> privileges, String rolesFolderName) throws SecurityException {
        Role role = new Role(null, name, description, privileges, null, SecurityConstants.RoleType.TEMPLATE);
        Folder rolesFolder = Factory.Folder.getInstance((ObjectStore)this.objectStore, (String)"Folder", (String)rolesFolderName);
        this.createRole(role, rolesFolder, null);
        return role;
    }

    public void createRole(Role role, Folder folder, AccessControlList secObjACL) throws SecurityException {
        String methodName = "createRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            List<String> privileges;
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Creating new custom object to represent the role \"" + role.getName() + "\"");
            CustomObject co = Factory.CustomObject.createInstance((ObjectStore)this.objectStore, (String)this.ROLE_CLASS);
            Properties props = co.getProperties();
            props.putValue(this.ROLE_NAME_PROPERTY, role.getName());
            props.putValue(this.ROLE_TYPE_PROPERTY, String.valueOf(role.getRoleType().getValue()));
            if (role.getDescription() != null) {
                props.putValue(this.DESCRIPTION_PROPERTY, role.getDescription());
            }
            if ((privileges = role.getPrivileges()) != null && privileges.size() > 0) {
                String privList = StringUtils.join(privileges, (String)",");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Setting user-defined privileges to: " + privList);
                props.putObjectValue(this.ROLE_PRIVS_PROPERTY, (Object)privList.getBytes("UTF-8"));
            }
            co.save(RefreshMode.REFRESH);
            HashMap<String, SecurityConstants.PrincipalType> assignees = role.getAssignees();
            if (assignees != null && assignees.size() > 0) {
                AccessPermissionList apl = co.get_Permissions();
                for (String key : assignees.keySet()) {
                    SecurityConstants.PrincipalType principalType = assignees.get(key);
                    if (principalType == SecurityConstants.PrincipalType.GROUP) {
                        this.addGroupToAccessPermissionList(apl, key, this.getAccessMaskFromRole(role), -1, AccessType.ALLOW);
                        continue;
                    }
                    this.addUserToAccessPermissionList(apl, key, this.getAccessMaskFromRole(role), -1, AccessType.ALLOW);
                }
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Saving new role \"" + role.getName() + "\"");
            PropertyFilter pfId = new PropertyFilter();
            pfId.addIncludeProperty(new FilterElement(null, null, null, "Id", null));
            pfId.setMaxRecursion(1);
            co.save(RefreshMode.REFRESH, pfId);
            String roleId = co.getProperties().getIdValue("Id").toString();
            role.setId(roleId);
            if (folder != null) {
                ReferentialContainmentRelationship rcr = Factory.ReferentialContainmentRelationship.createInstance((ObjectStore)this.objectStore, null, (AutoUniqueName)AutoUniqueName.NOT_AUTO_UNIQUE, (DefineSecurityParentage)DefineSecurityParentage.DO_NOT_DEFINE_SECURITY_PARENTAGE);
                rcr.set_ContainmentName(roleId);
                rcr.set_Head((IndependentObject)co);
                rcr.set_Tail((IndependentObject)folder);
                rcr.save(RefreshMode.NO_REFRESH);
            }
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode().equals(ExceptionCode.E_NOT_UNIQUE) || e.getExceptionCode().equals(ExceptionCode.DB_NOT_UNIQUE)) {
                Logger.logError((Object)this, methodName, "Role with name \"" + role.getName() + "\" already exists!", (Throwable)e);
                throw new SecurityException("Role with name \"" + role.getName() + "\" already exists!", e, 1020);
            }
            Logger.logError((Object)this, methodName, "Failed to create user role", (Throwable)e);
            throw new SecurityException("Failed to create user role!", e, 1021);
        }
        catch (Exception ex) {
            Logger.logError((Object)this, methodName, "Failed to create user role", (Throwable)ex);
            throw new SecurityException("Failed to create user role!", ex, 1021);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void deleteRole(String roleId) throws SecurityException {
        String methodName = "deleteRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            CustomObject roleObject = Factory.CustomObject.fetchInstance((ObjectStore)this.objectStore, (String)roleId, null);
            roleObject.delete();
            roleObject.save(RefreshMode.NO_REFRESH);
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                Logger.logError((Object)this, methodName, "Role with id \"" + roleId + "\" does not exist!", (Throwable)e);
                throw new SecurityException("Role with id \"" + roleId + "\" does not exist!", e, 1022);
            }
            Logger.logError((Object)this, methodName, "Failed to delete the user role!", (Throwable)e);
            throw new SecurityException("Failed to delete the user role!", e, 1024);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, "Failed to delete user role", (Throwable)e);
            throw new SecurityException("Failed to delete the user role!", e, 1024);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public Role retrieveRole(String roleId, boolean retrieveAllACEs) throws SecurityException {
        String methodName = "retrieveRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Role role = null;
        if (roleId != null) {
            try {
                CustomObject roleObject = Factory.CustomObject.fetchInstance((ObjectStore)this.objectStore, (String)roleId, null);
                role = this.createRoleObject((IndependentlyPersistableObject)roleObject, retrieveAllACEs);
            }
            catch (EngineRuntimeException e) {
                if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                    Logger.logError((Object)this, methodName, "Role with id \"" + roleId + "\" does not exist!", (Throwable)e);
                    throw new SecurityException("Role with id \"" + roleId + "\" does not exist!", e, 1022);
                }
                Logger.logError((Object)this, methodName, "Failed to retrieve the user role!", (Throwable)e);
                throw new SecurityException("Failed to retrieve the user role!", e, 1025);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return role;
    }

    public Role retrieveRoleByName(String roleName, boolean retrieveAllACEs) throws SecurityException {
        String methodName = "retrieveRoleByName";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Role role = null;
        SearchSQL sqlObject = new SearchSQL();
        sqlObject.setSelectList("*");
        sqlObject.setMaxRecords(100);
        sqlObject.setFromClauseInitialValue(this.ROLE_CLASS, "e", false);
        sqlObject.setWhereClause("e." + this.ROLE_NAME_PROPERTY + "='" + roleName + "'");
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Query to retrieve role objects=" + sqlObject.toString());
        SearchScope search = new SearchScope(this.objectStore);
        IndependentObjectSet myObjects = search.fetchObjects(sqlObject, Integer.valueOf(100), null, null);
        for (IndependentlyPersistableObject ipo : myObjects) {
            role = this.createRoleObject(ipo, retrieveAllACEs);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return role;
    }

    public void addPrincipalsToRole(String roleId, AccessControlList acl) throws SecurityException {
        String methodName = "addPrincipalsToRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            if (acl != null) {
                CustomObject roleObject = Factory.CustomObject.fetchInstance((ObjectStore)this.objectStore, (String)roleId, null);
                AccessPermissionList apl = roleObject.get_Permissions();
                for (AccessControlListData aclData : acl.getAclData()) {
                    P8AccessControlListData p8ACLData = (P8AccessControlListData)aclData;
                    if (p8ACLData.getType() == SecurityConstants.PrincipalType.USER) {
                        this.addUserToAccessPermissionList(apl, p8ACLData.getName(), p8ACLData.getAccessMask(), -1, AccessType.ALLOW);
                        continue;
                    }
                    if (p8ACLData.getType() != SecurityConstants.PrincipalType.GROUP) continue;
                    this.addGroupToAccessPermissionList(apl, p8ACLData.getName(), p8ACLData.getAccessMask(), -1, AccessType.ALLOW);
                }
                roleObject.set_Permissions(apl);
                roleObject.save(RefreshMode.REFRESH);
            }
        }
        catch (EngineRuntimeException e) {
            Logger.logError((Object)this, methodName, "Failed to create user role", (Throwable)e);
            if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                throw new SecurityException("Role with id \"" + roleId + "\" does not exist!", e, 1022);
            }
            throw new SecurityException("Failed to add subject to role \"" + roleId + "\"!", e, 1027);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void removePrincipalsFromRole(String roleId, List<String> principals) throws SecurityException {
        String methodName = "removePrincipalsFromRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            if (principals != null && principals.size() > 0) {
                CustomObject roleObject = Factory.CustomObject.fetchInstance((ObjectStore)this.objectStore, (String)roleId, null);
                AccessPermissionList apl = roleObject.get_Permissions();
                Iterator iter = apl.iterator();
                while (iter.hasNext()) {
                    AccessPermission ap = (AccessPermission)iter.next();
                    String granteeName = ap.get_GranteeName();
                    if (granteeName.equalsIgnoreCase(SpecialPrincipal.CREATOR_OWNER.getValue()) || granteeName.equalsIgnoreCase(SpecialPrincipal.AUTHENTICATED_USERS.getValue()) || !principals.contains(granteeName)) continue;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Removing user \"" + granteeName + "\" from role definition");
                    iter.remove();
                }
                roleObject.set_Permissions(apl);
                roleObject.save(RefreshMode.REFRESH);
            }
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                Logger.logError((Object)this, methodName, "Role with id \"" + roleId + "\" does not exist!", (Throwable)e);
                throw new SecurityException("Role with id \"" + roleId + "\" does not exist!", e, 1022);
            }
            Logger.logError((Object)this, methodName, "Failed to remove subjects from role \"" + roleId + "\"!", (Throwable)e);
            throw new SecurityException("Failed to remove subjects from role \"" + roleId + "\"!", e, 1027);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void applyACL(AccessControlList acl, AccessPermissionList apl) throws SecurityException {
        String methodName = "applyACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            List<AccessControlListData> aclData;
            if (acl != null && apl != null && (aclData = acl.getAclData()) != null && aclData.size() > 0) {
                ArrayList<String> curUsers = new ArrayList<String>();
                ArrayList<String> curGroups = new ArrayList<String>();
                for (AccessPermission ap : apl) {
                    if (ap == null || ap.getProperties() == null || !ap.getProperties().isPropertyPresent("GranteeName") || ap.get_GranteeName().equals(SpecialPrincipal.CREATOR_OWNER.getValue()) || ap.get_GranteeName().equals(SpecialPrincipal.AUTHENTICATED_USERS.getValue())) continue;
                    if (ap.getProperties().isPropertyPresent("GranteeType") && ap.get_GranteeType() == SecurityPrincipalType.GROUP) {
                        if (curGroups.contains(ap.get_GranteeName())) continue;
                        curGroups.add(ap.get_GranteeName());
                        continue;
                    }
                    if (curUsers.contains(ap.get_GranteeName())) continue;
                    curUsers.add(ap.get_GranteeName());
                }
                Collections.sort(curUsers);
                Collections.sort(curGroups);
                if (!curGroups.equals(acl.getGroupList()) || !curUsers.equals(acl.getUserList())) {
                    for (AccessControlListData aclDataObj : aclData) {
                        P8AccessControlListData aclDataP8 = (P8AccessControlListData)aclDataObj;
                        if (aclDataObj.getType() == SecurityConstants.PrincipalType.USER) {
                            this.addUserToAccessPermissionList(apl, aclDataP8.getName(), aclDataP8.getAccessMask(), aclDataP8.getInheritableDepth().getValue(), aclDataP8.getAccessType());
                            continue;
                        }
                        this.addGroupToAccessPermissionList(apl, aclDataP8.getName(), aclDataP8.getAccessMask(), aclDataP8.getInheritableDepth().getValue(), aclDataP8.getAccessType());
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, "Failed to apply access control list to object.", (Throwable)e);
            throw new SecurityException("Failed to apply access control list to object.", e, 1030);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public AccessControlList retrieveACL(IndependentlyPersistableObject ipo, boolean retrieveAllACEs) throws SecurityException {
        String methodName = "retrieveACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        AccessControlList acl = null;
        try {
            Properties props = ipo.getProperties();
            ClassDescription cd = ipo.get_ClassDescription();
            Hashtable<String, Integer> permissionMap = new Hashtable<String, Integer>();
            AccessPermissionDescriptionList apdl = cd.get_PermissionDescriptions();
            for (AccessPermissionDescription apd : apdl) {
                permissionMap.put(apd.get_DisplayName(), apd.get_AccessMask());
            }
            AccessPermissionList apl = (AccessPermissionList)props.getDependentObjectListValue("Permissions");
            ArrayList<Role> roles = new ArrayList<Role>();
            if (props.isPropertyPresent(this.SECURITY_ADAPTER_OVP)) {
                this.getRolesOnAdapter(props, roles, retrieveAllACEs);
            }
            ArrayList<AccessControlListData> aclData = new ArrayList<AccessControlListData>();
            for (AccessPermission ap : apl) {
                String name = ap.get_GranteeName();
                Integer accessMask = ap.get_AccessMask();
                SecurityPrincipalType secType = ap.get_GranteeType();
                P8AccessControlListData.InheritableDepth depth = P8AccessControlListData.InheritableDepth.getEnum(ap.get_InheritableDepth());
                if (secType == SecurityPrincipalType.UNKNOWN || retrieveAllACEs || depth == P8AccessControlListData.InheritableDepth.NONE || name.equalsIgnoreCase(SpecialPrincipal.CREATOR_OWNER.getValue()) || name.equalsIgnoreCase(SpecialPrincipal.AUTHENTICATED_USERS.getValue())) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding \"" + name + "\" with access mask=" + accessMask);
                P8AccessControlListData aclEntry = null;
                if (secType == SecurityPrincipalType.GROUP) {
                    aclEntry = new P8AccessControlListData(this.request, name, null, SecurityConstants.PrincipalType.GROUP, accessMask, depth, this.getPermissionsOnACE(permissionMap, accessMask), ap.get_AccessType());
                    aclData.add(aclEntry);
                } else if (secType == SecurityPrincipalType.USER) {
                    aclEntry = new P8AccessControlListData(this.request, name, null, SecurityConstants.PrincipalType.USER, accessMask, depth, this.getPermissionsOnACE(permissionMap, accessMask), ap.get_AccessType());
                    aclData.add(aclEntry);
                }
                if (aclEntry == null) continue;
                ArrayList<Role> aclEntryRoles = new ArrayList<Role>();
                for (Role role : roles) {
                    if (!role.getAssignees().containsKey(name)) continue;
                    aclEntryRoles.add(role);
                }
                aclEntry.setRoles(aclEntryRoles);
            }
            String id = props.getIdValue("Id").toString();
            acl = new AccessControlList(id, aclData);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, "Failed to retrieve access control list from object.", (Throwable)e);
            throw new SecurityException("Failed to retrieve access control list from object.", e, 1031);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return acl;
    }

    private List<String> getPermissionsOnACE(Hashtable<String, Integer> permissionMap, Integer accessMask) {
        ArrayList<String> permissions = new ArrayList<String>();
        Set<String> keys = permissionMap.keySet();
        for (String key : keys) {
            if ((accessMask & permissionMap.get(key)) != permissionMap.get(key)) continue;
            permissions.add(key);
        }
        return permissions;
    }

    private void getRolesOnAdapter(Properties props, List<Role> roles, boolean retrieveAllACEs) throws SecurityException {
        IndependentlyPersistableObject ipo;
        String methodName = "getRolesOnAdapter";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (props.isPropertyPresent(this.SECURITY_ADAPTER_OVP) && (ipo = (IndependentlyPersistableObject)props.getObjectValue(this.SECURITY_ADAPTER_OVP)) != null) {
            this.getRolesOnAdapter(ipo.getProperties(), roles, retrieveAllACEs);
        }
        for (int i = 1; i < 6; ++i) {
            IndependentlyPersistableObject ipo2;
            if (!props.isPropertyPresent(this.ROLE_OVP_PERFIX + i) || (ipo2 = (IndependentlyPersistableObject)props.getObjectValue(this.ROLE_OVP_PERFIX + i)) == null) continue;
            roles.add(this.createRoleObject(ipo2, retrieveAllACEs));
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void applyRolesToObject(String objectName, IndependentlyPersistableObject ipo, List<String> roleIds, AccessControlList secObjACL) throws SecurityException {
        String methodName = "applyRolesToObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Properties props = ipo.getProperties();
        String id = props.getIdValue("Id").toString();
        if (!props.isPropertyPresent(this.SECURITY_ADAPTER_OVP)) {
            throw new SecurityException("Object \"" + id + "\" does not have the object-value property \"" + this.SECURITY_ADAPTER_OVP + "\"! This is required to apply role-based security", 1029);
        }
        String adapterName = objectName + ".SEC_ADAPTER";
        IndependentlyPersistableObject adapter = this.createSecurityAdapter(adapterName, true, secObjACL);
        this.addRolesToAdapter(roleIds, adapter, adapterName, 1, secObjACL);
        adapter.save(RefreshMode.REFRESH);
        props.putObjectValue(this.SECURITY_ADAPTER_OVP, (Object)adapter);
        ipo.save(RefreshMode.REFRESH);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private void addRolesToAdapter(Collection<String> rolesToAdd, IndependentlyPersistableObject secAdapter, String adapterName, int adapterCount, AccessControlList secObjACL) throws SecurityException {
        String methodName;
        block4: {
            methodName = "addRolesToAdapter";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            try {
                if (rolesToAdd == null || rolesToAdd.size() <= 0) break block4;
                int propCount = 1;
                Object[] roles = rolesToAdd.toArray();
                PropertyFilter pf = new PropertyFilter();
                pf.addIncludeProperty(1, null, Boolean.valueOf(true), this.ROLE_CLASS, null);
                pf.addIncludeProperty(1, null, null, "Id", null);
                for (Object obj : roles) {
                    String role = (String)obj;
                    if (propCount >= 6) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Number of role objects exceeds the number of role OVPs available; creating a new security adapter for these role objects...");
                        String newAdapterName = adapterName + ++adapterCount;
                        IndependentlyPersistableObject ipo = this.createSecurityAdapter(newAdapterName, true, secObjACL);
                        this.addRolesToAdapter(rolesToAdd, ipo, adapterName, adapterCount, secObjACL);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding security adapter \"" + newAdapterName + "\" to security adapter \"" + adapterName + "\"...");
                        ipo.save(RefreshMode.REFRESH);
                        secAdapter.getProperties().putObjectValue(this.SECURITY_ADAPTER_OVP, (Object)ipo);
                        break;
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding role object \"" + role + "\" to object-valued property \"" + this.ROLE_OVP_PERFIX + propCount + "\"");
                    CustomObject ipo = Factory.CustomObject.fetchInstance((ObjectStore)this.objectStore, (Id)new Id(role), (PropertyFilter)pf);
                    secAdapter.getProperties().putObjectValue(this.ROLE_OVP_PERFIX + propCount, (Object)ipo);
                    ++propCount;
                    rolesToAdd.remove(role);
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, "Failed to apply roles to security adapter object!", (Throwable)e);
                throw new SecurityException("Failed to apply roles to security adapter object!", e, 1028);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void deleteSecurityObjectsFromIpo(IndependentlyPersistableObject ipo) throws SecurityException {
        String methodName = "deleteSecurityObjectsFromIpo";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Properties props = ipo.getProperties();
        if (props.isPropertyPresent(this.SECURITY_ADAPTER_OVP)) {
            IndependentlyPersistableObject adapter = (IndependentlyPersistableObject)props.getObjectValue(this.SECURITY_ADAPTER_OVP);
            this.deleteSecurityAdapter(adapter);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void deleteSecurityAdapter(IndependentlyPersistableObject securityAdapter) throws SecurityException {
        String methodName = "deleteSecurityAdapter";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            if (securityAdapter != null) {
                IndependentlyPersistableObject ipo;
                Properties props = securityAdapter.getProperties();
                if (props.isPropertyPresent(this.SECURITY_ADAPTER_OVP) && (ipo = (IndependentlyPersistableObject)props.getObjectValue(this.SECURITY_ADAPTER_OVP)) != null) {
                    this.deleteSecurityAdapter(ipo);
                }
                for (int i = 1; i < 6; ++i) {
                    IndependentlyPersistableObject ipo2;
                    if (!props.isPropertyPresent(this.ROLE_OVP_PERFIX + i) || (ipo2 = (IndependentlyPersistableObject)props.getObjectValue(this.ROLE_OVP_PERFIX + i)) == null) continue;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "deleting role object");
                    ipo2.delete();
                    ipo2.save(RefreshMode.NO_REFRESH);
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Deleting security adapter...");
                securityAdapter.delete();
                securityAdapter.save(RefreshMode.NO_REFRESH);
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, "Failed to delete security adapter!", (Throwable)e);
            throw new SecurityException("Failed to delete security adapter!", e, 1036);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public List<Role> retrieveRoles(SecurityConstants.RoleType roleTypeFilter, boolean retrieveAllACEs) throws SecurityException {
        String methodName = "retrieveRoles";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<Role> roles = new ArrayList<Role>();
        SearchSQL sqlObject = new SearchSQL();
        sqlObject.setSelectList("*");
        sqlObject.setMaxRecords(700);
        sqlObject.setFromClauseInitialValue(this.ROLE_CLASS, null, false);
        sqlObject.setOrderByClause(this.ROLE_NAME_PROPERTY);
        if (roleTypeFilter != null) {
            sqlObject.setWhereClause(this.ROLE_TYPE_PROPERTY + " = '" + roleTypeFilter.getValue() + "'");
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Query to retrieve role objects=" + sqlObject.toString());
        SearchScope search = new SearchScope(this.objectStore);
        IndependentObjectSet myObjects = search.fetchObjects(sqlObject, null, null, null);
        for (IndependentlyPersistableObject ipo : myObjects) {
            roles.add(this.createRoleObject(ipo, retrieveAllACEs));
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return roles;
    }

    public List<Role> retrieveRolesByUser(String user, SecurityConstants.RoleType roleTypeFilter, boolean retrieveAllACEs) throws SecurityException {
        String methodName = "retrieveRolesByUser";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<Role> roles = new ArrayList<Role>();
        SearchSQL sqlObject = new SearchSQL();
        sqlObject.setSelectList("*");
        sqlObject.setMaxRecords(100);
        sqlObject.setFromClauseInitialValue(this.ROLE_CLASS, "e", false);
        if (roleTypeFilter != null) {
            sqlObject.setWhereClause("e." + this.ROLE_TYPE_PROPERTY + " = '" + roleTypeFilter.getValue() + "'");
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "role query=" + sqlObject.toString());
        SearchScope search = new SearchScope(this.objectStore);
        IndependentObjectSet myObjects = search.fetchObjects(sqlObject, Integer.valueOf(100), null, null);
        for (IndependentlyPersistableObject ipo : myObjects) {
            Role role = this.createRoleObject(ipo, retrieveAllACEs);
            if (!role.getAssignees().containsKey(user)) continue;
            roles.add(role);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return roles;
    }

    private Role createRoleObject(IndependentlyPersistableObject ipo, boolean retrieveAllACEs) throws SecurityException {
        String[] strPrivs;
        String privs;
        byte[] privBytes;
        String methodName = "createRoleObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        int objectStoreAccessAllowed = this.objectStore.getAccessAllowed();
        Integer accessAllowed = ipo.getAccessAllowed();
        ArrayList<String> privileges = new ArrayList<String>();
        if ((accessAllowed & 0x10000) > 0 && (objectStoreAccessAllowed & 0x800000) > 0) {
            privileges.add("privDelete");
        }
        Properties props = ipo.getProperties();
        String id = props.getIdValue("Id").toString();
        String roleName = props.getStringValue(this.ROLE_NAME_PROPERTY);
        String description = "";
        if (props.isPropertyPresent(this.DESCRIPTION_PROPERTY)) {
            description = props.getStringValue(this.DESCRIPTION_PROPERTY);
        }
        SecurityConstants.RoleType roleType = SecurityConstants.RoleType.TEMPLATE;
        if (props.isPropertyPresent(this.ROLE_TYPE_PROPERTY)) {
            roleType = SecurityConstants.RoleType.getEnum(Integer.parseInt(props.getStringValue(this.ROLE_TYPE_PROPERTY)));
        }
        ArrayList<String> lPrivs = new ArrayList<String>();
        if (props.isPropertyPresent(this.ROLE_PRIVS_PROPERTY) && (privBytes = props.getBinaryValue(this.ROLE_PRIVS_PROPERTY)) != null && (privs = new String(privBytes)) != null && (strPrivs = privs.split(",")).length > 0) {
            for (int i = 0; i < strPrivs.length; ++i) {
                if (lPrivs.contains(strPrivs[i])) continue;
                lPrivs.add(strPrivs[i]);
            }
        }
        HashMap<String, SecurityConstants.PrincipalType> assignees = new HashMap<String, SecurityConstants.PrincipalType>();
        AccessControlList acl = this.retrieveACL(ipo, retrieveAllACEs);
        for (AccessControlListData aclData : acl.getAclData()) {
            P8AccessControlListData p8AclData = (P8AccessControlListData)aclData;
            assignees.put(p8AclData.getName(), p8AclData.getType());
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        if (id != null && roleName != null) {
            Role role = new Role(id, roleName, description, lPrivs, assignees, roleType);
            role.setCurrentUserPrivileges(privileges);
            return role;
        }
        return null;
    }

    private int getAccessMaskFromRole(Role role) {
        int accessMask = 0;
        List<String> rolePrivileges = role.getPrivileges();
        for (String privilege : rolePrivileges) {
            Integer privMask = (Integer)p8PrivilegeMap.get(privilege);
            if (privMask == null) continue;
            accessMask |= privMask.intValue();
        }
        return accessMask;
    }

    private String addUserToAccessPermissionList(AccessPermissionList apl, String user, Integer accessMask, int inheritDepth, AccessType accessType) {
        String methodName = "addUserToAccessPermissionList";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logError((Object)this, methodName, (ServletRequest)this.request, "adding user with id=" + user);
        String userId = null;
        AccessPermission ap = Factory.AccessPermission.createInstance();
        SecurityPrincipal principal = Factory.SecurityPrincipal.fetchInstance((Connection)this.connection, (String)user, null);
        if (principal != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Granting user \"" + user + "\" access mask \"" + accessMask + "\".");
            userId = principal.getProperties().getStringValue("Id");
            ap.set_GranteeName(principal.getProperties().getStringValue("Name"));
            ap.set_AccessType(accessType);
            ap.set_AccessMask(accessMask);
            ap.set_InheritableDepth(Integer.valueOf(inheritDepth));
            apl.add((Object)ap);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return userId;
    }

    private void addGroupToAccessPermissionList(AccessPermissionList apl, String groupName, Integer accessMask, int inheritDepth, AccessType accessType) {
        String methodName = "addGroupToAccessPermissionList";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        AccessPermission ap = Factory.AccessPermission.createInstance();
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Granting user \"" + groupName + "\" access mask \"" + accessMask + "\".");
        ap.set_GranteeName(groupName);
        ap.set_AccessType(accessType);
        ap.set_AccessMask(accessMask);
        ap.set_InheritableDepth(Integer.valueOf(inheritDepth));
        apl.add((Object)ap);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    private IndependentlyPersistableObject createSecurityAdapter(String adapterName, boolean deleteIfExists, AccessControlList secObjACL) throws SecurityException {
        String methodName = "createSecurityAdapter";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        IndependentlyPersistableObject ipo = this.getSecurityAdapterByName(adapterName);
        if (ipo != null && deleteIfExists) {
            this.deleteSecurityAdapter(ipo);
        }
        if (ipo == null) {
            CustomObject co = Factory.CustomObject.createInstance((ObjectStore)this.objectStore, (String)this.SECURITY_ADAPTER_CLASS);
            Properties props = co.getProperties();
            props.putValue(this.SECURITY_ADAPTER_NAME_PROPERTY, adapterName);
            co.save(RefreshMode.REFRESH);
            this.applyACL(secObjACL, co.get_Permissions());
            co.save(RefreshMode.NO_REFRESH);
            ipo = co;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return ipo;
    }

    private IndependentlyPersistableObject getSecurityAdapterByName(String adapterName) {
        String methodName = "getSecurityAdapterByName";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        SearchSQL sqlObject = new SearchSQL();
        sqlObject.setSelectList("*");
        sqlObject.setMaxRecords(1);
        sqlObject.setFromClauseInitialValue(this.SECURITY_ADAPTER_CLASS, "e", false);
        sqlObject.setWhereClause("e." + this.SECURITY_ADAPTER_NAME_PROPERTY + " = '" + adapterName + "'");
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Query to retrieve role objects=" + sqlObject.toString());
        SearchScope search = new SearchScope(this.objectStore);
        IndependentObjectSet myObjects = search.fetchObjects(sqlObject, Integer.valueOf(1), null, null);
        Iterator iter = myObjects.iterator();
        IndependentlyPersistableObject ipo = null;
        while (iter.hasNext()) {
            ipo = (IndependentlyPersistableObject)iter.next();
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return ipo;
    }

    public boolean isMemberOfGroup(String userId, String groupName, Realm realm) throws SecurityException {
        String methodName = "isMemberOfGroup";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            UserSet userSet = realm.findUsers(userId, PrincipalSearchType.EXACT, PrincipalSearchAttribute.SHORT_NAME, PrincipalSearchSortType.NONE, Integer.valueOf(1), null);
            for (com.filenet.api.security.User user : userSet) {
                GroupSet groupSet = user.get_MemberOfGroups();
                for (Group agroup : groupSet) {
                    String shortGroupName = agroup.get_ShortName();
                    if (shortGroupName == null || !shortGroupName.equalsIgnoreCase(groupName)) continue;
                    return true;
                }
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
            return false;
        }
        catch (EngineRuntimeException e) {
            if (e.getExceptionCode() == ExceptionCode.E_OBJECT_NOT_FOUND) {
                Logger.logError((Object)this, methodName, "User \"" + userId + "\" does not exist!", (Throwable)e);
                throw new SecurityException("User \"" + userId + "\" does not exist!", e, 1010);
            }
            Logger.logError((Object)this, methodName, "Failed to retrieve user \"" + userId + "\"!", (Throwable)e);
            throw new SecurityException(e, 1011);
        }
    }
}

