/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security.p8;

import com.filenet.api.constants.AccessType;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P8AccessControlListData
extends AccessControlListData {
    private Integer accessMask;
    private List<String> permissions;
    private HttpServletRequest request = null;
    private InheritableDepth inheritableDepth;
    private AccessType accessType;

    public P8AccessControlListData(HttpServletRequest request, String name, List<Role> roles, SecurityConstants.PrincipalType type, Integer accessMask, InheritableDepth inheritableDepth, List<String> permissions, AccessType accessType) {
        super(name, roles, type);
        this.accessMask = accessMask;
        this.inheritableDepth = inheritableDepth;
        this.accessType = accessType;
        this.permissions = permissions;
        this.request = request;
    }

    public P8AccessControlListData(JSONObject json) {
        super("", null, SecurityConstants.PrincipalType.USER);
        String methodName = "P8AccessControlListData";
        ServletRequest request = null;
        Set keys = json.keySet();
        for (String key : keys) {
            JSONArray jsonArray;
            if (key.equalsIgnoreCase("name")) {
                this.name = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("type")) {
                try {
                    this.type = SecurityConstants.PrincipalType.getEnum((Integer)json.get(key));
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, request, (Throwable)e);
                }
                continue;
            }
            if (key.equalsIgnoreCase("roles")) {
                this.roles = new ArrayList();
                jsonArray = (JSONArray)json.get(key);
                for (Object obj : jsonArray) {
                    this.roles.add(new Role((JSONObject)obj));
                }
                continue;
            }
            if (key.equalsIgnoreCase("accessMask")) {
                try {
                    this.accessMask = (int)((Integer)json.get(key));
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, request, (Throwable)e);
                }
                continue;
            }
            if (key.equalsIgnoreCase("accessType")) {
                try {
                    this.accessType = AccessType.getInstanceFromInt((int)((Integer)json.get(key)));
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, request, (Throwable)e);
                }
                continue;
            }
            if (key.equalsIgnoreCase("inheritableDepth")) {
                try {
                    this.inheritableDepth = InheritableDepth.getEnum((Integer)json.get(key));
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, request, (Throwable)e);
                }
                continue;
            }
            if (!key.equalsIgnoreCase("permissions")) continue;
            this.permissions = new ArrayList<String>();
            jsonArray = (JSONArray)json.get(key);
            for (Object obj : jsonArray) {
                this.permissions.add((String)obj);
            }
        }
    }

    public Integer getAccessMask() {
        return this.accessMask;
    }

    public void setAccessMask(Integer accessMask) {
        this.accessMask = accessMask;
    }

    public InheritableDepth getInheritableDepth() {
        return this.inheritableDepth;
    }

    public void setInheritableDepth(InheritableDepth inheritableDepth) {
        this.inheritableDepth = inheritableDepth;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    @Override
    public JSONObject toJSON() {
        String methodName = "toJSON";
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("name", this.name);
        jsonObj.put("type", (Object)this.type.getValue());
        jsonObj.put("accessMask", this.accessMask);
        jsonObj.put("accessType", (Object)this.accessType.getValue());
        jsonObj.put("inheritableDepth", (Object)this.inheritableDepth.getValue());
        JSONArray jsonArray = new JSONArray();
        jsonObj.put("roles", jsonArray);
        if (this.roles != null && this.roles.size() > 0) {
            for (Role role : this.roles) {
                jsonArray.add(role.toJSON());
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "add role: " + role.getId() + ", " + role.getDescription());
            }
        }
        JSONArray jsonArray2 = new JSONArray();
        jsonObj.put("permissions", jsonArray2);
        if (this.permissions != null && this.permissions.size() > 0) {
            for (String permission : this.permissions) {
                jsonArray2.add(permission);
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Returning JSON: " + jsonObj.toString());
        return jsonObj;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InheritableDepth {
        NONE{

            public int getValue() {
                return 0;
            }
        }
        ,
        ONE_LEVEL{

            public int getValue() {
                return 1;
            }
        }
        ,
        ALL_LEVELS{

            public int getValue() {
                return -1;
            }
        };


        public abstract int getValue();

        public static InheritableDepth getEnum(int value) throws Exception {
            for (InheritableDepth inheritableDepth : InheritableDepth.values()) {
                if (inheritableDepth.getValue() != value) continue;
                return inheritableDepth;
            }
            throw new SecurityException("Unsupported inheritable depth type!", 1000);
        }
    }
}

