/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security.cm8;

import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.User;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CM8User
extends User {
    private Role privSet;
    private List<String> groups;

    public CM8User(String id, String name, String shortName, String displayName, List<Role> roles) {
        super(id, name, shortName, displayName, null, roles);
        this.privSet = null;
    }

    public CM8User(String id, String name, String shortName, String displayName, List<Role> roles, Role privSet) {
        super(id, name, shortName, displayName, null, roles);
        this.privSet = privSet;
    }

    public CM8User(JSONObject json) {
        super(json);
        if (json.get("privSet") != null) {
            JSONObject obj = (JSONObject)json.get("privSet");
            this.privSet = new Role(obj);
        }
    }

    public Role getPrivSet() {
        return this.privSet;
    }

    public void setPrivSet(Role privSet) {
        this.privSet = privSet;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", this.id);
        jsonObj.put("name", this.name);
        jsonObj.put("shortName", this.shortName);
        jsonObj.put("displayName", this.displayName);
        if (this.privSet != null) {
            jsonObj.put("privSet", this.privSet.toJSON());
        }
        JSONArray jsonArray = new JSONArray();
        jsonObj.put("roles", jsonArray);
        if (this.roles != null) {
            for (Role role : this.roles) {
                jsonArray.add(role.toJSON());
            }
        }
        JSONArray jsonArray2 = new JSONArray();
        jsonArray2.addAll(this.getMaxPrivileges());
        jsonObj.put("maxPrivs", jsonArray2);
        return jsonObj;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("User: id=").append(this.id).append(" | name: ").append(this.name).append(" | short name: ").append(this.shortName).append(" | display name: ").append(this.displayName).append(" | privilege set=");
        if (this.privSet != null) {
            sb.append(this.privSet.toString());
        }
        sb.append("\n\tRoles: ");
        if (this.roles != null && this.roles.size() > 0) {
            for (Role role : this.roles) {
                if (role == null) continue;
                sb.append("\n\t").append(role.toString());
            }
        }
        return sb.toString();
    }

    @Override
    public CM8User clone() throws CloneNotSupportedException {
        CM8User clone = (CM8User)super.clone();
        ArrayList<Role> clonedRoles = new ArrayList<Role>();
        for (Role role : this.roles) {
            clonedRoles.add(role.clone());
        }
        clone.roles = clonedRoles;
        clone.privSet = this.privSet.clone();
        return clone;
    }
}

