/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security.cm8;

import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.HashCalculator;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.cm8.CM8AccessControlListData;
import com.ibm.ecm.security.cm8.CM8SecurityService;
import com.ibm.ecm.security.cm8.CM8User;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.mm.sdk.common.DKDatastoreAdminICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKUserMgmtICM;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CM8SecurityUtils {
    private static String CM_FULL_ACCESS_MASK = "984531";
    private static String CM_EDIT_ACCESS_MASK = "132563";
    private static String CM_FULL_ACCESS_FOLDER_MASK = "984883";
    private static String CM_EDIT_ACCESS_FOLDER_MASK = "132915";
    private static Map<String, Integer> cmPrivilegeMaskMap = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 5517555209352222936L;
        {
            this.put("modifyFolderPermissions", 262144);
            this.put("deleteFolders", 65536);
            this.put("modifyFolderProperties", 1478);
            this.put("createSubfolders", 512);
            this.put("fileInFolders", 48);
            this.put("viewItemProperties", 131073);
            this.put("modifyItemPermissions", 786432);
            this.put("deleteItems", 65536);
            this.put("modifyContent", 64);
            this.put("modifyItemProperties", 1298);
            this.put("viewContent", 128);
            this.put("addNewSearches", 1330);
            this.put("createItems", 512);
            this.put("shareSearches", null);
            this.put("addRemoveClassesOrEntryTemplates", 1330);
            this.put("addRemoveRoleParticipants", new Integer(787762));
        }
    };

    public static AccessControlList getPermissionsFromJSON(HttpServletRequest request, JSONArray jsonPermissions, DKDatastoreICM dsICM, SecurityConstants.AppPrivilegeSets creatorPrivSet) throws Exception {
        String methodName = " getPermissionsFromJSON";
        Logger.logEntry(CM8SecurityUtils.class, methodName, (ServletRequest)request);
        AccessControlList acl = null;
        if (jsonPermissions != null) {
            acl = CM8SecurityUtils.createAclFromJson(request, jsonPermissions, dsICM, creatorPrivSet);
        }
        Logger.logExit(CM8SecurityUtils.class, methodName, (ServletRequest)request);
        return acl;
    }

    public static String generatePrivSetNameHash(List<String> privList) throws Exception {
        if (privList != null) {
            StringBuffer sb = new StringBuffer();
            for (String priv : privList) {
                sb.append(priv);
            }
            return HashCalculator.calculateHash(new ByteArrayInputStream(sb.toString().getBytes()), "MD5");
        }
        return "";
    }

    public static String getSecurityPrivKeyfromValues(List<String> privs) {
        String key = null;
        for (Map.Entry<String, List<String>> entry : SecurityConstants.cm8PrivilegeMap.entrySet()) {
            List<String> entryValue = entry.getValue();
            if (!entryValue.containsAll(privs)) continue;
            key = entry.getKey();
            break;
        }
        return key;
    }

    public static List<String> getMappedPrivileges(List<String> privs, boolean hasItemSuperAccessPrivilege, boolean isOwner) {
        ArrayList<String> mappedPrivs = new ArrayList<String>();
        if (privs.contains("addRemoveRoleParticipants") && privs.contains("ItemSetUserAttr") || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("addRemoveRoleParticipants");
        }
        if (privs.contains("addRemoveClasses") && privs.contains("ItemSetUserAttr") || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("addRemoveClassesOrEntryTemplates");
        }
        if (privs.contains("shareSearches") || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("shareSearches");
        }
        if (privs.contains("addNewSearches") && privs.contains("ItemSetUserAttr") || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("addNewSearches");
        }
        if (isOwner || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("privOwner");
        }
        if (privs.contains("ItemSetUserAttr") || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("privEdit");
        }
        if (privs.contains("ItemDelete") || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("privDelete");
        }
        if (privs.contains("ItemSetUserAttr") && privs.contains("ItemCheckInOut") || hasItemSuperAccessPrivilege) {
            mappedPrivs.add("modifyFolderProperties");
        }
        return mappedPrivs;
    }

    protected static AccessControlList createAclFromJson(HttpServletRequest request, JSONArray permissionJSONArray, DKDatastoreICM dsICM, SecurityConstants.AppPrivilegeSets creatorPrivSet) throws Exception {
        String methodName = "createAclFromJson";
        Logger.logEntry(CM8SecurityUtils.class, methodName, (ServletRequest)request);
        ArrayList<AccessControlListData> aclData = new ArrayList<AccessControlListData>();
        AccessControlList secObjACL = new AccessControlList("", aclData);
        if (permissionJSONArray.size() > 0) {
            ArrayList<String> privileges = new ArrayList<String>();
            for (int i = 0; i < permissionJSONArray.size(); ++i) {
                ArrayList<Role> roles = new ArrayList<Role>();
                JSONObject permission = (JSONObject)permissionJSONArray.get(i);
                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "permission: " + permission);
                String userOrGroup = permission.get("granteeName").toString();
                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "userOrGroup: " + userOrGroup);
                Object roleName = permission.get("roleName");
                if (!(roleName == null || ((String)roleName).equalsIgnoreCase(SecurityConstants.AppPrivilegeSets.OWNER.getValue()) || ((String)roleName).equalsIgnoreCase(SecurityConstants.AppPrivilegeSets.EDIT.getValue()) || ((String)roleName).equalsIgnoreCase(SecurityConstants.AppPrivilegeSets.READ.getValue()) || ((String)roleName).equalsIgnoreCase(SecurityConstants.AppPrivilegeSets.TEAMSPACE.getValue()))) {
                    Role role = new Role((String)roleName, (String)roleName, (String)roleName, null, (String)roleName);
                    roles.add(role);
                    if (permission.get("granteeType").toString().equals("2001")) {
                        aclData.add(new CM8AccessControlListData(request, userOrGroup, roles, SecurityConstants.PrincipalType.GROUP, role));
                        continue;
                    }
                    aclData.add(new CM8AccessControlListData(request, userOrGroup, roles, SecurityConstants.PrincipalType.USER, role));
                    continue;
                }
                String secMask = permission.get("accessMask").toString();
                SecurityConstants.AppPrivilegeSets privSetVal = SecurityConstants.AppPrivilegeSets.READ;
                if (secMask.equals(CM_FULL_ACCESS_MASK) || secMask.equals(CM_FULL_ACCESS_FOLDER_MASK)) {
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "secMask equals full access");
                    privSetVal = SecurityConstants.AppPrivilegeSets.OWNER;
                } else if (secMask.equals(CM_EDIT_ACCESS_MASK) || secMask.equals(CM_EDIT_ACCESS_FOLDER_MASK)) {
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "secMask equals edit");
                    privSetVal = SecurityConstants.AppPrivilegeSets.EDIT;
                }
                Role role = new Role(privSetVal.getValue(), privSetVal.getValue(), privSetVal.getValue(), privileges, privSetVal.getValue());
                if (userOrGroup.equals("#AUTHENTICATED-USERS")) {
                    DKDatastoreDefICM _dsDef = (DKDatastoreDefICM)dsICM.datastoreDef();
                    DKDatastoreAdminICM _dsAdmin = (DKDatastoreAdminICM)_dsDef.datastoreAdmin();
                    DKUserMgmtICM _dsUserMgmt = (DKUserMgmtICM)_dsAdmin.userManagement();
                    String[] userNames = _dsUserMgmt.listUserNames();
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Number of users: " + userNames.length);
                    roles.add(role);
                    for (int counter = 0; counter < userNames.length; ++counter) {
                        if (dsICM.getUserName().equalsIgnoreCase(userNames[counter])) {
                            Role fullRole = new Role(SecurityConstants.AppPrivilegeSets.OWNER.getValue(), SecurityConstants.AppPrivilegeSets.OWNER.getValue(), SecurityConstants.AppPrivilegeSets.OWNER.getValue(), privileges, SecurityConstants.AppPrivilegeSets.OWNER.getValue());
                            roles.add(fullRole);
                            aclData.add(new CM8AccessControlListData(request, userNames[counter], roles, SecurityConstants.PrincipalType.USER, fullRole));
                            continue;
                        }
                        aclData.add(new CM8AccessControlListData(request, userNames[counter], roles, SecurityConstants.PrincipalType.USER, role));
                    }
                    continue;
                }
                if (permission.get("granteeType").toString().equals("2001")) {
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Adding user group \"" + userOrGroup + "\" to ACL \"" + userOrGroup + "\".");
                    roles.add(role);
                    aclData.add(new CM8AccessControlListData(request, userOrGroup, roles, SecurityConstants.PrincipalType.GROUP, role));
                    continue;
                }
                if (userOrGroup.equals("#CREATOR-OWNER")) {
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Add cm owner name");
                    permission.put("granteeName", dsICM.getUserName());
                    role = new Role(creatorPrivSet.getValue(), creatorPrivSet.getValue(), creatorPrivSet.getValue(), privileges, creatorPrivSet.getValue());
                    role.setOwner(true);
                    roles.add(role);
                    userOrGroup = dsICM.getUserName().toUpperCase();
                } else {
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Add read only role");
                    roles.add(role);
                }
                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Add : " + userOrGroup);
                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Logged on user is : " + dsICM.getUserName());
                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Role is owner : " + role.isOwner());
                if (!secObjACL.contains(userOrGroup)) {
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "adding : " + userOrGroup);
                    aclData.add(new CM8AccessControlListData(request, userOrGroup, roles, SecurityConstants.PrincipalType.USER, role));
                    continue;
                }
                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, userOrGroup + " already in ACLRule... not adding.  ");
            }
        }
        Logger.logExit(CM8SecurityUtils.class, methodName, (ServletRequest)request);
        return secObjACL;
    }

    public static JSONObject createJSONFromACL(HttpServletRequest request, DKDatastoreICM dsICM, AccessControlList acl, boolean isFolder, boolean isItemTypeLevelSec, boolean hasSetACLPriv) {
        boolean hasUpdatePriv;
        JSONArray jsonPermissions;
        JSONObject jsonObj;
        String methodName;
        block21: {
            methodName = "createJSONFromACL";
            jsonObj = new JSONObject();
            jsonPermissions = new JSONArray();
            hasUpdatePriv = hasSetACLPriv;
            List<String> groupNames = null;
            try {
                if (acl == null) break block21;
                if (!hasSetACLPriv) {
                    CM8SecurityService securityService = new CM8SecurityService(request, dsICM);
                    try {
                        Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Checking to see if the logged on user is a CM8 super user...");
                        CM8User usrObj = (CM8User)securityService.retrieveUser(dsICM.getUserName());
                        groupNames = usrObj.getGroups();
                        for (Role role : usrObj.getRoles()) {
                            if (!role.getId().equals("AllPrivs".toUpperCase())) continue;
                            Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "User " + dsICM.getUserName() + " is CM8 super user");
                            hasUpdatePriv = true;
                        }
                    }
                    catch (Exception ex) {
                        Logger.logError(CM8SecurityUtils.class, methodName, (ServletRequest)request, (Throwable)ex);
                    }
                }
                List<AccessControlListData> aclData = acl.getAclData();
                for (AccessControlListData aclDataEntry : aclData) {
                    CM8AccessControlListData cm8AclEntry = (CM8AccessControlListData)aclDataEntry;
                    boolean hasGroup = cm8AclEntry.getType() == SecurityConstants.PrincipalType.GROUP && groupNames != null && groupNames.contains(cm8AclEntry.getName());
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "cm8AclEntry name: " + cm8AclEntry.getName());
                    JSONObject jsonPermission = new JSONObject();
                    jsonPermission.put("id", aclDataEntry.getName());
                    jsonPermission.put("granteeName", aclDataEntry.getName());
                    jsonPermission.put("displayName", aclDataEntry.getName());
                    if (aclDataEntry.getType() == SecurityConstants.PrincipalType.GROUP) {
                        jsonPermission.put("granteeType", "2001");
                    } else {
                        jsonPermission.put("granteeType", "2000");
                    }
                    Role role = cm8AclEntry.getPrivSet();
                    jsonPermission.put("roleName", role.getName());
                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "role name: " + role.getName());
                    Integer accessMask = 0;
                    if (role.getPrivileges().containsAll(SecurityConstants.CM8_OWNER_PRIVS)) {
                        if (cm8AclEntry.getName().equalsIgnoreCase(dsICM.getUserName()) || hasGroup) {
                            hasUpdatePriv = true;
                        }
                        accessMask = isFolder ? Integer.valueOf(Integer.parseInt(CM_FULL_ACCESS_FOLDER_MASK)) : Integer.valueOf(Integer.parseInt(CM_FULL_ACCESS_MASK));
                    } else {
                        for (String key : SecurityConstants.cm8PrivilegeMap.keySet()) {
                            List<String> privs = SecurityConstants.cm8PrivilegeMap.get(key);
                            if (role.getPrivileges().containsAll(privs)) {
                                Integer cmAccessMask = cmPrivilegeMaskMap.get(key);
                                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "key: " + key + "for  cmAccessMask:" + cmAccessMask);
                                if (cmAccessMask == null) continue;
                                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "key:" + key);
                                if (isFolder && SecurityConstants.folderPrivilegeList.contains(key)) {
                                    accessMask = accessMask | cmAccessMask;
                                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "contains folder key: " + key + "updating mask cmAccessMask:" + cmAccessMask + " Accessmask: " + accessMask);
                                } else if (!isFolder && SecurityConstants.docPrivilegeList.contains(key)) {
                                    accessMask = accessMask | cmAccessMask;
                                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "contains key: " + key + "updating mask cmAccessMask:" + cmAccessMask + " Accessmask: " + accessMask);
                                } else {
                                    Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "does not contain : " + key);
                                }
                                if (!key.equals("modifyItemPermissions") || !cm8AclEntry.getName().equalsIgnoreCase(dsICM.getUserName()) && !hasGroup) continue;
                                hasUpdatePriv = true;
                                continue;
                            }
                            Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Role does not contain all of the following");
                            Iterator<String> iterator = privs.iterator();
                            Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "priv key:" + key);
                            while (iterator.hasNext()) {
                                Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "priv:" + iterator.next());
                            }
                        }
                    }
                    jsonPermission.put("accessMask", accessMask);
                    jsonPermission.put("accessType", "1");
                    jsonPermission.put("inheritableDepth", "0");
                    jsonPermission.put("permissionSource", "0");
                    jsonPermissions.add(jsonPermission);
                }
            }
            catch (Exception e) {
                Logger.logError(CM8SecurityUtils.class, methodName, (ServletRequest)request, (Throwable)e);
            }
        }
        jsonObj.put("acl", jsonPermissions);
        Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "hasUpdatePriv:" + hasUpdatePriv);
        if (isItemTypeLevelSec) {
            jsonObj.put("modifyPermissions", "false");
        } else {
            jsonObj.put("modifyPermissions", new Boolean(hasUpdatePriv).toString());
        }
        Logger.logDebug(CM8SecurityUtils.class, methodName, (ServletRequest)request, "Returning JSON:" + jsonObj.toString());
        Logger.logExit(CM8SecurityUtils.class, methodName, (ServletRequest)request);
        return jsonObj;
    }
}

