/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security.cm8;

import com.ibm.ecm.beans.cm.CMQueryService;
import com.ibm.ecm.security.AccessControlList;
import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.HashCalculator;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SecurityException;
import com.ibm.ecm.security.Subject;
import com.ibm.ecm.security.User;
import com.ibm.ecm.security.UserGroup;
import com.ibm.ecm.security.cm8.CM8AccessControlListData;
import com.ibm.ecm.security.cm8.CM8User;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.ecm.util.cm.CMBaseUtil;
import com.ibm.mm.sdk.common.DKACLData;
import com.ibm.mm.sdk.common.DKAccessControlListICM;
import com.ibm.mm.sdk.common.DKAdminDomainDefICM;
import com.ibm.mm.sdk.common.DKAdminDomainsMgmtICM;
import com.ibm.mm.sdk.common.DKAlreadyExistException;
import com.ibm.mm.sdk.common.DKAuthorizationMgmtICM;
import com.ibm.mm.sdk.common.DKCommonPrivilege;
import com.ibm.mm.sdk.common.DKDDO;
import com.ibm.mm.sdk.common.DKDatastoreAdminICM;
import com.ibm.mm.sdk.common.DKDatastoreDefICM;
import com.ibm.mm.sdk.common.DKException;
import com.ibm.mm.sdk.common.DKNVPair;
import com.ibm.mm.sdk.common.DKNotExistException;
import com.ibm.mm.sdk.common.DKPidICM;
import com.ibm.mm.sdk.common.DKPrivilegeICM;
import com.ibm.mm.sdk.common.DKPrivilegeSetICM;
import com.ibm.mm.sdk.common.DKRetrieveOptionsICM;
import com.ibm.mm.sdk.common.DKSequentialCollection;
import com.ibm.mm.sdk.common.DKUsageError;
import com.ibm.mm.sdk.common.DKUserDefICM;
import com.ibm.mm.sdk.common.DKUserGroupDefICM;
import com.ibm.mm.sdk.common.DKUserMgmtICM;
import com.ibm.mm.sdk.common.dkAccessControlList;
import com.ibm.mm.sdk.common.dkCollection;
import com.ibm.mm.sdk.common.dkDataObject;
import com.ibm.mm.sdk.common.dkDatastore;
import com.ibm.mm.sdk.common.dkDatastoreExt;
import com.ibm.mm.sdk.common.dkDatastoreIntICM;
import com.ibm.mm.sdk.common.dkIterator;
import com.ibm.mm.sdk.common.dkPrivilege;
import com.ibm.mm.sdk.common.dkPrivilegeSet;
import com.ibm.mm.sdk.common.dkResultSetCursor;
import com.ibm.mm.sdk.common.dkUserDef;
import com.ibm.mm.sdk.common.dkUserGroupDef;
import com.ibm.mm.sdk.server.DKDatastoreICM;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CM8SecurityService
implements SecurityConstants {
    public static List<Role> TEMP_SYSTEM_ROLES = new ArrayList<Role>();
    private HttpServletRequest request;
    private DKDatastoreICM dsICM;

    public CM8SecurityService(HttpServletRequest request, DKDatastoreICM dsICM) {
        this.dsICM = dsICM;
        this.request = request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<User> listUsers(String searchString) throws SecurityException {
        List<User> users = null;
        DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
        try {
            String[] userNames = userMgmt.listUserNames();
            if (userNames != null && userNames.length <= 0) return users;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return users;
    }

    public User retrieveUser(String userId) throws SecurityException {
        CM8User user = null;
        DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
        try {
            DKUserDefICM userDef = (DKUserDefICM)userMgmt.retrieveUserDef(userId);
            if (userDef == null) {
                throw new SecurityException("User \"" + userId + "\" does not exist!", 1010);
            }
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            if (userDef != null) {
                String userName = userDef.getName();
                ArrayList<Role> roles = new ArrayList<Role>();
                String desc = userDef.getDescription();
                if (desc == null || desc.length() == 0) {
                    desc = userName;
                }
                user = new CM8User(userName, userName, null, desc, roles);
                ArrayList<String> groups = new ArrayList<String>();
                for (Object obj : userDef.getGroups()) {
                    dkUserGroupDef groupDef = (dkUserGroupDef)obj;
                    groups.add(groupDef.getName());
                }
                user.setGroups(groups);
                if (this.hasItemSuperAccessPrivilege(userDef)) {
                    ArrayList<String> privs = new ArrayList<String>();
                    dkCollection col = authorMgmt.listPrivileges();
                    dkIterator iter = col.createIterator();
                    while (iter.more()) {
                        dkPrivilege dkPriv = (dkPrivilege)iter.next();
                        privs.add(dkPriv.getName());
                    }
                    user.getRoles().add(new Role("AllPrivs".toUpperCase(), null, "AllPrivs", privs));
                }
                dkPrivilegeSet dkPrivSet = authorMgmt.retrievePrivilegeSet(userDef.getPrivSetName());
                user.setPrivSet(new Role(userDef.getPrivSetName().toUpperCase(), null, userDef.getPrivSetName(), Arrays.asList(dkPrivSet.listPrivilegeNames())));
            }
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (DKNotExistException de) {
            throw new SecurityException("User \"" + userId + "\" does not exist!", 1010);
        }
        catch (Exception e) {
            throw new SecurityException(e, 1011);
        }
        return user;
    }

    public UserGroup retrieveUserGroup(String groupName) throws SecurityException {
        UserGroup userGroup = null;
        try {
            DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
            dkUserGroupDef groupDef = userMgmt.retrieveUserGroupDef(groupName);
            if (groupDef == null) {
                throw new SecurityException("Group \"" + groupName + "\" does not exist!", 1012);
            }
            dkCollection userCol = groupDef.listUsers();
            ArrayList<Subject> userList = new ArrayList<Subject>();
            dkIterator userIter = userCol.createIterator();
            while (userIter.more()) {
                DKUserDefICM cmUser = (DKUserDefICM)userIter.next();
                String userName = cmUser.getName();
                userList.add(this.retrieveUser(userName));
            }
            userGroup = new UserGroup(groupDef.getName(), groupDef.getName(), null, groupDef.getDescription(), userList, null);
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (DKNotExistException de) {
            throw new SecurityException("Group \"" + groupName + "\" does not exist!", 1012);
        }
        catch (Exception e) {
            throw new SecurityException(e, 1013);
        }
        return userGroup;
    }

    public void createUserGroup(UserGroup userGroup) throws SecurityException {
        if (userGroup != null) {
            try {
                DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
                dkUserGroupDef groupDef = userMgmt.createUserGroupDef();
                groupDef.setName(userGroup.getName());
                groupDef.setDescription(userGroup.getDisplayName());
                if (userGroup.getUsers() != null && userGroup.getUsers().size() > 0) {
                    for (Subject user : userGroup.getUsers()) {
                        dkUserDef userDef = userMgmt.retrieveUserDef(user.getId());
                        groupDef.addUser(userDef);
                    }
                }
                userMgmt.add(groupDef);
            }
            catch (DKAlreadyExistException de) {
                throw new SecurityException("Group already exists!", 1015);
            }
            catch (Exception e) {
                throw new SecurityException(e, 1014);
            }
        }
    }

    public void deleteUserGroup(String groupName) throws SecurityException {
        if (groupName != null) {
            try {
                DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
                userMgmt.delUserGroup(groupName);
            }
            catch (DKNotExistException de) {
                throw new SecurityException(de, 1012);
            }
            catch (Exception e) {
                throw new SecurityException(e, 1016);
            }
        }
    }

    public String createRoleTemplate(Role role) throws SecurityException {
        role.setRoleType(SecurityConstants.RoleType.TEMPLATE);
        String id = this.createRole(role);
        return id;
    }

    private String getPrivsetNameFromRole(Role role) {
        String methodName = "getPrivsetNameFromRole";
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "role.getPrivSetName() = " + role.getPrivSetName());
        return role.getPrivSetName();
    }

    public String createRole(Role userRole) throws SecurityException {
        String methodName = "createRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        String privSetName = this.getPrivsetNameFromRole(userRole);
        Role role = null;
        String pid = null;
        try {
            role = this.retrieveRoleByName(userRole.getRoleType(), userRole.getName());
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (role != null) {
            DKPrivilegeSetICM dkPrivSet = null;
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Attempting to retrieve privilege set \"" + privSetName + "\".");
                dkPrivSet = (DKPrivilegeSetICM)authorMgmt.retrievePrivilegeSet(privSetName);
            }
            catch (Exception e) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "PrivSet does not exit");
                dkPrivSet = null;
            }
            if (dkPrivSet != null) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The privilege set and Role already exists.");
                throw new SecurityException("Role \"" + userRole.getId() + "\" already exists!", 1020);
            }
        }
        try {
            this.createPrivilegeSet(privSetName, userRole.getName(), userRole.getPrivileges());
            pid = role == null ? this.createRoleDDO(userRole, privSetName) : role.getId();
        }
        catch (DKUsageError e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, "message: " + e.getMessage());
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Error code: " + e.errorCode());
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new SecurityException("Failed to create user role!", e, e.errorCode());
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new SecurityException("Failed to create user role!", e, 1021);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return pid;
    }

    public Role retrieveRole(String id) throws SecurityException {
        String methodName = "retrieveRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Role role = null;
        try {
            if (this.dsICM != null && this.dsICM.isConnected()) {
                DKDDO icmddo = this.dsICM.createDDOFromPID(id);
                try {
                    DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.dsICM);
                    dkRetrieveOptions.baseAttributes(true);
                    dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                    DKPidICM pid = (DKPidICM)icmddo.getPidObject();
                    if (pid.getVersionNumber().equals("0")) {
                        pid.setVersionNumber("1");
                        dkRetrieveOptions.functionVersionLatest(true);
                    }
                    icmddo.retrieve(dkRetrieveOptions.dkNVPair());
                    role = this.createRoleObject(icmddo);
                }
                catch (DKException dke1) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)dke1);
                }
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        }
        catch (Throwable e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, e);
            throw new SecurityException("Failed to retrieve the role !", e, 1020);
        }
        return role;
    }

    private String createRoleDDO(Role userRole, String rolePrivSetName) throws Exception {
        String methodName = "createRoleDDO";
        DKDDO roleDDO = this.dsICM.createDDO("ICMRole", 4);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "userRole.getName() : " + userRole.getName());
        roleDDO.setData(roleDDO.dataId("ATTR", "ICM$NAME"), (Object)userRole.getName());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "userRole.getDescription() : " + userRole.getDescription());
        roleDDO.setData(roleDDO.dataId("ATTR", "clbDescription"), (Object)userRole.getDescription());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "userRole.getRoleType() : " + userRole.getRoleType().getValue());
        roleDDO.setData(roleDDO.dataId("ATTR", "clbRoleType"), (Object)new Integer(userRole.getRoleType().getValue()));
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "privSetName : " + userRole.getName().toUpperCase());
        roleDDO.setData(roleDDO.dataId("ATTR", "clbPrivSetName"), (Object)rolePrivSetName);
        this.dsICM.addObject((dkDataObject)roleDDO, 0);
        return roleDDO.getPidObject().pidString();
    }

    public void deleteRoleObject(String roleId) throws SecurityException {
        String methodName = "deleteRoleObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "Delete role  " + roleId);
            if (this.dsICM != null && this.dsICM.isConnected()) {
                DKDDO icmddo = this.dsICM.createDDOFromPID(roleId);
                DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.dsICM);
                dkRetrieveOptions.baseAttributes(true);
                dkRetrieveOptions.basePropertyCheckedOutDetails(true);
                DKPidICM pid = (DKPidICM)icmddo.getPidObject();
                if (pid.getVersionNumber().equals("0")) {
                    pid.setVersionNumber("1");
                    dkRetrieveOptions.functionVersionLatest(true);
                }
                icmddo.retrieve(dkRetrieveOptions.dkNVPair());
                String userid = null;
                try {
                    userid = (String)icmddo.getPropertyByName("Checked_Out_UserID");
                }
                catch (DKUsageError e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
                if (userid == null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking checkout");
                    this.dsICM.checkOut((dkDataObject)icmddo);
                } else {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Item is checked out");
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Invoking deleteObject");
                this.dsICM.deleteObject((dkDataObject)icmddo, -1);
            }
            Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        }
        catch (DKUsageError e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, "message: " + e.getMessage());
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Error code: " + e.errorCode());
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new SecurityException("Failed to create user role!", e, e.errorCode());
        }
        catch (Exception e) {
            throw new SecurityException("Failed to delete the role !", e, 1024);
        }
    }

    public void deleteRole(Role userRole) throws SecurityException {
        String methodName = "deleteRole";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            Role role = this.retrieveRoleByName(null, userRole.getName());
            if (role == null) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Could not find the role in the ICMRole table");
                throw new SecurityException("Role \"" + userRole.getName() + "\" does not exist!", 1022);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "role.getId(): " + role.getId());
            this.deleteRoleObject(role.getId());
        }
        catch (Exception e) {
            throw new SecurityException("Failed to delete the user role!", e, 1024);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public List<String> retrieveICMPrivsFromPrivSet(String privilegeSetName) throws SecurityException {
        String methodName = "retrievePrivsFromPrivSet";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        List<String> privs = null;
        try {
            String[] privNames;
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            dkPrivilegeSet privSet = authorMgmt.getPrivilegeSet(privilegeSetName);
            if (privSet != null && (privNames = privSet.listPrivilegeNames()) != null) {
                privs = Arrays.asList(privNames);
            }
        }
        catch (DKNotExistException de) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)de);
            throw new SecurityException("Role \"" + privilegeSetName + "\" does not exist!", 1022);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new SecurityException(e, 1025);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return privs;
    }

    private void dumpList(List<String> list, String listType) {
        String methodName = "dumpList";
        for (String item : list) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, listType + "  has item : " + item);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, listType + " ---------------------------------------- ");
    }

    public List<String> retrievePrivsFromPrivSet(String privilegeSetName) throws SecurityException {
        String methodName = "retrievePrivsFromPrivSet";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        ArrayList<String> privs = new ArrayList<String>();
        try {
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            dkPrivilegeSet privSet = authorMgmt.getPrivilegeSet(privilegeSetName);
            if (privSet != null) {
                String[] privNames = privSet.listPrivilegeNames();
                List<String> privNamesArray = Arrays.asList(privNames);
                this.dumpList(privNamesArray, "privNamesFromPrivSet");
                for (Map.Entry entry : cm8PrivilegeMap.entrySet()) {
                    List entryValue = (List)entry.getValue();
                    if (privNamesArray.containsAll(entryValue)) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entryValue : " + entryValue + "   does contain:  " + privNamesArray);
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entry.getKey(): " + (String)entry.getKey());
                        privs.add((String)entry.getKey());
                        continue;
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "entryValue : " + entryValue + "   does not contain:  " + privNamesArray);
                }
            } else {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Could not find privset: " + privilegeSetName);
            }
        }
        catch (DKNotExistException de) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)de);
            throw new SecurityException("Role \"" + privilegeSetName + "\" does not exist!", 1022);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new SecurityException(e, 1025);
        }
        this.dumpList(privs, "clientPrivs");
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return privs;
    }

    public List<Role> retrieveRoles(SecurityConstants.RoleType roleTypeFilter, boolean retrieveAllACEs) throws SecurityException {
        String methodName = "retrieveRoles";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        List<Role> roles = this.retrieveRoles(roleTypeFilter);
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return roles;
    }

    private DKCommonPrivilege getCommonPrivilege(DKDDO privDDO, dkDatastoreExt dsExt) throws Exception {
        String methodName = "getCommonPrivilege";
        DKCommonPrivilege commonPrivilege = null;
        if (privDDO != null) {
            try {
                commonPrivilege = dsExt.getCommonItemPrivilege((dkDataObject)privDDO);
            }
            catch (RuntimeException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return commonPrivilege;
    }

    private Role createRoleObject(DKDDO ddo) throws SecurityException {
        String methodName = "createRoleObject";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Role role = null;
        try {
            dkDatastoreExt dsExt = (dkDatastoreExt)this.dsICM.getExtension("DATASTORE_EXTENSION");
            DKCommonPrivilege privilege = this.getCommonPrivilege(ddo, dsExt);
            boolean privDelete = CMBaseUtil.checkAuthorization(privilege, 27);
            ArrayList<String> privileges = new ArrayList<String>();
            if (privDelete) {
                privileges.add("privDelete");
            }
            String id = ddo.getPidObject().pidString();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "id = " + id);
            String roleName = (String)ddo.getDataByName("ICM$NAME");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "roleName = " + roleName);
            String roleDescription = (String)ddo.getDataByName("clbDescription");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "roleDescription = " + roleDescription);
            String rolePrivSetName = (String)ddo.getDataByName("clbPrivSetName");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "rolePrivSetName = " + rolePrivSetName);
            Integer roleType = (Integer)ddo.getDataByName("clbRoleType");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "roleType = " + roleType);
            List<String> privs = this.retrievePrivsFromPrivSet(rolePrivSetName);
            role = new Role(id, roleName, roleDescription, privs, rolePrivSetName);
            role.setRoleType(SecurityConstants.RoleType.getEnum(roleType));
            role.setCurrentUserPrivileges(privileges);
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            throw new SecurityException("Failed to retrieve role", e, 1031);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Role retrieveRoleByName(SecurityConstants.RoleType roleTypeFilter, String roleName) throws SecurityException {
        block19: {
            methodName = "retrieveRoleByName";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            role = null;
            cursor = null;
            queryString = null;
            queryString = roleTypeFilter != null ? "/ICMRole[@clbRoleType=" + roleTypeFilter.getValue() + " AND @" + "ICM$NAME" + "=\"" + roleName + "\"]" : "/ICMRole[@ICM$NAME=\"" + roleName + "\"]";
            try {
                block18: {
                    cursor = this.runQuery(queryString);
                    ddo = cursor.fetchNext();
                    if (ddo == null) break block18;
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Found the role: " + roleName);
                    role = this.createRoleObject(ddo);
                }
                var9_10 = null;
                ** if (cursor == null) goto lbl-1000
            }
            catch (Throwable var8_22) {
                var9_13 = null;
                if (cursor != null) {
                    try {
                        cursor.destroy();
                    }
                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                }
                throw var8_22;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    cursor.destroy();
                }
                catch (DKException e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
            }
lbl-1000:
            // 2 sources

            {
                break block19;
                catch (DKException e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    var9_11 = null;
                    if (cursor != null) {
                        try {
                            cursor.destroy();
                        }
                        catch (DKException e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                    }
                    break block19;
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    var9_12 = null;
                    if (cursor != null) {
                        try {
                            cursor.destroy();
                        }
                        catch (DKException e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                        catch (Exception e) {
                            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        }
                    }
                }
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Role> retrieveRoles(SecurityConstants.RoleType roleTypeFilter) throws SecurityException {
        block17: {
            methodName = "retrieveRoles";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            roles = new ArrayList<Role>();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "type: " + roleTypeFilter.getValue());
            cursor = null;
            queryString = "/ICMRole[@clbRoleType=\"" + roleTypeFilter.getValue() + "\"]";
            try {
                cursor = this.runQuery(queryString);
                role = null;
                while ((ddo = cursor.fetchNext()) != null) {
                    role = this.createRoleObject(ddo);
                    roles.add(role);
                }
                var9_10 = null;
                if (cursor == null) break block17;
                ** GOTO lbl60
            }
            catch (DKException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                var9_11 = null;
                if (cursor != null) {
                    try {
                        cursor.destroy();
                    }
                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                }
                break block17;
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                var9_12 = null;
                if (cursor != null) {
                    ** try [egrp 2[TRYBLOCK] [6, 7 : 186->196)] { 
lbl39:
                    // 1 sources

                    cursor.destroy();
lbl41:
                    // 1 sources

                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
lbl44:
                    // 1 sources

                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                }
                break block17;
            }
            {
                catch (Throwable var8_22) {
                    var9_13 = null;
                    if (cursor == null) throw var8_22;
                    ** try [egrp 2[TRYBLOCK] [6, 7 : 186->196)] { 
lbl52:
                    // 1 sources

                    cursor.destroy();
                    throw var8_22;
lbl54:
                    // 1 sources

                    catch (DKException e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                        throw var8_22;
                    }
lbl57:
                    // 1 sources

                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                    }
                    throw var8_22;
                }
lbl60:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [6, 7 : 186->196)] { 
lbl61:
                // 1 sources

                cursor.destroy();
lbl63:
                // 1 sources

                catch (DKException e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
lbl66:
                // 1 sources

                catch (Exception e) {}
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return roles;
    }

    protected dkResultSetCursor runQuery(String queryString) {
        String methodName = "runQuery";
        dkResultSetCursor cursor = null;
        try {
            DKRetrieveOptionsICM dkRetrieveOptions = DKRetrieveOptionsICM.createInstance((dkDatastoreIntICM)this.dsICM);
            dkRetrieveOptions.baseAttributes(true);
            dkRetrieveOptions.functionVersionLatest(true);
            dkRetrieveOptions.basePropertyCheckedOutDetails(true);
            dkRetrieveOptions.linksTypeFilter("DKFolder");
            DKNVPair[] options = new DKNVPair[]{new DKNVPair("MAX_RESULTS", (Object)"0"), new DKNVPair("RETRIEVE_OPTION", (Object)dkRetrieveOptions), new DKNVPair("End", null)};
            CMQueryService query = new CMQueryService(this.request, this.dsICM);
            cursor = query.execute(queryString, options);
        }
        catch (Exception e) {
            Logger.logError((Object)this, "runQuery", (ServletRequest)this.request, "Error executing query " + e.getMessage());
            Logger.logError((Object)this, "runQuery", (ServletRequest)this.request, (Throwable)e);
        }
        return cursor;
    }

    private DKAccessControlListICM findOrCreate(DKAuthorizationMgmtICM dsAclMgmt, DKAccessControlListICM dkAcl, AccessControlList acl, boolean alwaysCreateNew, boolean isTeamspace) throws DKException, Exception {
        String methodName = "findOrCreate";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ACL name=" + dkAcl.getName());
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "alwaysCreateNew= " + alwaysCreateNew);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "isTeamspace=" + isTeamspace);
        String[] existingAclNames = null;
        if (!alwaysCreateNew) {
            existingAclNames = dsAclMgmt.search((dkAccessControlList)dkAcl);
        }
        if (existingAclNames != null && existingAclNames.length > 0) {
            for (int i = 0; i < existingAclNames.length; ++i) {
                dkAcl = (DKAccessControlListICM)dsAclMgmt.retrieveAccessControlList(existingAclNames[i]);
                if (isTeamspace && dkAcl.getDescription().startsWith("clbTeamspace")) {
                    Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
                    return dkAcl;
                }
                if (isTeamspace || dkAcl.getDescription().startsWith("clbTeamspace")) continue;
                Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
                return dkAcl;
            }
        }
        boolean done = false;
        int retryCount = 2;
        while (!done && retryCount > 0) {
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Create new acl with name= " + dkAcl.getName());
                DKSequentialCollection collection = this.getAdminDomain(this.dsICM.getUserName());
                if (collection != null) {
                    dkAcl.setAdminDomains((dkCollection)collection);
                }
                dsAclMgmt.add((dkAccessControlList)dkAcl);
                done = true;
            }
            catch (Exception e) {
                if (retryCount == 0) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Failed to add ACL after several retries");
                    throw e;
                }
                --retryCount;
                String aclName = dkAcl.getName();
                aclName = aclName + new Date().getTime();
                dkAcl.setName(HashCalculator.calculateHash(new ByteArrayInputStream(aclName.getBytes()), "MD5"));
            }
            Thread.sleep(200L);
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ACL was added");
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return dkAcl;
    }

    public void deleteAllUserACLs() throws SecurityException {
        String methodName = "deleteAllUserACLs";
        try {
            DKDatastoreDefICM dsDef = (DKDatastoreDefICM)this.dsICM.datastoreDef();
            DKDatastoreAdminICM dsAdmin = (DKDatastoreAdminICM)dsDef.datastoreAdmin();
            DKAuthorizationMgmtICM dsAclMgmt = (DKAuthorizationMgmtICM)dsAdmin.authorizationMgmt();
            dkCollection coll = dsAclMgmt.listUserAccessControlLists((short)1);
            dkIterator it = coll.createIterator();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Has user ACLs " + it.more());
            while (it.more()) {
                DKAccessControlListICM tAcl = (DKAccessControlListICM)it.next();
                this.printACL(tAcl);
                try {
                    dsAclMgmt.del((dkAccessControlList)tAcl);
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
        }
    }

    public DKAccessControlListICM createACL(AccessControlList acl, boolean alwaysCreateNew, boolean isTeamspace) throws SecurityException {
        String methodName = "createACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKAccessControlListICM retAcl = null;
        if (acl != null) {
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Create ACL \"" + acl.getName() + "\"...");
                DKAuthorizationMgmtICM dsAclMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
                DKAccessControlListICM dkACL = new DKAccessControlListICM((dkDatastore)this.dsICM);
                dkACL.setACLType((short)1);
                dkACL.setName(acl.getName());
                this.addACLDataToDKACL(acl.getAclData(), dkACL);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ACL Id: " + dkACL.getID());
                retAcl = this.findOrCreate(dsAclMgmt, dkACL, acl, alwaysCreateNew, isTeamspace);
                this.printACL(retAcl);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "dsAclMgmt.retrieveAccessControlList");
            }
            catch (DKAlreadyExistException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                throw new SecurityException("ACL \"" + acl.getName() + "\" already exist!", e, 1034);
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                throw new SecurityException("Failed to update ACL \"" + acl.getName(), e, 1033);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return retAcl;
    }

    private void printACL(DKAccessControlListICM acl) throws DKException, Exception {
        String methodName = "printACL";
        if (acl != null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "  ACL = " + acl.getName() + " (" + acl.getDescription() + ")");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Contains " + acl.getACLType() + " type");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "ID " + acl.getID());
            dkCollection coll = acl.listACLData();
            dkIterator iter = coll.createIterator();
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Has user data " + iter.more());
            while (iter.more()) {
                DKACLData aclData = (DKACLData)iter.next();
                DKPrivilegeSetICM _privSet = (DKPrivilegeSetICM)aclData.getPrivilegeSet();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + _privSet + " --> " + _privSet.getName());
                short patronType = aclData.getPatronType();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + patronType + " --> " + patronType);
                String usrGrpName = aclData.getUserGroupName();
                if (patronType == 0) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + usrGrpName + " --> " + _privSet.getName());
                    continue;
                }
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "    " + usrGrpName + " --> " + _privSet.getName());
            }
        }
    }

    public DKAccessControlListICM updateACL(AccessControlList acl, String aclName) throws SecurityException {
        String methodName = "updateACL(";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKAccessControlListICM dkACL = null;
        if (acl != null) {
            try {
                DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
                dkACL = (DKAccessControlListICM)authorMgmt.retrieveAccessControlList(aclName);
                dkCollection col = dkACL.listACLData();
                dkIterator iter = col.createIterator();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Clearing existing acl data...");
                while (iter.more()) {
                    DKACLData dkACLData = (DKACLData)iter.next();
                    dkACL.removeACLData(dkACLData);
                }
                this.addACLDataToDKACL(acl.getAclData(), dkACL);
                authorMgmt.update((dkAccessControlList)dkACL);
            }
            catch (DKNotExistException e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                throw new SecurityException("ACL \"" + acl.getName() + "\" does not exist!", e, 1035);
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                throw new SecurityException("Failed to update ACL \"" + acl.getName(), e, 1032);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return dkACL;
    }

    public AccessControlList setACL(AccessControlList acl, DKDDO ddo, boolean alwaysCreateNewACL, boolean isTeamspace) throws SecurityException {
        String methodName = "applyACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKAccessControlListICM retAcl = null;
        AccessControlList aclObj = null;
        if (acl != null && ddo != null) {
            try {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "could not find the ACL.... about to create it");
                retAcl = this.createACL(acl, alwaysCreateNewACL, isTeamspace);
                short propertyID = ddo.propertyId("SYSROOTATTRS.ACLCODE");
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "set acl property name:  " + retAcl.getName() + " with id: " + retAcl.getID());
                ddo.setProperty(propertyID, (Object)retAcl.getName());
                aclObj = this.createACLfromDKACL((dkAccessControlList)retAcl);
            }
            catch (SecurityException se) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)se);
                throw se;
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                throw new SecurityException("Failed to apply ACL \"" + acl.getName() + "\" to item \"" + ddo.getPidObject().toString() + "\".", e, 1030);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return aclObj;
    }

    public AccessControlList retrieveACL(DKDDO ddo) throws SecurityException {
        AccessControlList acl;
        String methodName;
        block5: {
            methodName = " retrieveACL";
            Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
            acl = null;
            try {
                if (ddo == null) break block5;
                String aclName = null;
                try {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "retrieve ACL property from ddo");
                    short propertyID = ddo.propertyId("SYSROOTATTRS.ACLCODE");
                    aclName = (String)ddo.getProperty(propertyID);
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "aclName: " + aclName);
                }
                catch (Exception e) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "No ACL property found. Setting Item object ACL to null.");
                }
                if (aclName != null) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving ACL \"" + aclName + "\"...");
                    acl = this.retrieveACL(aclName);
                }
            }
            catch (Exception e) {
                Logger.logError(this, methodName, (ServletRequest)this.request, "Failed to retrieve ACL for item \"\".", e);
                throw new SecurityException("Failed to retrieve ACL for item \"" + ddo.getPidObject().toString() + "\".", e, 1031);
            }
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return acl;
    }

    public AccessControlList retrieveACL(String aclName) throws SecurityException {
        String methodName = "retrieveACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        AccessControlList acl = null;
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving ACL \"" + aclName + "\"...");
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            dkAccessControlList dkACL = authorMgmt.retrieveAccessControlList(aclName);
            acl = this.createACLfromDKACL(dkACL);
        }
        catch (Exception e) {
            Logger.logError(this, methodName, (ServletRequest)this.request, "Failed to retrieve ACL \"" + aclName + "\".", e);
            throw new SecurityException("Failed to retrieve ACL \"" + aclName + "\".", e, 1031);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return acl;
    }

    public dkAccessControlList retrieveDKACL(String aclName) throws SecurityException {
        String methodName = "retrieveACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        dkAccessControlList dkACL = null;
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving ACL from DDO with ID \"" + aclName + "\"...");
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            dkACL = authorMgmt.retrieveAccessControlList(aclName);
        }
        catch (Exception e) {
            Logger.logError(this, methodName, (ServletRequest)this.request, "Failed to retrieve ACL \"" + aclName + "\".", e);
            throw new SecurityException("Failed to retrieve ACL \"" + aclName + "\".", e, 1031);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return dkACL;
    }

    private AccessControlList createACLfromDKACL(dkAccessControlList dkACL) throws Exception {
        String methodName = "createACLfromDKACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        if (dkACL != null) {
            ArrayList<AccessControlListData> aclData = new ArrayList<AccessControlListData>();
            dkCollection col = dkACL.listACLData();
            dkIterator iter = col.createIterator();
            while (iter.more()) {
                DKACLData dkAclData = (DKACLData)iter.next();
                String name = dkAclData.getUserGroupName();
                dkPrivilegeSet dkPrivSet = dkAclData.getPrivilegeSet();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "User or user group name on ACL is \"" + name + "\" associated with privilege set \"" + dkPrivSet.getName() + "\".");
                List<String> privs = Arrays.asList(dkPrivSet.listPrivilegeNames());
                String roleName = dkPrivSet.getDescription() != null ? dkPrivSet.getDescription() : "";
                Role role = new Role(dkPrivSet.getName().toUpperCase(), dkPrivSet.getName(), roleName, privs);
                if (dkAclData.isUser()) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding user \"" + name + "\" to the Item ACL.");
                    aclData.add(new CM8AccessControlListData(this.request, name, null, SecurityConstants.PrincipalType.USER, role));
                    continue;
                }
                if (!dkAclData.isGroup()) continue;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding user group \"" + name + "\" to the Item ACL.");
                aclData.add(new CM8AccessControlListData(this.request, name, null, SecurityConstants.PrincipalType.GROUP, role));
            }
            return new AccessControlList(dkACL.getName(), aclData);
        }
        return null;
    }

    public void deleteACL(String aclName) throws SecurityException {
        String methodName = "deleteACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Retrieving ACL \"" + aclName + "\"...");
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            dkAccessControlList dkACL = authorMgmt.retrieveAccessControlList(aclName);
            DKAdminDomainsMgmtICM adminDomainMgmt = new DKAdminDomainsMgmtICM((dkDatastore)this.dsICM);
            dkCollection domains = null;
            try {
                domains = adminDomainMgmt.listAdminDomains();
            }
            catch (Exception e1) {
                // empty catch block
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Deleting ACL \"" + dkACL + "\"...");
            if (dkACL != null) {
                authorMgmt.del(dkACL);
            }
        }
        catch (DKNotExistException e) {
            Logger.logError(this, "removePrivilegeSet", (ServletRequest)this.request, "ACL \"" + aclName + "\" does not exist!", e);
            throw new SecurityException("ACL \"" + aclName + "\" does not exist!", e, 1035);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to delete ACL \"" + aclName + "\".", e, 1036);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void createPrivilege(String name, String description) throws SecurityException {
        String methodName = "createPrivilege";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        try {
            block8: {
                try {
                    DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
                    dkPrivilege dkPriv = null;
                    try {
                        dkPriv = authorMgmt.retrievePrivilege(name);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (dkPriv == null) {
                        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The privilege does not already exist, adding it");
                        dkPriv = authorMgmt.createPrivilege();
                        dkPriv.setName(name);
                        dkPriv.setDescription(description);
                        authorMgmt.add(dkPriv);
                        break block8;
                    }
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "The privilege already exist, skipping add");
                }
                catch (Exception ex) {
                    if (ex instanceof DKAlreadyExistException) {
                        throw new SecurityException("Privilege \"" + name + "\" already exists!", ex, 1043);
                    }
                    throw new SecurityException("Failed to create privilege \"" + name + "\"!", ex, 1044);
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void deletePrivilege(String name) throws SecurityException {
        dkPrivilege dkPriv = null;
        DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
        try {
            dkPriv = authorMgmt.retrievePrivilege(name);
        }
        catch (Exception ex) {
            throw new SecurityException(ex, 1041);
        }
        if (dkPriv == null) {
            throw new SecurityException("Unable to retrieve privilege, value returned is null, privilege does not exist: \"" + name + "\"!", 1040);
        }
        try {
            authorMgmt.del(dkPriv);
        }
        catch (Exception ex) {
            throw new SecurityException(ex, 1042);
        }
    }

    private DKSequentialCollection getAdminDomain(String userId) {
        DKSequentialCollection collection;
        block5: {
            String methodName = "getAdminDomainName";
            String domainName = "";
            collection = null;
            try {
                DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
                DKUserDefICM userDef = (DKUserDefICM)userMgmt.retrieveUserDef(userId);
                domainName = userDef.getDomainName();
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "domainName: " + domainName);
                if (domainName == null) break block5;
                DKAdminDomainsMgmtICM adminDomainMgmt = new DKAdminDomainsMgmtICM((dkDatastore)this.dsICM);
                dkCollection domains = null;
                try {
                    domains = adminDomainMgmt.listAdminDomains();
                }
                catch (Exception e1) {
                    // empty catch block
                }
                collection = new DKSequentialCollection();
                dkIterator iterator = domains.createIterator();
                while (iterator.more()) {
                    DKAdminDomainDefICM adminDomain = (DKAdminDomainDefICM)iterator.next();
                    if (!adminDomain.getName().equals(domainName)) continue;
                    collection.addElement((Object)adminDomain);
                    break;
                }
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
            }
        }
        return collection;
    }

    private boolean hasItemSuperAccessPrivilege(DKUserDefICM userDef) throws DKException, Exception {
        Logger.logEntry((Object)this, "hasItemSuperAccessPrivilege", (ServletRequest)this.request);
        long userPrivSetCode = userDef.getPrivSetCode();
        DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
        dkCollection privileges = authorMgmt.listPrivInSet(userPrivSetCode);
        if (privileges.cardinality() > 0) {
            dkIterator iterator = privileges.createIterator();
            while (iterator.more()) {
                DKPrivilegeICM privilege = (DKPrivilegeICM)iterator.next();
                if (!privilege.getName().equals("ItemSuperAccess")) continue;
                Logger.logExit((Object)this, "hasItemSuperAccessPrivilege", (ServletRequest)this.request);
                return true;
            }
        }
        Logger.logExit((Object)this, "hasItemSuperAccessPrivilege", (ServletRequest)this.request);
        return false;
    }

    public boolean hasUser(dkUserGroupDef userGroupDef, String user) throws Exception {
        Logger.logEntry((Object)this, "hasUser", (ServletRequest)this.request);
        String[] users = userGroupDef.listUserNames();
        if (users != null) {
            for (int i = 0; i < users.length; ++i) {
                if (!user.equalsIgnoreCase(users[i])) continue;
                Logger.logExit((Object)this, "hasUser", (ServletRequest)this.request);
                return true;
            }
        }
        Logger.logExit((Object)this, "hasUser", (ServletRequest)this.request);
        return false;
    }

    private void addACLDataToDKACL(List<AccessControlListData> aclData, DKAccessControlListICM dkACL) throws DKException, Exception {
        String methodName = "addACLDataToDKACL";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
        if (aclData != null && aclData.size() > 0) {
            for (AccessControlListData aclDataEntry : aclData) {
                DKACLData dkACLData;
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding entry \"" + aclDataEntry.getName());
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "CM8AccessControlListData: " + (CM8AccessControlListData)aclDataEntry);
                Role role = ((CM8AccessControlListData)aclDataEntry).getPrivSet();
                String roleName = this.getPrivsetNameFromRole(role);
                DKPrivilegeSetICM dkPrivSet = (DKPrivilegeSetICM)authorMgmt.retrievePrivilegeSet(roleName);
                if (dkPrivSet == null) continue;
                if (aclDataEntry.getType() == SecurityConstants.PrincipalType.GROUP) {
                    Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding user group \"" + aclDataEntry.getName() + "\" to ACL \"" + dkACL.getName() + "\".");
                    dkACLData = new DKACLData((dkPrivilegeSet)dkPrivSet, aclDataEntry.getName(), 1);
                    dkACL.addACLData(dkACLData);
                    continue;
                }
                dkACLData = new DKACLData((dkPrivilegeSet)dkPrivSet, aclDataEntry.getName(), 0);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, dkPrivSet.getName() + " priv name: Adding user \"" + aclDataEntry.getName() + "\" to ACL \"" + dkACL.getName() + "\".");
                dkACL.addACLData(dkACLData);
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "does not have  acl data: " + dkACL.getACLData().size());
            }
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "does not have  acl data: " + dkACL.getACLData().isEmpty());
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
    }

    public void removePrivilegeSet(String name) {
        try {
            DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
            DKPrivilegeSetICM dkPrivSet = (DKPrivilegeSetICM)authorMgmt.retrievePrivilegeSet(name);
            if (dkPrivSet != null) {
                authorMgmt.del((dkPrivilegeSet)dkPrivSet);
            }
        }
        catch (DKNotExistException e) {
            Logger.logError((Object)this, "removePrivilegeSet", (ServletRequest)this.request, (Throwable)e);
        }
        catch (DKException e) {
            Logger.logError((Object)this, "removePrivilegeSet", (ServletRequest)this.request, (Throwable)e);
        }
        catch (Exception e) {
            Logger.logError((Object)this, "removePrivilegeSet", (ServletRequest)this.request, (Throwable)e);
        }
    }

    public DKPrivilegeSetICM createPrivilegeSet(String name, String description, List<String> privileges) throws Exception {
        String methodName = "createPrivilegeSet";
        Logger.logEntry((Object)this, methodName, (ServletRequest)this.request);
        DKPrivilegeSetICM dkPrivSet = null;
        DKAuthorizationMgmtICM authorMgmt = new DKAuthorizationMgmtICM((dkDatastore)this.dsICM);
        DKAdminDomainsMgmtICM adminDomainMgmt = new DKAdminDomainsMgmtICM((dkDatastore)this.dsICM);
        dkCollection domains = null;
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Create new privset description: " + description);
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Create new privset name: " + name);
        try {
            domains = adminDomainMgmt.listAdminDomains();
        }
        catch (Exception e1) {
            // empty catch block
        }
        try {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Attempting to retrieve privilege set \"" + name + "\".");
            dkPrivSet = (DKPrivilegeSetICM)authorMgmt.retrievePrivilegeSet(name);
        }
        catch (Exception e) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "PrivSet does not exit");
            dkPrivSet = null;
        }
        if (dkPrivSet == null) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Create privilge set: " + name);
            dkPrivSet = (DKPrivilegeSetICM)authorMgmt.createPrivilegeSet();
            if (domains != null && domains.cardinality() > 0) {
                dkPrivSet.setAdminDomains(domains);
            }
            dkPrivSet.setName(name.substring(0, Math.min(name.length(), 32)));
            if (description != null) {
                dkPrivSet.setDescription(description);
            }
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Create new privset");
            for (String priv : privileges) {
                Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding CM privilege \"" + priv + "\" to privilege set \"" + name + "\".");
                dkPrivilege dkPriv = authorMgmt.retrievePrivilege(priv);
                try {
                    dkPrivSet.addPrivilege(dkPriv);
                }
                catch (Exception e) {}
            }
            authorMgmt.add((dkPrivilegeSet)dkPrivSet);
        }
        Logger.logExit((Object)this, methodName, (ServletRequest)this.request);
        return dkPrivSet;
    }

    protected void addPrivilegestoPrivSet(List<String> privileges, DKPrivilegeSetICM dkPrivSet, DKAuthorizationMgmtICM authorMgmt, boolean update) throws Exception {
        String methodName = "addPrivilegestoPrivSet";
        String name = dkPrivSet.getName();
        for (String priv : privileges) {
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding privilege \"" + priv + "\" to privilege set \"" + name + "\".");
            Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Adding CM privilege \"" + priv + "\" to privilege set \"" + name + "\".");
            dkPrivilege dkPriv = null;
            try {
                dkPriv = authorMgmt.retrievePrivilege(priv);
            }
            catch (Exception e1) {
                Logger.logError((Object)this, methodName, (ServletRequest)this.request, "Error retrieving privilege: " + priv + e1);
            }
            try {
                if (dkPriv == null) continue;
                Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "add dkPriv = " + dkPriv.getName());
                dkPrivSet.addPrivilege(dkPriv);
            }
            catch (DKAlreadyExistException e) {}
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Creating privilege set \"" + name + "\".");
        if (authorMgmt != null && dkPrivSet != null) {
            if (update) {
                authorMgmt.update((dkPrivilegeSet)dkPrivSet);
            } else {
                authorMgmt.add((dkPrivilegeSet)dkPrivSet);
            }
        } else {
            Logger.logInfo((Object)this, methodName, (ServletRequest)this.request, "authorMgmt or dkPrivSet is null");
        }
    }

    public List<String> addUsersToGroup(String userGroupName, List<String> userNames) throws SecurityException {
        ArrayList<String> notAdded = new ArrayList<String>();
        DKUserGroupDefICM groupDef = null;
        DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
        try {
            groupDef = (DKUserGroupDefICM)userMgmt.retrieveUserGroupDef(userGroupName);
        }
        catch (Exception e) {
            String msg = "Exception encountered during retrieval of group definition for group named:" + userGroupName;
            throw new SecurityException(msg, e, 1013);
        }
        for (String name : userNames) {
            try {
                DKUserDefICM userDef = (DKUserDefICM)userMgmt.retrieveUserDef(name);
                groupDef.addUser((dkUserDef)userDef);
            }
            catch (DKAlreadyExistException e) {
            }
            catch (Exception e) {
                notAdded.add(name);
            }
        }
        try {
            userMgmt.update((dkUserGroupDef)groupDef);
        }
        catch (Exception e) {
            String msg = "Exception encountered during update of group definition for group named :" + userGroupName;
            throw new SecurityException(msg, e, 1017);
        }
        return notAdded;
    }

    public List<String> removeUsersFromUserGroup(String userGroupName, List<String> userNames) throws SecurityException {
        ArrayList<String> notRemoved = new ArrayList<String>();
        DKUserGroupDefICM groupDef = null;
        DKUserMgmtICM userMgmt = new DKUserMgmtICM((dkDatastore)this.dsICM);
        try {
            groupDef = (DKUserGroupDefICM)userMgmt.retrieveUserGroupDef(userGroupName);
        }
        catch (Exception e) {
            String msg = "Exception encountered during retrieval of group definition for group named:" + userGroupName;
            throw new SecurityException(msg, e, 1013);
        }
        for (String name : userNames) {
            try {
                groupDef.removeUser(name);
            }
            catch (DKNotExistException e) {
            }
            catch (Exception e) {
                notRemoved.add(name);
            }
        }
        try {
            userMgmt.update((dkUserGroupDef)groupDef);
        }
        catch (Exception e) {
            String msg = "Exception encountered during update of group definition for group named :" + userGroupName;
            throw new SecurityException(msg, e, 1017);
        }
        return notRemoved;
    }
}

