/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security.cm8;

import com.ibm.ecm.security.AccessControlListData;
import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CM8AccessControlListData
extends AccessControlListData {
    private Role privSet;
    private HttpServletRequest request = null;

    public CM8AccessControlListData(HttpServletRequest request, String name, List<Role> roles, SecurityConstants.PrincipalType type, Role privSet) {
        super(name, roles, type);
        this.privSet = privSet;
        this.request = request;
    }

    public CM8AccessControlListData(JSONObject json) {
        super("", null, SecurityConstants.PrincipalType.USER);
        String methodName = "CM8AccessControlListData";
        Set keys = json.keySet();
        for (String key : keys) {
            if (key.equalsIgnoreCase("name")) {
                this.name = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("type")) {
                try {
                    this.type = SecurityConstants.PrincipalType.getEnum((Integer)json.get(key));
                }
                catch (Exception e) {
                    Logger.logError((Object)this, methodName, (ServletRequest)this.request, (Throwable)e);
                }
                continue;
            }
            if (key.equalsIgnoreCase("roles")) {
                this.roles = new ArrayList();
                JSONArray jsonArray = (JSONArray)json.get(key);
                for (Object obj : jsonArray) {
                    this.roles.add(new Role((JSONObject)obj));
                }
                continue;
            }
            if (!key.equalsIgnoreCase("privSet")) continue;
            this.privSet = new Role((JSONObject)json.get(key));
        }
    }

    public Role getPrivSet() {
        return this.privSet;
    }

    public void setPrivSet(Role privSet) {
        this.privSet = privSet;
    }

    @Override
    public JSONObject toJSON() {
        String methodName = "toJSON";
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("name", this.name);
        jsonObj.put("type", (Object)this.type.getValue());
        jsonObj.put("privSet", this.privSet.toJSON());
        JSONArray jsonArray = new JSONArray();
        jsonObj.put("roles", jsonArray);
        for (Role role : this.roles) {
            jsonArray.add(role.toJSON());
        }
        Logger.logDebug((Object)this, methodName, (ServletRequest)this.request, "Returning JSON: " + jsonObj.toString());
        return jsonObj;
    }
}

