/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.Subject;
import com.ibm.ecm.security.SubjectImpl;
import com.ibm.ecm.security.User;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserGroup
extends SubjectImpl
implements Cloneable {
    private List<Subject> users;
    private List<Role> roles;

    public UserGroup(String id, String name, List<Subject> users, List<Role> roles) {
        this.id = id;
        this.name = name;
        this.users = users;
        this.shortName = "";
        this.displayName = "";
        this.roles = roles;
        this.type = SecurityConstants.PrincipalType.GROUP;
    }

    public UserGroup(String id, String name, String shortName, String displayName, List<Subject> users, List<Role> roles) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.displayName = displayName;
        this.users = users;
        this.roles = roles;
        this.type = SecurityConstants.PrincipalType.GROUP;
    }

    public UserGroup(JSONObject json) {
        Set keys = json.keySet();
        for (String key : keys) {
            JSONArray jsonArray;
            if (key.equalsIgnoreCase("id")) {
                this.id = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("name")) {
                this.name = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase(key)) {
                this.shortName = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("displayName")) {
                this.displayName = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("users")) {
                this.users = new ArrayList<Subject>();
                jsonArray = (JSONArray)json.get(key);
                for (Object obj : jsonArray) {
                    this.users.add(new User((JSONObject)obj));
                }
                continue;
            }
            if (!key.equalsIgnoreCase("roles")) continue;
            this.roles = new ArrayList<Role>();
            jsonArray = (JSONArray)json.get(key);
            for (Object obj : jsonArray) {
                this.roles.add(new Role((JSONObject)obj));
            }
        }
        this.type = SecurityConstants.PrincipalType.GROUP;
    }

    public List<Subject> getUsers() {
        return this.users;
    }

    public void setUsers(List<Subject> users) {
        this.users = users;
    }

    public List<String> getUserNames() {
        if (this.users != null && this.users.size() > 0) {
            ArrayList<String> userNames = new ArrayList<String>();
            for (Subject user : this.users) {
                userNames.add(user.getName());
            }
            return userNames;
        }
        return null;
    }

    public List<String> getUserIDs() {
        if (this.users != null && this.users.size() > 0) {
            ArrayList<String> userIDs = new ArrayList<String>();
            for (Subject user : this.users) {
                userIDs.add(user.getId());
            }
            return userIDs;
        }
        return null;
    }

    public boolean contains(String userId) {
        if (this.users != null && this.users.size() > 0) {
            for (Subject user : this.users) {
                if (!user.getId().equalsIgnoreCase(userId) && !user.getName().equalsIgnoreCase(userId) && (user.getShortName() == null || !user.getShortName().equalsIgnoreCase(userId))) continue;
                return true;
            }
        }
        return false;
    }

    public void removeUser(String userId) {
        if (this.users != null && this.users.size() > 0) {
            boolean found = false;
            int i = 0;
            for (i = 0; i < this.users.size(); ++i) {
                Subject user = this.users.get(i);
                if (!user.getId().equalsIgnoreCase(userId) && !user.getName().equalsIgnoreCase(userId) && (user.getShortName() == null || !user.getShortName().equalsIgnoreCase(userId))) continue;
                found = true;
                break;
            }
            if (found) {
                this.users.remove(i);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Group - ").append("\n\tId: ").append(this.id).append("\n\tName: ").append(this.name).append("\n\tShort Name: ").append(this.shortName).append("\n\tDescription: ").append(this.displayName).append("\n\tUsers:");
        if (this.users != null && this.users.size() > 0) {
            for (Subject user : this.users) {
                if (user == null) continue;
                sb.append("\n\t\t").append(user.toString());
            }
        }
        return sb.toString();
    }

    public UserGroup clone() throws CloneNotSupportedException {
        UserGroup clone = (UserGroup)super.clone();
        ArrayList<Subject> clonedUsers = new ArrayList<Subject>();
        for (Subject user : this.users) {
            clonedUsers.add(((User)user).clone());
        }
        clone.users = clonedUsers;
        clone.type = SecurityConstants.PrincipalType.GROUP;
        return clone;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", this.id);
        jsonObj.put("name", this.name);
        jsonObj.put("shortName", this.shortName);
        jsonObj.put("displayName", this.displayName);
        jsonObj.put("type", (Object)this.type.getValue());
        JSONArray jsonArray = new JSONArray();
        jsonObj.put("users", this.users);
        if (this.users != null && this.users != null) {
            for (Subject usr : this.users) {
                jsonArray.add(usr.toJSON());
            }
        }
        JSONArray rolesJsonArray = new JSONArray();
        jsonObj.put("roles", rolesJsonArray);
        if (this.roles != null) {
            for (Role role : this.roles) {
                rolesJsonArray.add(role.toJSON());
            }
        }
        return jsonObj;
    }
}

