/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.SubjectImpl;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class User
extends SubjectImpl
implements Cloneable {
    public User(String id, String name, String shortName, String displayName, String emailAddress, List<Role> roles) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.displayName = displayName;
        this.emailAddress = emailAddress;
        this.roles = roles;
        this.type = SecurityConstants.PrincipalType.USER;
    }

    public User(JSONObject json) {
        Set keys = json.keySet();
        for (String key : keys) {
            if (key.equalsIgnoreCase("id")) {
                this.id = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("name")) {
                this.name = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("shortName")) {
                this.shortName = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("displayName")) {
                this.displayName = (String)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("emailAddress")) {
                this.emailAddress = (String)json.get(key);
                continue;
            }
            if (!key.equalsIgnoreCase("roles")) continue;
            this.roles = new ArrayList();
            JSONArray jsonArray = (JSONArray)json.get(key);
            for (Object obj : jsonArray) {
                this.roles.add(new Role((JSONObject)obj));
            }
        }
        this.type = SecurityConstants.PrincipalType.USER;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("User: id=").append(this.id).append(" | name: ").append(this.name).append(" | short name: ").append(this.shortName).append(" | display name: ").append(this.displayName).append("\n\tRoles: ");
        if (this.roles != null && this.roles.size() > 0) {
            for (Role role : this.roles) {
                if (role == null) continue;
                sb.append("\n\t").append(role.toString());
            }
        }
        return sb.toString();
    }

    public User clone() throws CloneNotSupportedException {
        User clone = (User)super.clone();
        ArrayList<Role> clonedRoles = new ArrayList<Role>();
        for (Role role : this.roles) {
            clonedRoles.add(role.clone());
        }
        clone.roles = clonedRoles;
        clone.type = SecurityConstants.PrincipalType.USER;
        return clone;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", this.id);
        jsonObj.put("name", this.name);
        jsonObj.put("shortName", this.shortName);
        jsonObj.put("displayName", this.displayName);
        if (this.emailAddress != null) {
            jsonObj.put("emailAddress", this.emailAddress);
        }
        jsonObj.put("type", (Object)this.type.getValue());
        JSONArray jsonArray = new JSONArray();
        jsonObj.put("roles", jsonArray);
        if (this.roles != null) {
            for (Role role : this.roles) {
                jsonArray.add(role.toJSON());
            }
        }
        JSONArray jsonArray2 = new JSONArray();
        jsonArray2.addAll(this.getMaxPrivileges());
        jsonObj.put("maxPrivs", jsonArray2);
        return jsonObj;
    }
}

