/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import com.ibm.ecm.security.Role;
import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.security.Subject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubjectImpl
implements Subject,
Cloneable {
    protected String id;
    protected String name;
    protected String shortName;
    protected String displayName;
    protected String emailAddress;
    protected List<Role> roles;
    protected SecurityConstants.PrincipalType type;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public List<Role> getRoles() {
        return this.roles;
    }

    @Override
    public void setRoles(List<Role> roles) {
        this.roles = roles;
    }

    @Override
    public SecurityConstants.PrincipalType getType() {
        return this.type;
    }

    public List<String> getMaxPrivileges() {
        ArrayList<String> maxPrivs = new ArrayList<String>();
        if (this.roles != null) {
            for (Role role : this.roles) {
                List<String> privs = role.getPrivileges();
                for (String priv : privs) {
                    if (maxPrivs.contains(priv)) continue;
                    maxPrivs.add(priv);
                }
            }
        }
        return maxPrivs;
    }
}

