/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import com.ibm.ecm.dm.CMDataModel;
import com.ibm.ecm.security.SecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface SecurityConstants {
    public static final String TEAMSPACE_ROLE_ITEMTYPE = "ICMRole";
    public static final String TEAMSPACE_ROLE_NAME = "ICM$NAME";
    public static final String TEAMSPACE_ROLE_DESCRIPTION = "clbDescription";
    public static final String TEAMSPACE_ROLE_TYPE = "clbRoleType";
    public static final String TEAMSPACE_ROLE_PRIVSET = "clbPrivSetName";
    public static final String FULL_ACCESS_MASK = "998903";
    public static final String READ_ACCESS_MASK = "131201";
    public static final String EDIT_ACCESS_MASK = "132599";
    public static final String FULL_ACCESS_FOLDER_MASK = "999415";
    public static final String READ_ACCESS_FOLDER_MASK = "131073";
    public static final String EDIT_ACCESS_FOLDER_MASK = "131121";
    public static final int RESERVE_BITS = 14336;
    public static final String CM8_SUPER_USER_ROLE = "AllPrivs";
    public static final List<String> CM8_OWNER_PRIVS = new ArrayList<String>(Arrays.asList(CMDataModel.OWNER_PRIVSET));
    public static final List<String> folderPrivilegeList = new ArrayList<String>(Arrays.asList("modifyItemProperties", "deleteItems", "modifyItemPermissions", "createSubfolders", "fileInFolders", "viewItemProperties"));
    public static final List<String> docPrivilegeList = new ArrayList<String>(Arrays.asList("modifyItemProperties", "deleteItems", "promoteVersions", "modifyContent", "modifyItemPermissions", "viewContent", "viewItemProperties"));
    public static final Map<String, Integer> p8PrivilegeMap = new HashMap<String, Integer>(){
        {
            this.put("modifyFolderPermissions", new Integer(276480));
            this.put("deleteFolders", 65536);
            this.put("modifyFolderProperties", 1478);
            this.put("createSubfolders", 512);
            this.put("fileInFolders", new Integer(0x2000030));
            this.put("viewItemProperties", 131073);
            this.put("modifyItemPermissions", new Integer(800768));
            this.put("deleteItems", 65536);
            this.put("promoteVersions", 4);
            this.put("modifyContent", new Integer(1346));
            this.put("modifyItemProperties", new Integer(0x2000032));
            this.put("viewContent", 128);
            this.put("addNewSearches", 1330);
            this.put("shareSearches", null);
            this.put("addRemoveClassesOrEntryTemplates", 1330);
            this.put("addRemoveRoleParticipants", new Integer(802098));
        }
    };
    public static final Map<String, List<String>> cm8PrivilegeMap = new HashMap<String, List<String>>(){
        {
            this.put("modifyItemPermissions", new ArrayList<String>(){
                {
                    this.add("ItemSetACL");
                    this.add("SystemQueryGroup");
                    this.add("UserACLOwner");
                    this.add("SystemQueryUserPrivs");
                    this.add("ItemSetUserAttr");
                    this.add("ItemCheckInOut");
                }
            });
            this.put("modifyItemProperties", new ArrayList<String>(){
                {
                    this.add("ItemSetUserAttr");
                    this.add("ItemCheckInOut");
                }
            });
            this.put("createSubfolders", new ArrayList<String>(){
                {
                    this.add("ItemAdd");
                    this.add("ItemAddLink");
                }
            });
            this.put("fileInFolders", new ArrayList<String>(){
                {
                    this.add("ItemLinkTo");
                    this.add("ItemAddLink");
                    this.add("ItemLinked");
                    this.add("ItemCheckInOut");
                }
            });
            this.put("createItems", new ArrayList<String>(){
                {
                    this.add("ItemAdd");
                    this.add("ItemAddLink");
                    this.add("ItemLinkTo");
                    this.add("ItemLinked");
                    this.add("ItemCheckInOut");
                }
            });
            this.put("viewItemProperties", new ArrayList<String>(){
                {
                    this.add("ItemSQLSelect");
                    this.add("ItemTypeQuery");
                    this.add("ClientAdvancedSearch");
                    this.add("ItemQuery");
                }
            });
            this.put("deleteItems", new ArrayList<String>(){
                {
                    this.add("ItemDelete");
                    this.add("ItemDeletePart");
                    this.add("ItemCheckInOut");
                }
            });
            this.put("modifyContent", new ArrayList<String>(){
                {
                    this.add("ItemSetUserAttr");
                    this.add("ItemCheckInOut");
                    this.add("ItemUpdatePart");
                    this.add("ClientPrint");
                    this.add("ClientExport");
                    this.add("ClientReadBasePart");
                    this.add("ClientReadNoteLog");
                    this.add("ClientReadHistory");
                    this.add("ClientAdvancedSearch");
                    this.add("ClientImport");
                    this.add("ClientModifyBasePart");
                    this.add("ClientAddNewBasePart");
                    this.add("ClientDeleteBasePart");
                    this.add("ClientReadAnnotation");
                    this.add("ClientModifyAnnotation");
                    this.add("ClientModifyNoteLog");
                    this.add("ClientAddToNoteLog");
                    this.add("ClientScan");
                }
            });
            this.put("viewContent", new ArrayList<String>(){
                {
                    this.add("ItemSQLSelect");
                    this.add("ClientReadBasePart");
                    this.add("ClientPrint");
                    this.add("ClientExport");
                    this.add("ClientReadBasePart");
                    this.add("ClientReadNoteLog");
                    this.add("ClientReadHistory");
                    this.add("ClientAdvancedSearch");
                    this.add("ClientReadAnnotation");
                }
            });
            this.put("addNewSearches", new ArrayList<String>(){
                {
                    this.add("addNewSearches");
                    this.add("ItemCheckInOut");
                    this.add("ItemSetUserAttr");
                }
            });
            this.put("shareSearches", new ArrayList<String>(){
                {
                    this.add("shareSearches");
                }
            });
            this.put("addRemoveClasses", new ArrayList<String>(){
                {
                    this.add("addRemoveClasses");
                    this.add("ItemSetUserAttr");
                    this.add("ItemCheckInOut");
                }
            });
            this.put("addRemoveRoleParticipants", new ArrayList<String>(){
                {
                    this.add("addRemoveRoleParticipants");
                    this.add("ItemSetUserAttr");
                    this.add("ItemCheckInOut");
                    this.add("ItemSetACL");
                }
            });
        }
    };
    public static final List<String> ALL_PRIVILEGES_P8 = Collections.unmodifiableList(new ArrayList<String>(p8PrivilegeMap.keySet()));
    public static final List<String> ALL_PRIVILEGES_CM = Collections.unmodifiableList(new ArrayList<String>(cm8PrivilegeMap.keySet()));
    public static final List<String> ALL_PRIVILEGES_P8_TEAMSPACE = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("createSubfolders");
            this.add("fileInFolders");
            this.add("viewFolderProperties");
            this.add("modifyDocumentProperties");
            this.add("addRemoveClassesOrEntryTemplates");
            this.add("deleteDocuments");
            this.add("modifyDocumentPermissions");
            this.add("viewDocumentProperties");
            this.add("viewContent");
            this.add("shareSearches");
            this.add("addNewSearches");
            this.add("deleteFolders");
            this.add("addRemoveRoleParticipants");
            this.add("modifyFolderProperties");
            this.add("promoteVersions");
            this.add("modifyFolderPermissions");
            this.add("modifyContent");
        }
    };
    public static final List<String> MEMBER_PRIVILEGES_P8 = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("createSubfolders");
            this.add("promoteVersions");
            this.add("fileInFolders");
            this.add("modifyContent");
            this.add("modifyItemProperties");
            this.add("viewContent");
            this.add("viewItemProperties");
        }
    };
    public static final List<String> MEMBER_PRIVILEGES_CM = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("modifyItemProperties");
            this.add("createItems");
            this.add("viewItemProperties");
            this.add("modifyContent");
            this.add("viewContent");
        }
    };
    public static final List<String> REVIEWER_PRIVILEGES_P8 = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("viewContent");
            this.add("viewItemProperties");
        }
    };
    public static final List<String> REVIEWER_PRIVILEGES_CM = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("viewItemProperties");
            this.add("viewContent");
        }
    };

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RoleType {
        REPOSITORY{

            public int getValue() {
                return 1;
            }
        }
        ,
        TEMPLATE{

            public int getValue() {
                return 2;
            }
        }
        ,
        TEAMSPACE{

            public int getValue() {
                return 3;
            }
        };


        public abstract int getValue();

        public static RoleType getEnum(int value) throws SecurityException {
            for (RoleType roleType : RoleType.values()) {
                if (roleType.getValue() != value) continue;
                return roleType;
            }
            throw new SecurityException("Unsupported role type!", 1000);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrincipalType {
        USER{

            public int getValue() {
                return 1;
            }
        }
        ,
        GROUP{

            public int getValue() {
                return 2;
            }
        };


        public abstract int getValue();

        public static PrincipalType getEnum(int value) throws SecurityException {
            for (PrincipalType principalType : PrincipalType.values()) {
                if (principalType.getValue() != value) continue;
                return principalType;
            }
            throw new SecurityException("Unsupported principal type!", 1000);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AppPrivilegeSets {
        EDIT{

            public String getValue() {
                return "clbEdit";
            }
        }
        ,
        READ{

            public String getValue() {
                return "clbReadOnly";
            }
        }
        ,
        OWNER{

            public String getValue() {
                return "clbOwnerPrivs";
            }
        }
        ,
        TEAMSPACE{

            public String getValue() {
                return "clbTeamspaceCreator";
            }
        };


        public abstract String getValue();

        public static AppPrivilegeSets getEnum(String value) throws SecurityException {
            for (AppPrivilegeSets privSet : AppPrivilegeSets.values()) {
                if (privSet.getValue() != value) continue;
                return privSet;
            }
            throw new SecurityException("Unsupported privilege type!", 1000);
        }
    }
}

