/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import com.ibm.ecm.security.SecurityConstants;
import com.ibm.ecm.serviceability.Logger;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Role
implements Cloneable {
    private String id;
    private String messageId;
    private String name;
    private String description;
    private List<String> unMappedPrivileges;
    private List<String> privileges;
    private List<String> currentUserPrivileges;
    private HashMap<String, SecurityConstants.PrincipalType> assignees;
    private SecurityConstants.RoleType roleType;
    private boolean owner;
    private boolean preDefined;
    private String privSetName;

    private Role(String id, String name, List<String> privileges) {
        this(id, name, null, privileges);
    }

    public Role(String id, String name, String description, List<String> privileges) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.privileges = privileges;
        this.assignees = null;
        this.roleType = SecurityConstants.RoleType.TEMPLATE;
    }

    public Role(String id, String name, String description, List<String> privileges, String privSetName) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.privileges = privileges;
        this.assignees = null;
        this.roleType = SecurityConstants.RoleType.TEMPLATE;
        this.privSetName = privSetName;
    }

    public Role(String id, String name, String description, List<String> privileges, HashMap<String, SecurityConstants.PrincipalType> assignees, SecurityConstants.RoleType roleType) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.privileges = privileges;
        this.assignees = assignees;
        this.roleType = roleType;
    }

    public String getPrivSetName() {
        return this.privSetName;
    }

    public void setPrivSetName(String privSetName) {
        this.privSetName = privSetName;
    }

    public boolean isPreDefined() {
        return this.preDefined;
    }

    public void setPreDefined(boolean preDefined) {
        this.preDefined = preDefined;
    }

    public List<String> getCurrentUserPrivileges() {
        return this.currentUserPrivileges;
    }

    public void setCurrentUserPrivileges(List<String> currentUserPrivileges) {
        this.currentUserPrivileges = currentUserPrivileges;
    }

    public Role(JSONObject json) {
        String methodName = "Role";
        ServletRequest request = null;
        Set keys = json.keySet();
        for (String key : keys) {
            JSONArray jsonArray;
            String value = (String)json.get(key);
            if (key.equalsIgnoreCase("id")) {
                this.id = value;
                continue;
            }
            if (key.equalsIgnoreCase("messageId")) {
                this.messageId = value;
                continue;
            }
            if (key.equalsIgnoreCase("name")) {
                this.name = value;
                continue;
            }
            if (key.equalsIgnoreCase("desc")) {
                this.description = value;
                continue;
            }
            if (key.equalsIgnoreCase("privs")) {
                jsonArray = (JSONArray)json.get(key);
                this.privileges = new ArrayList<String>();
                for (Object obj : jsonArray) {
                    this.privileges.add((String)obj);
                }
                continue;
            }
            if (key.equalsIgnoreCase("preDefined")) {
                this.preDefined = (Boolean)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("owner")) {
                this.owner = (Boolean)json.get(key);
                continue;
            }
            if (key.equalsIgnoreCase("assignees")) {
                jsonArray = (JSONArray)json.get(key);
                this.assignees = new HashMap();
                for (Object obj : jsonArray) {
                    JSONObject jsonObj = (JSONObject)obj;
                    try {
                        Set assigneeKeys = jsonObj.keySet();
                        for (String assigneeKey : assigneeKeys) {
                            this.assignees.put(assigneeKey, SecurityConstants.PrincipalType.getEnum((Integer)jsonObj.get(assigneeKey)));
                        }
                    }
                    catch (Exception e) {
                        Logger.logError((Object)this, methodName, request, (Throwable)e);
                    }
                }
                continue;
            }
            if (!key.equalsIgnoreCase("roletype")) continue;
            String roleTypeStr = value;
            try {
                this.roleType = SecurityConstants.RoleType.getEnum(Integer.valueOf(roleTypeStr));
            }
            catch (Exception e) {
                Logger.logError((Object)this, methodName, request, (Throwable)e);
                this.roleType = SecurityConstants.RoleType.TEMPLATE;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String id) {
        this.messageId = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<String> privileges) {
        this.privileges = privileges;
    }

    public void setAssigness(HashMap<String, SecurityConstants.PrincipalType> assignees) {
        this.assignees = assignees;
    }

    public HashMap<String, SecurityConstants.PrincipalType> getAssignees() {
        return this.assignees;
    }

    public SecurityConstants.RoleType getRoleType() {
        return this.roleType;
    }

    public void setRoleType(SecurityConstants.RoleType roleType) {
        this.roleType = roleType;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public List<String> getUnMappedPrivileges() {
        return this.unMappedPrivileges;
    }

    public void setUnMappedPrivileges(List<String> unMappedPrivileges) {
        this.unMappedPrivileges = unMappedPrivileges;
    }

    public void setOwner(boolean owner) {
        this.owner = owner;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nRole:").append("\tMessageId=").append(this.messageId).append("\tName=").append(this.name).append("\tType=").append((Object)this.roleType).append("\n\tPrivileges=").append(this.privileges).append("\n\tAssignees=");
        if (this.assignees != null && this.assignees.size() > 0) {
            Set<String> keys = this.assignees.keySet();
            for (String key : keys) {
                sb.append("\n\t\tName=").append(key).append(" | Type=").append((Object)this.assignees.get(key));
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public Role clone() throws CloneNotSupportedException {
        Role clone = (Role)super.clone();
        clone.privileges = new ArrayList<String>(this.privileges);
        return clone;
    }

    public JSONObject toJSON() {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("id", this.id);
        jsonObj.put("messageId", this.messageId != null ? this.messageId : "");
        jsonObj.put("name", this.name);
        jsonObj.put("desc", this.description);
        jsonObj.put("type", (Object)this.roleType.getValue());
        jsonObj.put("owner", (Object)this.owner);
        jsonObj.put("preDefined", (Object)this.preDefined);
        JSONArray jsonArray = new JSONArray();
        jsonObj.put("privs", jsonArray);
        if (this.privileges != null) {
            for (String priv : this.privileges) {
                jsonArray.add(priv);
            }
        }
        JSONArray jsonArray3 = new JSONArray();
        jsonObj.put("currentUserPrivileges", jsonArray3);
        if (this.currentUserPrivileges != null) {
            for (String priv : this.currentUserPrivileges) {
                jsonArray3.add(priv);
            }
        }
        JSONArray jsonArray2 = new JSONArray();
        jsonObj.put("assignees", jsonArray2);
        if (this.assignees != null) {
            Set<String> keys = this.assignees.keySet();
            for (String key : keys) {
                SecurityConstants.PrincipalType principalType = this.assignees.get(key);
                JSONObject jsonObj2 = new JSONObject();
                jsonObj2.put(key, (Object)principalType.getValue());
                jsonArray2.add(jsonObj2);
            }
        }
        return jsonObj;
    }
}

