/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ecm.security;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashCalculator {
    private static MessageDigest mdCalculator = null;
    private static byte[] buffer = new byte[2048];
    protected static final char[] c2h = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static void initMDCalculator() throws NoSuchAlgorithmException {
        if (mdCalculator == null) {
            mdCalculator = MessageDigest.getInstance("SHA-256");
        }
    }

    private static void initMDCalculator(String hashAlgorithm) throws NoSuchAlgorithmException {
        if (mdCalculator == null) {
            mdCalculator = MessageDigest.getInstance(hashAlgorithm);
        }
    }

    public static String calculateHash(InputStream is) throws NoSuchAlgorithmException, IOException {
        int len;
        assert (is != null);
        HashCalculator.initMDCalculator();
        while ((len = is.read(buffer)) >= 0) {
            mdCalculator.update(buffer, 0, len);
        }
        return HashCalculator.toHex(mdCalculator.digest());
    }

    public static String calculateHash(InputStream is, String hashAlgorithm) throws NoSuchAlgorithmException, IOException {
        int len;
        assert (is != null);
        HashCalculator.initMDCalculator(hashAlgorithm);
        while ((len = is.read(buffer)) >= 0) {
            mdCalculator.update(buffer, 0, len);
        }
        return HashCalculator.toHex(mdCalculator.digest());
    }

    protected static String toHex(byte[] data) {
        char[] res = new char[data.length << 1];
        int rp = res.length;
        for (int i = data.length - 1; i >= 0; --i) {
            res[--rp] = c2h[data[i] & 0xF];
            res[--rp] = c2h[data[i] >> 4 & 0xF];
        }
        return new String(res);
    }
}

